/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ui.tree.ChildSortingTreeNode;
import com.metamatrix.console.ui.util.LazyBranchNode;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class StaticTreeSortUtilities {
    public static boolean sortChildrenAlphabetically(MutableTreeNode node, boolean useUserObjectToString) {
        int[] nodesOrder = StaticTreeSortUtilities.alphabeticOrder(node, useUserObjectToString);
        return StaticTreeSortUtilities.reorderChildren(node, nodesOrder);
    }

    public static boolean sortChildrenAlphabetically(MutableTreeNode node) {
        return StaticTreeSortUtilities.sortChildrenAlphabetically(node, false);
    }

    public static boolean sortChildrenNumerically(MutableTreeNode node, boolean useUserObjectToString) {
        boolean changed;
        double[] numberValue = StaticTreeSortUtilities.numbersList(node, useUserObjectToString);
        if (numberValue == null) {
            changed = StaticTreeSortUtilities.sortChildrenAlphabetically(node, useUserObjectToString);
        } else {
            int[] nodesOrder = StaticTreeSortUtilities.numericOrder(numberValue);
            changed = StaticTreeSortUtilities.reorderChildren(node, nodesOrder);
        }
        return changed;
    }

    public static boolean sortChildrenNumerically(MutableTreeNode node) {
        return StaticTreeSortUtilities.sortChildrenNumerically(node, false);
    }

    private static double[] numbersList(MutableTreeNode node, boolean useUserObjectToString) {
        int childCount = node.getChildCount();
        double[] nl = new double[childCount];
        int i = 0;
        while (nl != null && i < childCount) {
            boolean useNodeToString;
            MutableTreeNode childNode = (MutableTreeNode)node.getChildAt(i);
            String inputString = null;
            boolean bl = useNodeToString = !useUserObjectToString;
            if (!useNodeToString) {
                if (childNode instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)childNode;
                    Object userObj = dmtn.getUserObject();
                    if (userObj != null) {
                        inputString = userObj.toString().trim();
                    } else {
                        useNodeToString = true;
                    }
                } else {
                    useNodeToString = true;
                }
            }
            if (useNodeToString) {
                inputString = childNode.toString().trim();
            }
            try {
                nl[i] = new Double(inputString);
                ++i;
            }
            catch (Exception e) {
                nl = null;
            }
        }
        return nl;
    }

    private static int[] numericOrder(double[] value) {
        int[] order = new int[value.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (int i = 0; i < order.length - 1; ++i) {
                if (!(value[i] > value[i + 1])) continue;
                done = false;
                double dtemp = value[i];
                value[i] = value[i + 1];
                value[i + 1] = dtemp;
                int itemp = order[i];
                order[i] = order[i + 1];
                order[i + 1] = itemp;
            }
        }
        return order;
    }

    private static int[] alphabeticOrder(MutableTreeNode node, boolean useUserObjectToString) {
        int childCount = node.getChildCount();
        int[] order = new int[childCount];
        String[] value = new String[childCount];
        for (int i = 0; i < order.length; ++i) {
            boolean useNodeToString;
            String val = null;
            MutableTreeNode childNode = (MutableTreeNode)node.getChildAt(i);
            order[i] = i;
            boolean bl = useNodeToString = !useUserObjectToString;
            if (!useNodeToString) {
                if (childNode instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)childNode;
                    Object userObj = dmtn.getUserObject();
                    if (dmtn != null) {
                        val = userObj.toString().trim();
                    } else {
                        useNodeToString = true;
                    }
                } else {
                    useNodeToString = true;
                }
            }
            if (useNodeToString) {
                val = childNode.toString().trim();
            }
            value[i] = val;
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (int i = 0; i < childCount - 1; ++i) {
                if (value[i].compareToIgnoreCase(value[i + 1]) <= 0) continue;
                done = false;
                String stemp = value[i];
                value[i] = value[i + 1];
                value[i + 1] = stemp;
                int itemp = order[i];
                order[i] = order[i + 1];
                order[i + 1] = itemp;
            }
        }
        return order;
    }

    private static boolean reorderChildren(MutableTreeNode node, int[] newOrder) {
        boolean changed = false;
        if (StaticTreeSortUtilities.orderChanged(newOrder)) {
            int i;
            changed = true;
            Object[] child = new Object[newOrder.length];
            for (i = 0; i < newOrder.length; ++i) {
                child[i] = node.getChildAt(i);
            }
            for (i = newOrder.length - 1; i >= 0; --i) {
                node.remove(i);
            }
            int childCount = node.getChildCount();
            if (childCount > 0) {
                LogManager.logError((String)"GENERAL", (String)("Loop in StaticTreeSortUtilities..reorderChildren() failed to remove all children.  Would have created duplicate node. Remaining child count is " + childCount));
                while (node.getChildCount() > 0) {
                    node.remove(0);
                }
            }
            int saveSortType = -1;
            ChildSortingTreeNode cstn = null;
            if (node instanceof ChildSortingTreeNode) {
                cstn = (ChildSortingTreeNode)node;
                saveSortType = cstn.getSortType();
                cstn.setSortType(3);
            }
            for (int i2 = 0; i2 < child.length; ++i2) {
                node.insert((MutableTreeNode)child[newOrder[i2]], i2);
            }
            if (cstn != null) {
                cstn.setSortType(saveSortType);
            }
        }
        return changed;
    }

    private static boolean orderChanged(int[] newOrder) {
        boolean mismatchFound = false;
        for (int i = 0; !mismatchFound && i < newOrder.length; ++i) {
            if (newOrder[i] == i) continue;
            mismatchFound = true;
        }
        return mismatchFound;
    }

    public static void sortTreeAlphabetically(TreeNode root, boolean useUserObjectToString) throws Exception {
        StaticTreeSortUtilities.sortTree(root, false, useUserObjectToString);
    }

    public static void sortTreeNumerically(TreeNode root, boolean useUserObjectToString) throws Exception {
        StaticTreeSortUtilities.sortTree(root, true, useUserObjectToString);
    }

    private static void sortTree(TreeNode root, boolean tryNumerically, boolean useUserObjectToString) throws Exception {
        TreeNode curNode = root;
        boolean done = false;
        while (!done) {
            LazyBranchNode lbn;
            if (curNode instanceof LazyBranchNode && !(lbn = (LazyBranchNode)curNode).isPopulated()) {
                lbn.populate();
            }
            if (curNode.getChildCount() > 0 && curNode instanceof MutableTreeNode) {
                MutableTreeNode mtn = (MutableTreeNode)curNode;
                if (tryNumerically) {
                    StaticTreeSortUtilities.sortChildrenNumerically(mtn, useUserObjectToString);
                } else {
                    StaticTreeSortUtilities.sortChildrenAlphabetically(mtn, useUserObjectToString);
                }
            }
            if (curNode.getChildCount() > 0) {
                curNode = curNode.getChildAt(0);
                continue;
            }
            boolean nextNodeFound = false;
            while (!done && !nextNodeFound) {
                if (curNode == root) {
                    done = true;
                    continue;
                }
                TreeNode parent = curNode.getParent();
                int prevChildIndex = parent.getIndex(curNode);
                if (prevChildIndex < parent.getChildCount() - 1) {
                    nextNodeFound = true;
                    curNode = parent.getChildAt(prevChildIndex + 1);
                    continue;
                }
                curNode = parent;
            }
        }
    }
}

