/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.console.ui.tree.TreePathExpansion;
import com.metamatrix.console.ui.util.LazyBranchNode;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class StaticTreeUtilities {
    public static final String CONTEXT_FOR_DUPE_CHECKING = "USERS";
    public static final int MSGLEVEL_FOR_DUPE_CHECKING = 6;

    public static int maxSelectedTreePathLength(JTree tree) {
        int max = 0;
        if (tree != null && tree.getSelectionCount() > 0) {
            TreePath[] treePath = tree.getSelectionPaths();
            for (int i = 0; i < treePath.length; ++i) {
                int cur = treePath[i].getPathCount();
                if (cur <= max) continue;
                max = cur;
            }
        }
        return max;
    }

    public static final void expandAll(JTree tree) {
        TreePath[] tp = null;
        try {
            tp = StaticTreeUtilities.allTreePaths(tree.getModel(), false);
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (int i = 0; i < tp.length; ++i) {
            tree.expandPath(tp[i]);
        }
    }

    public static List descendantsOfNode(TreeNode startingNode, boolean includeStartingNode) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        if (includeStartingNode) {
            list.add(startingNode);
        }
        if (startingNode.getChildCount() > 0) {
            TreeNode curNode = startingNode.getChildAt(0);
            while (curNode != startingNode) {
                list.add(curNode);
                if (curNode.getChildCount() > 0) {
                    curNode = curNode.getChildAt(0);
                    continue;
                }
                boolean nextChildFound = false;
                while (curNode != startingNode && !nextChildFound) {
                    TreeNode parent = curNode.getParent();
                    int prevIndex = parent.getIndex(curNode);
                    if (prevIndex < parent.getChildCount() - 1) {
                        curNode = parent.getChildAt(prevIndex + 1);
                        nextChildFound = true;
                        continue;
                    }
                    curNode = parent;
                }
            }
        }
        return list;
    }

    public static List descendantsOfNode(DefaultTreeNode startingNode, boolean includeStartingNode) {
        ArrayList<DefaultTreeNode> list = new ArrayList<DefaultTreeNode>();
        if (includeStartingNode) {
            list.add(startingNode);
        }
        if (startingNode.getChildCount() > 0) {
            DefaultTreeNode curNode = startingNode.getChild(0);
            while (curNode != startingNode) {
                list.add(curNode);
                if (curNode.getChildCount() > 0) {
                    curNode = curNode.getChild(0);
                    continue;
                }
                boolean nextChildFound = false;
                while (curNode != startingNode && !nextChildFound) {
                    DefaultTreeNode parent = curNode.getParent();
                    int prevIndex = parent.getChildIndex(curNode);
                    if (prevIndex < parent.getChildCount() - 1) {
                        curNode = parent.getChild(prevIndex + 1);
                        nextChildFound = true;
                        continue;
                    }
                    curNode = parent;
                }
            }
        }
        return list;
    }

    public static List descendantsOfNode(com.metamatrix.common.tree.TreeNode startingNode, boolean includeStartingNode, TreeView treeView) {
        int startingNodeChildCount;
        ArrayList<com.metamatrix.common.tree.TreeNode> list = new ArrayList<com.metamatrix.common.tree.TreeNode>();
        if (includeStartingNode) {
            list.add(startingNode);
        }
        if ((startingNodeChildCount = treeView.getChildren(startingNode).size()) > 0) {
            com.metamatrix.common.tree.TreeNode curNode = (com.metamatrix.common.tree.TreeNode)treeView.getChildren(startingNode).get(0);
            while (curNode != startingNode) {
                list.add(curNode);
                int curNodeChildCount = treeView.getChildren(curNode).size();
                if (curNodeChildCount > 0) {
                    curNode = (com.metamatrix.common.tree.TreeNode)treeView.getChildren(curNode).get(0);
                    continue;
                }
                boolean nextChildFound = false;
                while (curNode != startingNode && !nextChildFound) {
                    com.metamatrix.common.tree.TreeNode parent = treeView.getParent(curNode);
                    List parentsChildren = treeView.getChildren(parent);
                    int prevIndex = parentsChildren.indexOf(curNode);
                    if (prevIndex < parentsChildren.size() - 1) {
                        curNode = (com.metamatrix.common.tree.TreeNode)parentsChildren.get(prevIndex + 1);
                        nextChildFound = true;
                        continue;
                    }
                    curNode = parent;
                }
            }
        }
        return list;
    }

    public static List descendantsOfNode(TreeNode startingNode) {
        return StaticTreeUtilities.descendantsOfNode(startingNode, false);
    }

    public static void collapse(JTree tree) {
        boolean foundCollapsibleRow = true;
        while (foundCollapsibleRow) {
            foundCollapsibleRow = false;
            int numRows = tree.getRowCount();
            for (int curRow = numRows - 1; curRow >= 0; --curRow) {
                if (tree.isCollapsed(curRow)) continue;
                tree.collapseRow(curRow);
                foundCollapsibleRow = true;
            }
        }
    }

    public static String nodesString(DefaultTreeModel model) {
        DefaultMutableTreeNode root;
        String str = "";
        DefaultMutableTreeNode curNode = root = (DefaultMutableTreeNode)model.getRoot();
        int level = 0;
        boolean done = false;
        while (!done) {
            if (curNode != root) {
                str = str + "\n";
            }
            int numBlanks = 4 * level;
            for (int i = 0; i < numBlanks; ++i) {
                str = str + " ";
            }
            str = str + curNode.getClass().getName() + ":  " + curNode.toString();
            if (curNode.getChildCount() > 0) {
                curNode = (DefaultMutableTreeNode)curNode.getChildAt(0);
                ++level;
                continue;
            }
            boolean nextNodeFound = false;
            while (!done && !nextNodeFound) {
                if (curNode == root) {
                    done = true;
                    continue;
                }
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)curNode.getParent();
                int childIndex = parent.getIndex(curNode);
                if (childIndex < parent.getChildCount() - 1) {
                    curNode = (DefaultMutableTreeNode)parent.getChildAt(childIndex + 1);
                    nextNodeFound = true;
                    continue;
                }
                curNode = parent;
                --level;
            }
        }
        return str;
    }

    public static String nodesString(JTree tree) {
        String str = null;
        TreeModel tm = tree.getModel();
        if (tm instanceof DefaultTreeModel) {
            DefaultTreeModel dtm = (DefaultTreeModel)tm;
            str = StaticTreeUtilities.nodesString(dtm);
        }
        return str;
    }

    public static String treePathToString(TreePath tp, boolean classNamesOnly) {
        String outStr = "";
        if (tp == null) {
            outStr = "null";
        } else {
            Object[] node = tp.getPath();
            for (int i = 0; i < node.length; ++i) {
                Object userObj;
                String nodeStr = null;
                nodeStr = classNamesOnly ? (node[i] == null ? "node null" : (node[i] instanceof DefaultMutableTreeNode ? ((userObj = ((DefaultMutableTreeNode)node[i]).getUserObject()) == null ? "userObject null" : userObj.getClass().getName() + StaticTreeUtilities.tabbedPaneString(userObj)) : "node not DefaultMutableTreeNode")) : node[i].toString();
                if (nodeStr == null) {
                    nodeStr = "null";
                }
                if (i > 0) {
                    outStr = outStr + "->";
                }
                outStr = outStr + nodeStr;
            }
        }
        return outStr;
    }

    public static String treePathToString(TreePath tp) {
        return StaticTreeUtilities.treePathToString(tp, false);
    }

    public static String treePathToString(TreeNode node, boolean classNamesOnly) {
        TreeNode curNode = node;
        Vector<TreeNode> nodes = new Vector<TreeNode>();
        nodes.add(curNode);
        while (curNode.getParent() != null) {
            curNode = curNode.getParent();
            nodes.add(curNode);
        }
        String outStr = "";
        for (int i = nodes.size() - 1; i >= 0; --i) {
            String nodeStr;
            if (classNamesOnly) {
                Object userObj;
                nodeStr = node instanceof DefaultMutableTreeNode ? ((userObj = ((DefaultMutableTreeNode)node).getUserObject()) == null ? "userObject null" : userObj.getClass().getName()) : "node not DefaultMutableTreeNode";
            } else {
                nodeStr = nodes.get(i).toString();
                if (nodeStr == null) {
                    nodeStr = "null";
                }
            }
            if (i < nodes.size() - 1) {
                outStr = outStr + "->";
            }
            outStr = outStr + nodeStr;
        }
        return outStr;
    }

    public static String treePathToString(TreeNode node) {
        return StaticTreeUtilities.treePathToString(node, false);
    }

    public static TreePath[] allTreePaths(TreeModel tm, boolean populate, TreeView treeView) throws Exception {
        boolean javaTreeNode = true;
        Object rootObj = tm.getRoot();
        if (rootObj instanceof TreeNode) {
            javaTreeNode = true;
        } else if (rootObj instanceof com.metamatrix.common.tree.TreeNode) {
            javaTreeNode = false;
        } else {
            throw new Exception("Illegal root node object type: " + rootObj.getClass().getName());
        }
        if (populate) {
            if (javaTreeNode) {
                StaticTreeUtilities.populateTree((TreeNode)rootObj);
            } else {
                StaticTreeUtilities.populateTree((com.metamatrix.common.tree.TreeNode)rootObj, treeView);
            }
        }
        List nodes = javaTreeNode ? StaticTreeUtilities.descendantsOfNode((TreeNode)tm.getRoot(), true) : (tm.getRoot() instanceof DefaultTreeNode && treeView == null ? StaticTreeUtilities.descendantsOfNode((DefaultTreeNode)tm.getRoot(), true) : StaticTreeUtilities.descendantsOfNode((com.metamatrix.common.tree.TreeNode)tm.getRoot(), true, treeView));
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            ArrayList<Object> curPath;
            Object curNode;
            if (javaTreeNode) {
                curNode = (TreeNode)it.next();
                curPath = new ArrayList<Object>();
                curPath.add(curNode);
                while (curNode.getParent() != null) {
                    curNode = curNode.getParent();
                    curPath.add(curNode);
                }
            } else if (tm.getRoot() instanceof DefaultTreeNode && treeView == null) {
                curNode = (DefaultTreeNode)it.next();
                curPath = new ArrayList();
                curPath.add(curNode);
                while (((DefaultTreeNode)curNode).getParent() != null) {
                    curNode = ((DefaultTreeNode)curNode).getParent();
                    curPath.add(curNode);
                }
            } else {
                curNode = (com.metamatrix.common.tree.TreeNode)it.next();
                curPath = new ArrayList();
                curPath.add(curNode);
                while (treeView.getParent((com.metamatrix.common.tree.TreeNode)curNode) != null) {
                    curNode = treeView.getParent((com.metamatrix.common.tree.TreeNode)curNode);
                    curPath.add(curNode);
                }
            }
            Object[] objArray = new Object[curPath.size()];
            for (int i = 0; i < objArray.length; ++i) {
                objArray[objArray.length - 1 - i] = curPath.get(i);
            }
            TreePath tp = new TreePath(objArray);
            paths.add(tp);
        }
        TreePath[] tp = new TreePath[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            tp[i] = (TreePath)paths.get(i);
        }
        return tp;
    }

    public static TreePath[] allTreePaths(TreeModel tm, TreeView treeView) throws Exception {
        return StaticTreeUtilities.allTreePaths(tm, false, treeView);
    }

    public static TreePath[] allTreePaths(TreeModel tm, boolean populate) throws Exception {
        return StaticTreeUtilities.allTreePaths(tm, populate, null);
    }

    public static TreePath[] allTreePathsToLeafNodes(TreeModel tm) {
        TreePath[] allPaths = null;
        try {
            allPaths = StaticTreeUtilities.allTreePaths(tm, false, null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        ArrayList<TreePath> leafNodePaths = new ArrayList<TreePath>();
        for (int i = 0; i < allPaths.length; ++i) {
            Cloneable lastNode;
            Object lastPathComponent = allPaths[i].getLastPathComponent();
            if (lastPathComponent instanceof DefaultMutableTreeNode) {
                lastNode = (DefaultMutableTreeNode)lastPathComponent;
                if (!((DefaultMutableTreeNode)lastNode).isLeaf()) continue;
                leafNodePaths.add(allPaths[i]);
                continue;
            }
            if (!(lastPathComponent instanceof DefaultTreeNode) || ((DefaultTreeNode)(lastNode = (DefaultTreeNode)lastPathComponent)).getChildCount() != 0) continue;
            leafNodePaths.add(allPaths[i]);
        }
        TreePath[] leafNodePathsArray = new TreePath[leafNodePaths.size()];
        Iterator it = leafNodePaths.iterator();
        int i = 0;
        while (it.hasNext()) {
            leafNodePathsArray[i] = (TreePath)it.next();
            ++i;
        }
        return leafNodePathsArray;
    }

    public static String allTreePathsToString(JTree tree, TreeView treeView) {
        TreePath[] treePaths = null;
        try {
            treePaths = StaticTreeUtilities.allTreePaths(tree.getModel(), false, treeView);
        }
        catch (Exception e) {
            // empty catch block
        }
        String str = "All tree paths:\n";
        for (int i = 0; i < treePaths.length; ++i) {
            String treePathString = StaticTreeUtilities.treePathToString(treePaths[i]);
            str = str + treePathString;
            str = tree.isExpanded(treePaths[i]) ? str + " (exp.)" : str + " (not exp.)";
            str = str + "\n";
        }
        return str;
    }

    public static String allTreePathsToString(TreeModel model, boolean classNamesOnly, TreeView treeView) {
        TreePath[] treePaths = null;
        try {
            treePaths = StaticTreeUtilities.allTreePaths(model, false, treeView);
        }
        catch (Exception e) {
            // empty catch block
        }
        String str = "All tree paths:\n";
        for (int i = 0; i < treePaths.length; ++i) {
            String treePathString = StaticTreeUtilities.treePathToString(treePaths[i], classNamesOnly);
            str = str + treePathString;
            str = str + "\n";
        }
        return str;
    }

    public static String allTreePathsToString(TreeModel model) {
        return StaticTreeUtilities.allTreePathsToString(model, false, null);
    }

    public static Collection allTreePathsToNode(Object nodeUserObject, TreeModel model, TreeView treeView) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        TreePath[] tp = null;
        try {
            tp = StaticTreeUtilities.allTreePaths(model, false, treeView);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < tp.length; ++i) {
            DefaultMutableTreeNode lastNode;
            Object last = tp[i].getLastPathComponent();
            if (!(last instanceof DefaultMutableTreeNode) || (lastNode = (DefaultMutableTreeNode)last).getUserObject() == null || !lastNode.getUserObject().equals(nodeUserObject)) continue;
            paths.add(tp[i]);
        }
        return paths;
    }

    public static Collection allTreePathsToNode(Object nodeUserObject, TreeModel model) {
        return StaticTreeUtilities.allTreePathsToNode(nodeUserObject, model, null);
    }

    public static int indexInTreePath(String name, TreePath tp) {
        int index = -1;
        if (name != null) {
            Object[] nodes = tp.getPath();
            int loc = 0;
            while (index == -1 && loc < nodes.length) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)nodes[loc];
                String str = tn.toString();
                if (str == null) {
                    str = "";
                }
                if (str.length() > 0 && str.equals(name)) {
                    index = loc;
                    continue;
                }
                ++loc;
            }
        }
        return index;
    }

    public static void populateTree(TreeNode root) throws Exception {
        TreeNode curNode = root;
        boolean done = false;
        while (!done) {
            LazyBranchNode lbn;
            if (curNode instanceof LazyBranchNode && !(lbn = (LazyBranchNode)curNode).isPopulated()) {
                lbn.populate();
            }
            if (curNode.getChildCount() > 0) {
                curNode = curNode.getChildAt(0);
                continue;
            }
            boolean nextChildFound = false;
            while (!done && !nextChildFound) {
                if (curNode == root) {
                    done = true;
                    continue;
                }
                TreeNode parent = curNode.getParent();
                int prevIndex = parent.getIndex(curNode);
                if (prevIndex < parent.getChildCount() - 1) {
                    curNode = parent.getChildAt(prevIndex + 1);
                    nextChildFound = true;
                    continue;
                }
                curNode = parent;
            }
        }
    }

    public static void populateTree(com.metamatrix.common.tree.TreeNode root, TreeView treeView) {
        com.metamatrix.common.tree.TreeNode curNode = root;
        boolean done = false;
        while (!done) {
            List children = treeView.getChildren(curNode);
            int numChildren = children.size();
            if (numChildren > 0) {
                curNode = (com.metamatrix.common.tree.TreeNode)children.get(0);
                continue;
            }
            boolean nextNodeFound = false;
            while (!nextNodeFound && !done) {
                if (curNode == root) {
                    done = true;
                    continue;
                }
                com.metamatrix.common.tree.TreeNode parent = treeView.getParent(curNode);
                List parentsChildren = treeView.getChildren(parent);
                int index = parentsChildren.indexOf(curNode);
                if (index < parentsChildren.size() - 1) {
                    curNode = (com.metamatrix.common.tree.TreeNode)parentsChildren.get(index + 1);
                    nextNodeFound = true;
                    continue;
                }
                curNode = parent;
            }
        }
    }

    public static TreePathExpansion[] expansionState(JTree tree, TreeView treeView, boolean populate) throws Exception {
        TreePath[] tp = StaticTreeUtilities.allTreePaths(tree.getModel(), populate, treeView);
        TreePathExpansion[] tpe = new TreePathExpansion[tp.length];
        for (int i = 0; i < tpe.length; ++i) {
            boolean expanded = false;
            boolean hasBeenSet = false;
            Object lastNode = tp[i].getLastPathComponent();
            if (lastNode != null) {
                boolean lastNodeIsLeaf;
                TreeNode tn;
                if (treeView == null) {
                    tn = (TreeNode)lastNode;
                    lastNodeIsLeaf = tn.getChildCount() == 0;
                } else {
                    tn = (com.metamatrix.common.tree.TreeNode)lastNode;
                    boolean bl = lastNodeIsLeaf = treeView.getChildren((com.metamatrix.common.tree.TreeNode)tn).size() == 0;
                }
                if (lastNodeIsLeaf) {
                    Object[] parentPathNode = new Object[tp[i].getPathCount() - 1];
                    for (int j = 0; j < parentPathNode.length; ++j) {
                        parentPathNode[j] = tp[i].getPathComponent(j);
                    }
                    TreePath parentPath = new TreePath(parentPathNode);
                    expanded = tree.isExpanded(parentPath);
                    hasBeenSet = true;
                }
            }
            if (!hasBeenSet) {
                expanded = tree.isExpanded(tp[i]);
            }
            tpe[i] = new TreePathExpansion(tp[i], expanded);
        }
        return tpe;
    }

    public static TreePathExpansion[] expansionState(JTree tree) throws Exception {
        return StaticTreeUtilities.expansionState(tree, null, true);
    }

    public static TreePathExpansion[] expansionState(JTree tree, boolean populate) throws Exception {
        return StaticTreeUtilities.expansionState(tree, null, populate);
    }

    public static void restoreExpansionState(JTree tree, TreePathExpansion[] savedPathState, boolean expandNewPaths, Collection selectionListeners, Collection willExpandListeners, Collection expansionListeners, TreeView treeView) throws Exception {
        TreePath[] selectedPaths = tree.getSelectionPaths();
        if (selectionListeners != null && selectionListeners.size() > 0) {
            for (EventListener listener : selectionListeners) {
                tree.removeTreeSelectionListener((TreeSelectionListener)listener);
            }
        }
        if (willExpandListeners != null && willExpandListeners.size() > 0) {
            for (EventListener listener : willExpandListeners) {
                tree.removeTreeWillExpandListener((TreeWillExpandListener)listener);
            }
        }
        if (expansionListeners != null && expansionListeners.size() > 0) {
            for (EventListener listener : expansionListeners) {
                tree.removeTreeExpansionListener((TreeExpansionListener)listener);
            }
        }
        TreePath[] tp = StaticTreeUtilities.allTreePaths(tree.getModel(), true, treeView);
        StaticTreeUtilities.collapse(tree);
        for (int i = 0; i < tp.length; ++i) {
            boolean found = false;
            int j = 0;
            while (!found && j < savedPathState.length) {
                if (StaticTreeUtilities.treePathsEqual(tp[i], savedPathState[j].getTreePath())) {
                    found = true;
                    continue;
                }
                ++j;
            }
            boolean expanding = false;
            if (found) {
                if (savedPathState[j].isExpanded()) {
                    expanding = true;
                }
            } else if (expandNewPaths) {
                expanding = true;
            }
            if (!expanding) continue;
            tree.expandPath(tp[i]);
        }
        try {
            tree.setSelectionPaths(selectedPaths);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (selectionListeners != null && selectionListeners.size() > 0) {
            for (TreeSelectionListener listener : selectionListeners) {
                tree.addTreeSelectionListener(listener);
            }
        }
        if (willExpandListeners != null && willExpandListeners.size() > 0) {
            for (TreeWillExpandListener listener : willExpandListeners) {
                tree.addTreeWillExpandListener(listener);
            }
        }
        if (expansionListeners != null && expansionListeners.size() > 0) {
            for (TreeExpansionListener listener : expansionListeners) {
                tree.addTreeExpansionListener(listener);
            }
        }
    }

    public static void restoreExpansionState(JTree tree, TreePathExpansion[] savedPathState, boolean expandNewPaths, Collection selectionListeners, Collection willExpandListeners, Collection expansionListeners) throws Exception {
        StaticTreeUtilities.restoreExpansionState(tree, savedPathState, expandNewPaths, selectionListeners, willExpandListeners, expansionListeners, null);
    }

    public static void restoreExpansionState(JTree tree, TreePathExpansion[] savedPathState, boolean expandNewPaths, TreeView treeView) throws Exception {
        StaticTreeUtilities.restoreExpansionState(tree, savedPathState, expandNewPaths, null, null, null, treeView);
    }

    public static void restoreExpansionState(JTree tree, TreePathExpansion[] savedPathState, boolean expandNewPaths) throws Exception {
        StaticTreeUtilities.restoreExpansionState(tree, savedPathState, expandNewPaths, null, null, null, null);
    }

    public static TreePath[] allExpandedPaths(JTree tree, TreeView treeView) {
        TreePath[] allPaths = null;
        try {
            allPaths = StaticTreeUtilities.allTreePaths(tree.getModel(), false, treeView);
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<TreePath> expandedPaths = new ArrayList<TreePath>();
        for (int i = 0; i < allPaths.length; ++i) {
            if (!tree.isExpanded(allPaths[i])) continue;
            expandedPaths.add(allPaths[i]);
        }
        TreePath[] array = new TreePath[expandedPaths.size()];
        Iterator it = expandedPaths.iterator();
        int i = 0;
        while (it.hasNext()) {
            array[i] = (TreePath)it.next();
            ++i;
        }
        return array;
    }

    public static boolean treePathsEqual(TreePath tp1, TreePath tp2) {
        boolean equal = false;
        if (tp1 == null && tp2 == null) {
            equal = true;
        } else if (tp1 != null && tp2 != null && tp1.getPathCount() == tp2.getPathCount()) {
            boolean mismatchFound = false;
            int i = 0;
            while (i < tp1.getPathCount() && !mismatchFound) {
                String str1 = tp1.getPathComponent(i).toString();
                String str2 = tp2.getPathComponent(i).toString();
                boolean itemsMatch = false;
                itemsMatch = str1 == null && str2 == null ? true : str1.equals(str2);
                if (itemsMatch) {
                    ++i;
                    continue;
                }
                mismatchFound = true;
            }
            equal = !mismatchFound;
        }
        return equal;
    }

    public static DefaultMutableTreeNode nodeWithObjectOf(TreeModel tree, Object userObj) {
        DefaultMutableTreeNode theNode = null;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getRoot();
        List nodes = StaticTreeUtilities.descendantsOfNode(root, true);
        Iterator it = nodes.iterator();
        while (theNode == null && it.hasNext()) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)it.next();
            if (curNode.getUserObject() == null || !curNode.getUserObject().equals(userObj)) continue;
            theNode = curNode;
        }
        return theNode;
    }

    public static void deselectAll(JTree tree) {
        TreePath[] tp = tree.getSelectionPaths();
        tree.removeSelectionPaths(tp);
    }

    public static int removeNode(Object node, TreeModel model) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        int removalCount = 0;
        if (root.getChildCount() > 0) {
            boolean done = false;
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)root.getChildAt(0);
            DefaultMutableTreeNode curParent = root;
            while (!done) {
                if (curNode.getUserObject().equals(node)) {
                    curParent.remove(curNode);
                    ++removalCount;
                    curNode = curParent;
                    curParent = (DefaultMutableTreeNode)curNode.getParent();
                    continue;
                }
                if (curNode.getChildCount() > 0) {
                    curParent = curNode;
                    curNode = (DefaultMutableTreeNode)curNode.getChildAt(0);
                    continue;
                }
                boolean nextNodeFound = false;
                while (!nextNodeFound && !done) {
                    int indexOfNodeToParent = curParent.getIndex(curNode);
                    if (indexOfNodeToParent < curParent.getChildCount() - 1) {
                        curNode = (DefaultMutableTreeNode)curParent.getChildAt(indexOfNodeToParent + 1);
                        nextNodeFound = true;
                        continue;
                    }
                    curNode = curParent;
                    if (curNode == root) {
                        done = true;
                        continue;
                    }
                    curParent = (DefaultMutableTreeNode)curNode.getParent();
                }
            }
        }
        return removalCount;
    }

    public static int indexOfUserObject(DefaultMutableTreeNode node, Object userObject) {
        int childCount = node.getChildCount();
        boolean found = false;
        int matchLoc = -1;
        for (int loc = 0; loc < childCount && !found; ++loc) {
            DefaultMutableTreeNode dtn;
            TreeNode tn = node.getChildAt(loc);
            if (!(tn instanceof DefaultMutableTreeNode) || (dtn = (DefaultMutableTreeNode)tn).getUserObject() == null || !dtn.getUserObject().equals(userObject)) continue;
            found = true;
            matchLoc = loc;
        }
        return matchLoc;
    }

    public static String[] treePathToStrings(TreePath tp) {
        Object[] pathNodes = tp.getPath();
        String[] s = new String[pathNodes.length];
        for (int i = 0; i < pathNodes.length; ++i) {
            s[i] = pathNodes[i].toString();
        }
        return s;
    }

    public static DefaultMutableTreeNode nodeAtToStringPath(TreeModel tm, String[] tsp) {
        DefaultMutableTreeNode lastNode = null;
        DefaultMutableTreeNode currentNode = null;
        boolean noMatch = false;
        int i = 0;
        while (i < tsp.length && !noMatch) {
            ArrayList<Object> possibleNodes = new ArrayList<Object>();
            if (i == 0) {
                possibleNodes.add(tm.getRoot());
            } else {
                Enumeration<TreeNode> enumeration = currentNode.children();
                while (enumeration.hasMoreElements()) {
                    possibleNodes.add(enumeration.nextElement());
                }
            }
            boolean match = false;
            Iterator it = possibleNodes.iterator();
            while (!match && it.hasNext()) {
                DefaultMutableTreeNode thisNode = (DefaultMutableTreeNode)it.next();
                if (!thisNode.toString().equals(tsp[i])) continue;
                match = true;
                currentNode = thisNode;
            }
            if (!match) {
                noMatch = true;
                continue;
            }
            ++i;
        }
        if (!noMatch) {
            lastNode = currentNode;
        }
        return lastNode;
    }

    public static void userTabPaintProblemDuplicateNodeCheck(JTree tree) {
        if (!LogManager.isMessageToBeRecorded((String)CONTEXT_FOR_DUPE_CHECKING, (int)6)) {
            return;
        }
        List nodesList = StaticTreeUtilities.descendantsOfNode((TreeNode)tree.getModel().getRoot(), true);
        int listLen = nodesList.size();
        for (int i = 0; i < listLen; ++i) {
            String str1 = nodesList.get(i).toString();
            for (int j = i + 1; j < listLen; ++j) {
                String str2 = nodesList.get(j).toString();
                if (!str1.equals(str2)) continue;
                String outStr = StaticTreeUtilities.nodesString(tree);
                LogManager.log((int)6, (String)CONTEXT_FOR_DUPE_CHECKING, (String)("Duplicate nodes found in StaticTreeUtilities.userTabPaintProblemDuplicateNodeCheck():\n" + outStr));
                return;
            }
        }
    }

    public static TreePath treePathToNode(JTree tree, Object node) {
        TreePath path = null;
        int numRows = tree.getRowCount();
        int i = 0;
        while (path == null && i < numRows) {
            Object lastNode;
            TreePath tp = tree.getPathForRow(i);
            if (tp != null && (lastNode = tp.getLastPathComponent()) == node) {
                path = tp;
            }
            if (path != null) continue;
            ++i;
        }
        return path;
    }

    public static TreePath treePathToNodeUsingEquals(JTree tree, Object node) {
        TreePath path = null;
        int numRows = tree.getRowCount();
        int i = 0;
        while (path == null && i < numRows) {
            Object lastNode;
            TreePath tp = tree.getPathForRow(i);
            if (tp != null && (lastNode = tp.getLastPathComponent()).equals(node)) {
                path = tp;
            }
            if (path != null) continue;
            ++i;
        }
        return path;
    }

    private static String tabbedPaneString(Object obj) {
        String str = "";
        if (obj instanceof JTabbedPane) {
            JTabbedPane pane = (JTabbedPane)obj;
            str = "[";
            for (int i = 0; i < pane.getTabCount(); ++i) {
                str = str + pane.getTitleAt(i) + ":";
                str = str + pane.getComponentAt(i).getClass().getName();
                if (i >= pane.getTabCount() - 1) continue;
                str = str + ",";
            }
            str = str + "]";
        }
        return str;
    }
}

