/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.util.CenteredOptionPane;
import com.metamatrix.console.ui.util.property.PropertyProvider;
import com.metamatrix.console.util.StaticProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class StaticUtilities {
    public static final int PREFERRED_MODAL_DIALOG_TEXT_WIDTH = 70;
    public static final int MAX_MODAL_DIALOG_TEXT_WIDTH = 130;
    private static boolean showingWaitCursor = false;

    public static String roundToNumDecimalPlaces(double inputVal, int numDecPlaces) {
        String formatString;
        int MIN_DEC_PLACES = 0;
        int MAX_DEC_PLACES = 10;
        if (numDecPlaces < MIN_DEC_PLACES || numDecPlaces > MAX_DEC_PLACES) {
            return null;
        }
        if (numDecPlaces == 0) {
            formatString = "#0";
        } else {
            formatString = "#0.";
            for (int i = 1; i <= numDecPlaces; ++i) {
                formatString = formatString + "0";
            }
        }
        DecimalFormat df = new DecimalFormat(formatString);
        String numStr = df.format(inputVal);
        return numStr;
    }

    public static Point centerFrame(Dimension frameSize, Dimension screenSize) {
        int x = (screenSize.width - frameSize.width) / 2;
        int y = (screenSize.height - frameSize.height) / 2;
        return new Point(x, y);
    }

    public static Point centerFrame(Dimension frameSize) {
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension screenSize = t.getScreenSize();
        return StaticUtilities.centerFrame(frameSize, screenSize);
    }

    public static String insertLineBreaks(String str, int preferredMaxLineLen, int maxMaxLineLen) {
        int maxNonBlankSegment = StaticUtilities.longestNonBlankStringSegment(str);
        int maxLineLen = maxNonBlankSegment < preferredMaxLineLen ? preferredMaxLineLen : (maxNonBlankSegment > maxMaxLineLen ? maxMaxLineLen : maxNonBlankSegment);
        StringBuffer out = new StringBuffer(str.length() + 10);
        int lastLoc = str.length() - 1;
        int lastLocCopied = -1;
        boolean continuing = true;
        while (lastLocCopied < lastLoc && continuing) {
            int lastCopyableLoc;
            int firstLocToCopy = lastLocCopied + 1;
            boolean firstNonBlankFound = false;
            while (!firstNonBlankFound && firstLocToCopy <= lastLoc) {
                char curChar = str.charAt(firstLocToCopy);
                if (curChar != ' ') {
                    firstNonBlankFound = true;
                    continue;
                }
                ++firstLocToCopy;
            }
            if (!firstNonBlankFound) {
                continuing = false;
            }
            if (!continuing) continue;
            if (out.length() > 0) {
                out = out.append('\n');
            }
            if (str.charAt(firstLocToCopy) == '\n' && ++firstLocToCopy > lastLoc) {
                continuing = false;
            }
            if (!continuing) continue;
            int curLoc = lastCopyableLoc = Math.min(lastLoc, firstLocToCopy + maxLineLen - 1);
            int lastLinefeedLocInSeg = -1;
            while (lastLinefeedLocInSeg < 0 && curLoc >= firstLocToCopy) {
                char curChar = str.charAt(curLoc);
                if (curChar == '\n') {
                    lastLinefeedLocInSeg = curLoc;
                    continue;
                }
                --curLoc;
            }
            if (lastLinefeedLocInSeg >= 0) {
                out = out.append(str.substring(firstLocToCopy, lastLinefeedLocInSeg + 1));
                firstLocToCopy = lastLinefeedLocInSeg + 1;
                if (firstLocToCopy > lastLoc) {
                    continuing = false;
                } else {
                    lastCopyableLoc = Math.min(lastLoc, firstLocToCopy + maxLineLen - 1);
                }
            }
            if (!continuing) continue;
            int origLastCopyableLoc = lastCopyableLoc;
            char lastCopyableChar = str.charAt(lastCopyableLoc);
            if (lastCopyableChar != ' ') {
                boolean lastCharacterInWord = false;
                if (lastCopyableLoc == lastLoc) {
                    lastCharacterInWord = true;
                } else {
                    char nextChar = str.charAt(lastCopyableLoc + 1);
                    if (nextChar == ' ') {
                        lastCharacterInWord = true;
                    }
                }
                if (!lastCharacterInWord) {
                    boolean lineAllNonBlanks = false;
                    while (!lineAllNonBlanks && str.charAt(lastCopyableLoc) != ' ') {
                        if (--lastCopyableLoc >= firstLocToCopy) continue;
                        lineAllNonBlanks = true;
                        lastCopyableLoc = origLastCopyableLoc;
                    }
                }
            }
            while (str.charAt(lastCopyableLoc) == ' ') {
                --lastCopyableLoc;
            }
            out = out.append(str.substring(firstLocToCopy, lastCopyableLoc + 1));
            lastLocCopied = lastCopyableLoc;
        }
        return out.toString();
    }

    public static String[] getLineBreakSubstrings(String str) {
        ArrayList<String> substrings = new ArrayList<String>();
        int strLen = str.length();
        boolean prevCharWasLinebreak = true;
        StringBuffer buf = null;
        for (int loc = 0; loc <= strLen; ++loc) {
            char curChar;
            if (prevCharWasLinebreak) {
                buf = new StringBuffer();
            }
            if ((curChar = loc == strLen ? (char)'\n' : (char)str.charAt(loc)) == '\n') {
                String prevStr = buf.toString();
                substrings.add(prevStr);
                prevCharWasLinebreak = true;
                continue;
            }
            if (loc >= strLen) continue;
            prevCharWasLinebreak = false;
            buf = buf.append(curChar);
        }
        String[] strArray = new String[substrings.size()];
        Iterator it = substrings.iterator();
        int i = 0;
        while (it.hasNext()) {
            strArray[i] = (String)it.next();
            ++i;
        }
        return strArray;
    }

    public static void displayModalDialogWithOK(Component parent, String header, String msg, int messageType) {
        String formattedMsg = StaticUtilities.insertLineBreaks(msg, 70, 130);
        CenteredOptionPane.showMessageDialog(parent, formattedMsg, header, messageType, null);
    }

    public static void displayModalDialogWithOK(Component parent, String header, String msg) {
        StaticUtilities.displayModalDialogWithOK(parent, header, msg, -1);
    }

    public static void displayModalDialogWithOK(String hdr, String msg, int messageType) {
        StaticUtilities.displayModalDialogWithOK(ViewManager.getMainFrame(), hdr, msg, messageType);
    }

    public static void displayModalDialogWithOK(String hdr, String msg) {
        StaticUtilities.displayModalDialogWithOK(ViewManager.getMainFrame(), hdr, msg, -1);
    }

    public static void setDateFormat(String format) {
    }

    public static SimpleDateFormat getDefaultDateFormat() {
        PropertyProvider propProvider = new PropertyProvider("com/metamatrix/console/ui/data/common_ui");
        SimpleDateFormat formatter = (SimpleDateFormat)propProvider.getObject("date.formatter.default");
        return formatter;
    }

    public static int longestNonBlankStringSegment(String str) {
        int longest = -1;
        if (str != null) {
            longest = 0;
            int lastBreakSS = -1;
            int lastSS = str.length();
            for (int curSS = 0; curSS <= lastSS; ++curSS) {
                int curChar = curSS == lastSS ? 32 : (int)str.charAt(curSS);
                if (curChar != 32) continue;
                int curSegLen = curSS - lastBreakSS - 1;
                if (curSegLen > longest) {
                    longest = curSegLen;
                }
                lastBreakSS = curSS;
            }
        }
        return longest;
    }

    public static String[] tokenize(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuffer delimsBuffer = new StringBuffer();
        delimsBuffer = delimsBuffer.append(' ');
        delimsBuffer = delimsBuffer.append('\n');
        delimsBuffer = delimsBuffer.append('\r');
        String delims = delimsBuffer.toString();
        StringTokenizer tokenizer = new StringTokenizer(str, delims);
        boolean done = false;
        while (!done) {
            String token = null;
            try {
                token = tokenizer.nextToken();
            }
            catch (Exception ex) {
                done = true;
            }
            if (done) continue;
            tokens.add(token);
        }
        String[] tokenArray = new String[tokens.size()];
        Iterator it = tokens.iterator();
        int i = 0;
        while (it.hasNext()) {
            tokenArray[i] = (String)it.next();
            ++i;
        }
        return tokenArray;
    }

    public static String deleteChar(String sSource, char charToRemove) {
        StringBuffer sbModel = new StringBuffer(sSource);
        StringBuffer sbControl = new StringBuffer(sbModel.toString());
        int iLen = sbControl.length();
        int iDeletedCnt = 0;
        for (int x = 0; x < iLen; ++x) {
            if (sbControl.charAt(x) != charToRemove) continue;
            sbModel.deleteCharAt(x - iDeletedCnt);
            ++iDeletedCnt;
        }
        return sbModel.toString();
    }

    public static List descendantsOfComponent(Component startComp) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(startComp);
        int lastIndexExpanded = -1;
        while (lastIndexExpanded < list.size() - 1) {
            Component comp;
            if (!((comp = (Component)list.get(++lastIndexExpanded)) instanceof Container)) continue;
            Component expansionComp = comp;
            if (comp instanceof JFrame) {
                expansionComp = ((JFrame)comp).getContentPane();
            } else if (comp instanceof JDialog) {
                expansionComp = ((JDialog)comp).getContentPane();
            }
            if (!(expansionComp instanceof Container)) continue;
            Component[] children = ((Container)expansionComp).getComponents();
            for (int i = 0; i < children.length; ++i) {
                list.add(children[i]);
            }
        }
        return list;
    }

    public static int[] primeFactors(int num) {
        ArrayList<Integer> factors = new ArrayList<Integer>();
        if (num <= 1) {
            factors.add(new Integer(num));
        } else {
            int curValue = num;
            int curFac = 2;
            int upperLim = (int)Math.sqrt(curValue) + 1;
            boolean doneFactoring = false;
            while (!doneFactoring) {
                if (curFac > upperLim) {
                    doneFactoring = true;
                    continue;
                }
                if (curValue % curFac == 0) {
                    factors.add(new Integer(curFac));
                    upperLim = (int)Math.sqrt(curValue /= curFac) + 1;
                    continue;
                }
                ++curFac;
            }
            factors.add(new Integer(curValue));
        }
        int[] array = new int[factors.size()];
        int loc = 0;
        Iterator it = factors.iterator();
        while (it.hasNext()) {
            array[loc] = (Integer)it.next();
            ++loc;
        }
        return array;
    }

    public static Collection intersectionOf(Collection collections) {
        int j;
        int i;
        if (collections == null) {
            return null;
        }
        if (collections.size() == 1) {
            return (Collection)collections.iterator().next();
        }
        ArrayList resultList = new ArrayList();
        ArrayList inputLists = new ArrayList();
        for (Collection curCollection : collections) {
            Iterator it2 = curCollection.iterator();
            ArrayList curList = new ArrayList();
            while (it2.hasNext()) {
                Object obj = it2.next();
                curList.add(obj);
            }
            inputLists.add(curList);
        }
        int shortestListSize = ((List)inputLists.get(0)).size();
        int shortestListLoc = 0;
        for (int i2 = 1; i2 < inputLists.size(); ++i2) {
            List curList = (List)inputLists.get(i2);
            int curListSize = curList.size();
            if (curListSize >= shortestListSize) continue;
            shortestListSize = curListSize;
            shortestListLoc = i2;
        }
        int CELL_UNUSED = 0;
        int CELL_USED = 1;
        int CELL_MARKED = 2;
        ArrayList markings = new ArrayList();
        for (i = 0; i < inputLists.size(); ++i) {
            List curList = (List)inputLists.get(i);
            ArrayList<Integer> curMarkedList = new ArrayList<Integer>();
            for (j = 0; j < curList.size(); ++j) {
                curMarkedList.add(new Integer(CELL_UNUSED));
            }
            markings.add(curMarkedList);
        }
        inputLists.get(shortestListLoc);
        for (i = 0; i < shortestListSize; ++i) {
            Object curElement = ((List)inputLists.get(shortestListLoc)).get(i);
            ((List)markings.get(shortestListLoc)).set(i, new Integer(CELL_MARKED));
            boolean notInList = false;
            for (j = 0; !notInList && j < inputLists.size(); ++j) {
                if (j == shortestListLoc) continue;
                List curInputList = (List)inputLists.get(j);
                boolean inList = false;
                int k = 0;
                while (!inList && k < curInputList.size()) {
                    int curMarking = (Integer)((List)markings.get(j)).get(k);
                    if (curMarking == CELL_UNUSED) {
                        Object curComparisonElement = curInputList.get(k);
                        if (curElement.equals(curComparisonElement)) {
                            inList = true;
                            ((List)markings.get(j)).set(k, new Integer(CELL_MARKED));
                            continue;
                        }
                        ++k;
                        continue;
                    }
                    ++k;
                }
                if (inList) continue;
                notInList = true;
            }
            if (notInList) {
                StaticUtilities.resetElements(CELL_MARKED, CELL_UNUSED, markings);
                continue;
            }
            resultList.add(curElement);
            StaticUtilities.resetElements(CELL_MARKED, CELL_USED, markings);
        }
        return resultList;
    }

    public static Collection unionOf(Collection collections) {
        int CELL_UNUSED = 0;
        int CELL_MARKED = 1;
        if (collections == null) {
            return null;
        }
        ArrayList union = new ArrayList();
        ArrayList<Integer> markings = new ArrayList<Integer>();
        Iterator it = collections.iterator();
        while (it.hasNext()) {
            for (int i = 0; i < markings.size(); ++i) {
                markings.set(i, new Integer(CELL_UNUSED));
            }
            Collection aCollection = (Collection)it.next();
            for (Object curObject : aCollection) {
                boolean matchFound = false;
                int i = 0;
                while (!matchFound && i < union.size()) {
                    if ((Integer)markings.get(i) == CELL_UNUSED && curObject.equals(union.get(i))) {
                        matchFound = true;
                        markings.set(i, new Integer(CELL_MARKED));
                        continue;
                    }
                    ++i;
                }
                if (matchFound) continue;
                union.add(curObject);
                markings.add(new Integer(CELL_MARKED));
            }
        }
        return union;
    }

    public static int greatestCommonDivisor(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] >= 1) continue;
            return -1;
        }
        ArrayList factors = new ArrayList();
        for (int j = 0; j < array.length; ++j) {
            int[] fac = StaticUtilities.primeFactors(array[j]);
            ArrayList<Integer> coll = new ArrayList<Integer>();
            for (int i = 0; i < fac.length; ++i) {
                coll.add(new Integer(fac[i]));
            }
            factors.add(coll);
        }
        Collection commonFactors = StaticUtilities.intersectionOf(factors);
        int product = 1;
        Iterator it = commonFactors.iterator();
        while (it.hasNext()) {
            product *= ((Integer)it.next()).intValue();
        }
        return product;
    }

    public static int leastCommonMultiple(int[] array) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] < 1) {
                return -1;
            }
            if (array[i] <= 1) continue;
            values.add(new Integer(array[i]));
        }
        ArrayList collections = new ArrayList();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            int val = (Integer)it.next();
            int[] factors = StaticUtilities.primeFactors(val);
            ArrayList<Integer> collection = new ArrayList<Integer>();
            for (int i = 0; i < factors.length; ++i) {
                collection.add(new Integer(factors[i]));
            }
            collections.add(collection);
        }
        Collection union = StaticUtilities.unionOf(collections);
        int product = 1;
        it = union.iterator();
        while (it.hasNext()) {
            product *= ((Integer)it.next()).intValue();
        }
        return product;
    }

    public static void jiggleSplitter(JSplitPane splitPane) {
        int splitterLoc = splitPane.getDividerLocation();
        int incr = -5;
        if (splitterLoc == 0) {
            incr = 5;
        }
        splitPane.setDividerLocation(splitterLoc + incr);
        splitPane.setDividerLocation(splitterLoc);
    }

    public static void startWait(Component childComponent) {
        ViewManager.startBusySyncronize();
        Component parent = StaticUtilities.findParentFrame(childComponent);
        if (parent == null) {
            parent = childComponent;
        }
        if (parent instanceof JFrame) {
            ((JFrame)parent).setCursor(StaticProperties.CURSOR_WAIT);
        } else if (parent instanceof JDialog) {
            ((JDialog)parent).setCursor(StaticProperties.CURSOR_WAIT);
        }
        showingWaitCursor = true;
    }

    public static void startWait() {
        StaticUtilities.startWait(ViewManager.getMainFrame());
    }

    public static void endWait(Component childComponent) {
        Component parent = StaticUtilities.findParentFrame(childComponent);
        if (parent == null) {
            parent = childComponent;
        }
        if (parent instanceof JFrame) {
            ((JFrame)parent).setCursor(StaticProperties.CURSOR_DEFAULT);
        } else if (parent instanceof JDialog) {
            ((JDialog)parent).setCursor(StaticProperties.CURSOR_DEFAULT);
        }
        showingWaitCursor = false;
        ViewManager.endBusySyncronize();
    }

    public static void endWait() {
        StaticUtilities.endWait(ViewManager.getMainFrame());
    }

    public static boolean isShowingWaitCursor() {
        return showingWaitCursor;
    }

    private static Container findParentFrame(Component child) {
        Container parent = null;
        parent = SwingUtilities.getAncestorOfClass(JDialog.class, child);
        if (parent == null) {
            Container parentIntFrame = SwingUtilities.getAncestorOfClass(JInternalFrame.class, child);
            parent = parentIntFrame != null ? SwingUtilities.getAncestorOfClass(JFrame.class, parentIntFrame) : SwingUtilities.getAncestorOfClass(JFrame.class, child);
        }
        return parent;
    }

    public static Color averageRGBVals(Color[] colors) {
        Color avg = null;
        if (colors != null) {
            int totRed = 0;
            int totGreen = 0;
            int totBlue = 0;
            for (int i = 0; i < colors.length; ++i) {
                totRed += colors[i].getRed();
                totGreen += colors[i].getGreen();
                totBlue += colors[i].getBlue();
            }
            float numColors = colors.length;
            int red = Math.round((float)totRed / numColors);
            int green = Math.round((float)totGreen / numColors);
            int blue = Math.round((float)totBlue / numColors);
            avg = new Color(red, green, blue);
        }
        return avg;
    }

    public static void disableComponents(Container ct) {
        Component[] cs = ct.getComponents();
        if (cs == null) {
            return;
        }
        for (int ii = 0; ii < cs.length; ++ii) {
            if (cs[ii] instanceof JComboBox || cs[ii] instanceof AbstractButton || cs[ii] instanceof JTextComponent) {
                ((JComponent)cs[ii]).setEnabled(false);
            }
            if (!(cs[ii] instanceof Container)) continue;
            StaticUtilities.disableComponents((Container)cs[ii]);
        }
    }

    public static String getFileName(String fullFileName) {
        String fileName = null;
        if (fullFileName != null) {
            int index = fullFileName.lastIndexOf(File.separatorChar);
            fileName = fullFileName.substring(index + 1);
        }
        return fileName;
    }

    public static String getDirectoryName(String fullFileName) {
        String directoryName = null;
        if (fullFileName != null) {
            int index = fullFileName.lastIndexOf(File.separatorChar);
            directoryName = fullFileName.substring(0, index);
        }
        return directoryName;
    }

    public static String parseDelimitedStringGetRight(String sTheString, String sDelim) {
        String sResult = "";
        int iDelimIndex = sTheString.indexOf(sDelim);
        sResult = iDelimIndex != -1 ? sTheString.substring(iDelimIndex + 1, sTheString.length()) : sTheString;
        return sResult;
    }

    public static Vector arrayToVector(Object[] array) {
        Vector<Object> result = new Vector<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.add(array[i]);
        }
        return result;
    }

    public static Vector doubleArrayToVector(Object[][] array) {
        Vector<Vector> result = new Vector<Vector>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.add(StaticUtilities.arrayToVector(array[i]));
        }
        return result;
    }

    public static void invokeAndWaitSafe(Runnable runnable) throws Throwable {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void invokeLaterSafe(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static void resetElements(int oldValue, int newValue, List markings) {
        for (List curList : markings) {
            for (int i = 0; i < curList.size(); ++i) {
                int curValue = (Integer)curList.get(i);
                if (curValue != oldValue) continue;
                curList.set(i, new Integer(newValue));
            }
        }
    }
}

