/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.preference;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.properties.UnmodifiableProperties;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.ToolboxPlugin;
import com.metamatrix.toolbox.preference.UserPreferencesEditor;
import com.metamatrix.toolbox.ui.widget.util.StringFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class UserPreferences
implements PropertiedObject {
    public static final String LOG_CONTEXT = "USER_PREF";
    public static final String PROPERTY_PREFIX = "PROPERTY_PREFIX";
    private static final String PROPERTY_DELIM = ".";
    public static final String USER_PREFERENCES_DEFINITION_FILE_PROPERTY_NAME = "metamatrix.toolbox.userPrefs";
    private static UserPreferences INSTANCE = new UserPreferences();
    private String userPrefFileName;
    private Properties userPrefProperties;
    private Properties unmodifiableUserPrefProperties;
    private Properties configProperties = System.getProperties();
    private boolean readOnly = false;
    private boolean changed = false;

    private UserPreferences() {
        this.loadProperties();
    }

    public static UserPreferences getInstance() {
        return INSTANCE;
    }

    public void setConfigProperties(Properties properties) {
        this.configProperties = properties;
        this.loadProperties();
    }

    public boolean hasChanges() {
        return this.changed;
    }

    public void saveChanges() {
        if (this.changed) {
            this.saveChangedProperties();
            this.loadProperties();
        }
    }

    public void clearChanges() {
        if (this.changed) {
            this.loadProperties();
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public PropertiedObjectEditor getPropertiedObjectEditor() {
        return new UserPreferencesEditor();
    }

    public PropertiedObject getPropertiedObject() {
        return this;
    }

    public Object getValue(String propName) {
        Assertion.isNotNull((Object)propName, (String)ToolboxPlugin.Util.getString("UserPreferences.The_property_definition_reference_may_not_be_null_4"));
        Assertion.isNotZeroLength((String)propName, (String)ToolboxPlugin.Util.getString("UserPreferences.The_property_definition_reference_may_not_be_zero-length_5"));
        String result = this.userPrefProperties.getProperty(propName);
        if (result == null) {
            result = this.configProperties.getProperty(propName);
        }
        return result;
    }

    public boolean getBooleanValue(String propName) {
        Object value = this.getValue(propName);
        boolean result = false;
        if (value != null && value instanceof String) {
            String s = (String)value;
            result = Boolean.TRUE.toString().equalsIgnoreCase(s);
        }
        return result;
    }

    public void setValue(String propName, Object value) {
        Assertion.isNotNull((Object)propName, (String)ToolboxPlugin.Util.getString("UserPreferences.The_property_name_may_not_be_null_6"));
        Assertion.isNotZeroLength((String)propName, (String)ToolboxPlugin.Util.getString("UserPreferences.The_property_name_may_not_be_zero-length_7"));
        String previousValue = this.userPrefProperties.getProperty(propName);
        if (value == null || value instanceof String && ((String)value).length() == 0) {
            this.userPrefProperties.remove(propName);
        } else {
            this.userPrefProperties.setProperty(propName, value.toString());
        }
        if (previousValue != null && value != null && !previousValue.equals(value)) {
            LogManager.logDetail((String)LOG_CONTEXT, (Object[])new Object[]{ToolboxPlugin.Util.getString("UserPreferences.Marking_user_preferences_as_changed_(property___8") + propName + "\")"});
            this.changed = true;
        } else if (previousValue != null && value == null) {
            LogManager.logDetail((String)LOG_CONTEXT, (Object[])new Object[]{ToolboxPlugin.Util.getString("UserPreferences.Marking_user_preferences_as_changed_(property___10") + propName + "\")"});
            this.changed = true;
        } else if (previousValue == null && value != null) {
            LogManager.logDetail((String)LOG_CONTEXT, (Object[])new Object[]{ToolboxPlugin.Util.getString("UserPreferences.Marking_user_preferences_as_changed_(property___12") + propName + "\")"});
            this.changed = true;
        }
    }

    public void setValues(String propName, Collection values, char delimiter) {
        Assertion.isNotNull((Object)propName, (String)ToolboxPlugin.Util.getString("UserPreferences.The_property_name_may_not_be_null_14"));
        Assertion.isNotZeroLength((String)propName, (String)ToolboxPlugin.Util.getString("UserPreferences.The_property_name_may_not_be_zero-length_15"));
        this.userPrefProperties.getProperty(propName);
        if (values != null && !values.isEmpty()) {
            StringBuffer buf = new StringBuffer();
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                buf.append(delimiter);
            }
            this.setValue(propName, buf.toString());
        } else {
            this.setValue(propName, null);
        }
    }

    public void removeValue(String propName) {
        this.userPrefProperties.remove(propName);
    }

    public Collection getValues(String propName, char delimiter) {
        Object value = this.getValue(propName);
        ArrayList<String> result = Collections.EMPTY_LIST;
        if (value != null) {
            Assertion.assertTrue((boolean)(value instanceof String), (String)ToolboxPlugin.Util.getString("UserPreferences.The_value_of_a_property_definition_used_by_getValues_must_be_of_type_String_16"));
            StringTokenizer tok = new StringTokenizer((String)value, new String(new char[]{delimiter}));
            result = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreTokens()) {
                result.add(tok.nextToken());
            }
        }
        return result;
    }

    public Properties getProperties() {
        return this.unmodifiableUserPrefProperties;
    }

    public Properties getPropertiesBranch(String prefix) {
        String newKey;
        int indx;
        Object val;
        if (prefix == null || prefix.length() == 0) {
            return this.getProperties();
        }
        Properties branch = new Properties();
        if (prefix.endsWith(PROPERTY_DELIM)) {
            branch.put(PROPERTY_PREFIX, prefix.substring(0, prefix.length() - 1));
        } else {
            branch.put(PROPERTY_PREFIX, prefix);
        }
        Properties props = this.configProperties;
        for (String string : this.configProperties.keySet()) {
            if (!string.startsWith(prefix) || (val = props.get(string)) == null || ((String)val).equals("")) continue;
            indx = prefix.length();
            newKey = string.substring(indx);
            if (newKey.startsWith(PROPERTY_DELIM)) {
                newKey = newKey.substring(1);
            }
            branch.put(newKey, val);
        }
        for (String string : this.unmodifiableUserPrefProperties.keySet()) {
            if (!string.startsWith(prefix) || (val = props.get(string)) == null || ((String)val).equals("")) continue;
            indx = prefix.length();
            newKey = string.substring(indx);
            if (newKey.startsWith(PROPERTY_DELIM)) {
                newKey = newKey.substring(1);
            }
            branch.put(newKey, val);
        }
        return branch;
    }

    public Properties getProperties(String filter) {
        return this.getProperties(filter, false);
    }

    public Properties getProperties(String filter, boolean ignoreCase) {
        if (filter == null || filter.length() == 0 || "*".equals(filter)) {
            return this.getProperties();
        }
        StringFilter stringFilter = new StringFilter(filter, ignoreCase);
        Properties branch = new Properties();
        Properties props = this.configProperties;
        for (String string : this.configProperties.keySet()) {
            if (!stringFilter.includes(string)) continue;
            branch.put(string, props.get(string));
        }
        for (String string : this.unmodifiableUserPrefProperties.keySet()) {
            if (!stringFilter.includes(string)) continue;
            branch.put(string, props.get(string));
        }
        return branch;
    }

    private void loadProperties() {
        LogManager.logDetail((String)LOG_CONTEXT, (Object[])new Object[]{ToolboxPlugin.Util.getString("UserPreferences.Loading_user_preferences_20")});
        this.userPrefProperties = new Properties(this.configProperties);
        this.unmodifiableUserPrefProperties = new UnmodifiableProperties(this.userPrefProperties);
        this.userPrefFileName = this.configProperties.getProperty(USER_PREFERENCES_DEFINITION_FILE_PROPERTY_NAME, System.getProperty("prefFile", "console_pref.properties"));
        LogManager.logDetail((String)LOG_CONTEXT, (Object[])new Object[]{ToolboxPlugin.Util.getString("UserPreferences.User_preferences_file_set_to___21") + this.userPrefFileName + "\""});
        if (this.userPrefFileName == null || this.userPrefFileName.length() == 0) {
            LogManager.logInfo((String)LOG_CONTEXT, (String)ToolboxPlugin.Util.getString("UserPreferences.User_preferences_filename_is_invalid_or_not_specified_23"));
        } else {
            File prefFile = new File(this.userPrefFileName);
            if (!prefFile.exists()) {
                LogManager.logInfo((String)LOG_CONTEXT, (String)ToolboxPlugin.Util.getString("UserPreferences.User_preferences_file_not_found_24"));
            } else if (prefFile.isDirectory()) {
                LogManager.logError((String)LOG_CONTEXT, (String)(ToolboxPlugin.Util.getString("UserPreferences.User_preferences_file___25") + this.userPrefFileName + ToolboxPlugin.Util.getString("UserPreferences.__is_not_valid_(may_be_a_directory)_26")));
            } else {
                FileInputStream propStream = null;
                try {
                    propStream = new FileInputStream(this.userPrefFileName);
                }
                catch (FileNotFoundException ex) {
                    LogManager.logInfo((String)LOG_CONTEXT, (String)ToolboxPlugin.Util.getString("UserPreferences.User_preferences_file_not_found_27"));
                }
                if (propStream != null) {
                    try {
                        this.userPrefProperties.load(propStream);
                        ((InputStream)propStream).close();
                    }
                    catch (IOException e) {
                        LogManager.logError((String)LOG_CONTEXT, (Throwable)e, (String)(ToolboxPlugin.Util.getString("UserPreferences.Unable_to_read_user_preferences_file___28") + this.userPrefFileName + "\""));
                    }
                }
            }
        }
        this.changed = false;
    }

    private void saveChangedProperties() {
        FileOutputStream propStream = null;
        try {
            propStream = new FileOutputStream(this.userPrefFileName);
        }
        catch (FileNotFoundException ex) {
            LogManager.logInfo((String)LOG_CONTEXT, (String)ToolboxPlugin.Util.getString("UserPreferences.User_preferences_file_is_not_valid_(may_be_a_directory)_30"));
        }
        if (propStream != null) {
            try {
                LogManager.logInfo((String)LOG_CONTEXT, (String)(ToolboxPlugin.Util.getString("UserPreferences.Saving_user_preferences_to_file___31") + this.userPrefFileName + "\""));
                this.userPrefProperties.store(propStream, ToolboxPlugin.Util.getString("UserPreferences.MetaMatrix_preferences_file_-_all_rights_reserved_33"));
                ((OutputStream)propStream).close();
            }
            catch (IOException e) {
                LogManager.logError((String)LOG_CONTEXT, (Throwable)e, (String)(ToolboxPlugin.Util.getString("UserPreferences.Unable_to_save_user_preferences_to_file___34") + this.userPrefFileName + "\""));
            }
        }
        this.changed = false;
        this.unmodifiableUserPrefProperties = new UnmodifiableProperties(this.userPrefProperties);
        LogManager.logDetail((String)LOG_CONTEXT, (Object[])new Object[]{ToolboxPlugin.Util.getString("UserPreferences.Marking_user_preferences_as_saved_36")});
    }

    private void print(PrintStream stream) {
        System.out.println(ToolboxPlugin.Util.getString("UserPreferences.User_Preferences__37"));
        PropertiesUtils.print((PrintStream)stream, (Properties)this.userPrefProperties);
        System.out.println(ToolboxPlugin.Util.getString("UserPreferences.Configuration_Properties__38"));
        PropertiesUtils.print((PrintStream)stream, (Properties)this.configProperties);
    }

    public static void main(String[] args) {
        System.out.println(ToolboxPlugin.Util.getString("UserPreferences.Getting_user_preferences..._n_39"));
        UserPreferences prefs = UserPreferences.getInstance();
        System.out.println(ToolboxPlugin.Util.getString("UserPreferences._nPrinting_user_preferences..._n_40"));
        prefs.print(System.out);
        prefs.setValue(ToolboxPlugin.Util.getString("UserPreferences.new.user.pref.prop1_41"), ToolboxPlugin.Util.getString("UserPreferences.value1_42"));
        prefs.setValue(ToolboxPlugin.Util.getString("UserPreferences.new.user.pref.prop2_43"), ToolboxPlugin.Util.getString("UserPreferences.value1a_44"));
        System.out.println(ToolboxPlugin.Util.getString("UserPreferences._nPrinting_user_preferences_after_adding_2_properties_..._n_45"));
        prefs.print(System.out);
        prefs.clearChanges();
        System.out.println(ToolboxPlugin.Util.getString("UserPreferences._nPrinting_user_preferences_after_clearing_changes_..._n_46"));
        prefs.print(System.out);
        prefs.setValue(ToolboxPlugin.Util.getString("UserPreferences.new.user.pref.prop3_47"), ToolboxPlugin.Util.getString("UserPreferences.value2_48"));
        prefs.setValue(ToolboxPlugin.Util.getString("UserPreferences.new.user.pref.prop4_49"), ToolboxPlugin.Util.getString("UserPreferences.value3_50"));
        prefs.setValue(ToolboxPlugin.Util.getString("UserPreferences.metamatrix.log_51"), ToolboxPlugin.Util.getString("UserPreferences.0_52"));
        System.out.println(ToolboxPlugin.Util.getString("UserPreferences._nPrinting_user_preferences_after_after_adding_3_properites_..._n_53"));
        prefs.print(System.out);
        prefs.saveChanges();
        System.out.println(ToolboxPlugin.Util.getString("UserPreferences._nPrinting_user_preferences_after_saving_changes_..._n_54"));
        prefs.print(System.out);
        System.out.println(ToolboxPlugin.Util.getString("UserPreferences._nCompleted._55"));
    }
}

