/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.preference;

import com.metamatrix.common.object.DefaultPropertyAccessPolicy;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyAccessPolicy;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.transaction.UserTransactionFactory;
import com.metamatrix.common.transaction.manager.SimpleUserTransactionFactory;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.ToolboxPlugin;
import com.metamatrix.toolbox.preference.UserPreferences;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class UserPreferencesEditor
implements PropertiedObjectEditor {
    private PropertyAccessPolicy policy;
    private UserTransactionFactory txnFactory;
    private List propertyDefns;

    UserPreferencesEditor(PropertyAccessPolicy policy, UserTransactionFactory txnFactory) {
        Assertion.isNotNull((Object)policy, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertyAccessPolicy_reference_may_not_be_null_56"));
        Assertion.isNotNull((Object)txnFactory, (String)ToolboxPlugin.Util.getString("UserPreferences.The_UserTransactionFactory_reference_may_not_be_null_57"));
        this.policy = policy;
        this.txnFactory = txnFactory;
        this.propertyDefns = new ArrayList();
    }

    UserPreferencesEditor() {
        this((PropertyAccessPolicy)new DefaultPropertyAccessPolicy(), (UserTransactionFactory)new SimpleUserTransactionFactory());
    }

    protected UserPreferences assertUserPreferences(PropertiedObject obj) {
        Assertion.isNotNull((Object)obj, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertiedObject_reference_may_not_be_null_58"));
        Assertion.assertTrue((boolean)(obj instanceof UserPreferences), (String)ToolboxPlugin.Util.getString("UserPreferences.The_specified_PropertiedObject_is_not_am_instance_of_UserPreferences_59"));
        return (UserPreferences)obj;
    }

    public void setPropertyDefinitions(List propDefns) {
        Assertion.isNotNull((Object)propDefns, (String)ToolboxPlugin.Util.getString("UserPreferences.The_list_of_PropertyDefinition_references_may_not_be_null_60"));
        this.propertyDefns = Collections.unmodifiableList(new ArrayList(propDefns));
    }

    public List getPropertyDefinitions(PropertiedObject obj) {
        this.assertUserPreferences(obj);
        return this.propertyDefns;
    }

    public List getAllowedValues(PropertiedObject obj, PropertyDefinition def) {
        Assertion.isNotNull((Object)def, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertyDefinition_reference_may_not_be_null_61"));
        return def.getAllowedValues();
    }

    public Object getValue(PropertiedObject obj, PropertyDefinition def) {
        UserPreferences prefs = this.assertUserPreferences(obj);
        Assertion.isNotNull((Object)def, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertyDefinition_reference_may_not_be_null_62"));
        return prefs.getValue(def.getName());
    }

    public boolean isValidValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        this.assertUserPreferences(obj);
        Assertion.isNotNull((Object)def, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertyDefinition_reference_may_not_be_null_63"));
        if (value == null) {
            return def.getMultiplicity().getMinimum() == 0;
        }
        return def.getPropertyType().isValidValue(value);
    }

    public void setValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        UserPreferences prefs = this.assertUserPreferences(obj);
        Assertion.isNotNull((Object)def, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertyDefinition_reference_may_not_be_null_64"));
        prefs.setValue(def.getName(), value);
    }

    public PropertyAccessPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(PropertyAccessPolicy policy) {
        this.policy = policy == null ? new DefaultPropertyAccessPolicy() : policy;
    }

    public boolean isReadOnly(PropertiedObject obj) {
        UserPreferences prefs = this.assertUserPreferences(obj);
        return prefs.isReadOnly();
    }

    public boolean isReadOnly(PropertiedObject obj, PropertyDefinition def) {
        Assertion.isNotNull((Object)obj, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertiedObject_reference_may_not_be_null_65"));
        Assertion.isNotNull((Object)def, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertyDefinition_reference_may_not_be_null_66"));
        return this.policy.isReadOnly(obj, def);
    }

    public void setReadOnly(PropertiedObject obj, PropertyDefinition def, boolean readOnly) {
        Assertion.isNotNull((Object)obj, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertiedObject_reference_may_not_be_null_67"));
        Assertion.isNotNull((Object)def, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertyDefinition_reference_may_not_be_null_68"));
        this.policy.setReadOnly(obj, def, readOnly);
    }

    public void setReadOnly(PropertiedObject obj, boolean readOnly) {
        Assertion.isNotNull((Object)obj, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertiedObject_reference_may_not_be_null_69"));
        this.policy.setReadOnly(obj, readOnly);
    }

    public void reset(PropertiedObject obj) {
        Assertion.isNotNull((Object)obj, (String)ToolboxPlugin.Util.getString("UserPreferences.The_PropertiedObject_reference_may_not_be_null_70"));
        this.assertUserPreferences(obj);
        this.policy.reset(obj);
    }

    public UserTransaction createReadTransaction() {
        return this.txnFactory.createReadTransaction();
    }

    public UserTransaction createWriteTransaction() {
        return this.txnFactory.createWriteTransaction();
    }

    public UserTransaction createWriteTransaction(Object source) {
        return this.txnFactory.createWriteTransaction(source);
    }
}

