/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui;

import bsh.Interpreter;
import com.metamatrix.common.properties.ObjectPropertyManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class UIDefaults
extends ObjectPropertyManager {
    private static final String DEFAULT_PROPERTY_FILE_NAME = "com/metamatrix/toolbox/ui/uiDefaults";
    private static UIDefaults instance;

    public static UIDefaults getInstance() {
        if (instance == null) {
            instance = new UIDefaults();
        }
        return instance;
    }

    protected UIDefaults() {
        this((List)null);
    }

    protected UIDefaults(String namespace) {
        this(new String[]{namespace});
    }

    protected UIDefaults(String[] namespaces) {
        this(Arrays.asList(namespaces));
    }

    protected UIDefaults(List namespaces) {
        super(namespaces);
        this.initializeUIDefaults();
    }

    @Override
    public boolean addNamespace(String namespace) {
        return this.addNamespace(namespace, UIManager.getDefaults());
    }

    public Border getBorder(String key) {
        return (Border)this.getObject(key, Border.class);
    }

    public Border getBorder(String key, Color defaultValue) {
        return (Border)this.getObject(key, Border.class, defaultValue);
    }

    public Color getColor(String key) {
        return (Color)this.getObject(key, Color.class);
    }

    public Color getColor(String key, Color defaultValue) {
        return (Color)this.getObject(key, Color.class, defaultValue);
    }

    public Font getFont(String key) {
        return (Font)this.getObject(key, Font.class);
    }

    public Font getFont(String key, Font defaultValue) {
        return (Font)this.getObject(key, Font.class, defaultValue);
    }

    public Icon getIcon(String key) {
        return (Icon)this.getObject(key, Icon.class);
    }

    public Icon getIcon(String key, Icon defaultValue) {
        return (Icon)this.getObject(key, Icon.class, defaultValue);
    }

    public Insets getInsets(String key) {
        return (Insets)this.getObject(key, Insets.class);
    }

    public Insets getInsets(String key, Insets defaultValue) {
        return (Insets)this.getObject(key, Insets.class, defaultValue);
    }

    public ComponentUI getLookAndFeel(String key) {
        return (ComponentUI)this.getObject(key, ComponentUI.class);
    }

    public ComponentUI getLookAndFeel(String key, ComponentUI defaultValue) {
        return (ComponentUI)this.getObject(key, ComponentUI.class, defaultValue);
    }

    protected Object getObject(String key, Class valueClass) {
        Object val = this.get(key);
        UIDefaults.assertClass(key, val, valueClass);
        return val;
    }

    protected Object getObject(String key, Class valueClass, Object defaultValue) {
        Object val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        UIDefaults.assertClass(key, val, valueClass);
        return val;
    }

    @Override
    protected void initializeNamespaces(List namespaces, Map propertyMap) {
        this.addNamespace(DEFAULT_PROPERTY_FILE_NAME);
        super.initializeNamespaces(namespaces, propertyMap);
    }

    protected void initializeUIDefaults() {
        try {
            Interpreter interpreter = this.getInterpreter();
            interpreter.eval("import javax.swing.border.*;");
            interpreter.eval("import java.net.URL;");
            interpreter.eval("import com.metamatrix.toolbox.ui.*;");
            interpreter.eval("import com.metamatrix.toolbox.ui.widget.*;");
            interpreter.eval("icon(String path) {final URL url = ClassLoader.getSystemResource(path);if (url == null) {return null;}return new ImageIcon(url);}");
            Object[] keys = UIManager.getDefaults().keySet().toArray();
            int ndx = keys.length;
            while (--ndx >= 0) {
                Object key = keys[ndx];
                if (!(key instanceof String)) continue;
                this.get((String)key);
            }
        }
        catch (Exception err) {
            UIDefaults.throwRuntimeException(err);
        }
    }
}

