/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.callback;

import com.metamatrix.common.callback.Callback;
import com.metamatrix.common.callback.CallbackChoices;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.event.WidgetActionEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CallbackChoicesDialogPanel
extends DialogPanel {
    private Callback callback;
    private boolean responseSet = false;

    public CallbackChoicesDialogPanel(Callback callback) {
        this.callback = callback;
        this.configureCallbackChoices();
    }

    private void configureCallbackChoices() {
        CallbackChoices choice = this.callback.getChoices();
        if (choice.getOptionType() != 2) {
            if (choice.getOptionType() == 0) {
                this.getAcceptButton().setText("Yes");
                this.getCancelButton().setText("No");
            } else if (choice.getOptionType() == 1) {
                this.getAcceptButton().setText("Yes");
                this.createButton("No", 1, 1);
            } else if (choice.getOptionType() == -1) {
                this.getAcceptButton().setVisible(false);
            } else if (choice.getOptions() != null) {
                this.getAcceptButton().setVisible(false);
                this.getCancelButton().setVisible(false);
                for (int i = 0; i < choice.getOptions().length; ++i) {
                    this.createButton(choice.getOptions()[i], i);
                }
            }
        }
    }

    private void createButton(String optionName, final int choice) {
        ButtonWidget button = new ButtonWidget(optionName);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallbackChoicesDialogPanel.this.setChoice(choice);
                DialogWindow.disposeConditionally(CallbackChoicesDialogPanel.this.getWindowAncestor(), e);
            }
        });
        this.addNavigationButton(button);
    }

    private void createButton(String optionName, final int choice, int navIndex) {
        ButtonWidget button = new ButtonWidget(optionName);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallbackChoicesDialogPanel.this.setChoice(choice);
                DialogWindow.disposeConditionally(CallbackChoicesDialogPanel.this.getWindowAncestor(), e);
            }
        });
        this.addNavigationButton(button, navIndex);
    }

    @Override
    protected void accept(WidgetActionEvent event) {
        if (!this.responseSet) {
            CallbackChoices choice = this.callback.getChoices();
            if (choice.getOptionType() == 2) {
                this.setChoice(0);
            } else if (choice.getOptionType() == 0) {
                this.setChoice(0);
            } else if (choice.getOptionType() == 1) {
                this.setChoice(0);
            } else if (choice.getOptionType() == -1) {
                this.setChoice(0);
            }
        }
        this.responseSet = true;
    }

    protected void setChoice(int index) {
        if (!this.responseSet) {
            this.callback.getChoices().setSelectedIndex(index);
            this.callback.setResponse(index);
            this.responseSet = true;
        }
    }

    @Override
    protected void cancel(WidgetActionEvent event) {
        if (!this.responseSet) {
            CallbackChoices choice = this.callback.getChoices();
            if (choice.getOptionType() == 2) {
                this.setChoice(2);
            } else if (choice.getOptionType() == 0) {
                this.setChoice(1);
            } else if (choice.getOptionType() == 1) {
                this.setChoice(2);
            } else {
                this.setChoice(-1);
            }
        }
        this.responseSet = true;
    }
}

