/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.callback;

import com.metamatrix.common.callback.Callback;
import com.metamatrix.common.callback.CallbackHandler;
import com.metamatrix.common.callback.UnsupportedCallbackException;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinitionGroup;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.common.util.crypto.NullCryptor;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.ui.callback.CallbackChoicesDialogPanel;
import com.metamatrix.toolbox.ui.callback.ParentFrameSupplier;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class DialogFactoryCallbackHandler
implements CallbackHandler {
    private ParentFrameSupplier parentFrameSupplier;
    private JTabbedPane tabbedPane;
    private JDialog dialog = null;
    private Callback currentCallback = null;
    private Dimension size = null;
    boolean choiceSelected = false;

    public void setParentFrameSupplier(ParentFrameSupplier supplier) {
        Assertion.isNotNull((Object)supplier);
        this.parentFrameSupplier = supplier;
    }

    public void setDefaultDialogSize(Dimension size) {
        this.size = size;
    }

    @Override
    public void handle(Callback callback, Object source) throws IOException, UnsupportedCallbackException {
        Assertion.isNotNull((Object)callback);
        this.currentCallback = callback;
        if (callback.hasPropertiedObject()) {
            DialogPanel panel = this.processPropertiedObjectCallback(callback);
            Window window = this.parentFrameSupplier.getParentFrameForCallback();
            if (window instanceof Frame) {
                this.dialog = new DialogWindow((Frame)window, callback.getDisplayName(), panel, true);
            } else if (window instanceof Dialog) {
                this.dialog = new DialogWindow((Dialog)window, callback.getDisplayName(), panel, true);
            }
            if (this.dialog != null) {
                this.dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        DialogFactoryCallbackHandler.this.dialogDismissed();
                    }
                });
            }
            if (this.size != null) {
                this.dialog.setSize(this.size);
            } else {
                this.dialog.pack();
            }
            if (window != null) {
                this.dialog.setLocationRelativeTo(window);
            }
            this.dialog.show();
        } else {
            int messageType;
            int index = -1;
            index = callback.getChoices().getOptions() == null ? ((messageType = callback.getChoices().getMessageType()) == 1 || messageType == -1 ? JOptionPane.showConfirmDialog(this.parentFrameSupplier.getParentFrameForCallback(), callback.getChoices().getPrompt(), callback.getDisplayName(), 0, 1) : JOptionPane.showConfirmDialog(this.parentFrameSupplier.getParentFrameForCallback(), callback.getChoices().getPrompt(), callback.getDisplayName(), callback.getChoices().getOptionType(), callback.getChoices().getMessageType())) : JOptionPane.showOptionDialog(this.parentFrameSupplier.getParentFrameForCallback(), callback.getChoices().getPrompt(), callback.getDisplayName(), 2, callback.getChoices().getMessageType(), this.getIconForMessageType(callback.getChoices().getMessageType()), callback.getChoices().getOptions(), callback.getChoices().getOptions()[callback.getChoices().getDefaultOption()]);
            this.setChoice(index);
        }
    }

    private Icon getIconForMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    protected DialogPanel processPropertiedObjectCallback(Callback callback) {
        CallbackChoicesDialogPanel result = new CallbackChoicesDialogPanel(callback);
        if (callback.hasPropertyDefinitionGroups()) {
            if (!callback.isSequential()) {
                this.tabbedPane = new JTabbedPane();
                result.setContent(this.tabbedPane);
                while (callback.hasNextGroup()) {
                    PropertyDefinitionGroup group = callback.getNextGroup();
                    JPanel panel = this.createCallbackPanel(callback, group, callback.getPropertiedObject(), callback.getEditor());
                    this.tabbedPane.addTab(group.getDisplayName(), panel);
                }
            }
        } else {
            JPanel p = this.createCallbackPanel(callback, callback.getChoices().getPrompt(), callback.getPropertiedObject(), callback.getEditor());
            result.setContent(p);
        }
        return result;
    }

    protected JPanel createCallbackPanel(Callback callback, PropertyDefinitionGroup definitionGroup, PropertiedObject object, PropertiedObjectEditor editor) {
        JPanel result = new JPanel(new BorderLayout());
        JLabel description = new JLabel(definitionGroup.getShortDescription());
        result.add((Component)description, "North");
        PropertiedObjectPanel properties = new PropertiedObjectPanel(editor, (Encryptor)new NullCryptor());
        properties.setShowColumnHeaders(false);
        properties.setShowInvalidProperties(true);
        properties.setShowRequiredProperties(true);
        properties.createComponent();
        properties.setPropertiedObject(object, editor, definitionGroup.getPropertyDefinitions());
        result.add((Component)properties, "Center");
        return result;
    }

    protected JPanel createCallbackPanel(Callback callback, String prompt, PropertiedObject object, PropertiedObjectEditor editor) {
        JPanel result = new JPanel(new BorderLayout());
        JLabel description = new JLabel(prompt);
        result.add((Component)description, "North");
        PropertiedObjectPanel properties = new PropertiedObjectPanel(editor, (Encryptor)new NullCryptor());
        properties.setShowColumnHeaders(false);
        properties.setShowInvalidProperties(true);
        properties.setShowRequiredProperties(true);
        properties.createComponent();
        properties.setPropertiedObject(object);
        result.add((Component)properties, "Center");
        return result;
    }

    protected void dialogDismissed() {
        if (!this.choiceSelected) {
            this.currentCallback.getChoices().setSelectedIndex(-1);
            this.currentCallback.setResponse(-1);
            this.currentCallback = null;
        }
    }

    protected void setChoice(int index) {
        this.currentCallback.getChoices().setSelectedIndex(index);
        this.currentCallback.setResponse(index);
        this.choiceSelected = true;
    }
}

