/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ToolboxPlugin;
import com.metamatrix.toolbox.ui.IconConstants;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.ListWidget;
import com.metamatrix.toolbox.ui.widget.SpacerWidget;
import com.metamatrix.toolbox.ui.widget.util.WidgetUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AccumulatorPanel
extends DialogPanel
implements IconConstants {
    private static final String AVAILABLE_VALUES_HEADER = ToolboxPlugin.Util.getString("AccumulatorPanel.Available_Values_1");
    private static final String CURRENT_VALUES_HEADER = ToolboxPlugin.Util.getString("AccumulatorPanel.Current_Values_2");
    private boolean useRevisedLayout = false;
    private List initAvailVals;
    private transient List initVals;
    private DefaultListModel availValModel;
    private DefaultListModel valModel;
    private ListWidget availValList;
    private ListWidget valList;
    private ButtonWidget rightButton;
    private ButtonWidget allRightButton;
    private ButtonWidget leftButton;
    private ButtonWidget allLeftButton;
    private ButtonWidget upButton;
    private ButtonWidget downButton;
    private ButtonWidget addButton;
    private ButtonWidget removeButton;
    private ButtonWidget resetButton;
    private JButton[] additionalButtons = null;
    private boolean allowsNewVals;
    private boolean allowsReorderingVals;
    private Box valListButtonPanel;
    private Dimension listPrefSize;
    private LabelWidget availValHdr;
    private LabelWidget valHdr;
    private int minAllowed;
    private int maxAllowed;
    private SpacerWidget spacer;
    private Comparator comparator;

    public AccumulatorPanel() {
        this(null, null);
    }

    public AccumulatorPanel(List initialAvailableValues) {
        this(initialAvailableValues, null);
    }

    public AccumulatorPanel(List initialAvailableValues, List initialValues) {
        this.initAvailVals = initialAvailableValues;
        this.initVals = initialValues;
        this.initializeAccumulatorPanel();
    }

    public AccumulatorPanel(List initialAvailableValues, List initialValues, Comparator theComparator) {
        this.initAvailVals = initialAvailableValues;
        this.initVals = initialValues;
        this.comparator = theComparator;
        this.initializeAccumulatorPanel();
    }

    public AccumulatorPanel(List initialAvailableValues, List initialValues, JButton[] additionalButtons, Comparator theComparator) {
        this.initAvailVals = initialAvailableValues;
        this.initVals = initialValues;
        this.useRevisedLayout = true;
        this.additionalButtons = additionalButtons;
        this.comparator = theComparator;
        this.initializeAccumulatorPanel();
    }

    public void addAvailableValue(Object value) {
        if (value == null) {
            return;
        }
        this.initAvailVals.add(value);
        if (!this.valModel.contains(value)) {
            if (this.comparator == null) {
                this.availValModel.addElement(value);
            } else {
                int index = this.modelInsertionIndex(this.availValModel, value);
                this.availValModel.add(index, value);
            }
        }
        this.updateButtonStatus();
    }

    private int modelInsertionIndex(DefaultListModel model, Object value) {
        int index = 0;
        int listSize = model.getSize();
        boolean done = false;
        while (!done) {
            if (index == listSize) {
                done = true;
                continue;
            }
            int result = this.comparator.compare(value, model.get(index));
            if (result > 0) {
                ++index;
                continue;
            }
            done = true;
        }
        return index;
    }

    public void addListDataListener(ListDataListener listener) {
        this.valModel.addListDataListener(listener);
    }

    public void addValue(Object value) {
        if (value == null) {
            return;
        }
        if (!this.allowsNewVals) {
            this.validateValue(value);
        }
        if (this.useRevisedLayout && this.comparator != null) {
            int index = this.modelInsertionIndex(this.valModel, value);
            this.valModel.add(index, value);
        } else {
            this.valModel.addElement(value);
        }
        this.availValModel.removeElement(value);
        this.updateButtonStatus();
    }

    public boolean allowsNewValues() {
        return this.allowsNewVals;
    }

    public boolean allowsReorderingValues() {
        return this.allowsReorderingVals;
    }

    public void clearValues() {
        while (!this.valModel.isEmpty()) {
            this.removeValue(this.valModel.get(0));
        }
    }

    protected DefaultListModel createAvailableValuesListModel() {
        return this.createDefaultListModel();
    }

    protected ListWidget createAvailableValuesListWidget(DefaultListModel model) {
        return this.createDefaultListWidget(model);
    }

    protected DefaultListModel createDefaultListModel() {
        return new DefaultListModel();
    }

    protected ListWidget createDefaultListWidget(DefaultListModel model) {
        ListWidget list = new ListWidget(model){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return AccumulatorPanel.this.listPrefSize;
            }
        };
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                AccumulatorPanel.this.updateButtonStatus();
            }
        });
        return list;
    }

    protected LabelWidget createHeader(String text) {
        LabelWidget hdr = new LabelWidget(text);
        hdr.setMaximumSize(new Dimension(Short.MAX_VALUE, hdr.getMaximumSize().height));
        hdr.setAlignmentX(0.5f);
        UIDefaults dflts = UIDefaults.getInstance();
        Insets margins = dflts.getInsets("Button.margin");
        hdr.setBorder(BorderFactory.createCompoundBorder(dflts.getBorder("Button.border"), BorderFactory.createEmptyBorder(margins.top, margins.left, margins.bottom, margins.right)));
        return hdr;
    }

    protected DefaultListModel createValuesListModel() {
        return this.createDefaultListModel();
    }

    protected ListWidget createValuesListWidget(DefaultListModel model) {
        return this.createDefaultListWidget(model);
    }

    public List getAvailableValues() {
        return this.getValues(this.availValModel);
    }

    public LabelWidget getAvailableValuesHeader() {
        return this.availValHdr;
    }

    public List getInitialAvailableValues() {
        return new ArrayList(this.initAvailVals);
    }

    public List getInitialValues() {
        return new ArrayList(this.initVals);
    }

    public int getMaximumValuesAllowed() {
        return this.maxAllowed;
    }

    public int getMinimumValuesAllowed() {
        return this.minAllowed;
    }

    public ButtonWidget getResetButton() {
        return this.resetButton;
    }

    public List getValues() {
        return this.getValues(this.valModel);
    }

    protected List getValues(DefaultListModel model) {
        ArrayList vals = new ArrayList();
        Enumeration iterator = model.elements();
        while (iterator.hasMoreElements()) {
            vals.add(iterator.nextElement());
        }
        return vals;
    }

    public LabelWidget getValuesHeader() {
        return this.valHdr;
    }

    protected void initializeAccumulatorPanel() {
        Component comp;
        this.maxAllowed = Integer.MAX_VALUE;
        this.allowsReorderingVals = true;
        this.listPrefSize = new Dimension();
        this.availValHdr = this.createHeader(AVAILABLE_VALUES_HEADER);
        this.availValModel = this.createAvailableValuesListModel();
        this.availValList = this.createAvailableValuesListWidget(this.availValModel);
        this.valHdr = this.createHeader(CURRENT_VALUES_HEADER);
        this.valModel = this.createValuesListModel();
        this.valList = this.createValuesListWidget(this.valModel);
        UIDefaults dflts = UIDefaults.getInstance();
        this.rightButton = new ButtonWidget(dflts.getIcon("Icon.right"));
        this.allRightButton = new ButtonWidget(dflts.getIcon("Icon.allRight"));
        this.leftButton = new ButtonWidget(dflts.getIcon("Icon.left"));
        this.allLeftButton = new ButtonWidget(dflts.getIcon("Icon.allLeft"));
        this.upButton = new ButtonWidget(dflts.getIcon("Icon.up"));
        this.downButton = new ButtonWidget(dflts.getIcon("Icon.down"));
        this.addButton = new ButtonWidget(dflts.getIcon("Icon.add"));
        this.removeButton = new ButtonWidget(dflts.getIcon("Icon.subtract"));
        this.resetButton = new ButtonWidget(ToolboxPlugin.Util.getString("AccumulatorPanel.Reset_3"));
        this.resetButton.setMnemonic('r');
        JPanel panel = new JPanel();
        if (this.useRevisedLayout) {
            GridBagLayout layout = new GridBagLayout();
            panel.setLayout(layout);
            JScrollPane availJSP = new JScrollPane(this.availValList);
            JScrollPane selectedJSP = new JScrollPane(this.valList);
            GridLayout upperButtonsLayout = new GridLayout(4, 1, 2, 0);
            JPanel upperButtonsPanel = new JPanel();
            upperButtonsPanel.setLayout(upperButtonsLayout);
            upperButtonsPanel.add(this.rightButton);
            upperButtonsPanel.add(this.allRightButton);
            upperButtonsPanel.add(this.leftButton);
            upperButtonsPanel.add(this.allLeftButton);
            JPanel lowerButtonsPanel = null;
            if (this.additionalButtons != null) {
                lowerButtonsPanel = new JPanel();
                GridLayout lowerButtonsLayout = new GridLayout(this.additionalButtons.length, 1, 2, 0);
                lowerButtonsPanel.setLayout(lowerButtonsLayout);
                for (int i = 0; i < this.additionalButtons.length; ++i) {
                    lowerButtonsPanel.add(this.additionalButtons[i]);
                }
            }
            layout.setConstraints(this.availValHdr, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(this.availValHdr);
            layout.setConstraints(availJSP, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(availJSP);
            layout.setConstraints(this.valHdr, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(this.valHdr);
            layout.setConstraints(selectedJSP, new GridBagConstraints(2, 1, 1, 2, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(selectedJSP);
            layout.setConstraints(upperButtonsPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 2), 0, 0));
            panel.add(upperButtonsPanel);
            if (lowerButtonsPanel != null) {
                layout.setConstraints(lowerButtonsPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 15, 0, new Insets(2, 2, 0, 2), 0, 0));
                panel.add(lowerButtonsPanel);
            }
        } else {
            WidgetUtilities.equalizeSizeConstraints(Arrays.asList(this.rightButton, this.allRightButton, this.leftButton, this.allLeftButton));
            WidgetUtilities.equalizeSizeConstraints(Arrays.asList(this.upButton, this.downButton, this.addButton, this.removeButton));
            panel.setLayout(new BoxLayout(panel, 0));
            Box vBox = Box.createVerticalBox();
            vBox.add(this.availValHdr);
            vBox.add(new JScrollPane(this.availValList));
            panel.add(vBox);
            vBox = Box.createVerticalBox();
            vBox.add(SpacerWidget.createVerticalSpacer(this.availValHdr.getPreferredSize().height));
            vBox.add(this.rightButton);
            vBox.add(this.allRightButton);
            vBox.add(this.leftButton);
            vBox.add(this.allLeftButton);
            vBox.add(SpacerWidget.createVerticalExpandableSpacer());
            panel.add(vBox);
            vBox = Box.createVerticalBox();
            vBox.add(this.valHdr);
            vBox.add(new JScrollPane(this.valList));
            panel.add(vBox);
            this.valListButtonPanel = Box.createVerticalBox();
            this.valListButtonPanel.add(SpacerWidget.createVerticalSpacer(this.valHdr.getPreferredSize().height));
            this.valListButtonPanel.add(this.upButton);
            this.valListButtonPanel.add(this.downButton);
            this.valListButtonPanel.add(this.addButton);
            this.valListButtonPanel.add(this.removeButton);
            this.upButton.setVisible(this.allowsReorderingValues());
            this.downButton.setVisible(this.allowsReorderingValues());
            this.addButton.setVisible(this.allowsNewValues());
            this.removeButton.setVisible(this.allowsNewValues());
            this.valListButtonPanel.getComponentCount();
            this.valListButtonPanel.add(SpacerWidget.createVerticalExpandableSpacer());
            panel.add(this.valListButtonPanel);
        }
        this.setContent(panel);
        this.addNavigationButton(this.resetButton);
        this.rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AccumulatorPanel.this.moveSelectedValuesRight();
            }
        });
        this.allRightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AccumulatorPanel.this.availValList.setSelectionInterval(0, AccumulatorPanel.this.availValModel.getSize() - 1);
                AccumulatorPanel.this.moveSelectedValuesRight();
            }
        });
        this.leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AccumulatorPanel.this.removeSelectedValues();
            }
        });
        this.allLeftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AccumulatorPanel.this.valList.setSelectionInterval(0, AccumulatorPanel.this.valModel.getSize() - 1);
                AccumulatorPanel.this.removeSelectedValues();
            }
        });
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AccumulatorPanel.this.resetLists();
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int[] indices = AccumulatorPanel.this.valList.getSelectedIndices();
                for (int ndx = 0; ndx < indices.length; ++ndx) {
                    int selectedNdx = indices[ndx];
                    AccumulatorPanel.this.valModel.add(selectedNdx, AccumulatorPanel.this.valModel.remove(selectedNdx - 1));
                    indices[ndx] = selectedNdx - 1;
                }
                AccumulatorPanel.this.valList.setSelectedIndices(indices);
                AccumulatorPanel.this.updateButtonStatus();
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int[] indices = AccumulatorPanel.this.valList.getSelectedIndices();
                int ndx = indices.length;
                while (--ndx >= 0) {
                    int selectedNdx = indices[ndx];
                    AccumulatorPanel.this.valModel.add(selectedNdx, AccumulatorPanel.this.valModel.remove(selectedNdx + 1));
                    indices[ndx] = selectedNdx + 1;
                }
                AccumulatorPanel.this.valList.setSelectedIndices(indices);
                AccumulatorPanel.this.updateButtonStatus();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String val = JOptionPane.showInputDialog(AccumulatorPanel.this, ToolboxPlugin.Util.getString("AccumulatorPanel.Enter_a_new_value__4"), ToolboxPlugin.Util.getString("AccumulatorPanel.Input_5"), 1);
                AccumulatorPanel.this.addValue(val);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AccumulatorPanel.this.removeSelectedValues();
            }
        });
        this.availValList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() < 2) {
                    return;
                }
                if (AccumulatorPanel.this.valModel.size() >= AccumulatorPanel.this.maxAllowed) {
                    AccumulatorPanel.this.maximumValuesAccumulated();
                    return;
                }
                AccumulatorPanel.this.availValList.setSelectedIndex(AccumulatorPanel.this.availValList.locationToIndex(event.getPoint()));
                AccumulatorPanel.this.moveSelectedValuesRight();
            }
        });
        this.valList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() < 2) {
                    return;
                }
                if (AccumulatorPanel.this.valModel.size() <= AccumulatorPanel.this.minAllowed) {
                    AccumulatorPanel.this.minimumValuesAccumulated();
                    return;
                }
                AccumulatorPanel.this.valList.setSelectedIndex(AccumulatorPanel.this.valList.locationToIndex(event.getPoint()));
                AccumulatorPanel.this.removeSelectedValues();
            }
        });
        List vals = this.initAvailVals;
        this.initAvailVals = new ArrayList();
        this.setAvailableValues(vals);
        vals = this.initVals;
        this.initVals = new ArrayList();
        this.setInitialValues(vals);
        this.setValues(vals);
        this.removeValModelItemsFromAvailValModel();
        this.updateButtonStatus();
        this.updateListPreferredSize();
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AccumulatorPanel.this.resetValues();
            }
        });
        int ndx = this.getNavigationComponentIndex(this.getCancelButton()) - 1;
        if (ndx >= 0 && (comp = this.getNavigationComponent(ndx)) instanceof SpacerWidget) {
            this.spacer = (SpacerWidget)comp;
        }
    }

    private void removeValModelItemsFromAvailValModel() {
        int lastIndex;
        for (int i = lastIndex = this.availValModel.size() - 1; i >= 0; --i) {
            Object element = this.availValModel.elementAt(i);
            if (!this.valModel.contains(element)) continue;
            this.availValModel.remove(i);
        }
    }

    protected void maximumValuesAccumulated() {
    }

    protected void minimumValuesAccumulated() {
    }

    protected void moveSelectedValuesRight() {
        Object[] vals = this.availValList.getSelectedValues();
        for (int ndx = 0; ndx < vals.length; ++ndx) {
            this.addValue(vals[ndx]);
        }
        this.updateListPreferredSize();
    }

    protected void removeSelectedValues() {
        Object[] vals = this.valList.getSelectedValues();
        if (this.comparator != null) {
            this.removeValues(vals);
        } else {
            for (int ndx = 0; ndx < vals.length; ++ndx) {
                this.removeValue(vals[ndx]);
            }
        }
    }

    public void removeAvailableValue(Object value) {
        this.initAvailVals.remove(value);
        this.availValModel.removeElement(value);
        if (!this.allowsNewVals) {
            if (this.initVals.contains(value)) {
                this.initVals.remove(value);
            }
            if (this.valModel.contains(value)) {
                this.valModel.removeElement(value);
            }
        }
        this.updateButtonStatus();
    }

    public void removeListDataListener(ListDataListener listener) {
        this.valModel.removeListDataListener(listener);
    }

    public void removeValue(Object value) {
        this.valModel.removeElement(value);
        int valNdx = this.initAvailVals.indexOf(value);
        if (valNdx >= 0) {
            int addNdx = 0;
            Enumeration iterator = this.availValModel.elements();
            while (iterator.hasMoreElements() && valNdx >= this.initAvailVals.indexOf(iterator.nextElement())) {
                ++addNdx;
            }
            this.availValModel.add(addNdx, value);
        }
        this.updateButtonStatus();
    }

    public void removeValues(Object[] values) {
        ArrayList<Object> tempList = new ArrayList<Object>(this.availValModel.size());
        for (int ndx = 0; ndx < this.availValModel.size(); ++ndx) {
            tempList.add(this.availValModel.get(ndx));
        }
        int theIndex = 0;
        Object nextObj = null;
        for (theIndex = 0; theIndex < values.length; ++theIndex) {
            nextObj = values[theIndex];
            this.valModel.removeElement(nextObj);
            int valNdx = this.initAvailVals.indexOf(nextObj);
            if (valNdx < 0) continue;
            tempList.add(nextObj);
        }
        if (!tempList.isEmpty()) {
            Collections.sort(tempList, this.comparator);
            this.availValModel.clear();
            Iterator iter = tempList.iterator();
            theIndex = 0;
            while (iter.hasNext()) {
                nextObj = iter.next();
                this.availValModel.add(theIndex, nextObj);
                ++theIndex;
            }
        }
        this.updateButtonStatus();
    }

    public void resetValues() {
        this.resetLists();
    }

    public void setAllowsNewValues(boolean allowsNewValues) {
        this.addButton.setVisible(allowsNewValues);
        this.removeButton.setVisible(allowsNewValues);
        this.allowsNewVals = allowsNewValues;
    }

    public void setAllowsReorderingValues(boolean allowsReorderingValues) {
        this.upButton.setVisible(allowsReorderingValues);
        this.downButton.setVisible(allowsReorderingValues);
        this.allowsReorderingVals = allowsReorderingValues;
    }

    public void setAvailableValues(List values) {
        this.initAvailVals.clear();
        this.availValModel.clear();
        if (values != null) {
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                this.addAvailableValue(iterator.next());
            }
        }
        this.allRightButton.setVisible(this.initAvailVals.size() <= this.maxAllowed);
    }

    public void setSelectionListCellRenderer(ListCellRenderer renderer) {
        this.valList.setCellRenderer(renderer);
    }

    public void setAvailableListCellRenderer(ListCellRenderer renderer) {
        this.availValList.setCellRenderer(renderer);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.rightButton.setVisible(enabled);
        this.allRightButton.setVisible(enabled);
        this.leftButton.setVisible(enabled);
        this.allLeftButton.setVisible(enabled);
        this.upButton.setVisible(enabled);
        this.downButton.setVisible(enabled);
        this.addButton.setVisible(enabled);
        this.removeButton.setVisible(enabled);
        this.availValList.setEnabled(enabled);
        this.valList.setEnabled(enabled);
        this.getCancelButton().setVisible(enabled);
        if (this.spacer != null) {
            this.spacer.setVisible(enabled);
        }
        super.setEnabled(enabled);
    }

    public void setInitialValues(List values) {
        this.initVals.clear();
        if (values == null) {
            return;
        }
        if (this.allowsNewVals) {
            this.initVals.addAll(values);
        } else {
            for (Object val : values) {
                if (val == null) continue;
                this.validateValue(val);
                this.initVals.add(val);
            }
        }
    }

    public void setMaximumValuesAllowed(int maximum) {
        this.maxAllowed = maximum;
        this.allRightButton.setVisible(this.initAvailVals.size() <= maximum);
        this.updateButtonStatus();
    }

    public void setMinimumValuesAllowed(int minimum) {
        this.minAllowed = minimum;
        this.allLeftButton.setVisible(minimum == 0);
        this.updateButtonStatus();
    }

    public void setValues(List values) {
        this.clearValues();
        if (values != null) {
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                this.addValue(iterator.next());
            }
        }
    }

    protected void resetLists() {
        Object nextObj2;
        this.valModel.clear();
        if (this.initVals != null) {
            nextObj2 = null;
            for (Object nextObj2 : this.initVals) {
                this.valModel.addElement(nextObj2);
            }
        }
        this.availValModel.clear();
        if (this.initAvailVals != null) {
            nextObj2 = null;
            for (Object nextObj2 : this.initAvailVals) {
                if (this.valModel.contains(nextObj2)) continue;
                this.availValModel.addElement(nextObj2);
            }
        }
        this.updateButtonStatus();
    }

    protected void updateButtonStatus() {
        int availValCount = this.availValModel.size();
        int valCount = this.valModel.size();
        this.rightButton.setEnabled(!this.availValList.isSelectionEmpty() && this.availValList.getSelectedValues().length + valCount <= this.maxAllowed);
        boolean removeAllowed = !this.valList.isSelectionEmpty() && valCount - this.valList.getSelectedValues().length >= this.minAllowed;
        this.leftButton.setEnabled(removeAllowed);
        this.allRightButton.setEnabled(availValCount > 0 && valCount + availValCount <= this.maxAllowed);
        this.allLeftButton.setEnabled(valCount > 0 && this.minAllowed <= 0);
        this.upButton.setEnabled(this.valList.getMinSelectionIndex() > 0);
        int ndx = this.valList.getMaxSelectionIndex();
        this.downButton.setEnabled(ndx >= 0 && ndx < valCount - 1);
        this.removeButton.setEnabled(removeAllowed);
        this.addButton.setEnabled(valCount < this.maxAllowed);
        ButtonWidget acceptButton = this.getAcceptButton();
        if (acceptButton != null) {
            acceptButton.setEnabled(valCount >= this.minAllowed && valCount <= this.maxAllowed);
        }
    }

    public void updateListPreferredSize() {
        Dimension availValListSize = this.availValList.getPreferredSize();
        Dimension valListSize = this.valList.getPreferredSize();
        this.listPrefSize.width = Math.max(Math.max(availValListSize.width, this.availValHdr.getPreferredSize().width), Math.max(valListSize.width, this.valHdr.getPreferredSize().width));
        this.listPrefSize.height = Math.max(availValListSize.height, valListSize.height);
    }

    protected void validateValue(Object value) {
        if (!this.initAvailVals.contains(value)) {
            throw new IllegalArgumentException(ToolboxPlugin.Util.getString("AccumulatorPanel.Value_not_in_initial_available_value_list___6") + value);
        }
    }
}

