/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public final class ArrowIcon
implements Icon,
SwingConstants {
    private boolean bMenuStyle;
    private int nDirection;
    private int iconWidth;
    private int iconHeight;
    private Color enabledColour;
    private Color disabledColour;

    public ArrowIcon() {
        this(3, 8, false, (Color)UIManager.getDefaults().get("Label.foreground"), (Color)UIManager.getDefaults().get("Label.disabledForeground"));
    }

    public ArrowIcon(int direction, int size) {
        this(direction, size, false, (Color)UIManager.getDefaults().get("Label.foreground"), (Color)UIManager.getDefaults().get("Label.disabledForeground"));
    }

    public ArrowIcon(int direction, int size, boolean isMenu) {
        this(direction, size, isMenu, (Color)UIManager.getDefaults().get("Label.foreground"), (Color)UIManager.getDefaults().get("Label.disabledForeground"));
    }

    public ArrowIcon(int direction, int size, boolean isMenu, Color enb, Color dsb) {
        this.bMenuStyle = isMenu;
        this.nDirection = direction;
        this.enabledColour = enb;
        this.disabledColour = dsb;
        if (isMenu) {
            switch (this.nDirection) {
                case 1: 
                case 5: {
                    this.iconWidth = size;
                    this.iconHeight = size / 2;
                    break;
                }
                case 3: 
                case 7: {
                    this.iconWidth = size / 2;
                    this.iconHeight = size;
                }
            }
        } else {
            this.iconWidth = size;
            this.iconHeight = size;
        }
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.translate(x - 1, y);
        g.setColor(c.isEnabled() ? this.enabledColour : this.disabledColour);
        if (this.bMenuStyle) {
            this.paintMenuArrow(g);
        } else {
            this.paintDirectionArrow(g);
        }
        g.translate(-x, -y);
    }

    private void paintMenuArrow(Graphics g) {
        switch (this.nDirection) {
            case 1: {
                for (int y = 0; y < this.iconHeight; ++y) {
                    g.drawLine(y, this.iconHeight - y, this.iconWidth - y, this.iconHeight - y);
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.iconHeight; ++y) {
                    g.drawLine(y, y, this.iconWidth - y, y);
                }
                break;
            }
            case 7: {
                for (int x = 0; x < this.iconWidth; ++x) {
                    g.drawLine(x, this.iconWidth - x, x, this.iconHeight - this.iconWidth + x);
                }
                break;
            }
            case 3: {
                for (int x = 0; x < this.iconWidth; ++x) {
                    g.drawLine(x, x, x, this.iconHeight - x);
                }
                break;
            }
            default: {
                g.drawLine(0, 0, this.iconHeight, this.iconHeight);
                g.drawLine(this.iconHeight, 0, 0, this.iconHeight);
            }
        }
    }

    private void paintDirectionArrow(Graphics g) {
        switch (this.nDirection) {
            case 1: {
                for (int y = 0; y < this.iconHeight; ++y) {
                    g.drawLine((this.iconHeight - y) / 2, y, this.iconWidth - (this.iconHeight - y) / 2, y);
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.iconHeight; ++y) {
                    g.drawLine((y + 1) / 2, y, this.iconWidth - (y + 1) / 2, y);
                }
                break;
            }
            case 3: {
                for (int x = 0; x < this.iconWidth; ++x) {
                    g.drawLine(x, (x + 1) / 2, x, this.iconHeight - (x + 1) / 2);
                }
                break;
            }
            case 7: {
                for (int x = 0; x < this.iconWidth; ++x) {
                    g.drawLine(this.iconWidth - x, (x + 1) / 2, this.iconWidth - x, this.iconHeight - (x + 1) / 2);
                }
                break;
            }
            default: {
                g.drawLine(0, 0, this.iconHeight, this.iconHeight);
                g.drawLine(this.iconHeight, 0, 0, this.iconHeight);
            }
        }
    }
}

