/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.TextUtilities;
import com.metamatrix.toolbox.ui.widget.MultiLineToolTip;
import com.metamatrix.toolbox.ui.widget.event.WidgetActionEvent;
import com.metamatrix.toolbox.ui.widget.laf.ButtonLookAndFeel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;

public class ButtonWidget
extends JButton {
    public static final String PROPERTY_PREFIX = "Button.";
    public static final String ICON_PROPERTY_SUFFIX = "Icon";
    public static final String MNEMONIC_PROPERTY_SUFFIX = "Mnemonic";
    public static final String MARGIN_PROPERTY = "Button.margin";
    public static final String BORDER_PROPERTY = "Button.border";
    public static final String PRESSED_BORDER_PROPERTY = "Button.pressedBorder";
    private int iconTextGap = 0;
    private int pressedShift = 0;
    private String textFmt;
    private boolean focusTraversable = true;

    public ButtonWidget() {
        this(null, null);
    }

    public ButtonWidget(String text) {
        this(text, null);
    }

    public ButtonWidget(Icon icon) {
        this(null, icon);
    }

    public ButtonWidget(String text, Icon icon) {
        super(text, icon);
        this.initializeButtonWidget();
    }

    public ButtonWidget(Action a) {
        super(a);
        this.initializeButtonWidget();
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip tip = new MultiLineToolTip();
        tip.setComponent(this);
        return tip;
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        WidgetActionEvent newEvent = null;
        for (int ndx = listeners.length - 2; ndx >= 0; ndx -= 2) {
            if (listeners[ndx] != ActionListener.class) continue;
            if (newEvent == null) {
                String cmd = event.getActionCommand();
                if (cmd == null) {
                    cmd = this.getActionCommand();
                }
                newEvent = new WidgetActionEvent((Object)this, cmd, event.getModifiers());
            }
            ((ActionListener)listeners[ndx + 1]).actionPerformed(newEvent);
        }
    }

    @Override
    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public int getPressedShift() {
        return this.pressedShift;
    }

    public String getTextFormat() {
        return this.textFmt;
    }

    protected void initializeButtonWidget() {
        this.registerKeyboardAction(this.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), this.getActionCommand(), KeyStroke.getKeyStroke(10, 0, false), 0);
        this.registerKeyboardAction(this.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), this.getActionCommand(), KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    @Override
    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
        ((ButtonLookAndFeel)this.getUI()).setIconTextGap(iconTextGap);
    }

    public void setPressedShift(int pressedShift) {
        this.pressedShift = pressedShift;
        ((ButtonLookAndFeel)this.getUI()).setPressedShift(pressedShift);
    }

    @Override
    public void setText(String text) {
        this.textFmt = text;
        super.setText(TextUtilities.getUnformattedText(text));
    }

    @Override
    public String toString() {
        return this.getText();
    }

    @Override
    public void updateUI() {
        this.setUI(ButtonLookAndFeel.createUI(this));
    }

    public void setFocusTraversable(boolean flag) {
        this.focusTraversable = flag;
    }

    @Override
    public boolean isFocusTraversable() {
        return this.focusTraversable;
    }
}

