/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.widget.ArrowIcon;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.IntegerSpinner;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public final class CalendarPanel
extends JPanel
implements ActionListener {
    public static final String ID_TIMESTAMP_BOTH_FMT = "timestamp.both.fmt";
    public static final String ID_TIMESTAMP_NO_DATE_FMT = "timestamp.no_date.fmt";
    public static final String ID_TIMESTAMP_NO_TIME_FMT = "timestamp.no_time.fmt";
    private static final int ARROW_SIZE = 8;
    private SimpleDateFormat _calendarFormatter;
    private boolean calendarShowing = false;
    private Calendar _date = null;
    private SimpleDateFormat _dayFormatter;
    private EventListenerList listeners;
    private SimpleDateFormat _monthFormatter;
    private boolean _showCal = true;
    private boolean _showTime = true;
    private SimpleDateFormat _specialFormatter = new SimpleDateFormat("MMMddyyyy");
    private Color selectedColor = Color.white;
    private Color originalColor;
    private boolean _readOnly = false;
    private boolean _showToday = true;
    private boolean bSkipFocusLost;
    private ListenerMouse listenerMouse = new ListenerMouse();
    private MyFocusListener focusListener;
    private Frame owner;
    private ButtonWidget btnCalendar;
    private ButtonWidget btnClear;
    private CalendarWindow calWindow;
    private ArrowIcon iconUp;
    private ArrowIcon iconDown;
    private TextFieldWidget txfDate;

    public CalendarPanel(Frame owner) {
        this(owner, true, true);
    }

    public CalendarPanel(Frame owner, boolean theShowCalFlag, boolean theShowTimeFlag) {
        super(new FlowLayout(0, 0, 0));
        this.owner = owner;
        this.txfDate = new TextFieldWidget();
        this.txfDate.setEditable(false);
        this.txfDate.setBackground(Color.white);
        this.txfDate.setMinimumSize(this.txfDate.getPreferredSize());
        this.add(this.txfDate);
        this.iconUp = new ArrowIcon(1, 8);
        this.iconDown = new ArrowIcon(5, 8);
        this.btnCalendar = new ButtonWidget(this.iconDown);
        Insets insets = new Insets(2, 2, 2, 2);
        this.btnCalendar.setMargin(insets);
        this.btnCalendar.addMouseListener(this.listenerMouse);
        this.add(this.btnCalendar);
        this.btnClear = new ButtonWidget(new ArrowIcon(-1, 8));
        this.btnClear.addActionListener(this);
        this.btnClear.setMargin(insets);
        this.add(this.btnClear);
        this.setShowCalendar(theShowCalFlag);
        this.setShowTime(theShowTimeFlag);
        this.setReadOnly(this._readOnly);
        this.setShowToday(this._showToday);
        this.focusListener = new MyFocusListener();
        this.btnCalendar.addFocusListener(this.focusListener);
        this.btnClear.addFocusListener(this.focusListener);
        this.txfDate.addFocusListener(this.focusListener);
    }

    @Override
    public void requestFocus() {
        this.btnCalendar.requestFocus();
    }

    @Override
    public void addFocusListener(FocusListener theListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(FocusListener.class, theListener);
    }

    @Override
    public void removeFocusListener(FocusListener theListener) {
        if (this.listeners != null) {
            this.listeners.remove(FocusListener.class, theListener);
        }
    }

    public void reset() {
        this.actionClear();
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        super.setEnabled(bEnabled);
        this.btnCalendar.setEnabled(bEnabled);
        this.btnCalendar.removeMouseListener(this.listenerMouse);
        this.btnClear.setEnabled(bEnabled);
        this.txfDate.setEnabled(bEnabled);
        if (bEnabled) {
            this.btnCalendar.addMouseListener(this.listenerMouse);
        } else {
            this.btnCalendar.removeMouseListener(this.listenerMouse);
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.setEnabled(!readOnly);
        this._readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setShowCalendar(boolean showCal) {
        this._showCal = showCal;
        this.setFormatId();
        this.setDateColumns();
    }

    public boolean isShowCalendar() {
        return this._showCal;
    }

    public void setShowTime(boolean showTime) {
        this._showTime = showTime;
        this.setFormatId();
        this.setDateColumns();
    }

    public boolean isShowTime() {
        return this._showTime;
    }

    public void setShowToday(boolean showToday) {
        this._showToday = showToday;
    }

    public boolean isShowToday() {
        return this._showToday;
    }

    private void actionClear() {
        if (this._date != null) {
            this._date = null;
            this.txfDate.setText("");
            this.fireChangeEvent(new ChangeEvent(this));
        }
        this.calendarShowing = true;
        this.processCalendarWindow();
    }

    @Override
    public void actionPerformed(ActionEvent theEvent) {
        Object source = theEvent.getSource();
        if (source == this.btnClear) {
            this.actionClear();
        } else if (source == this.getCalWindow() && !this.bSkipFocusLost) {
            this.calendarShowing = true;
            this.processCalendarWindow();
            if (theEvent.getID() == 0) {
                this._date = this.getCalWindow().getCalendar();
                this.txfDate.setText(this.getCalendarFormatter().format(this._date.getTime()));
                this.fireChangeEvent(new ChangeEvent(this));
            } else if (theEvent.getID() == 2) {
                this._date = this.getCalWindow().getCalendar();
                this.txfDate.setText(this.getCalendarFormatter().format(this._date.getTime()));
                this.fireChangeEvent(new ChangeEvent(this));
            }
        }
    }

    public void addChangeListener(ChangeListener theListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(ChangeListener.class, theListener);
    }

    private void fireChangeEvent(ChangeEvent theEvent) {
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            Object l = list[i + 1];
            if (!(l instanceof ChangeListener)) continue;
            ((ChangeListener)l).stateChanged(theEvent);
        }
    }

    public void setDate(Date theDate) {
        if (theDate == null) {
            this.setCalendar(null);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(theDate);
            this.setCalendar(calendar);
        }
    }

    public void setCalendar(Calendar theDate) {
        this._date = theDate;
        this.txfDate.setText(this._date == null ? null : this.getCalendarFormatter().format(this._date.getTime()));
    }

    public Calendar getCalendar() {
        return this._date;
    }

    public DateFormat getFormatter() {
        return this.getCalendarFormatter();
    }

    public Timestamp getTimestamp() {
        if (this._date == null) {
            return null;
        }
        return new Timestamp(this._date.getTime().getTime());
    }

    private CalendarWindow getCalWindow() {
        if (this.calWindow == null) {
            this.calWindow = new CalendarWindow(this.owner);
            this.calWindow.setShowCal(this._showCal);
            this.calWindow.setShowTime(this._showTime);
            this.calWindow.addActionListener(this);
            this.calWindow.pack();
        }
        return this.calWindow;
    }

    private void initFormatters(Locale theLocale) {
        this._dayFormatter = new SimpleDateFormat("EE", theLocale);
        this._monthFormatter = new SimpleDateFormat("MMM", theLocale);
        String format = null;
        if (this._showCal && this._showTime) {
            format = "MMM dd, yyyy HH:mm";
        } else if (this._showCal && !this._showTime) {
            format = "MMM dd, yyyy";
        } else if (!this._showCal && this._showTime) {
            format = "HH:mm";
        }
        this._calendarFormatter = new SimpleDateFormat(format, theLocale);
    }

    private SimpleDateFormat getCalendarFormatter() {
        if (this._calendarFormatter == null) {
            this.initFormatters(Locale.getDefault());
        }
        return this._calendarFormatter;
    }

    private SimpleDateFormat getDayFormatter() {
        if (this._dayFormatter == null) {
            this.initFormatters(Locale.getDefault());
        }
        return this._dayFormatter;
    }

    private SimpleDateFormat getMonthFormatter() {
        if (this._monthFormatter == null) {
            this.initFormatters(Locale.getDefault());
        }
        return this._monthFormatter;
    }

    private void setDateColumns() {
        if (this._showCal && this._showTime) {
            this.txfDate.setColumns(20);
        } else if (this._showCal && !this._showTime) {
            this.txfDate.setColumns(12);
        } else if (!this._showCal && this._showTime) {
            this.txfDate.setColumns(8);
        } else {
            this.txfDate.setColumns(0);
        }
    }

    public boolean isDateValid() {
        boolean valid = false;
        try {
            valid = this.getCalendarFormatter().parse(this.txfDate.getText()) != null;
        }
        catch (ParseException pe) {
            valid = false;
        }
        return valid;
    }

    private void processCalendarWindow() {
        if (!this.calendarShowing) {
            Point p = this.getLocationOnScreen();
            p.y += this.getSize().height;
            this.getCalWindow().setLocation(p);
            this.getCalWindow().setCalendar(this._date);
            if (!this.getCalWindow().isVisible()) {
                this.getCalWindow().setVisible(true);
                this.getCalWindow().requestFocus();
                this.getCalWindow().toFront();
            }
        } else if (this.getCalWindow().isVisible()) {
            this.getCalWindow().setVisible(false);
        }
        this.calendarShowing = !this.calendarShowing;
        this.btnCalendar.setIcon(this.calendarShowing ? this.iconUp : this.iconDown);
    }

    public void removeChangeListener(ChangeListener theListener) {
        this.listeners.remove(ChangeListener.class, theListener);
    }

    private void setFormatId() {
        if (this._showCal && !this._showTime || this._showCal || this._showTime) {
            // empty if block
        }
    }

    @Override
    public String getToolTipText() {
        return this.txfDate.getToolTipText();
    }

    @Override
    public void setToolTipText(String theText) {
        this.txfDate.setToolTipText(theText);
    }

    private final class CalendarWindow
    extends JWindow
    implements ActionListener {
        private final Insets INSETS;
        public static final int SELECTED_DAY = 0;
        public static final int LOST_FOCUS = 1;
        public static final int SELECTED_TIME = 2;
        private Calendar _date;
        private Calendar _selectedDate;
        private ButtonWidget btnMonthDec;
        private ButtonWidget btnMonthInc;
        private ButtonWidget btnYearDec;
        private ButtonWidget btnYearInc;
        private IntegerSpinner isHours;
        private IntegerSpinner isMinutes;
        private JPanel pnlDate;
        private JPanel pnlTime;
        private LabelWidget lblMonth;
        private LabelWidget lblYear;
        private JPanel pnlDays;
        private ButtonWidget[] dayButtons;
        private ButtonWidget btnSetTime;
        private ListenerFocus fl;

        public CalendarWindow(Frame owner) {
            this(owner, null);
        }

        private CalendarWindow(Frame owner, Calendar theDate) {
            super(owner);
            this.INSETS = new Insets(2, 2, 2, 2);
            this.dayButtons = new ButtonWidget[31];
            this.fl = new ListenerFocus();
            this.addFocusListener(this.fl);
            this.pnlTime = new JPanel();
            this.pnlTime.setBorder(new EtchedBorder());
            LabelWidget lblHours = new LabelWidget("Hours:");
            lblHours.setName("cp.lblHours");
            this.pnlTime.add(lblHours);
            this.isHours = new IntegerSpinner(0, 23, 1);
            this.isHours.addFocusListener(this.fl);
            this.isHours.setEditable(true);
            this.isHours.setPad(true);
            this.pnlTime.add(this.isHours);
            LabelWidget lblMinutes = new LabelWidget("Minutes:");
            lblMinutes.setName("cp.lblMinutes");
            this.pnlTime.add(lblMinutes);
            this.isMinutes = new IntegerSpinner(0, 59, 1);
            this.isMinutes.addFocusListener(this.fl);
            this.isMinutes.setEditable(true);
            this.isMinutes.setPad(true);
            this.pnlTime.add(this.isMinutes);
            this.btnSetTime = new ButtonWidget();
            this.btnSetTime.setIcon(CalendarPanel.this.iconUp);
            this.btnSetTime.setMargin(new Insets(0, 0, 0, 0));
            this.btnSetTime.addActionListener(this);
            this.pnlTime.add(this.btnSetTime);
            this.getContentPane().add((Component)this.pnlTime, "South");
            this.pnlDate = new JPanel(new GridBagLayout());
            this.pnlDate.setBorder(new EtchedBorder());
            this.getContentPane().add((Component)this.pnlDate, "Center");
            this._date = theDate != null ? (Calendar)theDate.clone() : Calendar.getInstance();
            this._selectedDate = theDate == null ? null : (Calendar)theDate.clone();
            this.isHours.setValue(this._date.get(11));
            this.isMinutes.setValue(this._date.get(12));
            this.setBackground(this.pnlDate.getBackground());
            this.buildUI();
        }

        @Override
        public void actionPerformed(ActionEvent theEvent) {
            Object source = theEvent.getSource();
            if (source == this.btnMonthDec) {
                this._date.add(2, -1);
                this.redrawPanel();
            } else if (source == this.btnMonthInc) {
                this._date.add(2, 1);
                this.redrawPanel();
            } else if (source == this.btnYearDec) {
                this._date.add(1, -1);
                this.redrawPanel();
            } else if (source == this.btnYearInc) {
                this._date.add(1, 1);
                this.redrawPanel();
            } else if (source == this.btnSetTime) {
                if (this._selectedDate == null) {
                    this._selectedDate = (Calendar)this._date.clone();
                }
                this.setVisible(false);
                this.fireActionEvent(new ActionEvent(this, 2, "time selected"));
            } else {
                if (this._selectedDate == null) {
                    this._selectedDate = (Calendar)this._date.clone();
                }
                this._selectedDate.set(5, Integer.valueOf(theEvent.getActionCommand()));
                this._selectedDate.set(2, this._date.get(2));
                this._selectedDate.set(1, this._date.get(1));
                this.setVisible(false);
                this.fireActionEvent(new ActionEvent(this, 0, "day selected"));
            }
        }

        public void addActionListener(ActionListener theListener) {
            CalendarPanel.this.listeners.add(ActionListener.class, theListener);
        }

        public void removeActionListener(ActionListener theListener) {
            CalendarPanel.this.listeners.remove(ActionListener.class, theListener);
        }

        private JPanel buildHeaderPanel() {
            this.lblMonth = new LabelWidget(CalendarPanel.this.getMonthFormatter().format(this._date.getTime()));
            this.lblYear = new LabelWidget(Integer.toString(this._date.get(1)));
            GridBagConstraints gbc = new GridBagConstraints();
            JPanel headerPanel = new JPanel(new GridBagLayout());
            JPanel panel = new JPanel(new GridBagLayout());
            this.btnMonthDec = new ButtonWidget();
            this.btnMonthDec.addFocusListener(this.fl);
            this.btnMonthDec.setIcon(new ArrowIcon(7, 8));
            this.btnMonthDec.setMargin(this.INSETS);
            this.btnMonthDec.addActionListener(this);
            gbc.anchor = 13;
            gbc.insets = this.INSETS;
            panel.add((Component)this.btnMonthDec, gbc);
            gbc.anchor = 10;
            panel.add((Component)this.lblMonth, gbc);
            this.btnMonthInc = new ButtonWidget();
            this.btnMonthInc.addFocusListener(this.fl);
            this.btnMonthInc.setIcon(new ArrowIcon(3, 8));
            this.btnMonthInc.setMargin(this.INSETS);
            this.btnMonthInc.addActionListener(this);
            gbc.anchor = 17;
            panel.add((Component)this.btnMonthInc, gbc);
            gbc.anchor = 10;
            gbc.weightx = 1.0;
            headerPanel.add((Component)panel, gbc);
            panel = new JPanel(new GridBagLayout());
            this.btnYearDec = new ButtonWidget();
            this.btnYearDec.addFocusListener(this.fl);
            this.btnYearDec.setIcon(new ArrowIcon(7, 8));
            this.btnYearDec.setMargin(this.INSETS);
            this.btnYearDec.addActionListener(this);
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            panel.add((Component)this.btnYearDec, gbc);
            gbc.anchor = 10;
            panel.add((Component)this.lblYear, gbc);
            this.btnYearInc = new ButtonWidget();
            this.btnYearInc.addFocusListener(this.fl);
            this.btnYearInc.setIcon(new ArrowIcon(3, 8));
            this.btnYearInc.setMargin(this.INSETS);
            this.btnYearInc.addActionListener(this);
            gbc.anchor = 17;
            panel.add((Component)this.btnYearInc, gbc);
            gbc.anchor = 10;
            gbc.weightx = 1.0;
            headerPanel.add((Component)panel, gbc);
            return headerPanel;
        }

        private void buildUI() {
            for (int i = 0; i < this.dayButtons.length; ++i) {
                this.dayButtons[i] = new ButtonWidget(Integer.toString(i + 1));
                this.dayButtons[i].setMargin(this.INSETS);
                this.dayButtons[i].addActionListener(this);
            }
            CalendarPanel.this.originalColor = this.dayButtons[0].getBackground();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.pnlDate.add((Component)this.buildHeaderPanel(), gbc);
            this.pnlDays = new JPanel(new GridBagLayout());
            this.pnlDays.setBorder(new CompoundBorder(this.pnlDays.getBorder(), new EmptyBorder(10, 10, 0, 10)));
            this.redrawPanel();
            gbc.gridx = 0;
            ++gbc.gridy;
            this.pnlDate.add((Component)this.pnlDays, gbc);
        }

        private void fireActionEvent(ActionEvent theEvent) {
            Object[] list = CalendarPanel.this.listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                Object l = list[i + 1];
                if (!(l instanceof ActionListener)) continue;
                ((ActionListener)l).actionPerformed(theEvent);
            }
        }

        private void lostFocus() {
            this.setHourMinute();
            this.fireActionEvent(new ActionEvent(this, 1, "lost focus"));
        }

        private void redrawPanel() {
            this.pnlDays.removeAll();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(1, 1, 1, 1);
            Calendar date = Calendar.getInstance();
            int firstDay = date.getFirstDayOfWeek();
            date.set(7, firstDay);
            int i = 0;
            while (i < 7) {
                LabelWidget lbl = new LabelWidget(CalendarPanel.this.getDayFormatter().format(date.getTime()));
                lbl.setHorizontalAlignment(0);
                this.pnlDays.add((Component)lbl, gbc);
                date.set(7, date.get(7) + 1);
                ++i;
                ++gbc.gridx;
            }
            this.lblMonth.setText(CalendarPanel.this.getMonthFormatter().format(this._date.getTime()));
            this.lblYear.setText(Integer.toString(this._date.get(1)));
            firstDay = Calendar.getInstance().getFirstDayOfWeek();
            gbc.gridx = 0;
            ++gbc.gridy;
            Calendar today = Calendar.getInstance();
            today.setTime(new Date());
            Calendar cellDay = (Calendar)today.clone();
            int month = this._date.get(2);
            int year = this._date.get(1);
            cellDay.set(year, month, 1);
            gbc.gridx = cellDay.get(7) - firstDay;
            Font fntBtn = this.dayButtons[0].getFont();
            Font fntNorm = new Font(fntBtn.getName(), 0, fntBtn.getSize());
            Font fntToday = new Font(fntBtn.getName(), 1, fntBtn.getSize());
            while (cellDay.get(2) == month) {
                ButtonWidget btn = this.dayButtons[cellDay.get(5) - 1];
                if (gbc.gridx > 6) {
                    ++gbc.gridy;
                    gbc.gridx = 0;
                }
                if (today.equals(cellDay)) {
                    btn.setFont(fntToday);
                } else {
                    btn.setFont(fntNorm);
                }
                if (this._selectedDate != null && CalendarPanel.this._specialFormatter.format(cellDay.getTime()).equals(CalendarPanel.this._specialFormatter.format(this._selectedDate.getTime()))) {
                    btn.setBackground(CalendarPanel.this.selectedColor);
                } else if (btn.getBackground().equals(CalendarPanel.this.selectedColor)) {
                    btn.setBackground(CalendarPanel.this.originalColor);
                }
                this.pnlDays.add((Component)btn, gbc);
                ++gbc.gridx;
                cellDay.add(5, 1);
            }
            while (gbc.gridy < 6) {
                gbc.gridx = 0;
                ++gbc.gridy;
                gbc.insets = new Insets(6, 0, 6, 0);
                this.pnlDays.add((Component)new LabelWidget(" "), gbc);
            }
            this.repaint();
        }

        private void setCalendar(Calendar theDate) {
            if (theDate == null) {
                if (this._selectedDate != null) {
                    this.dayButtons[this._selectedDate.get(5) - 1].setBackground((Color)UIManager.getDefaults().get("Button.background"));
                }
                this._selectedDate = null;
            } else {
                this._date = (Calendar)theDate.clone();
            }
            this.redrawPanel();
        }

        private Calendar getCalendar() {
            this.setHourMinute();
            return this._selectedDate;
        }

        private boolean setHourMinute() {
            boolean changed = false;
            if (this._selectedDate != null) {
                int hour = this.isHours.getValue();
                int minute = this.isMinutes.getValue();
                if (this._selectedDate.get(11) != hour) {
                    changed = true;
                    this._selectedDate.set(11, hour);
                }
                if (this._selectedDate.get(12) != minute) {
                    changed = true;
                    this._selectedDate.set(12, minute);
                }
                if (changed) {
                    // empty if block
                }
            }
            return changed;
        }

        private void setShowCal(boolean theShowCalFlag) {
            if (this.pnlDate.isVisible() != theShowCalFlag) {
                this.pnlDate.setVisible(theShowCalFlag);
            }
        }

        private void setShowTime(boolean theShowTimeFlag) {
            if (this.pnlTime.isVisible() != theShowTimeFlag) {
                this.pnlTime.setVisible(theShowTimeFlag);
            }
        }

        final class ListenerFocus
        extends FocusAdapter {
            ListenerFocus() {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    Runnable doit = new Runnable(){

                        @Override
                        public void run() {
                            CalendarWindow.this.lostFocus();
                        }
                    };
                    SwingUtilities.invokeLater(doit);
                }
            }
        }
    }

    final class ListenerMouse
    extends MouseAdapter {
        ListenerMouse() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == CalendarPanel.this.btnCalendar) {
                CalendarPanel.this.bSkipFocusLost = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == CalendarPanel.this.btnCalendar) {
                CalendarPanel.this.processCalendarWindow();
                CalendarPanel.this.bSkipFocusLost = false;
            }
        }
    }

    class MyFocusListener
    implements FocusListener {
        MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent theEvent) {
            this.focusLost(theEvent);
        }

        @Override
        public void focusLost(FocusEvent theEvent) {
            Object[] list = CalendarPanel.this.listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                Object l = list[i + 1];
                if (!(l instanceof FocusListener)) continue;
                if (theEvent.getID() == 1004) {
                    ((FocusListener)l).focusGained(theEvent);
                    continue;
                }
                ((FocusListener)l).focusLost(theEvent);
            }
        }
    }
}

