/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.widget.MultiLineToolTip;
import com.metamatrix.toolbox.ui.widget.button.CheckBoxModel;
import com.metamatrix.toolbox.ui.widget.laf.CheckBoxLookAndFeel;
import java.awt.Color;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JToolTip;

public class CheckBox
extends JCheckBox {
    public static final int DESELECTED = 0;
    public static final int SELECTED = 1;
    public static final int PARTIALLY_SELECTED = 2;
    public static final String PROPERTY_PREFIX = "CheckBox.";
    private final transient int selectionState;
    private Color boxBkgdColor;
    private Color boxDisabledBkgdColor;

    public CheckBox() {
        this(null, 0);
    }

    public CheckBox(String text) {
        this(text, 0);
    }

    public CheckBox(int selectionState) {
        this(null, selectionState);
    }

    public CheckBox(String text, int selectionState) {
        super(text);
        this.selectionState = selectionState;
        this.initializeCheckBox();
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip tip = new MultiLineToolTip();
        tip.setComponent(this);
        return tip;
    }

    public Color getBoxBackgroundColor() {
        return this.boxBkgdColor;
    }

    public Color getBoxDisabledBackgroundColor() {
        return this.boxDisabledBkgdColor;
    }

    protected void initializeCheckBox() {
        this.setModel(new CheckBoxModel());
        switch (this.selectionState) {
            case 0: {
                break;
            }
            case 1: {
                this.setSelected(true);
                break;
            }
            case 2: {
                this.setPartiallySelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid selection state: " + this.selectionState);
            }
        }
        this.setBorder(null);
    }

    public boolean isPartiallySelected() {
        ButtonModel model = this.getModel();
        if (!(model instanceof CheckBoxModel)) {
            return false;
        }
        return ((CheckBoxModel)model).isPartiallySelected();
    }

    public void setBoxBackgroundColor(Color color) {
        this.boxBkgdColor = color;
    }

    public void setBoxDisabledBackgroundColor(Color color) {
        this.boxDisabledBkgdColor = color;
    }

    public void setPartiallySelected(boolean isPartiallySelected) {
        ButtonModel model = this.getModel();
        if (!(model instanceof CheckBoxModel)) {
            return;
        }
        ((CheckBoxModel)model).setPartiallySelected(isPartiallySelected);
    }

    @Override
    public void updateUI() {
        this.setUI(CheckBoxLookAndFeel.createUI(this));
    }
}

