/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class ComboButtonWidget
extends JPanel {
    private ButtonWidget popupListButton;
    private ButtonWidget cycleButton;
    private JPopupMenu displayListPopupMenu;
    private Icon detailsOnIcon;
    private Icon cycleButtonIcon;
    private Icon popupListButtonIcon;
    private String[] choicesList;
    private String popupListButtonToolTipText = "popupListButton ToolTip text";
    private String cycleButtonToolTipText = "cycleButton ToolTip text";
    private JRadioButtonMenuItem[] choicesMenuItemArray;

    public ComboButtonWidget(String[] choices) {
        super(new GridBagLayout());
        this.choicesList = choices;
        this.initializeComboButtonWidget();
        this.setMaximumSize(this.getPreferredSize());
    }

    private void initializeComboButtonWidget() {
        ImageIcon popupListButtonIcon = new ImageIcon(ClassLoader.getSystemResource("com/metamatrix/toolbox/ui/widget/images/little_down_arrow.gif"));
        Icon cycleButtonIcon = UIDefaults.getInstance().getIcon("FileChooser.listViewIcon");
        this.cycleButton = new ButtonWidget(this.detailsOnIcon);
        this.cycleButton.setToolTipText(this.cycleButtonToolTipText);
        this.cycleButton.setBorderPainted(false);
        this.cycleButton.setIcon(cycleButtonIcon);
        this.cycleButton.setFocusPainted(false);
        this.cycleButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ComboButtonWidget.this.cycleButton.setBorderPainted(true);
                ComboButtonWidget.this.popupListButton.setBorderPainted(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ComboButtonWidget.this.cycleButton.setBorderPainted(false);
                ComboButtonWidget.this.popupListButton.setBorderPainted(false);
            }
        });
        this.popupListButton = new ButtonWidget(this.detailsOnIcon);
        this.popupListButton.setToolTipText(this.popupListButtonToolTipText);
        this.popupListButton.setBorderPainted(false);
        this.popupListButton.setIcon(popupListButtonIcon);
        this.popupListButton.setFocusPainted(false);
        int cycleButtonHeight = this.cycleButton.getPreferredSize().height;
        int popupListButtonWidth = this.popupListButton.getPreferredSize().width;
        this.popupListButton.setPreferredSize(new Dimension(popupListButtonWidth, cycleButtonHeight));
        this.popupListButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ComboButtonWidget.this.cycleButton.setBorderPainted(true);
                ComboButtonWidget.this.popupListButton.setBorderPainted(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ComboButtonWidget.this.cycleButton.setBorderPainted(false);
                ComboButtonWidget.this.popupListButton.setBorderPainted(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ComboButtonWidget.this.displayListPopupMenu.show(e.getComponent(), e.getX() - 60, e.getY() + 20);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ComboButtonWidget.this.displayListPopupMenu.show(e.getComponent(), e.getX() - 60, e.getY() + 20);
            }
        });
        this.choicesMenuItemArray = new JRadioButtonMenuItem[this.choicesList.length];
        for (int i = 0; i < this.choicesList.length; ++i) {
            this.choicesMenuItemArray[i] = new JRadioButtonMenuItem(this.choicesList[i]);
            final JRadioButtonMenuItem choicesMenuItem = this.choicesMenuItemArray[i];
            choicesMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    choicesMenuItem.setSelected(true);
                }
            });
        }
        ButtonGroup choiceMenuItemButtonGroup = new ButtonGroup();
        this.displayListPopupMenu = new JPopupMenu();
        for (int j = 0; j < this.choicesList.length; ++j) {
            choiceMenuItemButtonGroup.add(this.choicesMenuItemArray[j]);
            this.displayListPopupMenu.add(this.choicesMenuItemArray[j]);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ComboButtonWidget.this.displayListPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ComboButtonWidget.this.displayListPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.add(this.cycleButton);
        this.add(this.popupListButton);
        this.cycleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboButtonWidget.this.repaint();
                ComboButtonWidget.this.setVisible(true);
                int index = -1;
                for (int i = 0; i < ComboButtonWidget.this.choicesMenuItemArray.length; ++i) {
                    if (!ComboButtonWidget.this.choicesMenuItemArray[i].isSelected()) continue;
                    index = i;
                }
                if (index + 1 < ComboButtonWidget.this.choicesMenuItemArray.length) {
                    ComboButtonWidget.this.choicesMenuItemArray[index + 1].doClick();
                } else {
                    ComboButtonWidget.this.choicesMenuItemArray[0].doClick();
                }
            }
        });
    }

    public JRadioButtonMenuItem getChoiceMenuItem(int index) {
        if (index <= this.choicesMenuItemArray.length) {
            return this.choicesMenuItemArray[index];
        }
        System.out.println("CombButtonWidget: throw exception here");
        return null;
    }

    public JRadioButtonMenuItem getChoiceMenuItem(String choice) {
        for (int i = 0; i < this.choicesMenuItemArray.length; ++i) {
            if (!this.choicesMenuItemArray[i].getText().equals(choice)) continue;
            return this.choicesMenuItemArray[i];
        }
        return null;
    }

    public void setCycleButtonIcon(Icon image) {
        this.cycleButtonIcon = image;
        this.cycleButton.setIcon(this.cycleButtonIcon);
    }

    public void setCycleButtonText(String text) {
        this.cycleButton.setText(text);
        this.setMaximumSize(this.getPreferredSize());
    }

    public void setCycleButtonToolTipText(String toolTipText) {
        this.cycleButtonToolTipText = toolTipText;
        this.cycleButton.setToolTipText(this.cycleButtonToolTipText);
    }

    public void setPopupListButtonIcon(ImageIcon image) {
        this.popupListButtonIcon = image;
        this.popupListButton.setIcon(this.popupListButtonIcon);
    }

    public void setPopupListButtonText(String text) {
        this.popupListButton.setText(text);
        this.setMaximumSize(this.getPreferredSize());
    }

    public void setPopupListButtonToolTipText(String toolTipText) {
        this.popupListButtonToolTipText = toolTipText;
        this.popupListButton.setToolTipText(this.popupListButtonToolTipText);
    }

    public void setSelectedChoice(int index) {
        this.choicesMenuItemArray[index].setSelected(true);
    }

    public void setSelectedChoice(String choice) {
        for (int i = 0; i < this.choicesMenuItemArray.length; ++i) {
            if (!this.choicesMenuItemArray[i].getText().equals(choice)) continue;
            this.setSelectedChoice(i);
        }
    }
}

