/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.widget.ButtonConstants;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.WidgetFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ConfigurationPanel
extends DialogPanel
implements ButtonConstants {
    private transient List tabNames = null;
    private transient List tabContents = null;
    private ButtonWidget applyButton = null;

    public ConfigurationPanel() {
        this((Component)null);
    }

    public ConfigurationPanel(Component content) {
        super(content);
        this.initializeConfigurationPanel();
    }

    public ConfigurationPanel(List tabNames) {
        this(tabNames, null);
    }

    public ConfigurationPanel(List tabNames, List tabContents) {
        super(new JTabbedPane());
        this.tabNames = tabNames;
        this.tabContents = tabContents;
        this.initializeConfigurationPanel();
    }

    public void addApplyActionListener(ActionListener listener) {
        this.getAcceptButton().addActionListener(listener);
        this.applyButton.addActionListener(listener);
    }

    protected ButtonWidget createApplyButton() {
        return WidgetFactory.createButton("apply");
    }

    protected Container createDefaultTab(String name) {
        return new JPanel();
    }

    public ButtonWidget getApplyButton() {
        return this.applyButton;
    }

    protected void initializeConfigurationPanel() {
        this.applyButton = this.createApplyButton();
        this.addNavigationButton(this.applyButton);
        if (this.tabNames != null) {
            JTabbedPane tabs = (JTabbedPane)this.getContent();
            Iterator nameIterator = this.tabNames.iterator();
            Iterator contentIterator = null;
            if (this.tabContents != null) {
                contentIterator = this.tabContents.iterator();
            }
            while (nameIterator.hasNext()) {
                String name = nameIterator.next().toString();
                if (this.tabContents == null || !contentIterator.hasNext()) {
                    tabs.addTab(name, this.createDefaultTab(name));
                    continue;
                }
                tabs.addTab(name, (Component)contentIterator.next());
            }
        }
    }

    public void removeApplyActionListener(ActionListener listener) {
        this.getAcceptButton().removeActionListener(listener);
        this.applyButton.removeActionListener(listener);
    }
}

