/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.UIConstants;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonConstants;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.SpacerWidget;
import com.metamatrix.toolbox.ui.widget.WidgetFactory;
import com.metamatrix.toolbox.ui.widget.event.WidgetActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class DialogPanel
extends JPanel
implements ButtonConstants,
UIConstants {
    private static final Border BORDER = UIDefaults.getInstance().getBorder("Window.border");
    private Component content;
    private Container contentPanel;
    private JComponent bar;
    private List acceptButtons;
    private ButtonWidget cancelButton;
    private ButtonWidget helpButton;
    private ButtonWidget selectedButton;
    private Window wdw;
    private LayoutManager layout;
    private int nextNdx;
    private boolean canAccept;
    private boolean canCancel;
    private ActionListener selectionListener;

    public DialogPanel() {
        this((Component)null);
    }

    public DialogPanel(Component content) {
        super(null);
        this.content = content;
        this.initializeDialogPanel();
    }

    protected void accept(WidgetActionEvent event) {
    }

    public int addAcceptButton(ButtonWidget button) {
        this.addAcceptButton(button, this.nextNdx);
        return this.nextNdx;
    }

    public void addAcceptButton(ButtonWidget button, int index) {
        List acceptButtons = this.getAcceptButtons();
        if (this.getNavigationButton(button.getText()) == null) {
            this.addNavigationButton(button, index);
            acceptButtons.add(button);
        }
    }

    public int addCancelButton(ButtonWidget button) {
        int ndx = this.addNavigationButton(button);
        this.cancelButton = button;
        return ndx;
    }

    public void addCancelButton(ButtonWidget button, int index) {
        this.addNavigationButton(button, index);
        this.cancelButton = button;
    }

    public int addHelpButton(ButtonWidget button) {
        this.addNavigationButton(button, 0);
        this.helpButton = button;
        return 0;
    }

    public void addHelpButton(ButtonWidget button, int index) {
        this.addNavigationButton(button, index);
        this.helpButton = button;
    }

    public int addNavigationButton(ButtonWidget button) {
        this.validateState();
        this.addNavigationButton(button, this.nextNdx);
        return this.nextNdx;
    }

    public void addNavigationButton(ButtonWidget button, int index) {
        if (this.selectionListener == null) {
            this.selectionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DialogPanel.this.selectedButton = (ButtonWidget)event.getSource();
                }
            };
        }
        button.addActionListener(this.selectionListener);
        this.addNavigationComponent(button, index);
        this.equalizeNavigationButtonWidths();
    }

    protected void addNavigationComponent(Component component, int index) {
        this.validateState();
        if (index <= this.nextNdx) {
            ++this.nextNdx;
        }
        this.bar.add(component, index);
    }

    public int addNavigationSpacer(SpacerWidget spacer) {
        this.validateState();
        this.addNavigationSpacer(spacer, this.nextNdx);
        return this.nextNdx;
    }

    public void addNavigationSpacer(SpacerWidget spacer, int index) {
        this.addNavigationComponent(spacer, index);
    }

    protected void buildNavigationBar() {
        this.bar.setLayout(new BoxLayout(this.bar, 0));
        this.bar.setBorder(BorderFactory.createEmptyBorder(DialogPanel.BORDER.getBorderInsets((Component)this).bottom, 0, 0, 0));
        if (this.helpButton != null) {
            this.addNavigationButton(this.helpButton);
        }
        this.addNavigationSpacer(SpacerWidget.createHorizontalExpandableSpacer());
        Iterator iter = this.getAcceptButtons().iterator();
        while (iter.hasNext()) {
            this.addNavigationButton((ButtonWidget)iter.next());
        }
        if (this.cancelButton != null) {
            this.bar.add(SpacerWidget.createHorizontalSpacer());
            this.addNavigationButton(this.cancelButton, this.nextNdx + 1);
        }
        this.equalizeNavigationButtonWidths();
    }

    public boolean canAccept() {
        return this.canAccept;
    }

    public boolean canCancel() {
        return this.canCancel;
    }

    protected void cancel(WidgetActionEvent event) {
    }

    protected ButtonWidget createAcceptButton() {
        return WidgetFactory.createButton("accept");
    }

    protected ButtonWidget createCancelButton() {
        return WidgetFactory.createButton("cancel");
    }

    protected ButtonWidget createHelpButton() {
        for (Container cntr = this; cntr != null; cntr = cntr.getParent()) {
            if (!(cntr instanceof JComponent) || ((JComponent)cntr).getClientProperty("contextSensitiveHelp") == null) continue;
            return WidgetFactory.createButton("help");
        }
        return null;
    }

    protected JComponent createNavigationBar() {
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        return bar;
    }

    protected void equalizeNavigationButtonWidths() {
        ButtonWidget button;
        Component comp;
        Dimension maxSize = new Dimension();
        int ndx = this.bar.getComponentCount();
        while (--ndx >= 0) {
            comp = this.bar.getComponent(ndx);
            if (!(comp instanceof ButtonWidget)) continue;
            button = (ButtonWidget)comp;
            if (button.isPreferredSizeSet()) {
                button.setPreferredSize(null);
            }
            Dimension size = button.getPreferredSize();
            maxSize.width = Math.max(maxSize.width, size.width);
            maxSize.height = Math.max(maxSize.height, size.height);
        }
        ndx = this.bar.getComponentCount();
        while (--ndx >= 0) {
            comp = this.bar.getComponent(ndx);
            if (!(comp instanceof ButtonWidget)) continue;
            button = (ButtonWidget)comp;
            button.setPreferredSize(maxSize);
            button.setMinimumSize(maxSize);
            button.setMaximumSize(maxSize);
        }
    }

    public ButtonWidget getAcceptButton() {
        List acceptButtons = this.getAcceptButtons();
        if (acceptButtons.isEmpty()) {
            return null;
        }
        return (ButtonWidget)acceptButtons.get(0);
    }

    public List getAcceptButtons() {
        if (this.acceptButtons == null) {
            this.acceptButtons = new ArrayList(0);
        }
        return this.acceptButtons;
    }

    public ButtonWidget getCancelButton() {
        return this.cancelButton;
    }

    public Component getContent() {
        return this.content;
    }

    public Container getContentContainer() {
        return this.contentPanel;
    }

    public ButtonWidget getHelpButton() {
        return this.helpButton;
    }

    public JComponent getNavigationBar() {
        return this.bar;
    }

    public ButtonWidget getNavigationButton(String text) {
        this.validateState();
        int ndx = this.bar.getComponentCount();
        while (--ndx >= 0) {
            ButtonWidget button;
            Component comp = this.bar.getComponent(ndx);
            if (!(comp instanceof ButtonWidget) || !(button = (ButtonWidget)comp).getText().equals(text)) continue;
            return button;
        }
        return null;
    }

    public Component getNavigationComponent(int index) {
        this.validateState();
        return this.bar.getComponent(index);
    }

    public int getNavigationComponentIndex(Component component) {
        this.validateState();
        int ndx = this.bar.getComponentCount();
        while (--ndx >= 0) {
            if (this.bar.getComponent(ndx) != component) continue;
            return ndx;
        }
        return -1;
    }

    public ButtonWidget getSelectedButton() {
        return this.selectedButton;
    }

    ActionListener getSelectionListener() {
        return this.selectionListener;
    }

    public Window getWindowAncestor() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            return (Window)parent;
        }
        return null;
    }

    protected void initializeDialogPanel() {
        ButtonWidget acceptButton;
        this.canAccept = true;
        this.canCancel = true;
        this.setBorder(BORDER);
        Insets insets = BORDER.getBorderInsets(this);
        this.setLayout(new BorderLayout(insets.top, insets.left));
        this.contentPanel = new JPanel(new BorderLayout());
        this.add((Component)this.contentPanel, "Center");
        if (this.content != null) {
            this.contentPanel.add(this.content, "Center");
        }
        if ((acceptButton = this.createAcceptButton()) != null) {
            this.getAcceptButtons().add(acceptButton);
        }
        this.cancelButton = this.createCancelButton();
        this.helpButton = this.createHelpButton();
        this.bar = this.createNavigationBar();
        if (this.bar != null) {
            this.buildNavigationBar();
            this.contentPanel.add((Component)this.bar, "South");
        }
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                DialogPanel.this.wdw = DialogPanel.this.getWindowAncestor();
                DialogPanel.this.windowAdded();
                if (DialogPanel.this.wdw != null) {
                    DialogPanel.this.wdw.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowActivated(WindowEvent event) {
                            DialogPanel.this.windowActivated();
                        }
                    });
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (!event.getPropertyName().equals("contextSensitiveHelp")) {
                    return;
                }
                if (DialogPanel.this.helpButton == null && Boolean.TRUE.equals(event.getNewValue())) {
                    DialogPanel.this.addHelpButton(DialogPanel.this.createHelpButton());
                } else if (DialogPanel.this.helpButton != null && !Boolean.TRUE.equals(event.getNewValue())) {
                    DialogPanel.this.removeNavigationButton(DialogPanel.this.helpButton);
                }
            }
        });
    }

    public int removeNavigationButton(ButtonWidget button) {
        this.validateState();
        if (button == null) {
            return -1;
        }
        int ndx = this.getNavigationComponentIndex(button);
        if (ndx < this.nextNdx) {
            --this.nextNdx;
        }
        this.bar.remove(button);
        return ndx;
    }

    public Component removeNavigationComponent(int index) {
        this.validateState();
        Component comp = this.bar.getComponent(index);
        if (index < this.nextNdx) {
            --this.nextNdx;
        }
        this.bar.remove(index);
        return comp;
    }

    public void removeNavigationSpacer(SpacerWidget spacer) {
        this.validateState();
        int ndx = this.getNavigationComponentIndex(spacer);
        if (ndx < this.nextNdx) {
            --this.nextNdx;
        }
        this.bar.remove(spacer);
    }

    protected void setCanAccept(boolean canAccept) {
        this.canAccept = canAccept;
    }

    protected void setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
    }

    public void setContent(Component content) {
        Container south = null;
        if (this.bar != null) {
            for (south = this.bar; south != null && south.getParent() != this.contentPanel; south = south.getParent()) {
            }
            if (south != null) {
                this.contentPanel.remove(south);
            }
        }
        if (this.content != null) {
            this.contentPanel.remove(this.content);
        }
        if (content != null) {
            this.contentPanel.add(content, "Center");
        }
        if (south != null) {
            this.contentPanel.add((Component)south, "South");
        }
        this.content = content;
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (this.layout != null && !(layout instanceof BorderLayout)) {
            throw new IllegalArgumentException("Parameter must be an instance of BorderLayout.");
        }
        super.setLayout(layout);
        this.layout = layout;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isVisible() && visible) {
            this.selectedButton = null;
        }
        super.setVisible(visible);
    }

    protected void validateState() {
        if (this.bar == null) {
            throw new IllegalComponentStateException("Navigation bar doesn't exist");
        }
    }

    protected void windowActivated() {
    }

    protected void windowAdded() {
    }
}

