/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.preference.UserPreferences;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.event.WidgetActionEvent;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DialogWindow
extends JDialog {
    public static final boolean IS_MODAL = true;
    private static final String SIZE_PREFERENCE_PREFIX = "dialogWindow.";
    private static boolean sizeToPreferences = false;
    private DialogPanel dlgPanel;
    private List listeners;

    public static void disposeConditionally(final Window window, final AWTEvent event) {
        Thread thread = new Thread("DialogWindow Conditional Dispose Thread"){

            @Override
            public void run() {
                DialogWindow dialog;
                String panelName;
                if (event instanceof WidgetActionEvent) {
                    WidgetActionEvent widgetEvent = (WidgetActionEvent)event;
                    widgetEvent.waitWhileProcessing();
                    if (widgetEvent.isDestroyed()) {
                        return;
                    }
                }
                if (sizeToPreferences && window instanceof DialogWindow && (panelName = (dialog = (DialogWindow)window).getDialogPanel().getName()) != null && panelName.length() > 0) {
                    DialogWindow.storeDimensionFromPreferences(panelName, window.getSize());
                }
                window.dispose();
            }
        };
        thread.start();
    }

    protected static Dimension getDimensionFromPreferences(String propertyName) {
        String sizeString;
        Dimension result = null;
        Object obj = UserPreferences.getInstance().getValue(SIZE_PREFERENCE_PREFIX + propertyName);
        if (obj != null && (sizeString = (String)obj).length() > 0) {
            StringTokenizer tok = new StringTokenizer(sizeString, ";");
            result = new Dimension(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
        }
        return result;
    }

    public static DialogWindow getInstance(Component parent, String title, Component content) {
        Window owner = null;
        if (parent instanceof Window) {
            owner = (Window)parent;
        } else if (parent != null) {
            owner = SwingUtilities.windowForComponent(parent);
        }
        DialogPanel panel = content instanceof DialogPanel ? (DialogPanel)content : new DialogPanel(content);
        if (owner == null || owner instanceof Frame) {
            return new DialogWindow((Frame)owner, title, panel);
        }
        if (owner instanceof Dialog) {
            return new DialogWindow((Dialog)owner, title, panel);
        }
        throw new IllegalArgumentException("Parent parameter must be within a Dialog (" + Dialog.class + ") or Frame (" + Frame.class + ")");
    }

    public static void setSizeToPreferences(boolean flag) {
        sizeToPreferences = flag;
    }

    public static DialogPanel show(DialogWindow dialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setSize(Math.min(dialog.getWidth(), screenSize.width), Math.min(dialog.getHeight(), screenSize.height));
        dialog.setLocationRelativeTo(dialog.getOwner());
        dialog.setVisible(true);
        return dialog.getDialogPanel();
    }

    public static DialogPanel show(Component parent, String title, Component content) {
        return DialogWindow.show(DialogWindow.getInstance(parent, title, content));
    }

    protected static void storeDimensionFromPreferences(String propertyName, Dimension size) {
        String key = SIZE_PREFERENCE_PREFIX + propertyName;
        String value = new Integer(size.width).toString() + ';' + new Integer(size.height).toString();
        UserPreferences.getInstance().setValue(key, value);
        UserPreferences.getInstance().saveChanges();
    }

    public DialogWindow(Frame owner, String title, DialogPanel panel) {
        this(owner, title, panel, true);
    }

    public DialogWindow(Dialog owner, String title, DialogPanel panel) {
        this(owner, title, panel, true);
    }

    public DialogWindow(Frame owner, String title, DialogPanel panel, boolean isModal) {
        super(owner, title, isModal);
        this.dlgPanel = panel;
        this.initializeDialogWindow();
    }

    public DialogWindow(Dialog owner, String title, DialogPanel panel, boolean isModal) {
        super(owner, title, isModal);
        this.dlgPanel = panel;
        this.initializeDialogWindow();
    }

    protected void accept(ActionEvent event) {
        ButtonWidget button = (ButtonWidget)event.getSource();
        ActionListener selectionListener = this.dlgPanel.getSelectionListener();
        EventListener[] actionListeners = button.getListeners(ActionListener.class);
        if (actionListeners[0] != selectionListener) {
            selectionListener.actionPerformed(event);
        }
        this.dlgPanel.accept((WidgetActionEvent)event);
        if (this.dlgPanel.canAccept()) {
            DialogWindow.disposeConditionally(this, event);
            this.unregisterListeners();
        }
    }

    protected void cancel(AWTEvent event) {
        this.dlgPanel.cancel((WidgetActionEvent)event);
        if (this.dlgPanel.canCancel()) {
            DialogWindow.disposeConditionally(this, event);
            this.unregisterListeners();
        }
    }

    public DialogPanel getDialogPanel() {
        return this.dlgPanel;
    }

    protected void initializeDialogWindow() {
        this.listeners = new ArrayList(2);
        this.getContentPane().add((Component)this.dlgPanel, "Center");
        ActionListener acceptListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DialogWindow.this.accept(event);
            }
        };
        Iterator iter = this.dlgPanel.getAcceptButtons().iterator();
        while (iter.hasNext()) {
            ((ButtonWidget)iter.next()).addActionListener(acceptListener);
        }
        this.listeners.add(acceptListener);
        ButtonWidget cancelButton = this.dlgPanel.getCancelButton();
        if (cancelButton != null) {
            ActionListener cancelListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DialogWindow.this.cancel(event);
                }
            };
            this.listeners.add(cancelListener);
            cancelButton.addActionListener(cancelListener);
        }
        this.getRootPane().setDefaultButton(this.dlgPanel.getAcceptButton());
        if (sizeToPreferences) {
            Dimension size = DialogWindow.getDimensionFromPreferences(this.dlgPanel.getName());
            if (size != null) {
                Dimension preferredSize = this.getPreferredSize();
                this.setSize(new Dimension(Math.max(size.width, preferredSize.width), Math.max(size.height, preferredSize.height)));
            } else {
                this.pack();
            }
        } else {
            this.pack();
        }
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201) {
            WidgetActionEvent actionEvent = new WidgetActionEvent(event.getSource(), null);
            this.cancel(actionEvent);
            if (actionEvent.isDestroyed() || !this.dlgPanel.canCancel()) {
                return;
            }
        }
        super.processWindowEvent(event);
    }

    protected void unregisterListeners() {
        if (!this.listeners.isEmpty()) {
            ButtonWidget cancelButton;
            ActionListener listener = (ActionListener)this.listeners.get(0);
            Iterator iter = this.dlgPanel.getAcceptButtons().iterator();
            while (iter.hasNext()) {
                ((ButtonWidget)iter.next()).removeActionListener(listener);
            }
            if (this.listeners.size() > 0 && (cancelButton = this.dlgPanel.getCancelButton()) != null) {
                cancelButton.removeActionListener((ActionListener)this.listeners.get(1));
            }
            this.listeners.clear();
        }
    }
}

