/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.PassThroughTreeNodeFilter;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeFilter;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryEditor;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.PassThroughDirectoryEntryFilter;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.ComboButtonWidget;
import com.metamatrix.toolbox.ui.widget.ComboData;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DirectoryEntryTable;
import com.metamatrix.toolbox.ui.widget.FilterComboBoxRenderer;
import com.metamatrix.toolbox.ui.widget.IconComboRenderer;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.PropertiedObjectArrayTable;
import com.metamatrix.toolbox.ui.widget.TableViewport;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.button.ButtonBorderPainter;
import com.metamatrix.toolbox.ui.widget.event.WidgetActionEvent;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.util.FileResourceConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class DirectoryChooserPanel
extends DialogPanel {
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    public static final int TYPE_OPEN = 0;
    public static final int TYPE_SAVE = 1;
    private int panelType = -1;
    private boolean showingTable = true;
    private boolean showNewFolderButton = true;
    private boolean showFilterComboBox = true;
    private boolean showDetailsButton = false;
    private boolean allowFolderCreation = true;
    protected boolean multiSelectionAllowed = false;
    private boolean filenameSelectionAllowed = true;
    private JPanel panel;
    protected JPanel bottomDetailsPanel;
    protected JPanel topButtonsPanel;
    protected JPanel topDetailsPanel;
    private JComboBox folderComboBox;
    protected JComboBox filterComboBox;
    private TextFieldWidget filenameTextField;
    private DirectoryEntryTable table;
    protected String INVALID_FILENAME_MSG = "Invalid name. Could not create entry.";
    protected String PROTECTED_PARENT_MSG = "Cannot create in this folder.";
    private JList list;
    private JScrollPane centralPanel;
    private ButtonWidget upButton;
    private ButtonWidget newFolderButton;
    private ButtonWidget detailsButton;
    private JPanel fileNamePanel;
    protected DirectoryEntryFilter selectedFilter = null;
    protected PassThroughDirectoryEntryFilter passThruDirectoryEntryFilter;
    private DirectoryEntryFilter[] chooserFilters = null;
    protected DirectoryEntryView directoryEntryView;
    protected DirectoryEntry selectedDirectoryEntry;
    protected DirectoryEntry existingDirectoryEntry;
    protected DirectoryEntry homeDirectoryEntry;
    protected DirectoryEntry parentDirectoryEntry;
    private DirectoryEntryEditor treeNodeEditor;
    private LabelWidget fileTypeLabel = null;
    private Collection rootsList;
    private Collection propertiesToShow = Collections.EMPTY_LIST;
    private Collection rootsToShow = Collections.EMPTY_LIST;
    private Collection selectedDirectoryEntries = Collections.EMPTY_LIST;
    private boolean acceptsFolders;
    private boolean tmpModelerOverride;
    private TableCellRenderer tableCellRenderer;
    private ListCellRenderer listCellRenderer;
    private MouseListener tableMouseListener;
    private MouseListener listMouseListener;
    private ListSelectionListener tableSelectionListener;
    private boolean nameFldUpdating;

    public DirectoryChooserPanel(DirectoryEntryView directoryEntryView, int type, DirectoryEntryFilter[] filters, Collection propertiesToShow, Collection rootsToShow) {
        this.directoryEntryView = directoryEntryView;
        this.propertiesToShow = propertiesToShow;
        this.rootsToShow = rootsToShow;
        this.rootsList = this.getRootsToUse();
        this.homeDirectoryEntry = (DirectoryEntry)directoryEntryView.getHome();
        directoryEntryView.getPropertyDefinitions().size();
        this.treeNodeEditor = directoryEntryView.getDirectoryEntryEditor();
        this.chooserFilters = filters;
        this.panelType = type;
        if (this.panelType == 0) {
            this.getAcceptButton().setText("Open");
        } else {
            this.getAcceptButton().setText("Save");
        }
        this.setAcceptButtonEnabled(false);
        this.createComponent();
        this.setContent(this.panel);
        this.getAcceptButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!(event instanceof WidgetActionEvent)) {
                    return;
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                DirectoryChooserPanel.this.panel.removeComponentListener(this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DirectoryChooserPanel.this.filenameTextField.isEnabled()) {
                            DirectoryChooserPanel.this.filenameTextField.requestFocus();
                        } else {
                            DirectoryChooserPanel.this.filenameTextField.requestFocus();
                        }
                    }
                });
            }
        });
    }

    public DirectoryChooserPanel(DirectoryEntryView directoryEntryView, int type) {
        this(directoryEntryView, type, null, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public DirectoryChooserPanel(DirectoryEntryView directoryEntryView, int type, DirectoryEntryFilter[] filters) {
        this(directoryEntryView, type, filters, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public DirectoryChooserPanel(DirectoryEntryView directoryEntryView, int type, DirectoryEntryFilter[] filters, Collection propertiesToShow) {
        this(directoryEntryView, type, filters, propertiesToShow, Collections.EMPTY_LIST);
    }

    protected void activateAcceptButton() {
        this.getAcceptButton().doClick();
    }

    protected void setAcceptButtonEnabled(boolean enabled) {
        this.getAcceptButton().setEnabled(enabled);
    }

    protected void updateAcceptButton() {
        if (this.panelType == 0) {
            List<Object> selections = this.showingTable ? this.table.getSelectedObjects() : Arrays.asList(this.list.getSelectedValues());
            Iterator iter = selections.iterator();
            while (iter.hasNext()) {
                DirectoryEntry deTemp = null;
                Object oEntry = iter.next();
                deTemp = oEntry instanceof ComboData ? ((ComboData)oEntry).getDirectoryEntry() : (DirectoryEntry)oEntry;
                if (!this.acceptsFolders && deTemp.getType() != FileSystemEntry.TYPE_FILE) continue;
                this.setAcceptButtonEnabled(true);
                return;
            }
            if (!this.acceptsFolders) {
                this.setAcceptButtonEnabled(false);
                if (this.showingTable) {
                    this.setAcceptButtonEnabled(this.table.getSelectedRowCount() > 0);
                } else {
                    this.setAcceptButtonEnabled(!this.list.isSelectionEmpty());
                }
            }
        } else {
            String name = this.getNameFieldText();
            this.setAcceptButtonEnabled(name != null && name.length() > 0);
        }
    }

    public void setTemporaryModelerOverride() {
        this.tmpModelerOverride = true;
    }

    protected boolean accept() {
        boolean result = false;
        boolean filenameEmpty = false;
        String fileName = this.filenameTextField.getText();
        if (fileName == null || fileName.trim().length() == 0) {
            filenameEmpty = true;
        } else if (this.filenameAlreadyExists(fileName = fileName.trim())) {
            this.selectedDirectoryEntry = this.existingDirectoryEntry;
        }
        if (!this.acceptsFolders && this.selectedDirectoryEntry != null && this.directoryEntryView.allowsChildren((TreeNode)this.selectedDirectoryEntry)) {
            this.parentDirectoryEntry = this.selectedDirectoryEntry;
            this.selectedDirectoryEntry = null;
            this.expand();
        } else if (this.panelType == 1 && !filenameEmpty) {
            result = this.save();
        } else if (this.panelType == 0 && !filenameEmpty) {
            result = this.open();
        }
        super.setCanAccept(result);
        return result;
    }

    public boolean acceptsFolders() {
        return this.acceptsFolders;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    private void changeView() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DirectoryChooserPanel.this.changeView();
                }
            });
            return;
        }
        this.changeView2();
    }

    protected void changeView2() {
        this.createTable();
        this.createList();
        if (this.showingTable) {
            this.centralPanel.setViewportView(this.table);
        } else {
            this.centralPanel.setViewportView(this.list);
        }
        this.updateAcceptButton();
        this.revalidate();
        this.repaint();
    }

    protected void createComponent() {
        this.parentDirectoryEntry = this.homeDirectoryEntry;
        UIDefaults dflts = UIDefaults.getInstance();
        Icon newOnIcon = dflts.getIcon("FileChooser.newFolderIcon");
        final Icon listButtonIcon = dflts.getIcon("FileChooser.listViewIcon");
        final Icon detailsButtonIcon = dflts.getIcon("FileChooser.detailsViewIcon");
        Border border5 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setBorder(border5);
        this.topDetailsPanel = new JPanel();
        this.topDetailsPanel.setLayout(new BoxLayout(this.topDetailsPanel, 1));
        this.topDetailsPanel.setAlignmentX(0.5f);
        this.panel.add(this.topDetailsPanel);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.setBorder(border5);
        LabelWidget lookInLabel = new LabelWidget();
        if (this.panelType == 0) {
            lookInLabel.setText("Look In: ");
        } else {
            lookInLabel.setText("Save In: ");
        }
        lookInLabel.setBorder(border5);
        this.folderComboBox = new JComboBox();
        this.folderComboBox.setRenderer(new IconComboRenderer());
        this.populateFolderComboBox();
        this.upButton = new ButtonWidget();
        this.upButton.setIcon(new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.translate(x, y);
                if (c.isEnabled()) {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                } else {
                    g.setColor(new Color(153, 153, 153));
                }
                g.fillRect(3, 5, 12, 9);
                g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
                g.drawLine(1, 6, 1, 14);
                g.drawLine(2, 14, 15, 14);
                g.drawLine(15, 13, 15, 5);
                g.drawLine(2, 5, 9, 5);
                g.drawLine(10, 6, 14, 6);
                if (!c.isEnabled()) {
                    g.setColor(new Color(102, 102, 102));
                }
                g.drawLine(8, 13, 8, 16);
                g.drawLine(8, 9, 8, 9);
                g.drawLine(7, 10, 9, 10);
                g.drawLine(6, 11, 10, 11);
                g.drawLine(5, 12, 11, 12);
                g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                g.drawLine(2, 6, 2, 13);
                g.drawLine(3, 6, 9, 6);
                g.drawLine(10, 7, 14, 7);
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                g.drawLine(11, 3, 15, 3);
                g.drawLine(10, 4, 15, 4);
                g.translate(-x, -y);
            }

            @Override
            public int getIconWidth() {
                return 18;
            }

            @Override
            public int getIconHeight() {
                return 18;
            }
        });
        if (((ComboData)this.folderComboBox.getSelectedItem()).isRoot()) {
            this.upButton.setEnabled(false);
        } else {
            this.upButton.setEnabled(true);
        }
        this.upButton.setToolTipText("Up one level");
        this.upButton.setBorderPainted(false);
        this.upButton.setFocusPainted(false);
        ButtonBorderPainter.registerButton(this.upButton);
        this.newFolderButton = new ButtonWidget();
        this.newFolderButton.setIcon(newOnIcon);
        this.newFolderButton.setBorderPainted(false);
        this.newFolderButton.setToolTipText("Create new folder");
        this.newFolderButton.setFocusPainted(false);
        if (this.allowFolderCreation) {
            this.newFolderButton.setEnabled(true);
        } else {
            this.newFolderButton.setEnabled(false);
        }
        ButtonBorderPainter.registerButton(this.newFolderButton);
        JToolBar topToolBar = new JToolBar();
        topToolBar.setFloatable(false);
        topToolBar.setBorderPainted(false);
        topToolBar.addSeparator();
        topToolBar.add(this.upButton);
        topToolBar.addSeparator();
        if (this.showNewFolderButton) {
            topToolBar.add(this.newFolderButton);
            topToolBar.addSeparator();
        }
        final ComboButtonWidget detailsComboButtonWidget = new ComboButtonWidget(new String[]{"List view", "Details view"});
        detailsComboButtonWidget.setCycleButtonToolTipText("Cycle views");
        detailsComboButtonWidget.setCycleButtonIcon(detailsButtonIcon);
        detailsComboButtonWidget.setPopupListButtonToolTipText("Display views");
        detailsComboButtonWidget.setVisible(true);
        topToolBar.add(detailsComboButtonWidget);
        topPanel.add(lookInLabel);
        topPanel.add(this.folderComboBox);
        topPanel.add(topToolBar);
        this.panel.add(topPanel);
        this.table = new DirectoryEntryTable(this.directoryEntryView);
        this.table.setTableArray(this.parentDirectoryEntry);
        this.centralPanel = new JScrollPane();
        this.centralPanel.setViewport(new TableViewport());
        this.centralPanel.getViewport().setBackground(this.table.getBackground());
        this.panel.add(this.centralPanel);
        this.fileNamePanel = new JPanel();
        this.fileNamePanel.setLayout(new BoxLayout(this.fileNamePanel, 0));
        LabelWidget fileNameLabel = new LabelWidget("Name: ");
        fileNameLabel.setBorder(border5);
        this.fileNamePanel.add(fileNameLabel);
        this.filenameTextField = new TextFieldWidget(){

            @Override
            public void setText(String text) {
                if (DirectoryChooserPanel.this.nameFldUpdating) {
                    return;
                }
                super.setText(text);
            }
        };
        this.filenameTextField.setRequestFocusEnabled(true);
        this.filenameTextField.setEditable(true);
        this.filenameTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ButtonWidget button = DirectoryChooserPanel.this.getAcceptButton();
                if (button.isEnabled()) {
                    DirectoryChooserPanel.this.activateAcceptButton();
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.fileNamePanel.add(this.filenameTextField);
        JPanel fileTypePanel = new JPanel();
        fileTypePanel.setLayout(new BoxLayout(fileTypePanel, 0));
        this.fileTypeLabel = new LabelWidget("Type: ");
        this.fileTypeLabel.setBorder(border5);
        fileTypePanel.add(this.fileTypeLabel);
        this.filterComboBox = new JComboBox();
        this.filterComboBox.setEditable(false);
        this.filterComboBox.setRenderer(new FilterComboBoxRenderer());
        if (this.chooserFilters != null) {
            for (int i = 0; i < this.chooserFilters.length; ++i) {
                this.filterComboBox.addItem(this.chooserFilters[i]);
            }
        }
        this.passThruDirectoryEntryFilter = new PassThroughDirectoryEntryFilter();
        this.filterComboBox.addItem(this.passThruDirectoryEntryFilter);
        this.filterComboBox.setSelectedIndex(0);
        this.selectedFilter = (DirectoryEntryFilter)this.filterComboBox.getItemAt(0);
        this.directoryEntryView.setFilter((TreeNodeFilter)this.selectedFilter);
        fileTypePanel.add(this.filterComboBox);
        JPanel filesPanel = new JPanel();
        filesPanel.setLayout(new BoxLayout(filesPanel, 1));
        filesPanel.setBorder(border5);
        filesPanel.add(this.fileNamePanel);
        filesPanel.add(Box.createVerticalStrut(10));
        if (this.showFilterComboBox) {
            filesPanel.add(fileTypePanel);
        }
        this.detailsButton = new ButtonWidget("Details");
        this.detailsButton.setPreferredSize(this.getAcceptButton().getPreferredSize());
        this.detailsButton.setEnabled(false);
        this.topButtonsPanel = new JPanel();
        this.topButtonsPanel.setLayout(new BoxLayout(this.topButtonsPanel, 0));
        this.topButtonsPanel.setBorder(border5);
        this.populateTopButtonsPanel();
        JPanel bottomButtonsPanel = new JPanel();
        bottomButtonsPanel.setLayout(new BoxLayout(bottomButtonsPanel, 0));
        bottomButtonsPanel.setBorder(border5);
        if (this.showDetailsButton) {
            bottomButtonsPanel.add(this.detailsButton);
        }
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 1));
        buttonsPanel.add(this.topButtonsPanel);
        buttonsPanel.add(bottomButtonsPanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.setBorder(border5);
        bottomPanel.add(filesPanel);
        bottomPanel.add(buttonsPanel);
        this.panel.add(bottomPanel);
        this.bottomDetailsPanel = new JPanel();
        this.bottomDetailsPanel.setLayout(new BoxLayout(this.bottomDetailsPanel, 1));
        this.bottomDetailsPanel.setAlignmentX(0.5f);
        this.panel.add(this.bottomDetailsPanel);
        this.newFolderButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bHaveRefreshed = false;
                String fullMessage = "Current Folder: " + DirectoryChooserPanel.this.parentDirectoryEntry.getFullName();
                if (DirectoryChooserPanel.this.treeNodeEditor.isReadOnly((PropertiedObject)DirectoryChooserPanel.this.parentDirectoryEntry)) {
                    JOptionPane.showMessageDialog(DirectoryChooserPanel.this, fullMessage + " is read-only", "Read-Only Error", 0);
                } else {
                    String newNodeName = JOptionPane.showInputDialog(DirectoryChooserPanel.this, fullMessage, "New Folder", 1);
                    if (newNodeName != null) {
                        if ((newNodeName = newNodeName.trim()).length() > 0) {
                            DirectoryEntryEditor editor = DirectoryChooserPanel.this.directoryEntryView.getDirectoryEntryEditor();
                            UserTransaction xaction = editor.createWriteTransaction((Object)DirectoryChooserPanel.this);
                            boolean wasErr = true;
                            try {
                                xaction.begin();
                                editor.create((TreeNode)DirectoryChooserPanel.this.parentDirectoryEntry, newNodeName, (ObjectDefinition)DirectoryEntry.TYPE_FOLDER);
                                xaction.commit();
                                wasErr = false;
                            }
                            catch (TransactionException err) {
                                JOptionPane.showMessageDialog(DirectoryChooserPanel.this, "Could not create entry " + newNodeName, "Creation Error", 0);
                            }
                            finally {
                                try {
                                    if (wasErr) {
                                        xaction.rollback();
                                    } else {
                                        DirectoryChooserPanel.this.changeView();
                                        bHaveRefreshed = true;
                                        TableModel tmModel = DirectoryChooserPanel.this.table.getModel();
                                        int iNewFoldersRow = -1;
                                        int iRowCount = tmModel.getRowCount();
                                        for (int iRow = 0; iRow < iRowCount; ++iRow) {
                                            FileSystemEntry fse = (FileSystemEntry)tmModel.getValueAt(iRow, 0);
                                            String sTempName = fse.getName();
                                            if (!sTempName.trim().equals(newNodeName.trim())) continue;
                                            iNewFoldersRow = iRow;
                                            break;
                                        }
                                        if (iNewFoldersRow > -1) {
                                            int iCorrectedRow = DirectoryChooserPanel.this.table.convertRowIndexToView(iNewFoldersRow);
                                            DirectoryChooserPanel.this.table.setRowSelectionInterval(iCorrectedRow, iCorrectedRow);
                                            int iY = iCorrectedRow * DirectoryChooserPanel.this.table.getRowHeight();
                                            int iH = 3 * DirectoryChooserPanel.this.table.getRowHeight();
                                            DirectoryChooserPanel.this.table.scrollRectToVisible(new Rectangle(0, iY, 10, iH));
                                        }
                                    }
                                }
                                catch (TransactionException err) {
                                    JOptionPane.showMessageDialog(DirectoryChooserPanel.this, "Could not rollback creation of entry " + newNodeName, "Rollback Error", 0);
                                }
                            }
                        }
                        if (!bHaveRefreshed) {
                            DirectoryChooserPanel.this.changeView();
                        }
                    }
                }
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryChooserPanel.this.folderComboBox.setSelectedIndex(DirectoryChooserPanel.this.folderComboBox.getSelectedIndex() - 1);
            }
        });
        detailsComboButtonWidget.getChoiceMenuItem("List view").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryChooserPanel.this.centralPanel.setColumnHeaderView(null);
                DirectoryChooserPanel.this.centralPanel.setViewportView(DirectoryChooserPanel.this.list);
                detailsComboButtonWidget.setCycleButtonIcon(listButtonIcon);
                DirectoryChooserPanel.this.showingTable = false;
            }
        });
        detailsComboButtonWidget.getChoiceMenuItem("Details view").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryChooserPanel.this.centralPanel.setViewportView(DirectoryChooserPanel.this.table);
                detailsComboButtonWidget.setCycleButtonIcon(detailsButtonIcon);
                DirectoryChooserPanel.this.showingTable = true;
            }
        });
        this.folderComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = DirectoryChooserPanel.this.folderComboBox.getSelectedIndex();
                DirectoryChooserPanel.this.parentDirectoryEntry = ((ComboData)DirectoryChooserPanel.this.folderComboBox.getSelectedItem()).getDirectoryEntry();
                if (!DirectoryChooserPanel.this.acceptsFolders) {
                    DirectoryChooserPanel.this.selectedDirectoryEntry = null;
                } else {
                    DirectoryChooserPanel.this.selectedDirectoryEntry = DirectoryChooserPanel.this.parentDirectoryEntry;
                    LogManager.logDetail((String)"WORKSPACE", (Object[])new Object[]{"[DirectoryChooserPanel.folderComboBox.actionPerformed] About to mod selectedDirectoryEntries: " + DirectoryChooserPanel.this.selectedDirectoryEntry});
                    DirectoryChooserPanel.this.selectedDirectoryEntries = Arrays.asList(DirectoryChooserPanel.this.selectedDirectoryEntry);
                    DirectoryChooserPanel.this.setNameFieldValueToParentName(DirectoryChooserPanel.this.parentDirectoryEntry);
                }
                DirectoryChooserPanel.this.changeView();
                if (((ComboData)DirectoryChooserPanel.this.folderComboBox.getSelectedItem()).isRoot()) {
                    DirectoryChooserPanel.this.upButton.setEnabled(false);
                } else {
                    DirectoryChooserPanel.this.upButton.setEnabled(true);
                }
                int selectedIndex = DirectoryChooserPanel.this.folderComboBox.getSelectedIndex();
                for (int i = index + 1; i < DirectoryChooserPanel.this.folderComboBox.getItemCount(); ++i) {
                    if (i <= selectedIndex || ((ComboData)DirectoryChooserPanel.this.folderComboBox.getItemAt(i)).isRoot()) continue;
                    DirectoryChooserPanel.this.folderComboBox.removeItemAt(i);
                    --i;
                }
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window parentWindow = DirectoryChooserPanel.this.getWindowAncestor();
                parentWindow.dispose();
            }
        });
        this.filterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryChooserPanel.this.selectedFilter = (DirectoryEntryFilter)DirectoryChooserPanel.this.filterComboBox.getSelectedItem();
                DirectoryChooserPanel.this.directoryEntryView.setFilter((TreeNodeFilter)DirectoryChooserPanel.this.selectedFilter);
                DirectoryChooserPanel.this.changeView();
            }
        });
        this.detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window parentWindow = DirectoryChooserPanel.this.getWindowAncestor();
                if (parentWindow != null) {
                    int currentWidth = parentWindow.getSize().width;
                    int currentHeight = parentWindow.getSize().height;
                    if (DirectoryChooserPanel.this.bottomDetailsPanel.isVisible()) {
                        parentWindow.setSize(new Dimension(currentWidth, currentHeight - 200));
                    } else {
                        parentWindow.setSize(new Dimension(currentWidth, currentHeight + 200));
                    }
                }
            }
        });
        this.filenameTextField.getDocument().addDocumentListener(new DocumentListener(){
            boolean wasEmpty = true;
            boolean textMatchedSelection;

            @Override
            public void changedUpdate(DocumentEvent event) {
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                if (this.wasEmpty) {
                    DirectoryChooserPanel.this.fireChangeEvent();
                    this.wasEmpty = false;
                }
                this.textMatchedSelection = false;
                this.update();
                if (this.textMatchedSelection) {
                    if (DirectoryChooserPanel.this.showingTable) {
                        if (DirectoryChooserPanel.this.table.getSelectedRowCount() == 1) {
                            DirectoryChooserPanel.this.table.scrollRectToVisible(DirectoryChooserPanel.this.table.getCellRect(DirectoryChooserPanel.this.table.getSelectedRow(), 0, true));
                        }
                    } else if (DirectoryChooserPanel.this.list.getSelectedValues().length == 1) {
                        DirectoryChooserPanel.this.list.ensureIndexIsVisible(DirectoryChooserPanel.this.list.getSelectedIndex());
                    }
                }
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                if (event.getDocument().getLength() == 0) {
                    DirectoryChooserPanel.this.fireChangeEvent();
                    this.wasEmpty = true;
                }
                this.update();
            }

            private void update() {
                if (DirectoryChooserPanel.this.panelType == 0) {
                    int tableRow;
                    int row;
                    DirectoryChooserPanel.this.nameFldUpdating = true;
                    ArrayList<Object> selections = DirectoryChooserPanel.this.showingTable ? DirectoryChooserPanel.this.table.getSelectedObjects() : new ArrayList<Object>(Arrays.asList(DirectoryChooserPanel.this.list.getSelectedValues()));
                    String text = DirectoryChooserPanel.this.filenameTextField.getText().trim();
                    List children = DirectoryChooserPanel.this.directoryEntryView.getChildren((TreeNode)DirectoryChooserPanel.this.getParentDirectoryEntry());
                    DirectoryEntryFilter filter = DirectoryChooserPanel.this.getSelectedFilter();
                    StringTokenizer textIter = new StringTokenizer(text, ";");
                    block0: while (textIter.hasMoreTokens()) {
                        String name = textIter.nextToken().trim();
                        Iterator entryIter = children.iterator();
                        row = 0;
                        while (entryIter.hasNext()) {
                            DirectoryEntry entry = (DirectoryEntry)entryIter.next();
                            String entryName = entry.getName();
                            boolean match = entryName.equalsIgnoreCase(name);
                            int ndx = filter.getExtensionCount();
                            while (!match && --ndx >= 0) {
                                match = entryName.equalsIgnoreCase(name + '.' + filter.getExtension(ndx));
                            }
                            if (match) {
                                this.textMatchedSelection = true;
                                if (selections.contains(entry)) {
                                    selections.remove(entry);
                                    continue block0;
                                }
                                if (DirectoryChooserPanel.this.showingTable) {
                                    tableRow = DirectoryChooserPanel.this.table.convertRowIndexToView(row);
                                    DirectoryChooserPanel.this.table.addRowSelectionInterval(tableRow, tableRow);
                                    DirectoryChooserPanel.this.selectTableRow(false);
                                    continue block0;
                                }
                                DirectoryChooserPanel.this.list.addSelectionInterval(row, row);
                                DirectoryChooserPanel.this.selectListRow(false);
                                continue block0;
                            }
                            ++row;
                        }
                    }
                    Iterator entryIter = children.iterator();
                    row = 0;
                    while (entryIter.hasNext()) {
                        if (selections.contains(entryIter.next())) {
                            if (DirectoryChooserPanel.this.showingTable) {
                                tableRow = DirectoryChooserPanel.this.table.convertRowIndexToView(row);
                                DirectoryChooserPanel.this.table.removeRowSelectionInterval(tableRow, tableRow);
                                DirectoryChooserPanel.this.selectTableRow(false);
                            } else {
                                DirectoryChooserPanel.this.list.removeSelectionInterval(row, row);
                                DirectoryChooserPanel.this.selectListRow(false);
                            }
                        }
                        ++row;
                    }
                    DirectoryChooserPanel.this.nameFldUpdating = false;
                }
                DirectoryChooserPanel.this.updateAcceptButton();
            }
        });
        this.centralPanel.setViewportView(this.table);
        detailsComboButtonWidget.setSelectedChoice("Details view");
        this.changeView();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getPreferredSize().width) / 2, (screen.height - this.getPreferredSize().height) / 2);
    }

    protected void setNameFieldValueToParentName(DirectoryEntry parentDirectoryEntry) {
        DirectoryEntryEditor editor = this.directoryEntryView.getDirectoryEntryEditor();
        if (editor.isReadOnly((PropertiedObject)parentDirectoryEntry)) {
            this.filenameTextField.setText(null);
            this.filenameTextField.setEditable(false);
        } else {
            this.filenameTextField.setText(parentDirectoryEntry.getName());
            this.filenameTextField.setEditable(true);
        }
    }

    private void createList() {
        boolean usingIconComboRenderer;
        this.list = new JList();
        this.list.setVisibleRowCount(100);
        if (this.listCellRenderer == null) {
            this.list.setCellRenderer(new IconComboRenderer());
            usingIconComboRenderer = true;
        } else {
            this.list.setCellRenderer(this.listCellRenderer);
            usingIconComboRenderer = false;
        }
        Object[] treeNodes = new DirectoryEntry[this.directoryEntryView.getChildren((TreeNode)this.parentDirectoryEntry).size()];
        Iterator iter = this.directoryEntryView.getChildren((TreeNode)this.parentDirectoryEntry).iterator();
        int treeDex = 0;
        while (iter.hasNext()) {
            treeNodes[treeDex] = (DirectoryEntry)iter.next();
            ++treeDex;
        }
        treeNodes = this.orderNodes(treeNodes);
        if (usingIconComboRenderer) {
            ComboData[] comboDataList = new ComboData[treeNodes.length];
            for (int i = 0; i < treeNodes.length; ++i) {
                comboDataList[i] = this.directoryEntryView.allowsChildren((TreeNode)treeNodes[i]) ? new ComboData(1, (DirectoryEntry)treeNodes[i]) : new ComboData(1, (DirectoryEntry)treeNodes[i], ComboData.TYPE_LEAF);
            }
            this.list.setListData(comboDataList);
        } else {
            this.list.setListData(treeNodes);
        }
        if (this.multiSelectionAllowed && this.panelType == 0) {
            this.list.getSelectionModel().setSelectionMode(2);
        } else {
            this.list.getSelectionModel().setSelectionMode(0);
        }
        this.listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DirectoryChooserPanel.this.selectListRow(e.getClickCount() >= 2);
            }
        };
        this.list.addMouseListener(this.listMouseListener);
    }

    protected void selectListRow(boolean doubleClicked) {
        LogManager.logDetail((String)"WORKSPACE", (Object[])new Object[]{"[DirectoryChooserPanel.selectListRow] TOP, doubleClicked is: " + doubleClicked});
        int row = this.list.getSelectedIndex();
        if (row == -1) {
            this.selectedDirectoryEntry = null;
            LogManager.logDetail((String)"WORKSPACE", (Object[])new Object[]{"[DirectoryChooserPanel.selectListRow] About to set selectedDirectoryEntries to EMPTY "});
            this.selectedDirectoryEntries = Collections.EMPTY_LIST;
            this.filenameTextField.setText("");
            return;
        }
        DirectoryEntry treeNode = this.list.getSelectedValue() instanceof DirectoryEntry ? (DirectoryEntry)this.list.getSelectedValue() : ((ComboData)this.list.getSelectedValue()).getDirectoryEntry();
        this.selectedDirectoryEntry = treeNode;
        this.selectedDirectoryEntries = Arrays.asList(this.selectedDirectoryEntry);
        String treeNodeName = treeNode.getName();
        if (this.acceptsFolders || !this.directoryEntryView.allowsChildren((TreeNode)treeNode)) {
            if (doubleClicked && this.directoryEntryView.allowsChildren((TreeNode)treeNode)) {
                this.parentDirectoryEntry = this.selectedDirectoryEntry;
                if (!this.acceptsFolders) {
                    this.selectedDirectoryEntry = null;
                } else if (this.filenameSelectionAllowed) {
                    this.filenameTextField.setText(treeNodeName);
                }
                this.expand();
                return;
            }
            this.detailsButton.setEnabled(true);
            if (this.filenameSelectionAllowed) {
                this.filenameTextField.setText(treeNodeName);
            }
            this.updateAcceptButton();
            if (doubleClicked) {
                this.activateAcceptButton();
            }
        } else {
            this.detailsButton.setEnabled(false);
            this.filenameTextField.setText(null);
            if (doubleClicked) {
                this.parentDirectoryEntry = treeNode;
                this.selectedDirectoryEntry = null;
                this.expand();
                this.filenameTextField.setText("");
            } else {
                this.selectedDirectoryEntry = treeNode;
                this.selectedDirectoryEntries = Arrays.asList(this.selectedDirectoryEntry);
            }
        }
    }

    private void createTable() {
        this.table = new DirectoryEntryTable(this.directoryEntryView);
        this.table.setTableArray(this.parentDirectoryEntry, this.propertiesToShow);
        this.table.setAutoResizeMode(4);
        this.table.setShowGrid(false);
        this.table.setSortable(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSortedAscending((EnhancedTableColumn)this.table.getEnhancedColumnModel().getColumn(0));
        this.table.sizeColumnsToFitData(100);
        if (this.tableCellRenderer != null) {
            this.table.getColumnModel().getColumn(0).setCellRenderer(this.tableCellRenderer);
        }
        if (this.multiSelectionAllowed && this.panelType == 0) {
            this.table.getSelectionModel().setSelectionMode(2);
        } else {
            this.table.getSelectionModel().setSelectionMode(0);
        }
        this.tableMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DirectoryChooserPanel.this.selectTableRow(e.getClickCount() >= 2);
            }
        };
        this.table.addMouseListener(this.tableMouseListener);
        this.tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                int row = DirectoryChooserPanel.this.table.getSelectedRow();
                if (row == -1 || DirectoryChooserPanel.this.table.getRowCount() == 0) {
                    DirectoryChooserPanel.this.selectedDirectoryEntry = null;
                    LogManager.logDetail((String)"WORKSPACE", (Object[])new Object[]{"[DirectoryChooserPanel.tableSelectionListener.valueChanged] About to set selectedDirectoryEntries to EMPTY "});
                    DirectoryChooserPanel.this.selectedDirectoryEntries = Collections.EMPTY_LIST;
                    if (!DirectoryChooserPanel.this.nameFldUpdating) {
                        DirectoryChooserPanel.this.filenameTextField.setText("");
                    }
                    return;
                }
                DirectoryEntry treeNode = (DirectoryEntry)DirectoryChooserPanel.this.table.getSelectedObject();
                Collection treeNodes = DirectoryChooserPanel.this.table.getSelectedObjects();
                if (treeNode != null && (DirectoryChooserPanel.this.acceptsFolders || !DirectoryChooserPanel.this.directoryEntryView.allowsChildren((TreeNode)treeNode))) {
                    String nodeNames = "";
                    Iterator selectedIter = treeNodes.iterator();
                    int semiFlag = 0;
                    while (selectedIter.hasNext()) {
                        DirectoryEntry de = (DirectoryEntry)selectedIter.next();
                        nodeNames = semiFlag == 0 ? nodeNames + de.getName() : nodeNames + "; " + de.getName();
                        ++semiFlag;
                    }
                    LogManager.logDetail((String)"WORKSPACE", (Object[])new Object[]{"[DirectoryChooserPanel.tableSelectionListener.valueChanged] About to set selectedDirectoryEntries to treeNodes " + treeNodes});
                    DirectoryChooserPanel.this.selectedDirectoryEntries = treeNodes;
                    DirectoryChooserPanel.this.selectedDirectoryEntry = treeNode;
                    DirectoryChooserPanel.this.detailsButton.setEnabled(true);
                    if (DirectoryChooserPanel.this.filenameSelectionAllowed) {
                        DirectoryChooserPanel.this.filenameTextField.setText(nodeNames);
                    }
                } else {
                    DirectoryChooserPanel.this.detailsButton.setEnabled(false);
                    if (DirectoryChooserPanel.this.panelType == 0) {
                        DirectoryChooserPanel.this.filenameTextField.setText(null);
                    }
                }
                DirectoryChooserPanel.this.updateAcceptButton();
            }
        };
        this.table.addListSelectionListener(this.tableSelectionListener);
    }

    protected void selectTableRow(boolean doubleClicked) {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            if (!this.nameFldUpdating) {
                this.selectedDirectoryEntry = null;
                LogManager.logDetail((String)"WORKSPACE", (Object[])new Object[]{"[DirectoryChooserPanel.selectTableRow] About to set selectedDirectoryEntries to EMPTY "});
                this.selectedDirectoryEntries = Collections.EMPTY_LIST;
                this.filenameTextField.setText("");
            }
            return;
        }
        DirectoryEntry treeNode = (DirectoryEntry)this.table.getSelectedObject();
        this.updateAcceptButton();
        if (this.acceptsFolders || !this.directoryEntryView.allowsChildren((TreeNode)treeNode)) {
            if (doubleClicked) {
                if (this.directoryEntryView.allowsChildren((TreeNode)treeNode)) {
                    this.parentDirectoryEntry = this.selectedDirectoryEntry;
                    if (!this.acceptsFolders) {
                        this.selectedDirectoryEntry = null;
                    }
                    this.expand();
                } else {
                    this.activateAcceptButton();
                }
            }
        } else if (doubleClicked) {
            this.parentDirectoryEntry = treeNode;
            this.selectedDirectoryEntry = null;
            this.expand();
        } else {
            this.selectedDirectoryEntry = treeNode;
        }
    }

    protected void expand() {
        int index = this.folderComboBox.getSelectedIndex();
        int parentCount = 0;
        if (!this.rootsList.contains(this.parentDirectoryEntry)) {
            parentCount = 1;
            DirectoryEntry tnParent = (DirectoryEntry)this.directoryEntryView.getParent((TreeNode)this.parentDirectoryEntry);
            while (tnParent != null && !this.rootsList.contains(tnParent)) {
                if ((tnParent = (DirectoryEntry)this.directoryEntryView.getParent((TreeNode)tnParent)) == null) continue;
                ++parentCount;
            }
        }
        this.folderComboBox.insertItemAt(new ComboData(parentCount, this.parentDirectoryEntry), index + 1);
        this.folderComboBox.setSelectedIndex(index + 1);
        this.changeView();
    }

    public boolean isFolderComboSelectionARoot() {
        return ((ComboData)this.folderComboBox.getSelectedItem()).isRoot();
    }

    public DirectoryEntry getFolderComboBoxSelection() {
        DirectoryEntry deResult = null;
        deResult = ((ComboData)this.folderComboBox.getSelectedItem()).getDirectoryEntry();
        return deResult;
    }

    protected boolean filenameAlreadyExists(String filename) {
        if (this.acceptsFolders && this.selectedDirectoryEntry != null && this.selectedDirectoryEntry == this.parentDirectoryEntry) {
            this.existingDirectoryEntry = this.selectedDirectoryEntry;
            return true;
        }
        DirectoryEntryView dev = this.directoryEntryView;
        dev.setFilter((TreeNodeFilter)this.passThruDirectoryEntryFilter);
        List childlist = dev.getChildren((TreeNode)this.parentDirectoryEntry);
        for (DirectoryEntry de : childlist) {
            if (!de.getName().toLowerCase().equals(filename.toLowerCase())) continue;
            this.existingDirectoryEntry = de;
            return true;
        }
        return false;
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = null;
        for (int ndx = listeners.length - 2; ndx >= 0; ndx -= 2) {
            if (listeners[ndx] != ChangeListener.class) continue;
            if (event == null) {
                event = new ChangeEvent(this.filenameTextField);
            }
            ((ChangeListener)listeners[ndx + 1]).stateChanged(event);
        }
    }

    protected JComboBox getFolderComboBox() {
        return this.folderComboBox;
    }

    public TreeNode getCurrentRoot() {
        int ndx = this.folderComboBox.getSelectedIndex();
        ComboData node = (ComboData)this.folderComboBox.getItemAt(ndx);
        while (ndx > 0 && !node.isRoot()) {
            node = (ComboData)this.folderComboBox.getItemAt(--ndx);
        }
        return node.getDirectoryEntry();
    }

    public DirectoryEntry getRoot() {
        return this.homeDirectoryEntry;
    }

    private Collection getRootsToUse() {
        List<DirectoryEntry> rootsToUse = new ArrayList();
        List allRootsList = this.directoryEntryView.getRoots();
        if (this.rootsToShow != Collections.EMPTY_LIST && this.rootsToShow != null) {
            for (DirectoryEntry de : allRootsList) {
                if (!this.rootsToShow.contains(de)) continue;
                rootsToUse.add(de);
            }
        } else {
            rootsToUse = allRootsList;
        }
        return rootsToUse;
    }

    public String getNameFieldText() {
        return this.filenameTextField.getText();
    }

    public DirectoryEntry getParentDirectoryEntry() {
        return this.parentDirectoryEntry;
    }

    public TreeNode getSelectedTreeNode() {
        return this.selectedDirectoryEntry;
    }

    public Collection getSelectedTreeNodes() {
        LogManager.logDetail((String)"WORKSPACE", (Object[])new Object[]{"[DirectoryChooserPanel.getSelectedTreeNodes] About to return selectedDirectoryEntries: " + this.selectedDirectoryEntries});
        return this.selectedDirectoryEntries;
    }

    public void setPanelType(int type) {
        this.panelType = type;
        if (this.panelType == 0) {
            this.getAcceptButton().setText("Open");
        } else {
            this.getAcceptButton().setText("Save");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean open() {
        String newFilename = this.filenameTextField.getText();
        if (this.multiSelectionAllowed) {
            return true;
        }
        if (!this.filenameAlreadyExists(newFilename)) {
            DirectoryEntryEditor editor = this.directoryEntryView.getDirectoryEntryEditor();
            int yesNoResult = JOptionPane.showConfirmDialog(this, newFilename + " not found. Create?", newFilename + " not found", 0);
            if (yesNoResult != 0) return false;
            if (editor.isReadOnly((PropertiedObject)this.parentDirectoryEntry)) {
                JOptionPane.showMessageDialog(this, this.PROTECTED_PARENT_MSG, "Read only folder", 0);
                return false;
            }
            if (!editor.isNameValid(newFilename)) {
                JOptionPane.showMessageDialog(this, this.INVALID_FILENAME_MSG, "Invalid Name", 0);
                return false;
            }
            newFilename = this.addFileExtension(newFilename, this.selectedFilter);
            UserTransaction xaction = editor.createWriteTransaction((Object)this);
            boolean wasErr = true;
            try {
                xaction.begin();
                DirectoryEntry de = (DirectoryEntry)editor.create((TreeNode)this.parentDirectoryEntry, newFilename, (ObjectDefinition)DirectoryEntry.TYPE_FILE);
                if (de == null) {
                    JOptionPane.showMessageDialog(this, "Could not create entry " + newFilename, "Creation Error", 0);
                    boolean bl = false;
                    return bl;
                }
                editor.makeExist(de);
                this.selectedDirectoryEntry = de;
                xaction.commit();
                wasErr = false;
                return true;
            }
            catch (TransactionException err) {
                JOptionPane.showMessageDialog(this, "Could not create entry " + newFilename, "Creation Error", 0);
                return true;
            }
            finally {
                try {
                    if (wasErr) {
                        xaction.rollback();
                    }
                }
                catch (TransactionException err) {
                    JOptionPane.showMessageDialog(this, "Could not rollback creation of entry " + newFilename, "Rollback Error", 0);
                }
            }
        }
        this.selectedDirectoryEntry = this.existingDirectoryEntry;
        return true;
    }

    private DirectoryEntry[] orderNodes(Object[] nodeList) {
        Vector<Object> nodes = new Vector<Object>();
        Vector<Object> leaves = new Vector<Object>();
        for (int q = 0; q < nodeList.length; ++q) {
            DirectoryEntry tn = (DirectoryEntry)nodeList[q];
            if (this.directoryEntryView.allowsChildren((TreeNode)tn)) {
                nodes.addElement(nodeList[q]);
                continue;
            }
            leaves.addElement(nodeList[q]);
        }
        nodes.addAll(leaves);
        DirectoryEntry[] orderedNodeList = new DirectoryEntry[nodes.size()];
        for (int k = 0; k < nodes.size(); ++k) {
            orderedNodeList[k] = (DirectoryEntry)nodes.elementAt(k);
        }
        nodeList = orderedNodeList;
        return orderedNodeList;
    }

    private void populateFolderComboBox() {
        Iterator iter = this.rootsList.iterator();
        this.homeDirectoryEntry = (DirectoryEntry)this.directoryEntryView.getHome();
        int folderIndex = -1;
        int folderHomeEntryIndex = 0;
        while (iter.hasNext()) {
            DirectoryEntry de = (DirectoryEntry)iter.next();
            if (this.directoryEntryView.isAncestorOf((TreeNode)de, (TreeNode)this.homeDirectoryEntry)) {
                this.folderComboBox.addItem(new ComboData(0, de, ComboData.TYPE_ROOT));
                ++folderIndex;
                int parentCount = 0;
                if (!this.rootsList.contains(this.homeDirectoryEntry)) {
                    parentCount = 1;
                    DirectoryEntry tnParent = (DirectoryEntry)this.directoryEntryView.getParent((TreeNode)this.homeDirectoryEntry);
                    while (!this.rootsList.contains(tnParent)) {
                        if (this.directoryEntryView.getParent((TreeNode)tnParent) == null) continue;
                        tnParent = (DirectoryEntry)this.directoryEntryView.getParent((TreeNode)tnParent);
                        ++parentCount;
                    }
                }
                this.folderComboBox.addItem(new ComboData(parentCount, this.homeDirectoryEntry, ComboData.TYPE_OTHER));
                int insertIndex = ++folderIndex;
                DirectoryEntry tempDirectoryEntry = (DirectoryEntry)this.directoryEntryView.getParent((TreeNode)this.homeDirectoryEntry);
                for (int i = parentCount - 1; i > 0; --i) {
                    this.folderComboBox.insertItemAt(new ComboData(i, tempDirectoryEntry, ComboData.TYPE_OTHER), insertIndex);
                    tempDirectoryEntry = (DirectoryEntry)this.directoryEntryView.getParent((TreeNode)tempDirectoryEntry);
                    ++folderIndex;
                }
                folderHomeEntryIndex = folderIndex;
                continue;
            }
            this.folderComboBox.addItem(new ComboData(0, de, ComboData.TYPE_ROOT));
            ++folderIndex;
            if (de != this.homeDirectoryEntry) continue;
            folderHomeEntryIndex = folderIndex;
        }
        this.folderComboBox.setSelectedIndex(folderHomeEntryIndex);
    }

    protected void populateTopButtonsPanel() {
        this.topButtonsPanel.add(Box.createHorizontalGlue());
        this.topButtonsPanel.add(this.getNavigationBar());
    }

    protected void reactivateRefresh() {
        this.changeView();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean save() {
        String newFilename = this.filenameTextField.getText();
        DirectoryEntryEditor editor = this.directoryEntryView.getDirectoryEntryEditor();
        if (!editor.isNameValid(newFilename)) {
            JOptionPane.showMessageDialog(this, this.INVALID_FILENAME_MSG, "Invalid Name", 0);
            return false;
        }
        if (!this.filenameAlreadyExists(newFilename = this.addFileExtension(newFilename, this.selectedFilter))) {
            UserTransaction xaction = editor.createWriteTransaction((Object)this);
            boolean wasErr = true;
            try {
                xaction.begin();
                DirectoryEntry de = (DirectoryEntry)editor.create((TreeNode)this.parentDirectoryEntry, newFilename, (ObjectDefinition)DirectoryEntry.TYPE_FILE);
                if (de == null) {
                    JOptionPane.showMessageDialog(this, "Could not create entry " + newFilename, "Creation Error", 0);
                    boolean bl = false;
                    return bl;
                }
                editor.makeExist(de);
                this.selectedDirectoryEntry = de;
                xaction.commit();
                wasErr = false;
                return true;
            }
            catch (TransactionException err) {
                JOptionPane.showMessageDialog(this, "Could not create entry " + newFilename, "Creation Error", 0);
                return true;
            }
            finally {
                try {
                    if (wasErr) {
                        xaction.rollback();
                    }
                }
                catch (TransactionException err) {
                    JOptionPane.showMessageDialog(this, "Could not rollback creation of entry " + newFilename, "Rollback Error", 0);
                }
            }
        }
        if (!this.tmpModelerOverride) {
            int yesNoResult = JOptionPane.showConfirmDialog(this, this.existingDirectoryEntry.getName() + " already exists. Overwrite?", this.existingDirectoryEntry.getName() + " already exists", 0);
            if (yesNoResult != 0) return false;
            if (this.treeNodeEditor.isReadOnly((PropertiedObject)this.existingDirectoryEntry)) {
                JOptionPane.showMessageDialog(this, this.existingDirectoryEntry.getName() + " is read-only", "Read-Only Error", 0);
                return false;
            }
            UserTransaction xaction = editor.createWriteTransaction((Object)this);
            boolean wasErr = true;
            try {
                xaction.begin();
                editor.delete((TreeNode)this.existingDirectoryEntry);
                DirectoryEntry de = (DirectoryEntry)editor.create((TreeNode)this.parentDirectoryEntry, newFilename, (ObjectDefinition)DirectoryEntry.TYPE_FILE);
                if (de == null) {
                    JOptionPane.showMessageDialog(this, "Could not create entry " + newFilename, "Creation Error", 0);
                    boolean bl = false;
                    return bl;
                }
                editor.makeExist(de);
                this.selectedDirectoryEntry = de;
                xaction.commit();
                wasErr = false;
                return true;
            }
            catch (TransactionException err) {
                JOptionPane.showMessageDialog(this, "Could not create entry " + newFilename, "Creation Error", 0);
                return true;
            }
            finally {
                try {
                    if (wasErr) {
                        xaction.rollback();
                    }
                }
                catch (TransactionException err) {
                    JOptionPane.showMessageDialog(this, "Could not rollback creation of entry " + newFilename, "Rollback Error", 0);
                }
            }
        }
        this.selectedDirectoryEntry = this.existingDirectoryEntry;
        return true;
    }

    protected String addFileExtension(String sFileName, DirectoryEntryFilter selectedFilter) {
        if (!(selectedFilter instanceof PassThroughDirectoryEntryFilter)) {
            if (FileResourceConstants.isValidXMIFileExtension(selectedFilter.getExtension(0)) && !FileResourceConstants.hasXMIFileExtension(sFileName)) {
                sFileName = !sFileName.endsWith(".") ? sFileName + "." + selectedFilter.getExtension(0) : sFileName + selectedFilter.getExtension(0);
            } else if (sFileName.indexOf(".") < 0) {
                sFileName = sFileName + "." + selectedFilter.getExtension(0);
            }
        }
        return sFileName;
    }

    public void setAcceptButtonLabel(String s) {
        this.getAcceptButton().setText(s);
    }

    public void setAcceptsFolders(boolean acceptsFolders) {
        this.acceptsFolders = acceptsFolders;
        if (acceptsFolders) {
            this.selectedDirectoryEntry = this.parentDirectoryEntry;
            this.filenameTextField.setText(this.selectedDirectoryEntry.getName());
        }
    }

    public void setAllowFolderCreation(boolean b) {
        this.allowFolderCreation = b;
        this.newFolderButton.setEnabled(b);
    }

    public void setAllowNonFolderCreation(boolean b) {
    }

    public void setCancelButtonLabel(String s) {
        this.getCancelButton().setText(s);
    }

    public void setDetailsButtonLabel(String s) {
        this.detailsButton.setText(s);
    }

    public void setFilenameSelectionAllowed(boolean allowed) {
        this.filenameSelectionAllowed = allowed;
        this.filenameTextField.setEnabled(allowed);
        this.changeView();
    }

    public void setInitialFilename(String name) {
        this.filenameTextField.setText(name);
    }

    public void setFileNameFieldVisible(boolean flag) {
        this.fileNamePanel.setVisible(flag);
    }

    public void setInvalidFilenameMsg(String msg) {
        this.INVALID_FILENAME_MSG = msg;
    }

    public void setMultiSelection(boolean allowed) {
        this.multiSelectionAllowed = allowed;
        this.changeView();
    }

    public void setShowAcceptButton(boolean b) {
        this.getAcceptButton().setVisible(b);
    }

    public void setShowCancelButton(boolean b) {
        this.getCancelButton().setVisible(b);
    }

    public void setShowDetailsButton(boolean b) {
        this.detailsButton.setVisible(b);
    }

    public void setShowFilterComboBox(boolean b) {
        this.fileTypeLabel.setVisible(b);
        this.filterComboBox.setVisible(b);
    }

    public void setShowNewFolderButton(boolean b) {
        this.newFolderButton.setVisible(b);
    }

    public void setShowPassThruFilter(boolean show) {
        boolean passThruFilterExists = false;
        int passThruFilterExistsAt = -1;
        for (int i = 0; i < this.filterComboBox.getItemCount(); ++i) {
            if (!(this.filterComboBox.getItemAt(i) instanceof PassThroughTreeNodeFilter)) continue;
            passThruFilterExists = true;
            passThruFilterExistsAt = i;
        }
        if (show && !passThruFilterExists) {
            this.filterComboBox.addItem(this.passThruDirectoryEntryFilter);
            this.changeView();
        }
        if (!show && passThruFilterExists && this.filterComboBox.getItemCount() > 1) {
            this.filterComboBox.removeItemAt(passThruFilterExistsAt);
            this.filterComboBox.setSelectedIndex(0);
            this.selectedFilter = (DirectoryEntryFilter)this.filterComboBox.getItemAt(0);
            this.directoryEntryView.setFilter((TreeNodeFilter)this.selectedFilter);
            this.changeView();
        }
    }

    public PropertiedObjectArrayTable getTable() {
        return this.table;
    }

    public JList getList() {
        return this.list;
    }

    public void setModelerTableCellRenderer(TableCellRenderer renderer) {
        if (renderer != null && this.table != null) {
            this.tableCellRenderer = renderer;
            if (this.table.getColumnModel().getColumnCount() > 0) {
                this.table.getColumnModel().getColumn(0).setCellRenderer(this.tableCellRenderer);
            }
        }
    }

    public void setModelerListCellRenderer(ListCellRenderer renderer) {
        if (renderer != null && this.list != null) {
            this.listCellRenderer = renderer;
            this.list.setCellRenderer(this.listCellRenderer);
        }
    }

    public DirectoryEntryFilter getSelectedFilter() {
        return this.selectedFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void accept(WidgetActionEvent event) {
        if (event.isProcessing()) {
            return;
        }
        event.setProcessing(true);
        this.setCanAccept(true);
        boolean accepted = false;
        try {
            accepted = this.accept();
        }
        finally {
            if (!accepted) {
                event.destroy();
                this.setCanAccept(false);
            }
            event.setProcessing(false);
        }
    }
}

