/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.toolbox.ui.widget.IconTableCellRenderer;
import com.metamatrix.toolbox.ui.widget.PropertiedObjectArrayTable;
import com.metamatrix.toolbox.ui.widget.table.DirectoryEntryTableComparator;
import com.metamatrix.toolbox.ui.widget.table.TableComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.table.DefaultTableCellRenderer;

public class DirectoryEntryTable
extends PropertiedObjectArrayTable {
    private DirectoryEntryView directoryEntryView;
    private Collection showProperties = Collections.EMPTY_LIST;

    public DirectoryEntryTable(DirectoryEntryView view) {
        this.setPropertiedObjectEditor((PropertiedObjectEditor)view.getDirectoryEntryEditor());
        this.directoryEntryView = view;
    }

    public void setTableArray(DirectoryEntry entry) {
        if (this.directoryEntryView.getChildren((TreeNode)entry).size() == 0 && !this.directoryEntryView.allowsChildren((TreeNode)entry)) {
            ArrayList<DirectoryEntry> fileEntry = new ArrayList<DirectoryEntry>();
            fileEntry.add(entry);
            if (this.showProperties != Collections.EMPTY_LIST) {
                super.setTableArray(fileEntry, this.showProperties);
            } else {
                super.setTableArray(fileEntry);
            }
        } else if (this.showProperties != Collections.EMPTY_LIST) {
            super.setTableArray((Collection)this.directoryEntryView.getChildren((TreeNode)entry), this.showProperties);
        } else {
            super.setTableArray(this.directoryEntryView.getChildren((TreeNode)entry));
        }
    }

    public void setTableArray(DirectoryEntry entry, Collection showProperties) {
        this.showProperties = showProperties;
        this.setTableArray(entry);
    }

    @Override
    protected TableComparator createDefaultComparator() {
        return DirectoryEntryTableComparator.getInstance();
    }

    @Override
    protected DefaultTableCellRenderer getCellRenderer() {
        return new IconTableCellRenderer(this.directoryEntryView);
    }
}

