/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MultipleException;
import com.metamatrix.api.exception.MultipleRuntimeException;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemFilter;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.DirectoryChooserPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorDialog
extends JDialog {
    private static boolean displayLastException = false;
    private final int ERROR_DIALOG_WIDTH = 400;
    private final int ERROR_DIALOG_HEIGHT_H = 150;
    private final int WHOLE_DIALOG_HEIGHT_H = 500;
    private int WHOLE_DIALOG_HEIGHT_W;
    private boolean detailsPressed = false;
    private ButtonWidget detailsButton = new ButtonWidget("Show Details");
    private ButtonWidget okButton = new ButtonWidget("OK");
    private JPanel upperPanel;
    private JPanel outerPanel;
    private JPanel lowerPanel;
    private String detailsText;
    private JPanel buttonPanel;
    private ButtonWidget saveButton = new ButtonWidget("Save Details to File");
    private LabelWidget msgLabel;
    private JTextArea msgArea;
    private JPanel linePanel;
    private JPanel excMsgPanel;
    private GridBagLayout excMsgLayout;
    private int rowCount;
    private LabelWidget detailLabel;
    private JTextArea detailArea;
    private JScrollPane scrollPane;
    private Font font;
    private LabelWidget excepLabel;
    private JComboBox excepField;
    private GridBagLayout lowerPanelLayout;
    private GridBagLayout outerPanelLayout;
    private LabelWidget statementArea;
    private JPanel stateReasonPanel;
    private JTextArea reasonArea;
    private JPanel outterButtonPanel;
    private boolean savesLastFileLoc;
    private List throwables;
    private List throwableNames;

    public static void setDisplayLastException(boolean showLast) {
        displayLastException = showLast;
    }

    public ErrorDialog(Frame owner, String title, String statement, String reason) {
        super(owner, "Error", true);
        this.detailsButton.setEnabled(false);
        this.createComponent(title, statement, reason, null, null, null);
        this.setLocationRelativeTo(owner);
    }

    public ErrorDialog(Frame owner, String title, String statement, String reason, Throwable exception) {
        super(owner, "Error", true);
        this.createComponent(title, statement, reason, exception, null, null);
        this.setLocationRelativeTo(owner);
    }

    public ErrorDialog(Frame owner, String title, String statement, String reason, String detailedMessage, String details) {
        super(owner, "Error", true);
        this.createComponent(title, statement, reason, null, detailedMessage, details);
        this.setLocationRelativeTo(owner);
    }

    public ErrorDialog(Dialog owner, String title, String statement, String reason) {
        super(owner, "Error", true);
        this.detailsButton.setEnabled(false);
        this.createComponent(title, statement, reason, null, null, null);
        this.setLocationRelativeTo(owner);
    }

    public ErrorDialog(Dialog owner, String title, String statement, String reason, Throwable exception) {
        super(owner, "Error", true);
        this.createComponent(title, statement, reason, exception, null, null);
        this.setLocationRelativeTo(owner);
    }

    public ErrorDialog(Dialog owner, String title, String statement, String reason, String detailedMessage, String details) {
        super(owner, "Error", true);
        this.createComponent(title, statement, reason, null, detailedMessage, details);
        this.setLocationRelativeTo(owner);
    }

    private void createComponent(String title, String statement, String reason, Throwable exception, String detailedMessage, String details) {
        this.outerPanel = new JPanel();
        Dimension edDimension = Toolkit.getDefaultToolkit().getScreenSize();
        Double edDimensionW = new Double(edDimension.getWidth() * 3.0 / 4.0);
        this.WHOLE_DIALOG_HEIGHT_W = edDimensionW.intValue();
        this.outerPanelLayout = new GridBagLayout();
        this.outerPanel.setLayout(this.outerPanelLayout);
        this.getContentPane().setLayout(new BorderLayout());
        this.upperPanel = new JPanel();
        this.upperPanel.setLayout(new BoxLayout(this.upperPanel, 1));
        this.lowerPanel = new JPanel();
        this.lowerPanelLayout = new GridBagLayout();
        this.lowerPanel.setLayout(this.lowerPanelLayout);
        this.excMsgPanel = new JPanel();
        this.excMsgLayout = new GridBagLayout();
        this.excMsgPanel.setLayout(this.excMsgLayout);
        this.detailLabel = new LabelWidget("Details");
        this.detailLabel.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        this.detailArea = new JTextArea();
        this.detailArea.setLineWrap(true);
        this.detailArea.setWrapStyleWord(true);
        if (details != null) {
            this.detailArea.setText(ErrorDialog.convertLineFeeds(details));
            this.detailsText = "Exception:\n\t" + title + "\n\t\t" + statement + "\nreason:\n\t" + reason + "\nMessage:\n\t" + detailedMessage + "Details\n\t" + details;
            this.detailsText = ErrorDialog.convertLineFeeds(this.detailsText);
        }
        this.scrollPane = new JScrollPane(this.detailArea);
        this.scrollPane.setPreferredSize(new Dimension(180, 100));
        this.detailArea.setCaretPosition(0);
        if (exception != null) {
            this.throwables = new ArrayList();
            this.throwableNames = new ArrayList();
            Throwable lastException = this.parseThrowable(exception);
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(bas);
            if (displayLastException) {
                lastException.printStackTrace(pw);
            } else {
                exception.printStackTrace(pw);
            }
            pw.close();
            this.detailArea.setText(ErrorDialog.convertLineFeeds(bas.toString()));
            this.excepLabel = new LabelWidget("Error:");
            this.excepField = new JComboBox<Object>(this.throwableNames.toArray());
            this.msgArea = new JTextArea();
            if (displayLastException) {
                this.msgArea.setText(this.parseMessage(lastException.getMessage()));
            } else {
                this.msgArea.setText(this.parseMessage(exception.getMessage()));
            }
            this.excepField.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int ndx = ErrorDialog.this.excepField.getSelectedIndex();
                    if (ndx < 0) {
                        return;
                    }
                    Throwable throwable = (Throwable)ErrorDialog.this.throwables.get(ndx);
                    ErrorDialog.this.msgArea.setText(ErrorDialog.this.parseMessage(throwable.getMessage()));
                    ByteArrayOutputStream bas = new ByteArrayOutputStream();
                    PrintWriter pw = new PrintWriter(bas);
                    throwable.printStackTrace(pw);
                    pw.close();
                    ErrorDialog.this.detailArea.setText(ErrorDialog.convertLineFeeds(bas.toString()));
                    ErrorDialog.this.detailArea.setCaretPosition(0);
                }
            });
            if (displayLastException) {
                this.excepField.setSelectedIndex(this.throwableNames.size() - 1);
            }
            this.excepLabel.setLabelFor(this.excepField);
            this.msgLabel = new LabelWidget("Message:");
            this.msgArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 0, 2, 0)));
            this.msgArea.setBackground(this.excMsgPanel.getBackground());
            this.msgArea.setLineWrap(true);
            this.msgArea.setWrapStyleWord(true);
            this.msgArea.setEditable(false);
            this.msgLabel.setLabelFor(this.msgArea);
            JScrollPane msgScroller = new JScrollPane(this.msgArea);
            this.excMsgLayout.setConstraints(this.excepLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(1, 1, 5, 5), 0, 0));
            this.excMsgLayout.setConstraints(this.excepField, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(1, 1, 5, 1), 0, 0));
            this.excMsgLayout.setConstraints(this.msgLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(1, 1, 1, 5), 0, 0));
            this.excMsgLayout.setConstraints(msgScroller, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
            this.excMsgPanel.add(this.excepLabel);
            this.excMsgPanel.add(this.excepField);
            this.excMsgPanel.add(this.msgLabel);
            this.excMsgPanel.add(msgScroller);
            this.lowerPanel.add(this.excMsgPanel);
            bas = new ByteArrayOutputStream();
            pw = new PrintWriter(bas);
            for (Throwable t : this.throwables) {
                String message = this.parseMessage(t.getMessage());
                if (message != null) {
                    pw.write(message);
                }
                t.printStackTrace(pw);
                pw.write(10);
            }
            pw.flush();
            this.detailsText = "Exception\n\t" + title + "\n\t\t" + statement + " \nreason:\n\t" + reason + "\nExceptionType:\n\t" + lastException.getClass().getName() + "\nDetails\n\t" + ErrorDialog.convertLineFeeds(bas.toString());
            this.detailsText = ErrorDialog.convertLineFeeds(this.detailsText);
        } else if (details != null) {
            this.msgLabel = new LabelWidget("Message:  " + detailedMessage);
            this.excMsgLayout.setConstraints(this.msgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.excMsgPanel.add(this.msgLabel);
            this.lowerPanel.add(this.excMsgPanel);
        }
        this.linePanel = new JPanel();
        this.linePanel.setBorder(BorderFactory.createEtchedBorder());
        this.linePanel.setPreferredSize(new Dimension(100, 2));
        this.lowerPanel.add(this.linePanel);
        this.lowerPanel.add(this.detailLabel);
        this.lowerPanel.add(this.scrollPane);
        this.lowerPanelLayout.setConstraints(this.linePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.lowerPanelLayout.setConstraints(this.excMsgPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.lowerPanelLayout.setConstraints(this.detailLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lowerPanelLayout.setConstraints(this.scrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 5, 1), 5, 5));
        this.lowerPanelLayout.setConstraints(this.saveButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lowerPanel.add(this.saveButton);
        this.statementArea = new LabelWidget(statement);
        this.stateReasonPanel = new JPanel();
        this.stateReasonPanel.setLayout(new BorderLayout());
        this.stateReasonPanel.add((Component)this.statementArea, "North");
        this.reasonArea = new JTextArea(reason);
        this.reasonArea.setLineWrap(true);
        this.reasonArea.setWrapStyleWord(true);
        this.font = this.reasonArea.getFont();
        this.rowCount = this.getRowCount(reason);
        this.reasonArea.setBackground(this.stateReasonPanel.getBackground());
        this.reasonArea.setEditable(false);
        TitledBorder tBorder = new TitledBorder("Reason");
        this.reasonArea.setName("Reason");
        JScrollPane scroller = new JScrollPane(this.reasonArea);
        scroller.setBorder(tBorder);
        this.stateReasonPanel.add((Component)scroller, "Center");
        this.upperPanel.add(this.stateReasonPanel);
        this.outterButtonPanel = new JPanel(new FlowLayout(1));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 2, 30, 0));
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.detailsButton);
        this.outterButtonPanel.add(this.buttonPanel);
        this.upperPanel.add(this.outterButtonPanel);
        this.outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.outerPanel.add(this.upperPanel);
        this.outerPanelLayout.setConstraints(this.upperPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add(this.outerPanel);
        this.setSize(400, 150 + (int)(1.5 * (double)this.font.getSize() * (double)this.rowCount));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (ErrorDialog.this.detailsPressed) {
                    if (ErrorDialog.this.getSize().width < ErrorDialog.this.WHOLE_DIALOG_HEIGHT_W || ErrorDialog.this.getSize().height < 500) {
                        ErrorDialog.this.setSize(ErrorDialog.this.WHOLE_DIALOG_HEIGHT_W, 500);
                    }
                    ErrorDialog.this.setLocationRelativeTo(ErrorDialog.this.getOwner());
                } else if (ErrorDialog.this.getSize().width < 400 || ErrorDialog.this.getSize().height < 150) {
                    ErrorDialog.this.setSize(400, 150 + (int)(1.5 * (double)ErrorDialog.this.font.getSize() * (double)ErrorDialog.this.rowCount));
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.okClicked();
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.detailsClicked();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.saveClicked();
            }
        });
    }

    private void detailsClicked() {
        if (!this.detailsPressed) {
            this.detailsPressed = true;
            this.detailsButton.setText("Hide Details");
            this.outerPanelLayout.setConstraints(this.lowerPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.outerPanel.add(this.lowerPanel);
            this.pack();
            this.validate();
        } else {
            this.detailsPressed = false;
            this.detailsButton.setText("Show Details");
            this.outerPanel.remove(this.lowerPanel);
            this.validate();
            this.pack();
        }
    }

    protected int getRowCount(String text) {
        if (text == null) {
            return 0;
        }
        return new StringTokenizer(text, "\n").countTokens();
    }

    private void okClicked() {
        this.dispose();
    }

    protected String parseMessage(String message) {
        if (message == null) {
            return null;
        }
        int ndx = message.indexOf(10);
        if (ndx >= 0) {
            return message.substring(0, ndx);
        }
        return message;
    }

    protected Throwable parseThrowable(Throwable throwable) {
        Throwable result = throwable;
        if (throwable == null) {
            return result;
        }
        this.throwables.add(throwable);
        this.throwableNames.add(throwable.getClass().getName());
        if (throwable instanceof MetaMatrixException) {
            result = this.parseThrowable(((MetaMatrixException)throwable).getChild());
        } else if (throwable instanceof MetaMatrixRuntimeException) {
            result = this.parseThrowable(((MetaMatrixRuntimeException)throwable).getChild());
        } else if (throwable instanceof MultipleException) {
            Iterator iter = ((MultipleException)throwable).getExceptions().iterator();
            while (iter.hasNext()) {
                result = this.parseThrowable((Throwable)iter.next());
            }
        } else if (throwable instanceof MultipleRuntimeException) {
            Iterator iter = ((MultipleRuntimeException)throwable).getThrowables().iterator();
            while (iter.hasNext()) {
                result = this.parseThrowable((Throwable)iter.next());
            }
        } else if (throwable instanceof InvocationTargetException) {
            result = this.parseThrowable(((InvocationTargetException)throwable).getTargetException());
        }
        if (result == null) {
            result = throwable;
            return result;
        }
        return result;
    }

    private void saveClicked() {
        String sSelectedFileName = this.getFileName();
        if (sSelectedFileName != null) {
            File file = new File(sSelectedFileName);
            boolean fileOK = false;
            if (file.exists()) {
                if (file.canWrite()) {
                    fileOK = true;
                }
            } else {
                try {
                    file.createNewFile();
                    fileOK = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!fileOK) {
                String msg = "Error in opening or writing to file.";
                JOptionPane.showMessageDialog(this, msg, "File Error", -1);
            } else {
                FileWriter writer = null;
                try {
                    writer = new FileWriter(file);
                    writer.write(this.detailsText);
                }
                catch (Exception ex) {
                    String msg = "Error in opening or writing to file.";
                    JOptionPane.showMessageDialog(this, msg, "File Error", -1);
                }
                if (writer != null) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static String convertLineFeeds(String str) {
        StringBuffer buf = new StringBuffer();
        char[] b = str.toCharArray();
        char p = '?';
        for (int i = 0; i < b.length; ++i) {
            if (p != '\r' && b[i] == '\n') {
                buf.append('\r');
            }
            p = b[i];
            buf.append(p);
        }
        return buf.toString();
    }

    protected String getFileName() {
        FileSystemView view = new FileSystemView();
        FileSystemFilter filter = new FileSystemFilter(view, new String[]{"txt"}, "Text documents (*.txt)");
        DirectoryChooserPanel dirPanel = new DirectoryChooserPanel((DirectoryEntryView)view, 1, (DirectoryEntryFilter[])new FileSystemFilter[]{filter});
        DialogWindow.show(this, "Save Details", dirPanel);
        if (dirPanel.getSelectedButton() != dirPanel.getAcceptButton()) {
            return null;
        }
        TreeNode node = dirPanel.getSelectedTreeNode();
        if (node == null) {
            return dirPanel.getParentDirectoryEntry().getFullName() + File.separatorChar + dirPanel.getNameFieldText();
        }
        return node.getFullName();
    }

    public boolean savesLastFileLocation() {
        return this.savesLastFileLoc;
    }

    public void setSavesLastFileLocation(boolean saves) {
        this.savesLastFileLoc = saves;
    }

    public AbstractButton getOKButton() {
        return this.okButton;
    }

    public static void main(String[] arguments) {
        MetaMatrixException err = new MetaMatrixException("Really big message line 1, Really big message line 2, Really big message line 3, Really big message line 4, Really big message line 5, Really big message line 6, Really big message line 7, Really big message line 8, Really big message line 9, Really big message line 10, Really big message line 11, Really big message line 12, Really big message line 13, Really big message line 14, Really big message line 15, Really big message line 16, Really big message line 17, Really big message line 18, Really big message line 19, Really big message line 20, Really big message line 21, Really big message line 22, Really big message line 23, Really big message line 24, Really big message line 25, Really big message line 26, Really big message line 27, Really big message line 28, Really big message line 29, Really big message line 30, Really big message line 31, Really big message line 32, Really big message line 33, Really big message line 34, Really big message line 35, Really big message line 36, Really big message line 37, Really big message line 38, Really big message line 39, Really big message line 40, ");
        MultipleException multErr = new MultipleException();
        multErr.setExceptions(Arrays.asList(new AWTError("AWT error"), new NullPointerException(), new RuntimeException("Runtime error")));
        ErrorDialog dlg = new ErrorDialog((Frame)null, "test Dialog", "statement", "1 reason for statement\n2 reason for statement\n3 reason for statement\n4 reason for statement\n5 reason for statement\n6 reason for statement\n7 reason for statement\n8 reason for statement\n9 reason for statement\n10 reason for statement\n11 reason for statement\n12 reason for statement\n13 reason for statement\n14 reason for statement\n15 reason for statement\n16 reason for statement\n17 reason for statement\n18 reason for statement\n19 reason for statement\n20 reason for statement\n21 reason for statement\n22 reason for statement\n", (Throwable)err);
        dlg.setVisible(true);
        new ErrorDialog((Frame)null, "test Dialog", "statement", "reason for statement", (Throwable)new NullPointerException()).setVisible(true);
        new ErrorDialog((Frame)null, "test Dialog", "statement", "reason for statement", "detailed message", "details").setVisible(true);
        new ErrorDialog((Frame)null, "test Dialog", "statement", "reason for statement", (Throwable)new InvocationTargetException(new IllegalArgumentException("Illegal argument"))).setVisible(true);
        System.exit(0);
    }
}

