/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.PropertiedObjectArrayTable;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class IconTableCellRenderer
extends DefaultTableCellRenderer {
    private DirectoryEntryView directoryEntryView;

    public IconTableCellRenderer(DirectoryEntryView tv) {
        this.directoryEntryView = tv;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof DirectoryEntry) {
            DirectoryEntry tn = (DirectoryEntry)value;
            if (this.directoryEntryView.allowsChildren((TreeNode)tn)) {
                this.setIcon(UIDefaults.getInstance().getIcon("Tree.closedIcon"));
            } else {
                this.setIcon(UIDefaults.getInstance().getIcon("Tree.leafIcon"));
            }
            this.setText(tn.getName());
        } else {
            this.setText(value.toString());
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        PropertiedObjectArrayTable thisTable = (PropertiedObjectArrayTable)table;
        Object selectedObject = thisTable.getSelectedObject(rowIndex);
        return super.getTableCellRendererComponent(thisTable, selectedObject, isSelected, hasFocus, rowIndex, columnIndex);
    }
}

