/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.UiTextManager;
import com.metamatrix.toolbox.ui.widget.ArrowIcon;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.text.DefaultTextFieldModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;

public class IntegerSpinner
extends JPanel
implements DocumentListener,
FocusListener {
    protected Document doc;
    protected boolean docUpdateInProgress = false;
    protected int max;
    protected int min;
    protected int increment;
    protected boolean pad;
    protected int value;
    protected int width;
    protected boolean wrap;
    protected int minWidth = 0;
    private boolean constructed = false;
    private EventListenerList listeners = new EventListenerList();
    protected IntegerSpinnerMouseListener downMouseListener;
    protected IntegerSpinnerMouseListener upMouseListener;
    protected IgnoreButton btnDown;
    protected IgnoreButton btnUp;
    protected JPanel pnlButtons;
    protected TextFieldWidget txf;

    public IntegerSpinner(int theMin, int theMax, int theIncrement) {
        this(theMin, theMax, theIncrement, theMin, true);
    }

    public IntegerSpinner(int theMin, int theMax, int theIncrement, int theInitialValue, boolean theWrapFlag) {
        super(new BorderLayout());
        this.min = theMin;
        this.max = theMax > theMin ? theMax : theMin;
        this.wrap = theWrapFlag;
        this.increment = theIncrement > 0 ? theIncrement : 1;
        this.pad = false;
        this.setWidth();
        this.construct();
        this.setSpinnerToolTipText();
        this.setValue(theInitialValue);
        this.txf.setText(this.format());
        this.upMouseListener = new IntegerSpinnerMouseListener(100, true);
        this.btnUp.addMouseListener(this.upMouseListener);
        this.downMouseListener = new IntegerSpinnerMouseListener(100, false);
        this.btnDown.addMouseListener(this.downMouseListener);
        this.txf.addFocusListener(this);
        this.constructed = true;
    }

    public void addChangeListener(ChangeListener theListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(ChangeListener.class, theListener);
    }

    @Override
    public void addFocusListener(FocusListener theListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(FocusListener.class, theListener);
    }

    @Override
    public void changedUpdate(DocumentEvent theEvent) {
        this.updateValue();
    }

    private void construct() {
        this.txf = new TextFieldWidget(){

            @Override
            public void setToolTipText(String theTip) {
                String tip = UiTextManager.getInstance().getText("IntegerSpinner.toolTipText", new Object[]{new Integer(IntegerSpinner.this.min), new Integer(IntegerSpinner.this.max)});
                super.setToolTipText(tip);
            }
        };
        this.txf.setMinimumSize(this.txf.getPreferredSize());
        try {
            this.txf.setValidCharacters("0-9");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.txf.setBackground(Color.white);
        this.setEditable(false);
        this.txf.setHorizontalAlignment(4);
        this.txf.addKeyListener(new SpinnerKeyListener());
        this.txf.setColumns(this.width + 1);
        this.setDocumentWidth();
        this.add((Component)this.txf, "Center");
        this.pnlButtons = new JPanel(new GridLayout(2, 1, 0, 1));
        this.add((Component)this.pnlButtons, "East");
        this.btnUp = new IgnoreButton((Icon)new ArrowIcon(1, 4));
        this.btnUp.setPreferredSize(new Dimension(12, 12));
        this.pnlButtons.add(this.btnUp);
        this.btnDown = new IgnoreButton((Icon)new ArrowIcon(5, 4));
        this.btnDown.setPreferredSize(new Dimension(12, 12));
        this.pnlButtons.add(this.btnDown);
    }

    public boolean decrement() {
        return this.setValue(this.value - this.increment);
    }

    private void fireChangeEvent(ChangeEvent theEvent) {
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            Object l = list[i + 1];
            if (!(l instanceof ChangeListener)) continue;
            ((ChangeListener)l).stateChanged(theEvent);
        }
    }

    private void fireFocusEvent(FocusEvent theEvent) {
        if (!theEvent.isTemporary()) {
            boolean gained = theEvent.getID() == 1004;
            FocusEvent event = new FocusEvent(this, theEvent.getID(), false);
            Object[] list = this.listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                Object l = list[i + 1];
                if (!(l instanceof FocusListener)) continue;
                if (gained) {
                    ((FocusListener)l).focusGained(event);
                    continue;
                }
                ((FocusListener)l).focusLost(event);
            }
        }
    }

    public int getMaxWidth() {
        return this.width;
    }

    public boolean increment() {
        return this.setValue(this.value + this.increment);
    }

    @Override
    public void insertUpdate(DocumentEvent theEvent) {
        this.updateValue();
    }

    public boolean isEditable() {
        return this.txf.isEditable();
    }

    @Override
    public void focusGained(FocusEvent theEvent) {
        this.fireFocusEvent(theEvent);
    }

    @Override
    public void focusLost(FocusEvent theEvent) {
        String formattedString;
        if (this.isEditable() && !this.docUpdateInProgress && !(formattedString = this.format()).equals(this.txf.getText())) {
            this.txf.setText(formattedString);
        }
        this.fireFocusEvent(theEvent);
    }

    public String format() {
        StringBuffer txt = new StringBuffer(Integer.toString(this.value));
        if (this.pad) {
            int offset;
            int n = offset = this.min < 0 ? 1 : 0;
            while (txt.length() < this.width) {
                txt.insert(offset, "0");
            }
        }
        return txt.toString();
    }

    public int getMaxValue() {
        return this.max;
    }

    public int getMinValue() {
        return this.min;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.txf.getPreferredSize().width + this.pnlButtons.getPreferredSize().width, this.txf.getPreferredSize().height);
    }

    public String getTextValue() {
        return this.txf.getText();
    }

    @Override
    public String getToolTipText() {
        return this.txf.getToolTipText();
    }

    public int getValue() {
        return this.value;
    }

    public void keyListenerKeyPressed(KeyEvent theEvent) {
        if (theEvent.getSource() == this.txf) {
            switch (theEvent.getKeyCode()) {
                case 40: {
                    if (!this.decrement()) break;
                    this.txf.selectAll();
                    break;
                }
                case 38: {
                    if (!this.increment()) break;
                    this.txf.selectAll();
                    break;
                }
            }
        }
    }

    public void removeChangeListener(ChangeListener theListener) {
        if (this.listeners != null) {
            this.listeners.remove(ChangeListener.class, theListener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener theListener) {
        if (this.listeners != null) {
            this.listeners.remove(FocusListener.class, theListener);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent theEvent) {
        this.updateValue();
    }

    @Override
    public void requestFocus() {
        this.txf.requestFocus();
    }

    @Override
    public String paramString() {
        return new StringBuffer().append("value=").append(this.value).append(", min=").append(this.min).append(", max=").append(this.max).append(", min width=").append(this.minWidth).append(", width=").append(this.width).append(", increment=").append(this.increment).append(", pad=").append(this.pad).append(", wrap=").append(this.wrap).append(", editable=").append(this.isEditable()).append(", docUpdateInProgress=").append(this.docUpdateInProgress).append(", toolTipText=").append(this.getToolTipText()).toString();
    }

    private void setDocumentWidth() {
        if (this.txf != null) {
            DefaultTextFieldModel doc = (DefaultTextFieldModel)this.txf.getDocument();
            doc.setMaximumLength(this.width);
        }
    }

    public void setEditable(boolean theEditableFlag) {
        if (this.txf.isEditable() != theEditableFlag) {
            this.txf.setEditable(theEditableFlag);
            if (theEditableFlag) {
                this.txf.addFocusListener(this);
                this.txf.getDocument().addDocumentListener(this);
                this.txf.setBackground(UIDefaults.getInstance().getColor("TextField.background"));
            } else {
                this.txf.removeFocusListener(this);
                this.txf.getDocument().removeDocumentListener(this);
                this.txf.setBackground(UIDefaults.getInstance().getColor("TextField.uneditableBackgroundColor"));
            }
        }
    }

    @Override
    public void setEnabled(boolean theEnableFlag) {
        if (this.txf.isEnabled() != theEnableFlag) {
            this.txf.setEnabled(theEnableFlag);
            this.btnUp.setEnabled(theEnableFlag);
            this.btnDown.setEnabled(theEnableFlag);
        }
    }

    public void setMaxValue(int theNewMax) {
        int n = this.max = theNewMax > this.min ? theNewMax : this.min;
        if (this.value > this.max) {
            this.value = this.max;
        }
        this.setWidth();
        this.setSpinnerToolTipText();
    }

    public void setMinValue(int newMin) {
        int n = this.min = newMin < this.max ? newMin : this.max;
        if (this.value < this.min) {
            this.value = this.min;
        }
        this.setWidth();
        this.setSpinnerToolTipText();
    }

    public void setPad(boolean pad) {
        this.pad = pad;
        this.txf.setText(this.format());
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        int height = preferredSize.height;
        this.pnlButtons.setPreferredSize(new Dimension(this.pnlButtons.getPreferredSize().width, height));
    }

    public void setReadonly(boolean value) {
        this.txf.setEditable(!value);
        this.btnUp.setEnabled(!value);
        this.btnDown.setEnabled(!value);
        if (!value) {
            this.txf.setBackground(Color.white);
        } else {
            this.txf.setBackground(new Color(204, 204, 204));
        }
    }

    private void setSpinnerToolTipText() {
        this.txf.setToolTipText("");
    }

    public boolean setValue(int newValue) {
        boolean changed = true;
        if (newValue == this.value) {
            changed = false;
        } else if (newValue > this.max) {
            if (this.wrap) {
                if (this.value != this.max) {
                    this.value = this.max;
                } else {
                    changed = false;
                }
            } else if (this.value != this.max) {
                this.value = this.max;
            } else {
                changed = false;
            }
        } else if (newValue < this.min) {
            if (this.wrap) {
                if (this.value != this.max) {
                    this.value = this.max;
                } else {
                    changed = false;
                }
            } else if (this.value != this.min) {
                this.value = this.min;
            } else {
                changed = false;
            }
        } else {
            this.value = newValue;
        }
        if (changed) {
            if (!this.docUpdateInProgress) {
                this.txf.setText(this.format());
            }
            if (this.constructed) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
        }
        return changed;
    }

    private void setWidth() {
        int newWidth = Math.max(String.valueOf(this.max).length(), String.valueOf(this.min).length());
        if (newWidth != this.width) {
            this.width = newWidth;
        }
        if ((newWidth = Math.min(String.valueOf(this.max).length(), String.valueOf(this.min).length())) != this.minWidth) {
            this.minWidth = newWidth;
        }
        this.setDocumentWidth();
    }

    @Override
    public String toString() {
        return this.format();
    }

    private boolean updateCurrentValue() {
        boolean update = false;
        try {
            String txtValue = this.txf.getText();
            int newValue = 0;
            newValue = Integer.parseInt(txtValue);
            update = this.setValue(newValue);
        }
        catch (NumberFormatException nfe) {
            update = false;
        }
        return update;
    }

    private void updateValue() {
        if (this.isEditable()) {
            this.docUpdateInProgress = true;
            this.updateCurrentValue();
            this.docUpdateInProgress = false;
        }
    }

    public static void main(String[] theArgs) {
        JFrame f = new JFrame();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent theEvent) {
                System.exit(0);
            }
        });
        JPanel p = new JPanel();
        f.getContentPane().add(p);
        IntegerSpinner is = new IntegerSpinner(0, 59, 1);
        is.setEditable(false);
        is.setPad(true);
        p.add(is);
        IntegerSpinner is2 = new IntegerSpinner(0, 10, 1);
        is2.setEditable(true);
        is2.setPad(true);
        p.add(is2);
        f.setSize(400, 400);
        f.setVisible(true);
    }

    public class SpinnerKeyListener
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent event) {
            IntegerSpinner.this.keyListenerKeyPressed(event);
        }
    }

    class IntegerSpinnerMouseListener
    extends MouseAdapter
    implements ActionListener {
        protected Timer tm;
        protected boolean directionup;

        public IntegerSpinnerMouseListener(int delay, boolean directionup) {
            this.tm = new Timer(delay, this);
            this.tm.setInitialDelay(500);
            this.directionup = directionup;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.tm.start();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.tm.stop();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == IntegerSpinner.this.btnUp) {
                if (IntegerSpinner.this.btnUp.isEnabled()) {
                    IntegerSpinner.this.txf.requestFocus();
                    IntegerSpinner.this.increment();
                }
            } else if (e.getSource() == IntegerSpinner.this.btnDown && IntegerSpinner.this.btnDown.isEnabled()) {
                IntegerSpinner.this.txf.requestFocus();
                IntegerSpinner.this.decrement();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.directionup) {
                IntegerSpinner.this.txf.requestFocus();
                IntegerSpinner.this.increment();
            } else {
                IntegerSpinner.this.txf.requestFocus();
                IntegerSpinner.this.decrement();
            }
        }
    }

    private class IgnoreButton
    extends ButtonWidget {
        public IgnoreButton(Icon icon) {
            super(icon);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }
    }
}

