/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.widget.PopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.list.DefaultListCellRenderer;
import com.metamatrix.toolbox.ui.widget.menu.DefaultPopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.text.TextContainer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class ListWidget
extends JList
implements TextContainer {
    private boolean isClipTipEnabled = true;
    private PopupMenuFactory popupMenuFactory;

    public ListWidget() {
        this(Collections.EMPTY_LIST);
    }

    public ListWidget(List data) {
        super(new Vector(data));
        this.initializeListWidget();
    }

    public ListWidget(ListModel model) {
        super(model);
        this.initializeListWidget();
    }

    protected ListCellRenderer createCellRenderer() {
        return new DefaultListCellRenderer();
    }

    protected PopupMenuFactory createDefaultPopupMenuFactory() {
        return new DefaultPopupMenuFactory();
    }

    public PopupMenuFactory getPopupMenuFactory() {
        return this.popupMenuFactory;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (event != null) {
            Component comp;
            Point mouseLoc = event.getPoint();
            int row = this.locationToIndex(mouseLoc);
            ListCellRenderer renderer = this.getCellRenderer();
            if (row != -1 && renderer != null && (comp = renderer.getListCellRendererComponent(this, this.getModel().getElementAt(row), row, this.isSelectedIndex(row), true)) instanceof JComponent) {
                Rectangle cellBounds = this.getCellBounds(row, row);
                mouseLoc.translate(-cellBounds.x, -cellBounds.y);
                MouseEvent newEvent = new MouseEvent(comp, event.getID(), event.getWhen(), event.getModifiers(), mouseLoc.x, mouseLoc.y, event.getClickCount(), event.isPopupTrigger());
                return ((JComponent)comp).getToolTipText(newEvent);
            }
        }
        return null;
    }

    protected void initializeListWidget() {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(this.createCellRenderer());
        this.setPopupMenuFactory(this.createDefaultPopupMenuFactory());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent event) {
                JPopupMenu popup;
                if (!SwingUtilities.isRightMouseButton(event)) {
                    return;
                }
                int ndx = ListWidget.this.locationToIndex(event.getPoint());
                if (!ListWidget.this.isSelectedIndex(ndx)) {
                    ListWidget.this.setSelectedIndex(ndx);
                }
                if (ListWidget.this.popupMenuFactory != null && (popup = ListWidget.this.popupMenuFactory.getPopupMenu(ListWidget.this)) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            popup.show(ListWidget.this, event.getX(), event.getY());
                        }
                    });
                }
            }
        });
    }

    @Override
    public boolean isClipTipEnabled() {
        return this.isClipTipEnabled;
    }

    @Override
    public void setClipTipEnabled(boolean isClipTipEnabled) {
        this.isClipTipEnabled = isClipTipEnabled;
    }

    public void setPopupMenuFactory(PopupMenuFactory factory) {
        this.popupMenuFactory = factory;
    }
}

