/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.log.MessageLevel;
import com.metamatrix.toolbox.preference.UserPreferences;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LoggingPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final String LOGGING_TITLE = "Message Logging";
    private JList logList;
    private JComboBox cb;
    private ButtonGroup listGroup = new ButtonGroup();
    private JRadioButton logAllContextsButton;
    private JRadioButton logSelectedContextsButton;

    public LoggingPanel(List availContextsList) {
        this.buildLoggingPanel(availContextsList);
    }

    private void buildLoggingPanel(List availContextsList) {
        UserPreferences preferences = UserPreferences.getInstance();
        this.setLayout(new BoxLayout(this, 1));
        CompoundBorder b = BorderFactory.createCompoundBorder(new EmptyBorder(2, 2, 2, 2), new TitledBorder(LOGGING_TITLE));
        this.setBorder(b);
        this.add(Box.createVerticalStrut(20));
        JPanel hiP = new JPanel();
        hiP.add(new JLabel("Message Type Filter : "));
        this.cb = new JComboBox<Object>(MessageLevel.getDisplayNames().toArray());
        this.cb.setSelectedIndex(Integer.parseInt(preferences.getProperties().getProperty("metamatrix.log", "3")));
        this.cb.addActionListener(this);
        hiP.add(this.cb);
        this.add(hiP);
        this.add(Box.createVerticalStrut(20));
        JPanel loP = new JPanel(new GridBagLayout());
        loP.setBorder(new EmptyBorder(0, 2, 0, 5));
        GridBagConstraints c = new GridBagConstraints();
        this.logAllContextsButton = new JRadioButton("All", true);
        this.logSelectedContextsButton = new JRadioButton("All Except : ");
        this.listGroup.add(this.logAllContextsButton);
        this.listGroup.add(this.logSelectedContextsButton);
        this.logAllContextsButton.setActionCommand("All");
        this.logSelectedContextsButton.setActionCommand("Select");
        this.logList = new JList<Object>(availContextsList.toArray());
        this.logList.setEnabled(false);
        this.logList.setFixedCellWidth(200);
        this.logList.getSelectionModel().addListSelectionListener(this);
        this.logAllContextsButton.addActionListener(this);
        this.logSelectedContextsButton.addActionListener(this);
        JScrollPane jSP = new JScrollPane(this.logList);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        loP.add((Component)new JLabel("Log Contexts"), c);
        c.gridx = 1;
        c.anchor = 17;
        loP.add((Component)this.logAllContextsButton, c);
        c.gridy = 1;
        c.anchor = 18;
        loP.add((Component)this.logSelectedContextsButton, c);
        c.gridx = 2;
        c.anchor = 10;
        loP.add((Component)jSP, c);
        this.add(loP);
        Collection removedContexts = preferences.getValues("metamatrix.log.contexts", ';');
        if (removedContexts.size() != 0) {
            Object[] allContexts = availContextsList.toArray();
            this.logSelectedContextsButton.setSelected(true);
            this.logList.setEnabled(true);
            int[] removedIndices = new int[allContexts.length];
            int ind = 0;
            for (int i = 0; i < allContexts.length; ++i) {
                if (!removedContexts.contains(allContexts[i])) continue;
                removedIndices[ind] = i;
                ++ind;
            }
            this.logList.setSelectedIndices(removedIndices);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cb) {
            UserPreferences preferences = UserPreferences.getInstance();
            preferences.setValue("metamatrix.log", new Integer(this.cb.getSelectedIndex()).toString());
        } else if (e.getActionCommand().equals("All")) {
            this.logList.clearSelection();
            this.logList.setEnabled(false);
        } else if (e.getActionCommand().equals("Select")) {
            this.logList.setEnabled(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        UserPreferences preferences = UserPreferences.getInstance();
        if (this.logAllContextsButton.isSelected()) {
            preferences.setValue("metamatrix.log.contexts", "");
        } else {
            List<Object> selectedContexts = Arrays.asList(this.logList.getSelectedValues());
            preferences.setValues("metamatrix.log.contexts", selectedContexts, ';');
        }
    }

    public void removeLoggingContexts(Collection contexts) {
        LogConfiguration config = LogManager.getLogConfigurationCopy();
        config.recordAllContexts();
        config.discardContexts(contexts);
        LogManager.setLogConfiguration((LogConfiguration)config);
    }

    public void clearLoggingContexts() {
        LogConfiguration config = LogManager.getLogConfigurationCopy();
        config.recordAllContexts();
        LogManager.setLogConfiguration((LogConfiguration)config);
    }

    public Collection getRemovedLoggingContexts() {
        LogConfiguration config = LogManager.getLogConfigurationCopy();
        return config.getDiscardedContexts();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("User Preferences Test");
        frame.setLocation(100, 100);
        frame.setSize(600, 500);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ArrayList<String> contexts = new ArrayList<String>();
        contexts.add("fake context");
        frame.getContentPane().add(new LoggingPanel(contexts));
        frame.setVisible(true);
    }
}

