/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.IconConstants;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.WidgetFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class LoginPanel
extends DialogPanel
implements IconConstants {
    private static final UIDefaults DFLTS = UIDefaults.getInstance();
    public static final String PROPERTY_PREFIX = "LoginPanel.";
    public static final String FIELD_COLUMNS_PROPERTY = "LoginPanel.fieldColumns";
    public static final String LOGO_BORDER_PROPERTY = "LoginPanel.logoBorder";
    public static final String USER_NAME_LABEL_PROPERTY = "LoginPanel.userNameLabel";
    public static final String PASSWORD_LABEL_PROPERTY = "LoginPanel.passwordLabel";
    public static final String SYSTEM_LABEL_PROPERTY = "LoginPanel.systemLabel";
    private static final int FIELD_COLUMNS = DFLTS.getInt("LoginPanel.fieldColumns");
    private static final Icon LOGO_AND_NAME_ICON = DFLTS.getIcon("Icon.logoAndName");
    private static final Border LOGO_BORDER = DFLTS.getBorder("LoginPanel.logoBorder");
    private static final String NAME_LABEL = DFLTS.getString("LoginPanel.userNameLabel");
    private static final String PASSWORD_LABEL = DFLTS.getString("LoginPanel.passwordLabel");
    private static final String SYSTEM_LABEL = DFLTS.getString("LoginPanel.systemLabel");
    private static final KeyStroke ENTER_RELEASED = KeyStroke.getKeyStroke(10, 0, true);
    private ArrayList labels;
    private TextFieldWidget nameFld;
    private JPasswordField pwdFld;
    private JComboBox sysFld;
    private Icon loginIcon;
    private Action enterKeyAction;

    public LoginPanel() {
        this(true);
    }

    public LoginPanel(boolean addSystemField) {
        this.loginIcon = LOGO_AND_NAME_ICON;
        this.initializeLoginPanel(addSystemField);
    }

    public LoginPanel(boolean addSystemField, Icon icon) {
        this.loginIcon = icon;
        this.initializeLoginPanel(addSystemField);
    }

    public void addField(String text, JComponent component) {
        this.labels.add(this.addField((Container)this.getContent(), text, component));
        this.alignLabels();
    }

    protected LabelWidget addField(Container container, String text, JComponent component) {
        Box hBox = Box.createHorizontalBox();
        LabelWidget label = new LabelWidget(text + ' ');
        label.setHorizontalAlignment(4);
        hBox.add(label);
        component.setMaximumSize(new Dimension(Short.MAX_VALUE, component.getPreferredSize().height));
        hBox.add(component);
        container.add(hBox);
        if (component instanceof JComboBox) {
            component = (JComponent)((JComboBox)component).getEditor().getEditorComponent();
            InputMap inputMap = component.getInputMap();
            inputMap.put(ENTER_RELEASED, "enter");
            ActionMap actionMap = component.getActionMap();
            actionMap.put("enter", this.enterKeyAction);
        }
        return label;
    }

    protected void alignLabels() {
        int maxWth = 0;
        Iterator iterator = this.labels.iterator();
        while (iterator.hasNext()) {
            maxWth = Math.max(maxWth, ((LabelWidget)iterator.next()).getPreferredSize().width);
        }
        Dimension size = new Dimension(maxWth, ((LabelWidget)this.labels.get((int)0)).getPreferredSize().height);
        for (LabelWidget label : this.labels) {
            label.setMinimumSize(size);
            label.setPreferredSize(size);
            label.setMaximumSize(size);
        }
    }

    @Override
    protected ButtonWidget createAcceptButton() {
        return WidgetFactory.createButton("login");
    }

    public ButtonWidget getLoginButton() {
        return this.getAcceptButton();
    }

    public JPasswordField getPasswordField() {
        return this.pwdFld;
    }

    public JComboBox getSystemField() {
        return this.sysFld;
    }

    public TextFieldWidget getUserNameField() {
        return this.nameFld;
    }

    protected void initializeLoginPanel(boolean addSystemField) {
        LabelWidget label = new LabelWidget(this.loginIcon);
        label.setBorder(LOGO_BORDER);
        label.setHorizontalAlignment(0);
        this.add((Component)label, "North");
        this.enterKeyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LoginPanel.this.getLoginButton().requestFocus();
                LoginPanel.this.getLoginButton().doClick();
            }
        };
        this.labels = new ArrayList();
        Box vBox = Box.createVerticalBox();
        this.setContent(vBox);
        this.nameFld = new TextFieldWidget(FIELD_COLUMNS);
        this.labels.add(this.addField(vBox, NAME_LABEL, this.nameFld));
        this.pwdFld = new JPasswordField(FIELD_COLUMNS);
        this.labels.add(this.addField(vBox, PASSWORD_LABEL, this.pwdFld));
        if (addSystemField) {
            this.sysFld = new JComboBox();
            this.sysFld.setEditable(true);
            this.labels.add(this.addField(vBox, SYSTEM_LABEL, this.sysFld));
        }
        this.alignLabels();
    }
}

