/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.MessageStandards;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.SpacerWidget;
import com.metamatrix.toolbox.ui.widget.WidgetFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class MessagePanel
extends DialogPanel {
    public static final String BUTTON_TYPES_PROPERTY_PREFIX = "MessagePanel.buttonTypes.";
    public static final String TYPE_WARNING = "warning";
    public static final String TYPE_NOTIFICATION = "notification";
    public static final String TYPE_ERROR = "error";
    public static final String TYPE_CONFIRMATION = "confirmation";
    public static final String TYPE_CANCELLABLE_QUESTION = "cancellable_question";
    public static final String TYPE_QUESTION = "question";
    public static final String CONFIRMATION_TITLE = "Confirm";
    public static final String ERROR_TITLE = "Error";
    public static final String NOTIFICATION_TITLE = "Message";
    public static final String QUESTION_TITLE = "Question";
    public static final String WARNING_TITLE = "Warning";
    private String id;
    private String type;
    private String msg;
    private Icon icon;
    private JComponent detailComp;
    private ButtonWidget detailButton = null;
    private final int INSET_PIXELS = 5;

    public MessagePanel(String id) {
        this.id = id;
        this.initializeMessagePanel();
    }

    public MessagePanel(String type, String message) {
        this.type = type;
        this.msg = message;
        this.initializeMessagePanel();
    }

    public MessagePanel(Icon icon, String message) {
        this.icon = icon;
        this.msg = message;
        this.initializeMessagePanel();
    }

    public MessagePanel(String id, JComponent component) {
        this.id = id;
        this.detailComp = component;
        this.initializeMessagePanel();
    }

    public MessagePanel(String type, String message, JComponent component) {
        this.type = type;
        this.msg = message;
        this.detailComp = component;
        this.initializeMessagePanel();
    }

    public MessagePanel(Icon icon, String message, JComponent component) {
        this.icon = icon;
        this.msg = message;
        this.detailComp = component;
        this.initializeMessagePanel();
    }

    @Override
    public ButtonWidget createAcceptButton() {
        return null;
    }

    @Override
    public ButtonWidget createCancelButton() {
        return null;
    }

    protected ButtonWidget createDetailButton() {
        ButtonWidget detailButton = WidgetFactory.createButton("details");
        return detailButton;
    }

    public ButtonWidget getDetailButton() {
        return this.detailButton;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getID() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    protected void initializeMessagePanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addNavigationSpacer(SpacerWidget.createHorizontalExpandableSpacer());
        if (this.id != null) {
            this.type = MessageStandards.getType(this.id);
            this.msg = MessageStandards.getMessage(this.id);
        }
        if (this.type != null) {
            UIDefaults dflts = UIDefaults.getInstance();
            this.icon = dflts.getIcon(this.type);
            String listOfButtonTypes = dflts.getString(BUTTON_TYPES_PROPERTY_PREFIX + this.type);
            StringTokenizer tokenizer = new StringTokenizer(listOfButtonTypes, ",");
            while (tokenizer.hasMoreTokens()) {
                String latestType = tokenizer.nextToken().trim();
                final ButtonWidget button = WidgetFactory.createButton(latestType);
                if (button == null) continue;
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Container parent = button;
                        while (!((parent = parent.getParent()) instanceof Window)) {
                        }
                        ((Window)parent).dispose();
                    }
                });
                this.addNavigationSpacer(SpacerWidget.createHorizontalSpacer());
                this.addNavigationButton(button);
            }
        }
        if (this.icon != null) {
            JPanel iconPanel = new JPanel();
            iconPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            iconPanel.add(new JLabel(this.icon));
            contentPanel.add((Component)iconPanel, "West");
        }
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        messagePanel.setLayout(new BoxLayout(messagePanel, 1));
        if (this.msg != null) {
            LabelWidget message = new LabelWidget(this.msg);
            messagePanel.add(message);
        }
        final JPanel messageAndDetailsPanel = new JPanel();
        messageAndDetailsPanel.setLayout(new BorderLayout());
        messageAndDetailsPanel.add((Component)messagePanel, "North");
        if (this.detailComp != null) {
            this.detailButton = this.createDetailButton();
            this.detailButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MessagePanel.this.detailComp.isVisible()) {
                        MessagePanel.this.detailComp.setVisible(false);
                    } else {
                        MessagePanel.this.detailComp.setVisible(true);
                    }
                    messageAndDetailsPanel.revalidate();
                    messageAndDetailsPanel.repaint();
                }
            });
            messageAndDetailsPanel.add((Component)this.detailComp, "South");
            this.detailComp.setVisible(false);
            this.detailComp.addAncestorListener(new WindowResizingAncestorListener());
            this.addNavigationSpacer(SpacerWidget.createHorizontalSpacer());
            this.addNavigationButton(this.detailButton);
            this.addNavigationSpacer(SpacerWidget.createHorizontalSpacer());
        }
        contentPanel.add((Component)messageAndDetailsPanel, "Center");
        this.setContent(contentPanel);
        this.addNavigationSpacer(SpacerWidget.createHorizontalExpandableSpacer());
    }

    public boolean isDetailAvailable() {
        return this.detailComp != null;
    }

    protected void setTitle(DialogWindow dlg, String title) {
        if (!title.equals(dlg.getTitle())) {
            dlg.setTitle(title);
        }
    }

    @Override
    protected void windowAdded() {
        if (this.type == null) {
            return;
        }
        Window wdw = this.getWindowAncestor();
        if (wdw == null || !(wdw instanceof DialogWindow)) {
            return;
        }
        DialogWindow dlg = (DialogWindow)wdw;
        if (this.type.equals(TYPE_CONFIRMATION)) {
            this.setTitle(dlg, CONFIRMATION_TITLE);
        } else if (this.type.equals(TYPE_ERROR)) {
            this.setTitle(dlg, ERROR_TITLE);
        } else if (this.type.equals(TYPE_NOTIFICATION)) {
            this.setTitle(dlg, NOTIFICATION_TITLE);
        } else if (this.type.equals(TYPE_QUESTION) || this.type.equals(TYPE_CANCELLABLE_QUESTION)) {
            this.setTitle(dlg, QUESTION_TITLE);
        } else if (this.type.equals(TYPE_WARNING)) {
            this.setTitle(dlg, WARNING_TITLE);
        }
    }

    private static class WindowResizingAncestorListener
    implements AncestorListener {
        Window windowToResize;

        @Override
        public void ancestorAdded(AncestorEvent e) {
            Container target = e.getComponent();
            boolean done = false;
            do {
                if ((target = target.getParent()) instanceof Window) {
                    this.windowToResize = (Window)target;
                    done = true;
                    continue;
                }
                if (!(target instanceof JViewport)) continue;
                this.windowToResize = null;
                done = true;
            } while (!done);
            if (this.windowToResize != null) {
                this.windowToResize.pack();
                this.windowToResize.repaint();
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent e) {
            if (this.windowToResize != null) {
                this.windowToResize.pack();
                this.windowToResize.repaint();
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent e) {
        }
    }
}

