/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.event.WidgetActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PasswordButton
extends ButtonWidget {
    private static final String PREFIX = "PasswordButton.";
    public static final String DEFAULT_DIALOG_TITLE_PROPERTY = "PasswordButton.dialogTitle";
    public static final String DEFAULT_TEXT_PROPERTY = "PasswordButton.text";
    public static final String FIELD_COLUMNS_PROPERTY = "PasswordButton.fieldColumns";
    public static final String FIELD_NAME_PROPERTY = "PasswordButton.fieldName";
    public static final String DEFAULT_DIALOG_TITLE = UIDefaults.getInstance().getString("PasswordButton.dialogTitle");
    public static final String DEFAULT_TEXT = UIDefaults.getInstance().getString("PasswordButton.text");
    public static final int FIELD_COLUMNS = UIDefaults.getInstance().getInt("PasswordButton.fieldColumns");
    public static final String FIELD_NAME = UIDefaults.getInstance().getString("PasswordButton.fieldName");
    private static final String LOG_CONTEXT = "PROPERTY";
    private char[] pwd;
    private String dlgTitle;
    private Encryptor encryptor;

    public PasswordButton(char[] password, Encryptor encryptor) {
        super(DEFAULT_TEXT, null);
        this.encryptor = encryptor;
        this.constructPasswordButton(password);
    }

    protected void accept(DialogPanel panel, WidgetActionEvent event) {
    }

    protected JPasswordField addField(JPanel labelPanel, JPanel fieldPanel, String text) {
        labelPanel.add(new JLabel(text + ": ", 4));
        JPasswordField fld = new JPasswordField(FIELD_COLUMNS);
        fieldPanel.add(fld);
        return fld;
    }

    protected void constructPasswordButton(char[] password) {
        Assertion.isNotNull((Object)password, (String)"Password");
        this.pwd = password;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JPanel panel = new JPanel(new BorderLayout());
                JPanel labelPanel = new JPanel(new GridLayout(0, 1));
                panel.add((Component)labelPanel, "West");
                JPanel fldPanel = new JPanel(new GridLayout(0, 1));
                panel.add((Component)fldPanel, "Center");
                final JPasswordField fld = PasswordButton.this.addField(labelPanel, fldPanel, FIELD_NAME);
                final DialogPanel dlgPanel = new DialogPanel(){

                    @Override
                    protected void accept(WidgetActionEvent event) {
                        PasswordButton.this.accept(this, event);
                        if (!event.isDestroyed()) {
                            PasswordButton.access$002(PasswordButton.this, fld.getPassword());
                            PasswordButton.this.fireStateChanged();
                        }
                    }
                };
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        dlgPanel.getAcceptButton().doClick();
                    }
                };
                fld.addActionListener(listener);
                dlgPanel.setContent(panel);
                DialogWindow.show(PasswordButton.this, PasswordButton.this.dlgTitle, dlgPanel);
            }
        });
        this.setDialogTitle(DEFAULT_DIALOG_TITLE);
    }

    public String getDialogTitle() {
        return this.dlgTitle;
    }

    public char[] getPassword() {
        char[] pwd = new char[this.pwd.length];
        System.arraycopy(this.pwd, 0, pwd, 0, pwd.length);
        return pwd;
    }

    public void setDialogTitle(String title) {
        this.dlgTitle = title;
    }

    static /* synthetic */ char[] access$002(PasswordButton x0, char[] x1) {
        x0.pwd = x1;
        return x1;
    }
}

