/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.toolbox.ui.widget.DirectoryEntryTable;
import com.metamatrix.toolbox.ui.widget.TreeNodeTableWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.DirectoryEntryTableComparator;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import com.metamatrix.toolbox.ui.widget.table.TableComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class PropertiedObjectArrayTable
extends TreeNodeTableWidget {
    private static final String EMPTY_MESSAGE = "Folder empty or all files filtered out";
    private int propertyCount = 0;
    private PropertiedObjectEditor propertiedObjectEditor;
    private Collection propertiedObjects = Collections.EMPTY_LIST;
    private Object[] propertiedObjectsArray;
    private Collection propDefnsToShow = Collections.EMPTY_LIST;
    private List propertyDefinitions = Collections.EMPTY_LIST;
    private String emptyMessage = "Folder empty or all files filtered out";
    private DefaultTableCellRenderer renderer;

    public PropertiedObjectArrayTable() {
        this((PropertiedObjectEditor)null);
    }

    public PropertiedObjectArrayTable(PropertiedObjectEditor editor) {
        this.propertiedObjectEditor = editor;
    }

    public void addListSelectionListener(ListSelectionListener lsl) {
        this.getSelectionModel().addListSelectionListener(lsl);
    }

    public void setEmptyMessage(String msg) {
        if (msg != null) {
            this.emptyMessage = msg;
        }
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    protected void initializePropertiedObjectArrayEntryTable() {
        if (this.propDefnsToShow != null && this.propDefnsToShow.size() > 0) {
            this.propertyDefinitions = new ArrayList(this.propDefnsToShow.size());
            for (PropertyDefinition propDef : this.propDefnsToShow) {
                if (propDef.isHidden()) continue;
                this.propertyDefinitions.add(propDef);
            }
        } else if (this.propertiedObjects.size() > 0) {
            this.propertyDefinitions = this.propertiedObjectEditor.getPropertyDefinitions((PropertiedObject)this.propertiedObjects.iterator().next());
            Iterator propIter = this.propertyDefinitions.iterator();
            ArrayList<PropertyDefinition> displayedPropertyDefinitions = new ArrayList<PropertyDefinition>(this.propertyDefinitions.size());
            while (propIter.hasNext()) {
                PropertyDefinition propDef = (PropertyDefinition)propIter.next();
                if (propDef.isHidden()) continue;
                displayedPropertyDefinitions.add(propDef);
            }
            this.propertyDefinitions = displayedPropertyDefinitions;
        }
        this.propertyCount = this.propertyDefinitions.size();
        DefaultTableModel tableModel = this.propertiedObjects.size() > 0 ? new DefaultTableModel(this.getData(), this.getPropertyDefNames()) : new DefaultTableModel(this.getData(), this.getEmptyTableHeaderArray());
        tableModel.setEditable(false);
        this.setModel(tableModel);
    }

    @Override
    protected TableComparator createDefaultComparator() {
        return DirectoryEntryTableComparator.getInstance();
    }

    protected DefaultTableCellRenderer getCellRenderer() {
        if (this.renderer == null) {
            return new DefaultTableCellRenderer();
        }
        return this.renderer;
    }

    protected Object[][] getData() {
        Object[] showingObjects = this.propertiedObjects.toArray();
        Object[][] data = new Object[showingObjects.length][this.propertyCount];
        if (showingObjects.length == 0) {
            Object[][] noData = new Object[0][1];
            return noData;
        }
        for (int i = 0; i < showingObjects.length; ++i) {
            data[i] = this.getRowData((PropertiedObject)showingObjects[i]);
        }
        return data;
    }

    protected Object[] getRowData(PropertiedObject node) {
        boolean isDirectoryEntryTable = false;
        if (this.getClass() == DirectoryEntryTable.class) {
            isDirectoryEntryTable = true;
        }
        Object[] rowData = new Object[this.propertyCount];
        Iterator iter = this.propertyDefinitions.iterator();
        for (int i = 0; i < this.propertyCount; ++i) {
            if (i == 0 && isDirectoryEntryTable) {
                rowData[i] = node;
                iter.next();
                continue;
            }
            rowData[i] = this.propertiedObjectEditor.getValue(node, (PropertyDefinition)iter.next());
        }
        return rowData;
    }

    public Object getSelectedObject() {
        Object selectedObject = null;
        if (this.isShowing()) {
            int selectedRow = this.getSelectedRow();
            int modelRow = this.convertRowIndexToModel(selectedRow);
            selectedObject = this.propertiedObjectsArray[modelRow];
        }
        return selectedObject;
    }

    public Object getSelectedObject(int row) {
        Object selectedObject = null;
        if (this.isShowing()) {
            int selectedRow = row;
            int modelRow = this.convertRowIndexToModel(selectedRow);
            selectedObject = this.propertiedObjectsArray[modelRow];
        }
        return selectedObject;
    }

    public Collection getSelectedObjects() {
        int[] selectedRows = this.getSelectedRows();
        int[] selectedModelRows = new int[selectedRows.length];
        for (int row = 0; row < selectedRows.length; ++row) {
            selectedModelRows[row] = this.convertRowIndexToModel(selectedRows[row]);
        }
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedObjects.add(this.propertiedObjectsArray[selectedModelRows[i]]);
        }
        return selectedObjects;
    }

    public void refresh() {
        ArrayList<TableCellRenderer> cellRenderers = new ArrayList<TableCellRenderer>(this.getColumnCount());
        ArrayList<TableCellRenderer> headerRenderers = new ArrayList<TableCellRenderer>(this.getColumnCount());
        int[] widths = new int[this.getColumnCount()];
        int[] maxs = new int[this.getColumnCount()];
        int[] mins = new int[this.getColumnCount()];
        int[] prefs = new int[this.getColumnCount()];
        int i = 0;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            EnhancedTableColumn column = (EnhancedTableColumn)enumeration.nextElement();
            cellRenderers.add(column.getCellRenderer());
            headerRenderers.add(column.getHeaderRenderer());
            maxs[i] = column.getMaxWidth();
            mins[i] = column.getMinWidth();
            prefs[i] = column.getPreferredWidth();
            widths[i++] = column.getWidth();
        }
        DefaultTableModel tableModel = new DefaultTableModel(this.getData(), this.getPropertyDefNames());
        tableModel.setEditable(false);
        this.setModel(tableModel);
        i = 0;
        enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            EnhancedTableColumn column = (EnhancedTableColumn)enumeration.nextElement();
            column.setCellRenderer((TableCellRenderer)cellRenderers.get(i));
            column.setHeaderRenderer((TableCellRenderer)headerRenderers.get(i));
            column.setMaxWidth(maxs[i]);
            column.setMinWidth(mins[i]);
            column.setPreferredWidth(prefs[i]);
            column.setWidth(widths[i++]);
        }
    }

    protected String[] getPropertyDefNames() {
        String[] propDefNames = new String[this.propertyCount];
        Iterator iter = this.propertyDefinitions.iterator();
        for (int i = 0; i < this.propertyCount; ++i) {
            propDefNames[i] = iter.next().toString();
        }
        return propDefNames;
    }

    protected String[] getEmptyTableHeaderArray() {
        String[] emptyTableHeaderArray = new String[]{this.emptyMessage};
        return emptyTableHeaderArray;
    }

    public void setPropertiedObjectEditor(PropertiedObjectEditor editor) {
        this.propertiedObjectEditor = editor;
    }

    public void setTableArray(Collection propertiedObjects) {
        this.setTableArray(propertiedObjects, null, this.propertiedObjectEditor);
    }

    public void setTableArray(Collection propertiedObjects, Collection propDefnsToShow) {
        this.setTableArray(propertiedObjects, propDefnsToShow, this.propertiedObjectEditor);
    }

    public void setTableArray(Collection propertiedObjects, PropertiedObjectEditor editor) {
        this.setTableArray(propertiedObjects, null, editor);
    }

    public void setTableArray(Collection propertiedObjects, Collection propDefnsToShow, PropertiedObjectEditor editor) {
        this.propertiedObjects = propertiedObjects;
        this.propertiedObjectsArray = propertiedObjects.toArray();
        this.propDefnsToShow = propDefnsToShow;
        this.propertiedObjectEditor = editor;
        this.initializePropertiedObjectArrayEntryTable();
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        super.tableChanged(event);
        EnhancedTableColumnModel colModel = this.getEnhancedColumnModel();
        int count = colModel.getColumnCount();
        if (count == 0 || event.getType() != 0 || event.getColumn() >= 0 || event.getFirstRow() >= 0) {
            return;
        }
        TableColumn col = colModel.getColumn(0);
        for (int ndx = 0; ndx < count; ++ndx) {
            col = colModel.getColumn(ndx);
            if (!col.getIdentifier().equals("Name")) continue;
            col.setCellRenderer(this.getCellRenderer());
            break;
        }
    }
}

