/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.widget.ToolBar;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JSeparator;

public class SeparatorWidget
extends JSeparator {
    private boolean getsOrientationFromToolBarParent = false;
    private ToolBar toolbarParent;
    private static final int LEFT_INSET_MINIMUM = 5;
    private static final int RIGHT_INSET_MINIMUM = 5;
    private static final int TOP_INSET_MINIMUM = 0;
    private static final int BOTTOM_INSET_MINIMUM = 0;

    public SeparatorWidget() {
        this(1, 0);
    }

    public SeparatorWidget(int gap) {
        this(1, gap);
    }

    public SeparatorWidget(int orientation, int gap) {
        this(orientation, new Insets(gap, 0, gap, 0));
    }

    public SeparatorWidget(int orientation, Insets insets) {
        super(orientation);
        this.setBorder(insets);
        this.initializeSeparator();
    }

    public SeparatorWidget(ToolBar parent) {
        this(parent, 0);
    }

    public SeparatorWidget(ToolBar parent, int gap) {
        this(parent, new Insets(gap, 0, gap, 0));
    }

    public SeparatorWidget(ToolBar parent, Insets insets) {
        super(1);
        this.getsOrientationFromToolBarParent = true;
        this.toolbarParent = parent;
        this.setBorder(insets);
        this.initializeSeparator();
    }

    protected void initializeSeparator() {
        Insets myInsets = this.getInsets();
        if (myInsets.left < 5) {
            myInsets.left = 5;
        }
        if (myInsets.right < 5) {
            myInsets.right = 5;
        }
        if (myInsets.top < 0) {
            myInsets.top = 0;
        }
        if (myInsets.bottom < 0) {
            myInsets.bottom = 0;
        }
        this.setBorder(myInsets);
    }

    @Override
    public void paint(Graphics g) {
        Dimension s = this.getSize();
        int firstLine = this.getInsets().left;
        int secondLine = firstLine + 1;
        if (this.getOrientation() == 1) {
            g.setColor(this.getBackground().darker().darker().darker());
            g.drawLine(firstLine, this.getInsets().bottom, firstLine, s.height - this.getInsets().top);
            g.setColor(this.getBackground().brighter());
            g.drawLine(secondLine, this.getInsets().bottom, secondLine, s.height - this.getInsets().top);
        } else {
            g.setColor(this.getBackground().darker().darker().darker());
            g.drawLine(this.getInsets().bottom, firstLine, s.width - this.getInsets().top, firstLine);
            g.setColor(this.getBackground().brighter());
            g.drawLine(this.getInsets().bottom, secondLine, s.width - this.getInsets().top, secondLine);
        }
    }

    @Override
    public int getOrientation() {
        if (this.getsOrientationFromToolBarParent) {
            if (this.toolbarParent.getOrientation() == 0) {
                return 1;
            }
            return 0;
        }
        return super.getOrientation();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getOrientation() == 1) {
            return new Dimension(this.getInsets().left + this.getInsets().right + 2, super.getPreferredSize().height);
        }
        return new Dimension(super.getPreferredSize().width, this.getInsets().left + this.getInsets().right + 2);
    }

    public Dimension getMiniumumSize() {
        if (this.getOrientation() == 1) {
            return new Dimension(this.getInsets().left + this.getInsets().right + 2, super.getMinimumSize().height);
        }
        return new Dimension(super.getMinimumSize().width, this.getInsets().left + this.getInsets().right + 2);
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.getOrientation() == 1) {
            return new Dimension(this.getInsets().left + this.getInsets().right + 2, super.getMaximumSize().height);
        }
        return new Dimension(super.getMaximumSize().width, this.getInsets().left + this.getInsets().right + 2);
    }

    public void setBorder(Insets insets) {
        this.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
    }
}

