/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.UIConstants;
import com.metamatrix.toolbox.ui.UIDefaults;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class SpacerWidget
extends JComponent
implements UIConstants {
    public static final int DEFAULT_SPACER_WIDTH = UIDefaults.getInstance().getInt("Spacer.horizontalLength");
    public static final int DEFAULT_SPACER_HEIGHT = new SpacerWidget().getFontMetrics(UIDefaults.getInstance().getFont("normalFont")).getHeight();
    public static final Dimension ZERO_SIZE = new Dimension();
    public static final Dimension INFINITE_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    public static final int CHOICE_INDENT = UIManager.getIcon("CheckBox.icon").getIconWidth() + UIManager.getInt("Button.textIconGap");

    public static SpacerWidget createHorizontalExpandableSpacer() {
        return new SpacerWidget(ZERO_SIZE, ZERO_SIZE, new Dimension(Short.MAX_VALUE, 0));
    }

    public static SpacerWidget createHorizontalSpacer() {
        return new SpacerWidget(new Dimension(DEFAULT_SPACER_WIDTH, 0));
    }

    public static SpacerWidget createHorizontalSpacer(int width) {
        return new SpacerWidget(new Dimension(width, 0));
    }

    public static SpacerWidget createVerticalExpandableSpacer() {
        return new SpacerWidget(ZERO_SIZE, ZERO_SIZE, new Dimension(0, Short.MAX_VALUE));
    }

    public static SpacerWidget createVerticalSpacer() {
        return new SpacerWidget(new Dimension(0, DEFAULT_SPACER_HEIGHT));
    }

    public static SpacerWidget createVerticalSpacer(int height) {
        return new SpacerWidget(new Dimension(0, height));
    }

    public SpacerWidget() {
        this(ZERO_SIZE, ZERO_SIZE, ZERO_SIZE);
    }

    public SpacerWidget(Dimension size) {
        this(size, size, size);
    }

    public SpacerWidget(Dimension minimumSize, Dimension preferredSize, Dimension maximumSize) {
        this.setMinimumSize(minimumSize);
        this.setPreferredSize(preferredSize);
        this.setMaximumSize(maximumSize);
    }
}

