/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.common.properties.TextManager;
import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.ui.UIDefaults;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SplashPanel
extends JPanel {
    private static final String BANNER_PROPERTY = "Icon.splashBanner";
    private static final String IMAGE_PROPERTY = "Icon.splashImage";
    public static final String PROPERTY_PREFIX = "SplashPanel.";
    public static final String BACKGROUND_COLOR_PROPERTY = "SplashPanel.background";
    public static final String FOREGROUND_COLOR_PROPERTY = "SplashPanel.foreground";
    public static final String NAME_FONT_PROPERTY = "SplashPanel.nameFont";
    public static final String LEGAL_TEXT_BACKGROUND_COLOR_PROPERTY = "SplashPanel.legalTextBackground";
    public static final String LEGAL_TEXT_FOREGROUND_COLOR_PROPERTY = "SplashPanel.legalTextForeground";
    public static final String COPYRIGHT_PROPERTY = "SplashPanel.copyright";
    public static final String TRADEMARK_PROPERTY = "SplashPanel.trademark";
    public static final String PENALTY_NOTICE_PROPERTY = "SplashPanel.penaltyNotice";
    public static final String APPLICATION_NAME_PROPERTY = "SplashPanel.applicationName";
    public static final String VERSION_NUMBER_PROPERTY = "SplashPanel.versionNumber";
    public static final String BUILD_NUMBER_PROPERTY = "SplashPanel.buildNumber";
    public static final String NULL_MESSAGE_PROPERTY = "SplashPanel.nullMessage";
    public static final String VERSION_PROPERTY = "SplashPanel.version";
    public static final String LICENSE_PROPERTY = "SplashPanel.license";
    private int wth;

    public SplashPanel() {
        super(null);
        this.initializeSplashPanel();
    }

    protected void addLabel(JPanel panel, String text, Color color, Font font) {
        JLabel label = new JLabel(text, 0);
        label.setForeground(color);
        label.setFont(font);
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, label.getPreferredSize().height));
        panel.add(label);
    }

    protected JPanel addLabels(JPanel panel, String text, Color foregroundColor, Font font, int margin) {
        return this.addLabels(panel, text, panel.getBackground(), foregroundColor, font, margin);
    }

    protected JPanel addLabels(JPanel panel, String text, Color backgroundColor, Color foregroundColor, Font font, int margin) {
        JPanel subPanel = new JPanel(null);
        subPanel.setLayout(new BoxLayout(subPanel, 1));
        subPanel.setBackground(backgroundColor);
        subPanel.setBorder(BorderFactory.createEmptyBorder(margin, 0, 0, 0));
        if (text != null) {
            if (text.trim().length() == 0) {
                this.addLabel(subPanel, text, foregroundColor, font);
            } else {
                FontMetrics metrics = this.getFontMetrics(font);
                StringTokenizer tokens = new StringTokenizer(text, " \n", true);
                if (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    do {
                        String line;
                        boolean fits;
                        boolean bl = fits = metrics.stringWidth(line = token) < this.wth;
                        while (tokens.hasMoreTokens() && fits) {
                            token = tokens.nextToken();
                            if (token.equals(" ")) continue;
                            if (token.equals("\n")) {
                                fits = false;
                                if (!tokens.hasMoreTokens()) continue;
                                token = tokens.nextToken();
                                continue;
                            }
                            String newLine = line + ' ' + token;
                            fits = metrics.stringWidth(newLine) < this.wth;
                            if (!fits) continue;
                            line = newLine;
                        }
                        this.addLabel(subPanel, line, foregroundColor, font);
                    } while (tokens.hasMoreTokens());
                }
            }
        }
        panel.add(subPanel);
        return subPanel;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = this.wth;
        return size;
    }

    protected void initializeSplashPanel() {
        TextManager textMgr = TextManager.INSTANCE;
        UIDefaults dflts = UIDefaults.getInstance();
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(dflts.getColor(BACKGROUND_COLOR_PROPERTY));
        Icon banner = dflts.getIcon(BANNER_PROPERTY);
        this.wth = banner.getIconWidth();
        this.add(new JLabel(banner));
        Font font = dflts.getFont("normalFont");
        int margin = this.getFontMetrics(font).getHeight();
        String name = "Console";
        ApplicationInfo build = ApplicationInfo.getInstance();
        this.validateProperty(name, APPLICATION_NAME_PROPERTY);
        this.validateProperty(build.getReleaseNumber(), VERSION_NUMBER_PROPERTY);
        this.validateProperty(build.getBuildNumber(), BUILD_NUMBER_PROPERTY);
        this.validateProperty(build.getCopyright(), "Copyright");
        JPanel panel = new JPanel(null);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(this.getBackground());
        panel.setBorder(BorderFactory.createEmptyBorder(margin, 0, margin, 0));
        Color color = dflts.getColor(FOREGROUND_COLOR_PROPERTY);
        this.addLabels(panel, name, color, dflts.getFont(NAME_FONT_PROPERTY), 0);
        this.addLabels(panel, textMgr.getText(VERSION_PROPERTY, build.getReleaseNumber(), build), color, font, 0);
        this.add(panel);
        this.add(new JLabel(dflts.getIcon(IMAGE_PROPERTY)));
        panel = new JPanel(null);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(dflts.getColor(LEGAL_TEXT_BACKGROUND_COLOR_PROPERTY));
        color = dflts.getColor(LEGAL_TEXT_FOREGROUND_COLOR_PROPERTY);
        panel.setBorder(BorderFactory.createEmptyBorder(margin /= 2, 0, margin, 0));
        this.addLabels(panel, textMgr.getText(COPYRIGHT_PROPERTY, build.getCopyright()), color, font.deriveFont((float)font.getSize() - 1.0f), 0);
        this.addLabels(panel, textMgr.translate(TRADEMARK_PROPERTY), color, font.deriveFont((float)font.getSize() - 2.0f), margin);
        this.addLabels(panel, textMgr.translate(PENALTY_NOTICE_PROPERTY), color, font.deriveFont((float)font.getSize() - 3.0f), margin);
        this.add(panel);
        int ndx = this.getComponentCount();
        while (--ndx >= 0) {
            ((JComponent)this.getComponent(ndx)).setAlignmentX(0.5f);
        }
    }

    protected void validateProperty(String property, String name) {
        Assertion.isNotNull((Object)property, (String)TextManager.INSTANCE.getText(NULL_MESSAGE_PROPERTY, name));
    }
}

