/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.SplashPanel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class SplashWindow
extends JWindow {
    public static final String PROPERTY_PREFIX = "SplashWindow.";
    public static final String STATUS_MESSAGE_BACKGROUND_COLOR_PROPERTY = "SplashWindow.statusMessageBackground";
    public static final String STATUS_MESSAGE_FOREGROUND_COLOR_PROPERTY = "SplashWindow.statusMessageForeground";
    private SplashPanel splashPanel;
    private JLabel status;

    public SplashWindow() {
        this((String)null);
    }

    public SplashWindow(String message) {
        this.initializeSplashWindow(message);
    }

    protected void initializeSplashWindow(String message) {
        if (message == null) {
            message = " ";
        }
        this.splashPanel = new SplashPanel();
        JPanel statusPanel = new JPanel(null);
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        UIDefaults dflts = UIDefaults.getInstance();
        statusPanel.setBackground(dflts.getColor(STATUS_MESSAGE_BACKGROUND_COLOR_PROPERTY));
        this.status = new JLabel(message, 0);
        this.status.setForeground(dflts.getColor(STATUS_MESSAGE_FOREGROUND_COLOR_PROPERTY));
        Font font = dflts.getFont("Label.font");
        this.status.setFont(font.deriveFont((float)font.getSize() - 1.0f));
        this.status.setMaximumSize(new Dimension(Short.MAX_VALUE, this.status.getPreferredSize().height));
        this.status.setAlignmentX(0.5f);
        statusPanel.add(this.status);
        this.splashPanel.add(statusPanel);
        this.getContentPane().add(this.splashPanel);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getPreferredSize();
        this.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    public void setStatusMessage(String message) {
        if (message == null) {
            message = " ";
        }
        this.status.setText(message);
        this.splashPanel.paintImmediately(this.splashPanel.getBounds());
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.splashPanel.paintImmediately(this.splashPanel.getBounds());
        }
    }
}

