/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.widget.SplitterShadowBorder;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class Splitter
extends JSplitPane {
    public static final String WEIGHT_PROPERTY = "resizeWeight";
    private double weight = -1.0;

    public Splitter() {
        this(1, false, null, null);
    }

    public Splitter(int orientation) {
        this(orientation, false, null, null);
    }

    public Splitter(int orientation, boolean continuousLayout) {
        this(orientation, continuousLayout, null, null);
    }

    public Splitter(int orientation, Component firstComponent, Component secondComponent) {
        this(orientation, false, firstComponent, secondComponent);
    }

    public Splitter(int orientation, boolean continuousLayout, Component firstComponent, Component secondComponent) {
        super(orientation, continuousLayout, firstComponent, secondComponent);
    }

    @Override
    public double getResizeWeight() {
        if (this.weight >= 0.0) {
            return this.weight;
        }
        Component firstComp = this.getLeftComponent();
        int len = this.orientation == 1 ? this.getWidth() : this.getHeight();
        if (firstComp == null || len == 0) {
            return 0.0;
        }
        if (this.orientation == 1) {
            return ((double)firstComp.getWidth() + (double)this.getDividerSize() / 2.0) / (double)len;
        }
        return ((double)firstComp.getHeight() + (double)this.getDividerSize() / 2.0) / (double)len;
    }

    @Override
    public void setDividerLocation(double location) {
        super.setDividerLocation(location);
        this.setResizeWeight(location);
    }

    @Override
    public void setDividerLocation(int location) {
        super.setDividerLocation(location);
    }

    @Override
    public void setResizeWeight(double weight) {
        if (weight < 0.0 || weight > 1.0) {
            throw new IllegalArgumentException("Weight must be between 0 and 1");
        }
        double oldWeight = this.weight;
        this.weight = weight;
        this.firePropertyChange(WEIGHT_PROPERTY, oldWeight, weight);
    }

    @Override
    public void setRightComponent(Component component) {
        int loc = this.getDividerLocation();
        super.setRightComponent(component);
        if (this.isShowing() && loc >= 0) {
            super.setDividerLocation(loc);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof JComponent && !(comp instanceof JSplitPane)) {
            JComponent jcomp = (JComponent)comp;
            jcomp.setBorder(new SplitterShadowBorder());
        }
        super.addImpl(comp, constraints, index);
    }
}

