/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ToolboxPlugin;
import com.metamatrix.toolbox.ui.TextUtilities;
import com.metamatrix.toolbox.ui.UIConstants;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ExtendedBasicTableHeaderUI;
import com.metamatrix.toolbox.ui.widget.MultiLineToolTip;
import com.metamatrix.toolbox.ui.widget.PopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.menu.DefaultPopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableCellEditor;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableCellRenderer;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableColumnModel;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableComparator;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableHeader;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableHeaderRenderer;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableSorter;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableModel;
import com.metamatrix.toolbox.ui.widget.table.TableColumnSortListener;
import com.metamatrix.toolbox.ui.widget.table.TableComparator;
import com.metamatrix.toolbox.ui.widget.table.TableFilter;
import com.metamatrix.toolbox.ui.widget.table.TableHeader;
import com.metamatrix.toolbox.ui.widget.table.TableSorter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableWidget
extends JTable
implements TableColumnSortListener,
UIConstants {
    public static final String PROPERTY_PREFIX = "Table.";
    public static final String CHECKBOX_BORDER_PROPERTY = "Table.checkBoxBorder";
    public static final String FOCUS_BORDER_PROPERTY = "Table.focusCellHighlightBorder";
    public static final String FOCUS_BACKGROUND_PROPERTY = "Table.focusCellBackground";
    public static final String NO_FOCUS_BORDER_PROPERTY = "Table.noFocusBorder";
    private static final boolean NEED_MODIFIED_HEADER_UI;
    private transient List colNames;
    private EnhancedTableModel model;
    private EnhancedTableColumnModel colModel;
    private List filters = null;
    private boolean isSortable = false;
    private TableSorter sorter = null;
    private TableComparator comparator = null;
    private boolean allowsMultipleColumnSorting;
    private List modelRowMap = null;
    private boolean sizingColumns = false;
    private int remainingDeltaColNdx = 0;
    private PopupMenuFactory popupMenuFactory = null;

    public TableWidget() {
        this((List)null, false);
    }

    public TableWidget(List columnNames) {
        this(columnNames, false);
    }

    public TableWidget(TableModel model) {
        this(model, false);
    }

    public TableWidget(boolean isSortable) {
        this((List)null, isSortable);
    }

    public TableWidget(List columnNames, boolean isSortable) {
        this.colNames = columnNames;
        this.isSortable = isSortable;
        this.initializeTableWidget();
    }

    public TableWidget(TableModel model, boolean isSortable) {
        super(model);
        this.isSortable = isSortable;
        this.initializeTableWidget();
    }

    @Override
    public void addColumn(TableColumn column) {
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.createDefaultHeaderRenderer();
            column.setHeaderRenderer(renderer);
        }
        if (column.getHeaderValue() == null) {
            int ndx = column.getModelIndex();
            String name = this.getModel().getColumnName(ndx);
            column.setIdentifier(TextUtilities.getUnformattedText(name));
            if (this.colNames != null && ndx < this.colNames.size()) {
                column.setHeaderValue(this.colNames.get(ndx));
            } else {
                column.setHeaderValue(name);
            }
        }
        this.colModel.addColumn(column);
        int someMinWidth = renderer.getTableCellRendererComponent((JTable)this, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)(this.getColumnCount() - 1)).getMinimumSize().width;
        column.setMinWidth(Math.min(someMinWidth, Short.MAX_VALUE));
    }

    public void addFilter(TableFilter filter) {
        if (filter == null) {
            throw new NullPointerException(ToolboxPlugin.Util.getString("TableWidget.Filter_parameter_cannot_be_null_6"));
        }
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        this.filters.add(filter);
        if (this.modelRowMap == null) {
            this.createModelRowMap();
        } else {
            Vector rows = this.model.getDataVector();
            Iterator iterator = this.modelRowMap.iterator();
            while (iterator.hasNext()) {
                int rowNdx = (Integer)iterator.next();
                if (!filter.isFiltered(rowNdx, (List)rows.get(rowNdx))) continue;
                iterator.remove();
            }
        }
    }

    public boolean allowsMultipleColumnSorting() {
        return this.allowsMultipleColumnSorting;
    }

    public void clearFilters() {
        this.filters = null;
        if (!this.isSorted()) {
            this.modelRowMap = null;
        } else {
            this.createModelRowMap();
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent event) {
        TableColumn col;
        int colNdx = -1;
        JTableHeader hdr = this.getTableHeader();
        if (hdr != null && (col = hdr.getResizingColumn()) != null) {
            colNdx = this.colModel.getColumnIndex(col);
        }
        this.sizeColumnsToFitContainer(colNdx);
    }

    @Override
    public void columnSorted() {
        this.sort();
    }

    @Override
    public int convertRowIndexToModel(int row) {
        if (this.modelRowMap == null) {
            return row;
        }
        return (Integer)this.modelRowMap.get(row);
    }

    @Override
    public int convertRowIndexToView(int row) {
        if (this.modelRowMap == null) {
            return row;
        }
        return this.modelRowMap.indexOf(new Integer(row));
    }

    @Override
    protected final TableColumnModel createDefaultColumnModel() {
        return this.createEnhancedColumnModel();
    }

    @Override
    public void createDefaultColumnsFromModel() {
        this.colModel.removeColumnModelListener(this);
        while (this.colModel.getColumnCount() > 0) {
            this.colModel.removeColumn(this.colModel.getColumn(0));
        }
        for (int ndx = 0; ndx < this.model.getColumnCount(); ++ndx) {
            this.addColumn(new EnhancedTableColumn(ndx));
        }
        this.colModel.addColumnModelListener(this);
    }

    protected TableComparator createDefaultComparator() {
        return DefaultTableComparator.getInstance();
    }

    @Override
    protected final TableModel createDefaultDataModel() {
        return this.createEnhancedModel();
    }

    protected TableCellRenderer createDefaultHeaderRenderer() {
        return DefaultTableHeaderRenderer.getInstance();
    }

    protected PopupMenuFactory createDefaultPopupMenuFactory() {
        return new DefaultPopupMenuFactory();
    }

    @Override
    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new Hashtable();
    }

    protected TableSorter createDefaultSorter() {
        return DefaultTableSorter.getInstance();
    }

    @Override
    protected final JTableHeader createDefaultTableHeader() {
        return new DefaultTableHeader(this.colModel);
    }

    protected EnhancedTableColumnModel createEnhancedColumnModel() {
        this.colModel = new DefaultTableColumnModel();
        return this.colModel;
    }

    protected EnhancedTableModel createEnhancedModel() {
        this.model = new DefaultTableModel();
        return this.model;
    }

    public void createModelRowMap() {
        this.modelRowMap = new ArrayList();
        this.mapModelRows(0, this.model.getRowCount());
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip tip = new MultiLineToolTip();
        tip.setComponent(this);
        return tip;
    }

    public TableComparator getComparator() {
        return this.comparator;
    }

    public EnhancedTableColumnModel getEnhancedColumnModel() {
        return this.colModel;
    }

    public EnhancedTableModel getEnhancedModel() {
        return this.model;
    }

    public List getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public int getHiddenColumnCount() {
        return this.colModel.getHiddenColumnCount();
    }

    public List getHiddenColumns() {
        return this.colModel.getHiddenColumns();
    }

    public PopupMenuFactory getPopupMenuFactory() {
        return this.popupMenuFactory;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getWidth() == 0) {
            return super.getPreferredSize();
        }
        return new Dimension(this.getWidth(), super.getPreferredSize().height);
    }

    @Override
    public int getRowCount() {
        if (this.modelRowMap == null) {
            return super.getRowCount();
        }
        return this.modelRowMap.size();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getSortedColumnCount() {
        return this.colModel.getSortedColumnCount();
    }

    public List getSortedColumns() {
        return this.colModel.getSortedColumns();
    }

    public TableSorter getSorter() {
        return this.sorter;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.getValueAt(this.convertRowIndexToModel(rowIndex), this.convertColumnIndexToModel(columnIndex));
    }

    protected void increaseColumnSize(int index, int width) {
        TableColumn col = this.colModel.getColumn(index);
        col.setWidth(col.getWidth() + width);
    }

    protected void initializeTableWidget() {
        this.allowsMultipleColumnSorting = true;
        if (this.colNames != null) {
            Vector<String> colIDs = new Vector<String>(this.colNames.size());
            Iterator nameIterator = this.colNames.iterator();
            while (nameIterator.hasNext()) {
                colIDs.add(TextUtilities.getUnformattedText((String)nameIterator.next()));
            }
            this.model.setColumnIdentifiers(colIDs);
        }
        this.setTableHeader(this.createDefaultTableHeader());
        this.sorter = this.createDefaultSorter();
        this.comparator = this.createDefaultComparator();
        this.setSortable(this.isSortable);
        this.setPopupMenuFactory(this.createDefaultPopupMenuFactory());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent event) {
                JPopupMenu popup;
                if (!SwingUtilities.isRightMouseButton(event)) {
                    return;
                }
                int colNdx = TableWidget.this.columnAtPoint(event.getPoint());
                int rowNdx = TableWidget.this.rowAtPoint(event.getPoint());
                if (!TableWidget.this.isCellSelected(rowNdx, colNdx)) {
                    TableWidget.this.setColumnSelectionInterval(colNdx, colNdx);
                    TableWidget.this.setRowSelectionInterval(rowNdx, rowNdx);
                }
                if (TableWidget.this.popupMenuFactory != null && (popup = TableWidget.this.popupMenuFactory.getPopupMenu(TableWidget.this)) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            popup.show(TableWidget.this, event.getX(), event.getY());
                        }
                    });
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){
            private Container parent;
            private ComponentAdapter compListener;

            @Override
            public void ancestorAdded(AncestorEvent event) {
                this.parent = TableWidget.this.getParent();
                TableWidget.this.sizeColumnsToFitContainer(-1);
                this.compListener = new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent event) {
                        TableWidget.this.sizeColumnsToFitContainer(-1);
                    }
                };
                this.parent.addComponentListener(this.compListener);
                if (this.parent instanceof JViewport) {
                    final JScrollPane scroller = (JScrollPane)this.parent.getParent();
                    if (this.parent.getParent() == null) {
                        TableWidget.this.addAncestorListener(new AncestorListener(){

                            @Override
                            public void ancestorAdded(AncestorEvent event) {
                                TableWidget.this.sizeColumnsToFitViewport(scroller);
                            }

                            @Override
                            public void ancestorMoved(AncestorEvent event) {
                            }

                            @Override
                            public void ancestorRemoved(AncestorEvent event) {
                            }
                        });
                    } else {
                        TableWidget.this.sizeColumnsToFitViewport(scroller);
                    }
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                this.parent.removeComponentListener(this.compListener);
            }
        });
        this.setDefaultEditor(Object.class, new DefaultTableCellEditor());
        this.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.colModel.setColumnMargin(UIDefaults.getInstance().getInt("Spacer.horizontalLength") / 2);
        if (NEED_MODIFIED_HEADER_UI) {
            this.getTableHeader().setUI(new ExtendedBasicTableHeaderUI());
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.model.isCellEditable(this.convertRowIndexToModel(rowIndex), this.convertColumnIndexToModel(columnIndex));
    }

    public boolean isColumnEditable(int columnIndex) {
        return this.model.isColumnEditable(this.convertColumnIndexToModel(columnIndex));
    }

    public boolean isEditable() {
        return this.model.isEditable();
    }

    protected boolean isFiltered(int rowIndex, List row) {
        if (this.filters == null) {
            return false;
        }
        Iterator iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            if (!((TableFilter)iterator.next()).isFiltered(rowIndex, row)) continue;
            return true;
        }
        return false;
    }

    public boolean isFilteredBy(TableFilter filter) {
        return this.filters.contains(filter);
    }

    public boolean isRowEditable(int rowIndex) {
        return this.model.isRowEditable(this.convertRowIndexToModel(rowIndex));
    }

    public boolean isSorted() {
        return this.colModel.getSortedColumnCount() > 0;
    }

    public boolean isSortable() {
        return this.isSortable;
    }

    protected void mapModelRows(int firstRowIndex, int rowCount) {
        List sortedCols = this.colModel.getSortedColumns();
        Vector rows = this.model.getDataVector();
        ListIterator iterator = rows.listIterator(firstRowIndex);
        for (int rowNdx = firstRowIndex; rowNdx < firstRowIndex + rowCount; ++rowNdx) {
            List row = (List)iterator.next();
            if (this.isFiltered(rowNdx, row)) continue;
            if (this.isSortable) {
                this.modelRowMap.add(this.sorter.getInsertionIndex(row, rows, this.modelRowMap, sortedCols, this.comparator, this.modelRowMap.size()), new Integer(rowNdx));
                continue;
            }
            this.modelRowMap.add(new Integer(rowNdx));
        }
    }

    public void removeFilter(TableFilter filter) {
        this.filters.remove(filter);
        if (this.filters.size() == 0) {
            this.filters = null;
            if (!this.isSorted()) {
                this.modelRowMap = null;
            } else {
                this.createModelRowMap();
            }
        } else {
            this.createModelRowMap();
        }
    }

    public void setAllowsMultipleColumnSorting(boolean allowsMultipleColumnSorting) {
        this.allowsMultipleColumnSorting = allowsMultipleColumnSorting;
    }

    public void setCellEditable(int rowIndex, int columnIndex, boolean isEditable) {
        this.model.setCellEditable(this.convertRowIndexToModel(rowIndex), this.convertColumnIndexToModel(columnIndex), isEditable);
    }

    public void setColumnEditable(int columnIndex, boolean isEditable) {
        this.model.setColumnEditable(this.convertColumnIndexToModel(columnIndex), isEditable);
    }

    public void setColumnHidden(EnhancedTableColumn column, boolean isHidden) {
        this.colModel.setColumnHidden(column, isHidden);
    }

    @Override
    public void setColumnModel(TableColumnModel model) {
        if (!(model instanceof EnhancedTableColumnModel)) {
            throw new IllegalArgumentException(ToolboxPlugin.Util.getString("TableWidget.Model_parameter_must_be_an_instance_of__7") + EnhancedTableColumnModel.class);
        }
        this.colModel = (EnhancedTableColumnModel)model;
        this.colModel.addColumnSortListener(this);
        super.setColumnModel(model);
    }

    public void setColumnNotSorted(EnhancedTableColumn column) {
        this.colModel.setColumnNotSorted(column, false);
    }

    public void setColumnNotSorted(EnhancedTableColumn column, boolean isCurrentColumnSortOrderKept) {
        this.colModel.setColumnNotSorted(column, isCurrentColumnSortOrderKept);
    }

    public void setColumnSortedAscending(EnhancedTableColumn column) {
        this.colModel.setColumnSortedAscending(column, false);
    }

    public void setColumnSortedAscending(EnhancedTableColumn column, boolean isCurrentColumnSortOrderKept) {
        this.colModel.setColumnSortedAscending(column, isCurrentColumnSortOrderKept);
    }

    public void setColumnSortedDescending(EnhancedTableColumn column) {
        this.colModel.setColumnSortedDescending(column, false);
    }

    public void setColumnSortedDescending(EnhancedTableColumn column, boolean isCurrentColumnSortOrderKept) {
        this.colModel.setColumnSortedDescending(column, isCurrentColumnSortOrderKept);
    }

    public void setColumnsHidden(boolean isHidden) {
        this.colModel.setColumnsHidden(isHidden);
    }

    public void setColumnsNotSorted() {
        this.colModel.setColumnsNotSorted();
    }

    public void setComparator(TableComparator comparator) {
        this.comparator = comparator == null ? this.createDefaultComparator() : comparator;
        if (this.isSorted()) {
            this.sort();
        }
    }

    public void setEditable(boolean isEditable) {
        this.model.setEditable(isEditable);
    }

    @Override
    public void setModel(TableModel model) {
        EnhancedTableColumn col;
        Enumeration<TableColumn> iterator2;
        if (!(model instanceof EnhancedTableModel)) {
            throw new IllegalArgumentException(ToolboxPlugin.Util.getString("TableWidget.Model_parameter_must_be_an_instance_of__8") + EnhancedTableModel.class);
        }
        ArrayList<TableColumn> cols = new ArrayList<TableColumn>(this.colModel.getColumnCount());
        Enumeration<TableColumn> iter = this.colModel.getColumns();
        while (iter.hasMoreElements()) {
            cols.add(iter.nextElement());
        }
        List sortedCols = this.colModel.getSortedColumns();
        List hiddenCols = this.colModel.getHiddenColumns();
        this.colModel.setColumnsHidden(false);
        this.model = (EnhancedTableModel)model;
        super.setModel(model);
        this.modelRowMap = null;
        if (sortedCols != null) {
            this.colModel.setColumnsNotSorted();
            block1: for (EnhancedTableColumn enhancedTableColumn : sortedCols) {
                iterator2 = this.colModel.getColumns();
                while (iterator2.hasMoreElements()) {
                    col = (EnhancedTableColumn)iterator2.nextElement();
                    if (!col.getIdentifier().equals(enhancedTableColumn.getIdentifier())) continue;
                    if (enhancedTableColumn.isSortedAscending()) {
                        this.colModel.setColumnSortedAscending(col, true);
                        continue block1;
                    }
                    this.colModel.setColumnSortedDescending(col, true);
                    continue block1;
                }
            }
        }
        if (this.modelRowMap == null && this.filters != null && this.filters.size() > 0) {
            this.createModelRowMap();
        }
        if (hiddenCols != null) {
            this.colModel.setColumnsHidden(false);
            block3: for (EnhancedTableColumn enhancedTableColumn : hiddenCols) {
                iterator2 = this.colModel.getColumns();
                while (iterator2.hasMoreElements()) {
                    col = (EnhancedTableColumn)iterator2.nextElement();
                    if (!col.getIdentifier().equals(enhancedTableColumn.getIdentifier())) continue;
                    this.colModel.setColumnHidden(col, true);
                    continue block3;
                }
            }
        }
        iter = this.colModel.getColumns();
        block5: while (iter.hasMoreElements()) {
            col = (EnhancedTableColumn)iter.nextElement();
            for (EnhancedTableColumn enhancedTableColumn : cols) {
                if (!col.getIdentifier().equals(enhancedTableColumn.getIdentifier())) continue;
                col.setWidth(enhancedTableColumn.getWidth());
                continue block5;
            }
        }
    }

    public void setPopupMenuFactory(PopupMenuFactory popupMenuFactory) {
        this.popupMenuFactory = popupMenuFactory;
    }

    public void setRowEditable(int rowIndex, boolean isEditable) {
        this.model.setRowEditable(this.convertRowIndexToModel(rowIndex), isEditable);
    }

    public void setSortable(boolean isSortable) {
        JTableHeader hdr;
        this.isSortable = isSortable;
        if (isSortable) {
            if (this.filters == null) {
                this.modelRowMap = null;
            }
        } else if (this.isSorted()) {
            this.sort();
        }
        if ((hdr = this.getTableHeader()) != null) {
            hdr.repaint();
        }
    }

    public void setSorter(TableSorter sorter) {
        this.sorter = sorter == null ? this.createDefaultSorter() : sorter;
        if (this.isSorted()) {
            this.sort();
        }
    }

    public void unsortAll() {
        ((EnhancedTableColumnModel)this.getColumnModel()).setColumnsNotSorted();
        this.sort();
        this.resizeAndRepaint();
    }

    @Override
    public void setTableHeader(JTableHeader header) {
        if (!(header instanceof TableHeader)) {
            throw new IllegalArgumentException(ToolboxPlugin.Util.getString("TableWidget.Model_parameter_must_be_an_instance_of__9") + TableHeader.class);
        }
        super.setTableHeader(header);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.model.setValueAt(value, this.convertRowIndexToModel(rowIndex), this.convertColumnIndexToModel(columnIndex));
    }

    protected int sizeColumnToFitDataInternal(EnhancedTableColumn column, int count) {
        int modelColNdx = column.getModelIndex();
        int colNdx = this.convertColumnIndexToView(modelColNdx);
        TableCellRenderer renderer = column.getCellRenderer();
        if (renderer == null) {
            renderer = this.getDefaultRenderer(this.getModel().getColumnClass(modelColNdx));
        }
        int maxWth = column.getMinWidth();
        count = Math.min(count, this.getRowCount());
        for (int rowNdx = 0; rowNdx < count; ++rowNdx) {
            Component component = renderer.getTableCellRendererComponent(this, this.getValueAt(rowNdx, colNdx), false, false, rowNdx, colNdx);
            int preferredWidth = component.getPreferredSize().width;
            if (preferredWidth >= Short.MAX_VALUE) continue;
            maxWth = Math.max(maxWth, preferredWidth);
        }
        column.setPreferredWidth(maxWth += this.colModel.getColumnMargin());
        return colNdx;
    }

    public void sizeColumnToFitData(EnhancedTableColumn column) {
        this.sizeColumnToFitData(column, this.getRowCount());
    }

    public void sizeColumnToFitData(final EnhancedTableColumn column, final int count) {
        if (this.isShowing()) {
            this.sizeColumnsToFitContainer(this.sizeColumnToFitDataInternal(column, count));
        } else {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent event) {
                    TableWidget.this.sizeColumnToFitData(column, count);
                    TableWidget.this.removeComponentListener(this);
                }
            });
        }
    }

    @Override
    public void sizeColumnsToFit(int resizedColumnIndex) {
        this.sizeColumnsToFitContainer(resizedColumnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sizeColumnsToFitContainer(int resizedColumnIndex) {
        int count = this.colModel.getColumnCount();
        if (this.sizingColumns || count == 0) {
            return;
        }
        this.sizingColumns = true;
        try {
            int hgt;
            Container parent;
            boolean oldJDK;
            int wth = this.colModel.getTotalColumnWidth();
            boolean bl = oldJDK = System.getProperty("java.version").compareTo("1.3") < 0;
            if (oldJDK) {
                wth -= this.colModel.getColumnMargin() * count;
            }
            if ((parent = this.getParent()) != null && wth < parent.getWidth()) {
                int parentWth = parent.getWidth();
                int delta = parentWth - wth;
                int mode = this.getAutoResizeMode();
                if (mode == 3) {
                    if (resizedColumnIndex == count - 1) {
                        this.increaseColumnSize(0, delta);
                    } else {
                        this.increaseColumnSize(count - 1, delta);
                    }
                } else if (mode == 1 && resizedColumnIndex >= 0) {
                    if (count == 1) {
                        this.increaseColumnSize(0, delta);
                    } else if (resizedColumnIndex == count - 1) {
                        this.increaseColumnSize(resizedColumnIndex - 1, delta);
                    } else {
                        this.increaseColumnSize(resizedColumnIndex + 1, delta);
                    }
                } else {
                    TableColumn col;
                    int lastNdx;
                    int firstNdx;
                    if (count == 1) {
                        firstNdx = 0;
                        lastNdx = 1;
                    } else if (resizedColumnIndex == count - 1) {
                        firstNdx = 0;
                        lastNdx = count - 1;
                    } else {
                        firstNdx = resizedColumnIndex + 1;
                        lastNdx = count;
                    }
                    int maxWth = 0;
                    for (int ndx = firstNdx; ndx < lastNdx; ++ndx) {
                        maxWth += this.colModel.getColumn(ndx).getMaxWidth();
                    }
                    double pctDelta = (double)delta / (double)(maxWth - wth);
                    wth = 0;
                    int expandableCols = 0;
                    for (int ndx = 0; ndx < count; ++ndx) {
                        col = this.colModel.getColumn(ndx);
                        if (ndx >= firstNdx && ndx < lastNdx) {
                            col.setWidth(col.getWidth() + (int)((double)(col.getMaxWidth() - col.getWidth()) * pctDelta));
                            if (col.getWidth() < col.getMaxWidth()) {
                                ++expandableCols;
                            }
                        }
                        wth += col.getWidth();
                    }
                    delta = parentWth - wth;
                    this.remainingDeltaColNdx %= count;
                    while (expandableCols > 0 && delta > 0) {
                        if (this.remainingDeltaColNdx >= firstNdx && this.remainingDeltaColNdx < lastNdx && (col = this.colModel.getColumn(this.remainingDeltaColNdx)).getWidth() < col.getMaxWidth()) {
                            --delta;
                            col.setWidth(col.getWidth() + 1);
                            if (col.getWidth() == col.getMaxWidth()) {
                                --expandableCols;
                            }
                        }
                        this.remainingDeltaColNdx = (this.remainingDeltaColNdx + 1) % count;
                    }
                    this.remainingDeltaColNdx %= count;
                    while (delta > 0) {
                        if (this.remainingDeltaColNdx >= firstNdx && this.remainingDeltaColNdx < lastNdx) {
                            col = this.colModel.getColumn(this.remainingDeltaColNdx);
                            --delta;
                            col.setWidth(col.getWidth() + 1);
                        }
                        this.remainingDeltaColNdx = (this.remainingDeltaColNdx + 1) % count;
                    }
                }
                wth = parentWth;
            }
            if ((hgt = this.getHeight()) == 0) {
                hgt = this.getPreferredSize().height;
            }
            this.setSize(wth, hgt);
            this.resizeAndRepaint();
            JTableHeader hdr = this.getTableHeader();
            if (hdr != null) {
                hdr.setPreferredSize(null);
                hdr.setPreferredSize(new Dimension(wth, hdr.getPreferredSize().height));
                hdr.repaint();
            }
        }
        finally {
            this.sizingColumns = false;
        }
    }

    public void sizeColumnsToFitData() {
        this.sizeColumnsToFitData(this.getRowCount());
    }

    public void sizeColumnsToFitData(final int count) {
        if (this.isShowing()) {
            Enumeration<TableColumn> iterator = this.colModel.getColumns();
            while (iterator.hasMoreElements()) {
                this.sizeColumnToFitDataInternal((EnhancedTableColumn)iterator.nextElement(), count);
            }
            this.sizeColumnsToFitContainer(-1);
        } else {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent event) {
                    TableWidget.this.sizeColumnsToFitData(count);
                    TableWidget.this.removeComponentListener(this);
                }
            });
        }
    }

    protected void sizeColumnsToFitViewport(JScrollPane scroller) {
        final JScrollBar bar = scroller.getVerticalScrollBar();
        bar.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent event) {
                int wth = TableWidget.this.colModel.getTotalColumnWidth();
                Container parent = TableWidget.this.getParent();
                if (parent == null) {
                    return;
                }
                int parentWth = parent.getWidth();
                int delta = wth - parentWth;
                if (delta != bar.getWidth()) {
                    return;
                }
                int minWth = 0;
                Enumeration<TableColumn> iter = TableWidget.this.colModel.getColumns();
                while (iter.hasMoreElements()) {
                    minWth += iter.nextElement().getMinWidth();
                }
                if (wth - delta < minWth) {
                    return;
                }
                int ndx = TableWidget.this.colModel.getColumnCount();
                while (--ndx >= 0 && delta > 0) {
                    TableColumn col = TableWidget.this.colModel.getColumn(ndx);
                    int colDelta = Math.max(col.getMinWidth(), col.getWidth() - delta);
                    col.setWidth(colDelta);
                    delta -= colDelta;
                }
                int hgt = TableWidget.this.getHeight();
                if (hgt == 0) {
                    hgt = TableWidget.this.getPreferredSize().height;
                }
                TableWidget.this.setSize(parentWth, hgt);
                TableWidget.this.resizeAndRepaint();
                JTableHeader hdr = TableWidget.this.getTableHeader();
                if (hdr != null) {
                    hdr.setPreferredSize(null);
                    hdr.setPreferredSize(new Dimension(parentWth, hdr.getPreferredSize().height));
                    hdr.repaint();
                }
            }
        });
    }

    public void sort() {
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            return;
        }
        int[] tmpSelectedRows = this.getSelectedRows();
        this.clearSelection();
        Object[] selectedRows = new Object[tmpSelectedRows.length];
        if (this.modelRowMap == null) {
            int ndx = selectedRows.length;
            while (--ndx >= 0) {
                selectedRows[ndx] = new Integer(tmpSelectedRows[ndx]);
            }
            this.createModelRowMap();
        } else {
            int ndx = selectedRows.length;
            while (--ndx >= 0) {
                selectedRows[ndx] = this.modelRowMap.get(tmpSelectedRows[ndx]);
            }
            Vector rows = this.model.getDataVector();
            List sortedCols = this.colModel.getSortedColumns();
            for (int ndx2 = 0; ndx2 < this.modelRowMap.size(); ++ndx2) {
                int rowNdx = (Integer)this.modelRowMap.remove(ndx2);
                this.modelRowMap.add(this.sorter.getInsertionIndex((List)rows.get(rowNdx), rows, this.modelRowMap, sortedCols, this.comparator, ndx2), new Integer(rowNdx));
            }
        }
        int ndx = selectedRows.length;
        while (--ndx >= 0) {
            int rowNdx = this.modelRowMap.indexOf(selectedRows[ndx]);
            this.addRowSelectionInterval(rowNdx, rowNdx);
        }
        if (selectedRows.length > 0) {
            this.scrollRectToVisible(this.getCellRect(this.modelRowMap.indexOf(selectedRows[0]), 0, true));
        }
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        super.tableChanged(event);
        if (event.getType() == 0 && event.getFirstRow() == -1) {
            this.sizeColumnsToFitContainer(-1);
        }
        if (this.modelRowMap == null) {
            return;
        }
        int type = event.getType();
        if (type == 1) {
            int firstRowNdx = event.getFirstRow();
            int rowCount = event.getLastRow() - firstRowNdx + 1;
            ListIterator<Integer> iterator = this.modelRowMap.listIterator();
            while (iterator.hasNext()) {
                int rowNdx = (Integer)iterator.next();
                if (rowNdx < firstRowNdx) continue;
                iterator.set(new Integer(rowNdx + rowCount));
            }
            this.mapModelRows(firstRowNdx, rowCount);
        } else if (type == -1) {
            int firstRowNdx = event.getFirstRow();
            int rowCount = event.getLastRow() - firstRowNdx + 1;
            ListIterator<Integer> iterator = this.modelRowMap.listIterator();
            while (iterator.hasNext()) {
                int rowNdx = (Integer)iterator.next();
                if (rowNdx < firstRowNdx) continue;
                if (rowNdx >= firstRowNdx + rowCount) {
                    iterator.set(new Integer(rowNdx - rowCount));
                    continue;
                }
                iterator.remove();
            }
        }
    }

    static {
        boolean isGreater = false;
        String versStr = System.getProperty("java.version");
        int lastPosit = versStr.length() - 1;
        int numPeriods = 0;
        String substring = null;
        for (int posit = 0; posit <= lastPosit && numPeriods < 2; ++posit) {
            char curChar = versStr.charAt(posit);
            if (curChar != '.' || ++numPeriods != 2) continue;
            substring = versStr.substring(0, posit);
        }
        if (substring == null) {
            substring = versStr;
        }
        substring = substring.trim();
        Float versFloat = null;
        try {
            versFloat = new Float(substring);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (versFloat != null) {
            float vers = versFloat.floatValue();
            isGreater = (double)vers > 1.3;
        }
        NEED_MODIFIED_HEADER_UI = isGreater;
    }
}

