/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.MultiLineToolTip;
import com.metamatrix.toolbox.ui.widget.text.DefaultTextFieldModel;
import com.metamatrix.toolbox.ui.widget.text.TextConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class TextFieldWidget
extends JTextField
implements TextConstants {
    public static final String PROPERTY_PREFIX = "TextField.";
    public static final String BACKGROUND_COLOR_PROPERTY = "TextField.background";
    public static final String FOREGROUND_COLOR_PROPERTY = "TextField.foreground";
    public static final String INVALID_BACKGROUND_COLOR_PROPERTY = "TextField.invalidBackgroundColor";
    public static final String INVALID_FOREGROUND_COLOR_PROPERTY = "TextField.invalidForegroundColor";
    public static final String COLUMN_WIDTH_CHARACTER_PROPERTY = "TextField.columnWidthCharacter";
    private char colWthChr;
    private int colWth;
    private boolean isClipTipEnabled;
    private boolean isErrorTipEnabled;
    private JPopupMenu menu;
    private MouseListener menuCtrlr;
    private int maxLen;

    public TextFieldWidget() {
        this(null, 0);
    }

    public TextFieldWidget(String text) {
        this(text, text.length());
    }

    public TextFieldWidget(int characters) {
        this(null, characters);
    }

    public TextFieldWidget(String text, int characters) {
        super(text, characters);
        this.initializeTextFieldWidget();
    }

    protected void buildContextMenu() {
        this.menu = new JPopupMenu();
        Action[] actions = this.getActions();
        this.menu.add(this.getAction(actions, "cut"));
        this.menu.add(this.getAction(actions, "copy"));
        this.menu.add(this.getAction(actions, "paste"));
    }

    @Override
    public void paste() {
        super.paste();
        this.fireActionPerformed();
    }

    @Override
    public void cut() {
        super.cut();
        this.fireActionPerformed();
    }

    public boolean commit() {
        Document doc = this.getDocument();
        if (doc instanceof DefaultTextFieldModel) {
            DefaultTextFieldModel model = (DefaultTextFieldModel)doc;
            if (!model.isValid()) {
                return false;
            }
            model.commit();
        }
        return true;
    }

    @Override
    protected Document createDefaultModel() {
        return new DefaultTextFieldModel();
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip tip = new MultiLineToolTip();
        tip.setComponent(this);
        return tip;
    }

    private Action getAction(Action[] actions, String name) {
        Action action = null;
        int ndx = actions.length;
        while (--ndx >= 0 && !((String)(action = actions[ndx]).getValue("Name")).startsWith(name)) {
        }
        return action;
    }

    @Override
    public int getColumnWidth() {
        if (this.colWth == 0) {
            this.colWth = this.getFontMetrics(this.getFont()).stringWidth("" + this.colWthChr);
        }
        return this.colWth;
    }

    public char getColumnWidthCharacter() {
        return this.colWthChr;
    }

    public JPopupMenu getContextMenu() {
        return this.menu;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size = super.getMaximumSize();
        Dimension prefSize = this.getPreferredSize();
        size.height = prefSize.height;
        size.width = Math.max(size.width, prefSize.width);
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.height = this.getPreferredSize().height;
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Insets insets = this.getInsets();
        int minWth = insets.left + insets.right + 2;
        int cols = this.getColumns();
        size.width = cols > 0 ? minWth + this.getColumnWidth() * cols : (this.maxLen > 0 ? minWth + this.maxLen * this.getColumnWidth() : Math.max(size.width, minWth));
        return size;
    }

    protected void initializeTextFieldWidget() {
        final UIDefaults dflts = UIDefaults.getInstance();
        this.setMaximumWidth(Short.MAX_VALUE);
        this.setColumnWidthCharacter(dflts.getChar(COLUMN_WIDTH_CHARACTER_PROPERTY));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TextFieldWidget.this.validateModel();
                TextFieldWidget.this.commit();
                TextFieldWidget.this.selectText();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
                TextFieldWidget.this.selectText();
            }

            @Override
            public void focusLost(FocusEvent event) {
                if (!event.isTemporary()) {
                    TextFieldWidget.this.validateModel();
                    TextFieldWidget.this.commit();
                }
            }
        });
        this.setContextMenuEnabled(true);
        this.isClipTipEnabled = true;
        Document model = this.getDocument();
        if (model instanceof DefaultTextFieldModel) {
            final DefaultTextFieldModel dfltModel = (DefaultTextFieldModel)model;
            dfltModel.setModified(false);
            dfltModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    String prop = event.getPropertyName();
                    if (prop.equals("valid")) {
                        if (!dfltModel.isValid()) {
                            Object validationResult;
                            TextFieldWidget.this.setBackground(dflts.getColor(TextFieldWidget.INVALID_BACKGROUND_COLOR_PROPERTY));
                            TextFieldWidget.this.setForeground(dflts.getColor(TextFieldWidget.INVALID_FOREGROUND_COLOR_PROPERTY));
                            if (TextFieldWidget.this.isErrorTipEnabled && (validationResult = dfltModel.getValidationResult()) != null) {
                                if (validationResult instanceof Throwable) {
                                    TextFieldWidget.this.setToolTipText(((Throwable)validationResult).getMessage());
                                } else {
                                    TextFieldWidget.this.setToolTipText(validationResult.toString());
                                }
                            }
                        } else {
                            TextFieldWidget.this.setBackground(dflts.getColor(TextFieldWidget.BACKGROUND_COLOR_PROPERTY));
                            TextFieldWidget.this.setForeground(dflts.getColor(TextFieldWidget.FOREGROUND_COLOR_PROPERTY));
                            TextFieldWidget.this.setClipTipText();
                        }
                    } else if (prop.equals("maximumLength")) {
                        TextFieldWidget.this.maxLen = (Integer)event.getNewValue();
                        TextFieldWidget.this.revalidate();
                    }
                }
            });
        }
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TextFieldWidget.this.rollback();
                TextFieldWidget.this.validateModel();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 0);
    }

    public boolean isClipTipEnabled() {
        return this.isClipTipEnabled;
    }

    public boolean isContextMenuEnabled() {
        return this.menu != null;
    }

    public boolean isErrorTipEnabled() {
        return this.isErrorTipEnabled;
    }

    public boolean isTextValid() {
        Document model = this.getDocument();
        if (model instanceof DefaultTextFieldModel) {
            return ((DefaultTextFieldModel)model).isValid();
        }
        return true;
    }

    public void rollback() {
        try {
            Document model = this.getDocument();
            if (model instanceof DefaultTextFieldModel) {
                ((DefaultTextFieldModel)model).rollback();
            }
            this.selectText();
        }
        catch (Exception err) {
            throw new RuntimeException(err.getMessage());
        }
    }

    @Override
    public void scrollRectToVisible(Rectangle rectangle) {
        super.scrollRectToVisible(rectangle);
        this.setClipTipText();
    }

    public void selectText() {
        this.setCaretPosition(this.getDocument().getLength());
        this.moveCaretPosition(0);
    }

    public void setClipTipEnabled(boolean isClipTipEnabled) {
        this.isClipTipEnabled = isClipTipEnabled;
    }

    protected void setClipTipText() {
        Document model = this.getDocument();
        if (this.isErrorTipEnabled && model instanceof DefaultTextFieldModel && ((DefaultTextFieldModel)model).getValidationResult() != null || !this.isClipTipEnabled) {
            return;
        }
        BoundedRangeModel range = this.getHorizontalVisibility();
        if (range.getValueIsAdjusting()) {
            return;
        }
        if (range.getExtent() < range.getMaximum() - 1 || range.getValue() > range.getMinimum()) {
            this.setToolTipText(this.getText());
        } else {
            this.setToolTipText(null);
        }
    }

    public void setColumnWidth(int width) {
        this.colWth = width;
        this.invalidate();
    }

    public void setColumnWidthCharacter(char character) {
        this.colWthChr = character;
        this.setColumnWidth(0);
    }

    public void setContextMenuEnabled(boolean isMenuEnabled) {
        if (isMenuEnabled) {
            this.buildContextMenu();
            this.menuCtrlr = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (SwingUtilities.isLeftMouseButton(event) || SwingUtilities.isMiddleMouseButton(event) || !SwingUtilities.isRightMouseButton(event)) {
                        return;
                    }
                    TextFieldWidget.this.setCaretPosition(TextFieldWidget.this.getDocument().getLength());
                    TextFieldWidget.this.moveCaretPosition(0);
                    TextFieldWidget.this.menu.show(TextFieldWidget.this, event.getX(), event.getY());
                }
            };
            this.addMouseListener(this.menuCtrlr);
        } else {
            this.menu = null;
            this.menuCtrlr = null;
        }
    }

    public void setErrorTipEnabled(boolean isErrorTipEnabled) {
        this.isErrorTipEnabled = isErrorTipEnabled;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.colWth = 0;
    }

    public void setInvalidCharacters(String invalidCharacters) throws ParseException {
        Document model = this.getDocument();
        if (!(model instanceof DefaultTextFieldModel)) {
            throw new UnsupportedOperationException("Method only supported when using a DefaultTextFieldModel.");
        }
        ((DefaultTextFieldModel)model).setInvalidCharacters(invalidCharacters);
    }

    @Override
    public void setMaximumSize(Dimension size) {
        super.setMaximumSize(new Dimension(size.width, this.getPreferredSize().height));
    }

    public void setMaximumWidth(int width) {
        this.setMaximumSize(new Dimension(width, this.getPreferredSize().height));
    }

    @Override
    public void setMinimumSize(Dimension size) {
        super.setMinimumSize(new Dimension(size.width, this.getPreferredSize().height));
    }

    public void setMinimumWidth(int width) {
        this.setMinimumSize(new Dimension(width, this.getPreferredSize().height));
    }

    @Override
    public void setPreferredSize(Dimension size) {
        super.setPreferredSize(new Dimension(size.width, this.getPreferredSize().height));
    }

    public void setPreferredWidth(int width) {
        this.setPreferredSize(new Dimension(width, this.getPreferredSize().height));
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.isTextValid();
    }

    public void setValidCharacters(String validCharacters) throws ParseException {
        Document model = this.getDocument();
        if (!(model instanceof DefaultTextFieldModel)) {
            throw new UnsupportedOperationException("Method only supported when using a DefaultTextFieldModel.");
        }
        ((DefaultTextFieldModel)model).setValidCharacters(validCharacters);
    }

    @Override
    public String toString() {
        return this.getText();
    }

    protected void validateModel() {
        Document model = this.getDocument();
        if (model instanceof DefaultTextFieldModel) {
            ((DefaultTextFieldModel)model).isValid();
        }
    }
}

