/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.StringReader;
import javax.swing.JTextPane;
import javax.swing.RepaintManager;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public class TextPane
extends JTextPane
implements Printable {
    private String sPrintHeader = "";
    private int iTitlePos = 0;
    private LabelWidget lblTitle;

    public TextPane() {
        Dimension max = this.getMaximumSize();
        this.setMaximumSize(new Dimension(900, max.height));
    }

    public TextPane(StyledDocument doc) {
        super(doc);
    }

    public void printContent() {
        TextPane printCopy = this.makePrintCopy();
        printCopy.setMaximumSize(new Dimension(800, this.getMaximumSize().height));
        PrinterJob pjob = PrinterJob.getPrinterJob();
        pjob.pageDialog(pjob.defaultPage());
        RepaintManager.currentManager(printCopy).setDoubleBufferingEnabled(false);
        pjob.setPrintable(printCopy);
        if (pjob.printDialog()) {
            try {
                pjob.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
    }

    public void setHeaderForPrinting(String sPrintHeader) {
        this.sPrintHeader = sPrintHeader;
        this.lblTitle = new LabelWidget(sPrintHeader);
    }

    public String getHeaderForPrinting() {
        return this.sPrintHeader;
    }

    @Override
    public int print(Graphics g, PageFormat pform, int pageNumber) {
        View view = this.getUI().getRootView(this);
        double pageOffset = (double)pageNumber * pform.getImageableHeight();
        if (pageOffset > (double)view.getPreferredSpan(1)) {
            return 1;
        }
        if (this.lblTitle != null) {
            g.drawString(this.lblTitle.getText(), 0, this.iTitlePos);
            int y = this.iTitlePos;
            g.setFont(this.lblTitle.getFont());
            FontMetrics fm = g.getFontMetrics();
            int iContentPos = y += fm.getAscent();
            iContentPos += 20;
        }
        ((Graphics2D)g).translate(0.0, -pageOffset);
        Rectangle rect = new Rectangle();
        rect.setRect(pform.getImageableX(), pform.getImageableY(), pform.getImageableWidth(), pform.getImageableHeight() + pageOffset);
        view.paint(g, rect);
        return 0;
    }

    private TextPane makePrintCopy() {
        TextPane copy = new TextPane();
        copy.setEditorKit(this.getStyledEditorKit());
        String sResults = this.getText();
        BufferedReader in = new BufferedReader(new StringReader(sResults));
        try {
            copy.getStyledEditorKit().read(in, copy.getDocument(), 0);
        }
        catch (Exception e) {
            // empty catch block
        }
        copy.setEditable(false);
        Style normal = copy.getStyledDocument().getStyle("default");
        StyleConstants.setFontSize(normal, 8);
        return copy;
    }
}

