/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.border.Border;

public class TitledBorder
extends javax.swing.border.TitledBorder {
    private static final Point textLoc = new Point();

    protected static boolean computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
        int x1 = Math.max(rx, dest.x);
        int x2 = Math.min(rx + rw, dest.x + dest.width);
        int y1 = Math.max(ry, dest.y);
        int y2 = Math.min(ry + rh, dest.y + dest.height);
        dest.x = x1;
        dest.y = y1;
        dest.width = x2 - x1;
        dest.height = y2 - y1;
        return dest.width > 0 && dest.height > 0;
    }

    public TitledBorder(String text) {
        super(text);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border border = this.getBorder();
        if (this.getTitle() == null || this.getTitle().equals("")) {
            if (border != null) {
                border.paintBorder(c, g, x, y, width, height);
            }
            return;
        }
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Font font = g.getFont();
        Color color = g.getColor();
        g.setFont(this.getFont(c));
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        int stringWidth = fm.stringWidth(this.getTitle());
        int halfChrWth = stringWidth / this.getTitle().length() / 2;
        stringWidth += halfChrWth * 2;
        Insets insets = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        int titlePos = this.getTitlePosition();
        switch (titlePos) {
            case 1: {
                int diff = ascent + descent + (Math.max(2, 4) - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                TitledBorder.textLoc.y = grooveRect.y - (descent + 2);
                break;
            }
            case 0: 
            case 2: {
                int diff = Math.max(0, ascent / 2 + 2 - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                TitledBorder.textLoc.y = grooveRect.y - descent + (insets.top + ascent + descent) / 2;
                break;
            }
            case 3: {
                TitledBorder.textLoc.y = grooveRect.y + insets.top + ascent + 2;
                break;
            }
            case 4: {
                TitledBorder.textLoc.y = grooveRect.y + grooveRect.height - (insets.bottom + descent + 2);
                break;
            }
            case 5: {
                grooveRect.height -= fontHeight / 2;
                TitledBorder.textLoc.y = grooveRect.y + grooveRect.height - descent + (ascent + descent - insets.bottom) / 2;
                break;
            }
            case 6: {
                grooveRect.height -= fontHeight;
                TitledBorder.textLoc.y = grooveRect.y + grooveRect.height + ascent + 2;
            }
        }
        int justification = this.getTitleJustification();
        if (c.getComponentOrientation().isLeftToRight()) {
            if (justification == 4 || justification == 0) {
                justification = 1;
            } else if (justification == 5) {
                justification = 3;
            }
        } else if (justification == 4 || justification == 0) {
            justification = 3;
        } else if (justification == 5) {
            justification = 1;
        }
        switch (justification) {
            case 1: {
                TitledBorder.textLoc.x = grooveRect.x + 5 + insets.left;
                break;
            }
            case 3: {
                TitledBorder.textLoc.x = grooveRect.x + grooveRect.width - (stringWidth + 5 + insets.right);
                break;
            }
            case 2: {
                TitledBorder.textLoc.x = grooveRect.x + (grooveRect.width - stringWidth) / 2;
            }
        }
        if (border != null) {
            if (titlePos == 2 || titlePos == 5 || titlePos == 0) {
                Rectangle clipRect = new Rectangle();
                Rectangle saveClip = g.getClipBounds();
                clipRect.setBounds(saveClip);
                if (TitledBorder.computeIntersection(clipRect, x, y, TitledBorder.textLoc.x, height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                clipRect.setBounds(saveClip);
                if (TitledBorder.computeIntersection(clipRect, TitledBorder.textLoc.x + stringWidth, 0, width - stringWidth - TitledBorder.textLoc.x, height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                clipRect.setBounds(saveClip);
                if (titlePos == 2 || titlePos == 0) {
                    if (TitledBorder.computeIntersection(clipRect, TitledBorder.textLoc.x, grooveRect.y + insets.top, stringWidth, height - grooveRect.y - insets.top)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                } else if (TitledBorder.computeIntersection(clipRect, TitledBorder.textLoc.x, y, stringWidth, height - insets.bottom - (height - grooveRect.height - grooveRect.y))) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                g.setClip(saveClip);
            } else {
                border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
            }
        }
        g.setColor(this.getTitleColor());
        g.drawString(this.getTitle(), TitledBorder.textLoc.x + halfChrWth, TitledBorder.textLoc.y);
        g.setFont(font);
        g.setColor(color);
    }
}

