/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.SeparatorWidget;
import com.metamatrix.toolbox.ui.widget.laf.ToolBarLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.plaf.basic.BasicArrowButton;

public class ToolBar
extends JToolBar {
    private static final String MARGIN_PROPERTY = "ToolBar.margin";
    private Container buttons;
    private BasicArrowButton leftButton;
    private BasicArrowButton rightButton;
    private JViewport port;
    private Hashtable listenerRegistry;

    public ToolBar() {
        this(0);
    }

    public ToolBar(int orientation) {
        super(orientation);
        this.initializeToolBar();
    }

    @Override
    public JButton add(Action action) {
        ButtonWidget button = new ButtonWidget((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.setEnabled(action.isEnabled());
        button.addActionListener(action);
        this.add(button);
        return button;
    }

    @Override
    protected void addImpl(Component component, Object constraints, int index) {
        this.buttons.add(component, constraints, index);
    }

    @Override
    public void addSeparator() {
        SeparatorWidget sep = new SeparatorWidget(this);
        this.add(sep);
    }

    public void addSeparator(int gap) {
        SeparatorWidget sep = new SeparatorWidget(this, gap);
        this.add(sep);
    }

    @Override
    public void addSeparator(Dimension d) {
        this.addSeparator(d, 0);
    }

    public void addSeparator(Dimension d, int gap) {
        SeparatorWidget sep = new SeparatorWidget(this, gap);
        sep.setSize(d);
        this.add(sep);
    }

    public void addSeparator(Insets insets) {
        SeparatorWidget sep = new SeparatorWidget(this, insets);
        this.add(sep);
    }

    public Container getButtonContainer() {
        return this.buttons;
    }

    @Override
    public int getComponentIndex(Component component) {
        Component[] comps = this.buttons.getComponents();
        int ndx = comps.length;
        while (--ndx >= 0) {
            if (comps[ndx] != component) continue;
            return ndx;
        }
        return -1;
    }

    @Override
    public Component getComponentAtIndex(int index) {
        if (index >= 0 && index < this.getComponentCount()) {
            return this.buttons.getComponents()[index];
        }
        return null;
    }

    protected void initializeToolBar() {
        this.setMargin(UIDefaults.getInstance().getInsets(MARGIN_PROPERTY));
        super.setLayout(new BorderLayout());
        this.port = new JViewport();
        this.buttons = new JPanel(null);
        this.port.setView(this.buttons);
        super.addImpl(this.port, "Center", -1);
        this.setLayout(new BoxLayout(this.buttons, 0));
        this.port.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                ToolBar.this.updateScrollButtons();
            }
        });
        ((ToolBarLookAndFeel)this.getUI()).installSubclassListeners();
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (this.buttons != null && layout instanceof BoxLayout) {
            if (this.leftButton != null) {
                this.remove(this.leftButton);
            }
            if (this.rightButton != null) {
                this.remove(this.rightButton);
            }
            if (this.getOrientation() == 0) {
                this.buttons.setLayout(new BoxLayout(this.buttons, 0));
                this.leftButton = new BasicArrowButton(7);
                this.rightButton = new BasicArrowButton(3);
                super.addImpl(this.leftButton, "West", -1);
                super.addImpl(this.rightButton, "East", -1);
            } else {
                this.buttons.setLayout(new BoxLayout(this.buttons, 1));
                this.leftButton = new BasicArrowButton(1);
                this.rightButton = new BasicArrowButton(5);
                super.addImpl(this.leftButton, "North", -1);
                super.addImpl(this.rightButton, "South", -1);
            }
            this.leftButton.setVisible(false);
            this.rightButton.setVisible(false);
            this.leftButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Rectangle bounds = ToolBar.this.port.getViewRect();
                    Component[] comps = ToolBar.this.buttons.getComponents();
                    if (ToolBar.this.getOrientation() == 0) {
                        int ndx = comps.length;
                        while (--ndx >= 0) {
                            Component comp = comps[ndx];
                            if (bounds.x <= comp.getX()) continue;
                            ToolBar.this.port.setViewPosition(new Point(comp.getX(), 0));
                            ToolBar.this.updateScrollButtons();
                            ToolBar.this.port.repaint();
                            break;
                        }
                    } else {
                        int ndx = comps.length;
                        while (--ndx >= 0) {
                            Component comp = comps[ndx];
                            if (bounds.y <= comp.getY()) continue;
                            ToolBar.this.port.setViewPosition(new Point(0, comp.getY()));
                            ToolBar.this.updateScrollButtons();
                            ToolBar.this.port.repaint();
                            break;
                        }
                    }
                }
            });
            this.rightButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Rectangle bounds = ToolBar.this.port.getViewRect();
                    Component[] comps = ToolBar.this.buttons.getComponents();
                    if (ToolBar.this.getOrientation() == 0) {
                        int end = bounds.x + bounds.width;
                        for (int ndx = 0; ndx < comps.length; ++ndx) {
                            Component comp = comps[ndx];
                            int delta = comp.getX() + comp.getWidth() - end;
                            if (delta <= 0) continue;
                            ToolBar.this.port.setViewPosition(new Point(bounds.x + delta, 0));
                            ToolBar.this.updateScrollButtons();
                            ToolBar.this.port.repaint();
                            break;
                        }
                    } else {
                        int end = bounds.y + bounds.height;
                        for (int ndx = 0; ndx < comps.length; ++ndx) {
                            Component comp = comps[ndx];
                            int delta = comp.getY() + comp.getHeight() - end;
                            if (delta <= 0) continue;
                            ToolBar.this.port.setViewPosition(new Point(0, bounds.y + delta));
                            ToolBar.this.updateScrollButtons();
                            ToolBar.this.port.repaint();
                            break;
                        }
                    }
                }
            });
        }
    }

    protected void unregisterButtonForAction(JButton item) {
        ActionChangedListener p;
        if (this.listenerRegistry != null && (p = (ActionChangedListener)this.listenerRegistry.remove(item)) != null) {
            Action a = (Action)this.listenerRegistry.remove(p);
            if (a != null) {
                item.removeActionListener(a);
                a.removePropertyChangeListener(p);
            }
            p.setTarget(null);
        }
    }

    protected void updateScrollButtons() {
        Rectangle bounds = this.port.getViewRect();
        if (this.getOrientation() == 0) {
            this.leftButton.setVisible(bounds.x > 0);
            if (this.rightButton.isVisible()) {
                this.rightButton.setVisible(bounds.x + bounds.width + this.rightButton.getWidth() < this.buttons.getWidth());
            } else {
                this.rightButton.setVisible(bounds.x + bounds.width < this.buttons.getWidth());
            }
        } else {
            this.leftButton.setVisible(bounds.y > 0);
            if (this.rightButton.isVisible()) {
                this.rightButton.setVisible(bounds.y + bounds.height + this.rightButton.getHeight() < this.buttons.getHeight());
            } else {
                this.rightButton.setVisible(bounds.y + bounds.height < this.buttons.getHeight());
            }
        }
    }

    @Override
    public void updateUI() {
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setUI(ToolBarLookAndFeel.createUI(this));
    }

    @Override
    public void remove(Component comp) {
        this.buttons.remove(comp);
    }

    @Override
    public void remove(int index) {
        this.buttons.remove(index);
    }

    @Override
    public void removeAll() {
        this.buttons.removeAll();
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JButton button;

        ActionChangedListener(JButton b) {
            this.setTarget(b);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.button.setText(text);
                this.button.repaint();
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
                this.button.repaint();
            } else if (e.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)e.getNewValue();
                this.button.setIcon(icon);
                this.button.invalidate();
                this.button.repaint();
            }
        }

        public void setTarget(JButton b) {
            this.button = b;
        }
    }
}

