/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.transfer.DragAndDropController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TreeNodeTableWidget
extends TableWidget {
    private TreeNodeEditor editor;
    private TreeView view;
    private List nodes;
    private List defs;
    private String emptyTableColName;
    private DragAndDropController dndCtrlr;

    public TreeNodeTableWidget() {
        this(null, null, null, null);
    }

    public TreeNodeTableWidget(TreeNodeEditor editor) {
        this(editor, null, null, null);
    }

    public TreeNodeTableWidget(TreeNodeEditor editor, TreeView view) {
        this(editor, view, null, null);
    }

    public TreeNodeTableWidget(TreeNodeEditor editor, List nodes, List definitions) {
        this(editor, null, nodes, definitions);
    }

    public TreeNodeTableWidget(TreeNodeEditor editor, TreeView view, List nodes) {
        this(editor, view, nodes, null);
    }

    public TreeNodeTableWidget(TreeNodeEditor editor, TreeView view, List nodes, List definitions) {
        super(true);
        this.initializeTreeNodeTable(editor, view, nodes, definitions);
    }

    public List getPropertyDefinitionsShown() {
        return this.defs;
    }

    public List getTreeNodes() {
        return this.nodes;
    }

    public TreeNode getTreeNode(int index) {
        if (this.nodes == null) {
            return null;
        }
        return (TreeNode)this.nodes.get(index);
    }

    public TreeView getTreeView() {
        return this.view;
    }

    protected void initializeTreeNodeTable(TreeNodeEditor editor, TreeView view, List nodes, List definitions) {
        this.editor = editor;
        this.view = view;
        this.nodes = nodes;
        this.updateModel(editor, nodes, definitions);
    }

    public void setDragAndDropController(DragAndDropController controller) {
        this.dndCtrlr = controller;
        if (this.dndCtrlr != null) {
            this.dndCtrlr.setComponent(this);
        }
    }

    public void setEmptyTableColumnName(String name) {
        this.emptyTableColName = name;
        if (this.nodes == null || this.nodes.size() == 0) {
            DefaultTableModel model = new DefaultTableModel(new Vector(), (Vector)new Vector<String>(Arrays.asList(this.emptyTableColName)));
            model.setEditable(false);
            this.setModel(model);
        }
    }

    public void setPropertyDefinitionsShown(List definitions) {
        this.updateModel(this.editor, this.nodes, definitions);
    }

    public void setTreeNodeEditor(TreeNodeEditor editor) {
        this.editor = editor;
        this.updateModel(editor, this.nodes, this.defs);
    }

    public void setTreeNodes(List nodes) {
        this.nodes = nodes;
        this.updateModel(this.editor, nodes, this.defs);
    }

    public void setTreeView(TreeView view) {
        this.view = view;
    }

    protected void updateModel(TreeNodeEditor editor, List nodes, List definitions) {
        if (nodes == null && this.view != null) {
            this.nodes = nodes = this.view.getRoots();
        }
        if ((definitions == null || definitions.size() == 0) && editor != null && nodes != null && nodes.size() > 0) {
            definitions = editor.getPropertyDefinitions((PropertiedObject)nodes.get(0));
        }
        this.defs = new ArrayList();
        if (definitions != null) {
            for (Object def : definitions) {
                Assertion.assertTrue((boolean)(def instanceof PropertyDefinition), (String)("All elements must be instances of PropertyDefinition: " + def.getClass().getName()));
                if (((PropertyDefinition)def).isHidden()) continue;
                this.defs.add(def);
            }
        }
        if (editor == null) {
            return;
        }
        Vector rowData = new Vector();
        Vector<String> colNames = new Vector<String>();
        if (nodes == null || nodes.size() == 0) {
            if (this.emptyTableColName != null) {
                colNames.add(this.emptyTableColName);
            }
        } else {
            Iterator defIter;
            Iterator nodeIter = nodes.iterator();
            int colCount = this.defs.size();
            while (nodeIter.hasNext()) {
                PropertiedObject node = (PropertiedObject)nodeIter.next();
                Vector<Object> colData = new Vector<Object>(colCount);
                defIter = this.defs.iterator();
                while (defIter.hasNext()) {
                    colData.add(editor.getValue(node, (PropertyDefinition)defIter.next()));
                }
                rowData.add(colData);
            }
            defIter = this.defs.iterator();
            while (defIter.hasNext()) {
                colNames.add(((PropertyDefinition)defIter.next()).getDisplayName());
            }
        }
        DefaultTableModel model = new DefaultTableModel(rowData, (Vector)colNames);
        model.setEditable(false);
        this.setModel(model);
    }
}

