/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.toolbox.property.VetoedChangeEvent;
import com.metamatrix.toolbox.property.VetoedChangeListener;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.MultiLineToolTip;
import com.metamatrix.toolbox.ui.widget.PopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.laf.TreeLookAndFeel;
import com.metamatrix.toolbox.ui.widget.menu.DefaultPopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.text.TextContainer;
import com.metamatrix.toolbox.ui.widget.transfer.TreeNodeDragAndDropController;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeCellEditor;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeCellRenderer;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeWidget
extends JTree
implements TextContainer {
    public static final String PROPERTY_PREFIX = "Tree.";
    private static final String LINE_STYLE_PROPERTY = "JTree.lineStyle";
    private TreeModel model;
    private transient Object value;
    private boolean isClipTipEnabled;
    private PopupMenuFactory popupMenuFactory;
    private TreeNodeDragAndDropController dndCtrlr;
    private TreeModelListener modelListener;
    private VetoedChangeListener vetoListener;

    public static int convertIndexToModel(TreeNode theParent, int theStartIndex, TreeView theFilteredView, TreeView theUnfilteredView) {
        if (theParent == null) {
            throw new IllegalArgumentException("TreeWidget.convertIndexToModel:Parent is null.");
        }
        if (theFilteredView == null) {
            throw new IllegalArgumentException("TreeWidget.convertIndexToModel:Filtered view is null.");
        }
        if (theUnfilteredView == null) {
            throw new IllegalArgumentException("TreeWidget.convertIndexToModel:Unfiltered view is null.");
        }
        int index = theStartIndex;
        List kids = theUnfilteredView.getChildren(theParent);
        if (!kids.isEmpty()) {
            if (index > 0 && index - 1 < kids.size()) {
                for (int i = index - 1; i >= 0; --i) {
                    TreeNode kid = (TreeNode)kids.get(i);
                    if (!theFilteredView.isHidden(kid)) continue;
                    --index;
                }
            } else if (theStartIndex != 0) {
                index = -1;
            }
        } else if (theStartIndex != 0) {
            index = -1;
        }
        return index;
    }

    public TreeWidget() {
        this((TreeModel)null);
    }

    public TreeWidget(Object value) {
        super((TreeModel)null);
        this.value = value;
        this.initializeTreeWidget();
    }

    public TreeWidget(TreeModel model) {
        super((TreeModel)null);
        this.model = model;
        this.initializeTreeWidget();
    }

    protected void changeVetoed(VetoedChangeEvent event) {
    }

    @Override
    public String convertValueToText(Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        if (value == null) {
            return "";
        }
        if (value instanceof TreeNode) {
            return ((TreeNode)value).getName();
        }
        return value.toString();
    }

    protected PopupMenuFactory createDefaultPopupMenuFactory() {
        return new DefaultPopupMenuFactory();
    }

    protected TreeCellEditor createDefaultTreeCellEditor() {
        javax.swing.tree.DefaultTreeCellRenderer adapter = new javax.swing.tree.DefaultTreeCellRenderer(){

            @Override
            public Icon getClosedIcon() {
                TreeCellRenderer renderer = TreeWidget.this.getCellRenderer();
                if (renderer != null && renderer instanceof DefaultTreeCellRenderer) {
                    return ((DefaultTreeCellRenderer)renderer).getClosedIcon();
                }
                return super.getClosedIcon();
            }

            @Override
            public Font getFont() {
                if (TreeWidget.this == null) {
                    return super.getFont();
                }
                TreeCellRenderer renderer = TreeWidget.this.getCellRenderer();
                if (renderer != null && renderer instanceof DefaultTreeCellRenderer) {
                    return ((DefaultTreeCellRenderer)renderer).getFont();
                }
                return super.getFont();
            }

            @Override
            public int getIconTextGap() {
                TreeCellRenderer renderer = TreeWidget.this.getCellRenderer();
                if (renderer != null && renderer instanceof DefaultTreeCellRenderer) {
                    return ((DefaultTreeCellRenderer)renderer).getIconTextGap();
                }
                return super.getIconTextGap();
            }

            @Override
            public Icon getLeafIcon() {
                TreeCellRenderer renderer = TreeWidget.this.getCellRenderer();
                if (renderer != null && renderer instanceof DefaultTreeCellRenderer) {
                    return ((DefaultTreeCellRenderer)renderer).getLeafIcon();
                }
                return super.getLeafIcon();
            }

            @Override
            public Icon getOpenIcon() {
                TreeCellRenderer renderer = TreeWidget.this.getCellRenderer();
                if (renderer != null && renderer instanceof DefaultTreeCellRenderer) {
                    return ((DefaultTreeCellRenderer)renderer).getOpenIcon();
                }
                return super.getOpenIcon();
            }

            @Override
            public Dimension getPreferredSize() {
                TreeCellRenderer renderer = TreeWidget.this.getCellRenderer();
                if (renderer != null && renderer instanceof DefaultTreeCellRenderer) {
                    return ((DefaultTreeCellRenderer)renderer).getPreferredSize();
                }
                return super.getPreferredSize();
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focused) {
                TreeCellRenderer renderer = TreeWidget.this.getCellRenderer();
                if (renderer != null && renderer instanceof DefaultTreeCellRenderer) {
                    return renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, focused);
                }
                return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, focused);
            }
        };
        return new DefaultTreeCellEditor(this, adapter);
    }

    protected TreeCellRenderer createDefaultTreeCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModel createDefaultTreeModel(Object value) {
        return new DefaultTreeModel(value);
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip tip = new MultiLineToolTip();
        tip.setComponent(this);
        return tip;
    }

    public TreeNodeDragAndDropController getDragAndDropController() {
        return this.dndCtrlr;
    }

    public PopupMenuFactory getPopupMenuFactory() {
        return this.popupMenuFactory;
    }

    public int getRowForNode(TreePath parentPath, Object node) {
        if (parentPath == null) {
            return this.getRowForPath(new TreePath(new Object[]{node}));
        }
        if (!this.hasBeenExpanded(parentPath)) {
            return -1;
        }
        TreePath collapsedPath = null;
        if (this.isCollapsed(parentPath)) {
            collapsedPath = parentPath;
            while (collapsedPath.getPathCount() > 1 && this.isCollapsed(collapsedPath.getParentPath())) {
                collapsedPath = collapsedPath.getParentPath();
            }
            this.setExpandedState(parentPath, true);
        }
        int count = parentPath.getPathCount();
        Object[] nodePath = new Object[count + 1];
        System.arraycopy(parentPath.getPath(), 0, nodePath, 0, count);
        nodePath[count] = node;
        int parentRow = this.getRowForPath(parentPath);
        int row = this.getRowForPath(new TreePath(nodePath));
        for (int ndx = row - 1; ndx > parentRow; --ndx) {
            if (this.getPathForRow(ndx).getParentPath().equals(parentPath)) continue;
            --row;
        }
        if (collapsedPath != null) {
            this.setExpandedState(collapsedPath, false);
        }
        return row - parentRow - 1;
    }

    protected void initializeTreeWidget() {
        this.modelListener = new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent event) {
                if (TreeWidget.this.getUI() instanceof TreeLookAndFeel) {
                    ((TreeLookAndFeel)TreeWidget.this.getUI()).invalidateLayoutCache();
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent event) {
                TreePath rootPath = new TreePath(TreeWidget.this.model.getRoot());
                if (!TreeWidget.this.isRootVisible() && !TreeWidget.this.isExpanded(rootPath)) {
                    TreeWidget.this.expandPath(rootPath);
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent event) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent event) {
            }
        };
        this.vetoListener = new VetoedChangeListener(){

            @Override
            public void changeVetoed(VetoedChangeEvent event) {
                TreeWidget.this.changeVetoed(event);
            }
        };
        if (this.model == null) {
            this.setModel(this.createDefaultTreeModel(this.value));
        } else {
            this.setModel(this.model);
        }
        this.isClipTipEnabled = true;
        ToolTipManager.sharedInstance().registerComponent(this);
        TreeCellRenderer renderer = this.createDefaultTreeCellRenderer();
        this.setCellRenderer(renderer);
        if (renderer instanceof DefaultTreeCellRenderer) {
            this.setCellEditor(this.createDefaultTreeCellEditor());
        }
        this.setPopupMenuFactory(this.createDefaultPopupMenuFactory());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent event) {
                JPopupMenu popup;
                if (!SwingUtilities.isRightMouseButton(event)) {
                    return;
                }
                TreePath path = TreeWidget.this.getPathForLocation(event.getX(), event.getY());
                if (!TreeWidget.this.isPathSelected(path)) {
                    TreeWidget.this.setSelectionPath(path);
                }
                if (TreeWidget.this.popupMenuFactory != null && (popup = TreeWidget.this.popupMenuFactory.getPopupMenu(TreeWidget.this)) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            popup.show(TreeWidget.this, event.getX(), event.getY());
                        }
                    });
                }
            }
        });
        this.putClientProperty(LINE_STYLE_PROPERTY, UIDefaults.getInstance().getString(LINE_STYLE_PROPERTY));
        this.setInvokesStopCellEditing(true);
    }

    @Override
    public boolean isClipTipEnabled() {
        return this.isClipTipEnabled;
    }

    @Override
    public void setClipTipEnabled(boolean isClipTipEnabled) {
        this.isClipTipEnabled = isClipTipEnabled;
    }

    public void setDragAndDropController(TreeNodeDragAndDropController controller) {
        if (this.dndCtrlr != null) {
            this.dndCtrlr.setComponent(null);
        }
        this.dndCtrlr = controller;
        if (this.dndCtrlr != null) {
            this.dndCtrlr.setComponent(this);
        }
    }

    @Override
    public void setModel(TreeModel model) {
        TreeModel oldModel;
        if (model == null) {
            return;
        }
        model.addTreeModelListener(this.modelListener);
        if (model instanceof DefaultTreeModel) {
            DefaultTreeModel dfltModel = (DefaultTreeModel)model;
            dfltModel.setTreeWidget(this);
            dfltModel.addVetoedChangeListener(this.vetoListener);
        }
        if ((oldModel = this.getModel()) != null) {
            oldModel.removeTreeModelListener(this.modelListener);
            if (oldModel instanceof DefaultTreeModel) {
                ((DefaultTreeModel)oldModel).removeVetoedChangeListener(this.vetoListener);
            }
        }
        super.setModel(model);
        this.model = model;
    }

    public void setPopupMenuFactory(PopupMenuFactory popupMenuFactory) {
        this.popupMenuFactory = popupMenuFactory;
    }

    @Override
    public void updateUI() {
        this.setUI(TreeLookAndFeel.createUI(this));
    }

    @Override
    public TreePath getPathForLocation(int x, int y) {
        Rectangle pathBounds;
        TreePath closestPath = this.getClosestPathForLocation(x, y);
        if (closestPath != null && (pathBounds = this.getPathBounds(closestPath)) != null) {
            return super.getPathForLocation(x, y);
        }
        return null;
    }
}

