/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.util.BrowserControl;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;

public class URLLabelWidget
extends LabelWidget {
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private Rectangle clickRect;

    public URLLabelWidget() {
        this.init();
    }

    public URLLabelWidget(String text) {
        super(text);
        this.init();
    }

    public URLLabelWidget(Icon icon) {
        super(icon);
        this.init();
    }

    public URLLabelWidget(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    private void init() {
        super.setForeground(Color.blue);
        this.clickRect = new Rectangle(0, 0, 0, 0);
        this.addMouseListener(new MouseAdapter(){
            Cursor prevCursor = null;

            @Override
            public void mouseReleased(MouseEvent event) {
                if (URLLabelWidget.this.getText().length() > 0 && URLLabelWidget.this.clickRect.contains(event.getPoint())) {
                    URLLabelWidget.this.doLinkClick(URLLabelWidget.this.getText());
                }
            }

            @Override
            public void mouseEntered(MouseEvent theEvent) {
                if (URLLabelWidget.this.getText().length() > 0 && URLLabelWidget.this.clickRect.contains(theEvent.getPoint())) {
                    URLLabelWidget.this.setCursor(HAND_CURSOR);
                } else {
                    URLLabelWidget.this.setCursor(DEFAULT_CURSOR);
                }
            }

            @Override
            public void mouseExited(MouseEvent theEvent) {
                URLLabelWidget.this.setCursor(this.prevCursor);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent theEvent) {
            }

            @Override
            public void mouseMoved(MouseEvent theEvent) {
                String url = URLLabelWidget.this.getText();
                if (url.length() > 0 && URLLabelWidget.this.clickRect.contains(theEvent.getPoint())) {
                    URLLabelWidget.this.setCursor(HAND_CURSOR);
                } else {
                    URLLabelWidget.this.setCursor(DEFAULT_CURSOR);
                }
            }
        });
    }

    protected void doLinkClick(String url) {
        BrowserControl.displayURL(url);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setPaint(this.getForeground());
        String text = this.getText();
        FontMetrics fontMetrics = g2D.getFontMetrics(this.getFont());
        int x = 0;
        int y = fontMetrics.getMaxAscent() + 3;
        int width = fontMetrics.stringWidth(text);
        g2D.drawLine(x, y, x + width, y);
        this.clickRect.width = width;
        this.clickRect.height = y;
    }
}

