/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.util.BrowserControl;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class URLTextFieldWidget
extends TextFieldWidget {
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(2);
    private boolean dragged = false;
    private Rectangle clickRect;
    private boolean enableClick = true;
    private boolean overrideHyperlinkClick = false;

    public URLTextFieldWidget() {
        this.init();
    }

    public URLTextFieldWidget(String text) {
        super(text);
        this.init();
    }

    public URLTextFieldWidget(int characters) {
        super(characters);
        this.init();
    }

    public URLTextFieldWidget(String text, int characters) {
        super(text, characters);
        this.init();
    }

    private void init() {
        this.setForeground(Color.blue);
        this.clickRect = new Rectangle(0, 0, 0, 0);
        this.setDisabledTextColor(Color.blue);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent theEvent) {
                String url = URLTextFieldWidget.this.getText();
                if (url.length() > 0 && URLTextFieldWidget.this.enableClick && URLTextFieldWidget.this.clickRect.contains(theEvent.getPoint()) && !URLTextFieldWidget.this.dragged) {
                    URLTextFieldWidget.this.doLinkClick(url);
                }
                URLTextFieldWidget.this.dragged = false;
            }

            @Override
            public void mouseEntered(MouseEvent theEvent) {
                String url = URLTextFieldWidget.this.getText();
                if (url.length() > 0 && URLTextFieldWidget.this.enableClick && URLTextFieldWidget.this.clickRect.contains(theEvent.getPoint())) {
                    URLTextFieldWidget.this.setCursor(HAND_CURSOR);
                } else {
                    URLTextFieldWidget.this.setCursor(DEFAULT_CURSOR);
                }
            }

            @Override
            public void mouseExited(MouseEvent theEvent) {
                URLTextFieldWidget.this.setCursor(DEFAULT_CURSOR);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent theEvent) {
                URLTextFieldWidget.this.dragged = true;
            }

            @Override
            public void mouseMoved(MouseEvent theEvent) {
                String url = URLTextFieldWidget.this.getText();
                if (url.length() > 0 && URLTextFieldWidget.this.enableClick && URLTextFieldWidget.this.clickRect.contains(theEvent.getPoint())) {
                    URLTextFieldWidget.this.setCursor(HAND_CURSOR);
                } else {
                    URLTextFieldWidget.this.setCursor(DEFAULT_CURSOR);
                }
            }
        });
    }

    protected void doLinkClick(String url) {
        BrowserControl.displayURL(url);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setPaint(this.getForeground());
        String text = this.getText();
        FontMetrics fontMetrics = g2D.getFontMetrics(this.getFont());
        int x = 0;
        int y = fontMetrics.getMaxAscent() + 4;
        int width = fontMetrics.stringWidth(text);
        g2D.drawLine(x, y, x + width, y);
        this.clickRect.width = width;
        this.clickRect.height = y;
    }

    @Override
    public void setForeground(Color c) {
        if (c.equals(Color.red)) {
            super.setForeground(c);
            this.enableClick = false;
        } else {
            super.setForeground(Color.blue);
            if (!this.overrideHyperlinkClick) {
                this.enableClick = true;
            }
        }
    }

    public void setHyperlinkEnabled(boolean flag) {
        this.overrideHyperlinkClick = !flag;
    }
}

