/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget;

import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.WidgetFactory;
import com.metamatrix.toolbox.ui.widget.util.WidgetUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class WizardPanel
extends DialogPanel {
    protected Collection pages = null;
    private ButtonWidget backButton = null;
    private ButtonWidget nextButton = null;
    private ButtonWidget finishButton = null;
    private int pgNdx = 0;
    private Dimension prefSize;

    public WizardPanel() {
        this((Collection)null);
    }

    public WizardPanel(Component page) {
        this(new ArrayList<Component>(Collections.singleton(page)));
    }

    public WizardPanel(Collection pages) {
        this.pages = pages;
        this.initializeWizardPanel();
    }

    public int addPage(Component page) {
        int ndx = this.getPageCount();
        this.addPage(page, ndx);
        return ndx;
    }

    public void addPage(Component page, int index) {
        if (this.pages == null) {
            this.pages = new ArrayList();
        }
        if (this.pages.size() == 1) {
            this.addNavigationButton(this.backButton, this.getNavigationComponentIndex(this.finishButton));
        }
        ((List)this.pages).add(index, page);
        Dimension size = page.getPreferredSize();
        this.prefSize.width = Math.max(this.prefSize.width, size.width);
        this.prefSize.height = Math.max(this.prefSize.height, size.height);
        Component currentPg = this.getContent();
        super.setContent(new JComponent(){

            @Override
            public Dimension getPreferredSize() {
                return WizardPanel.this.prefSize;
            }
        });
        this.setPreferredSize(null);
        this.setPreferredSize(this.getPreferredSize());
        if (index == this.pgNdx) {
            this.showPage(index);
        } else {
            super.setContent(currentPg);
        }
    }

    @Override
    protected ButtonWidget createAcceptButton() {
        return WidgetFactory.createButton("finish");
    }

    protected ButtonWidget createBackButton() {
        ButtonWidget button = WidgetFactory.createButton("back");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                WizardPanel.this.showPreviousPage();
            }
        });
        return button;
    }

    protected ButtonWidget createNextButton() {
        ButtonWidget button = WidgetFactory.createButton("next");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                WizardPanel.this.showNextPage();
            }
        });
        return button;
    }

    public ButtonWidget getBackButton() {
        return this.backButton;
    }

    public final Component getCurrentPage() {
        return this.getContent();
    }

    public int getCurrentPageIndex() {
        return this.pgNdx;
    }

    public final ButtonWidget getFinishButton() {
        return this.getAcceptButton();
    }

    public final ButtonWidget getNextButton() {
        return this.nextButton;
    }

    public int getPageCount() {
        if (this.pages == null) {
            return 0;
        }
        return this.pages.size();
    }

    protected void initializeWizardPanel() {
        this.finishButton = this.getAcceptButton();
        this.backButton = this.createBackButton();
        this.nextButton = this.createNextButton();
        WidgetUtilities.equalizeSizeConstraints(Arrays.asList(this.backButton, this.nextButton, this.finishButton, this.getCancelButton()));
        this.prefSize = new Dimension();
        if (this.pages != null) {
            this.pages = new ArrayList(this.pages);
            if (this.pages.size() > 1) {
                this.addNavigationButton(this.backButton, this.getNavigationComponentIndex(this.finishButton));
                Iterator iterator = this.pages.iterator();
                while (iterator.hasNext()) {
                    Dimension size = ((Component)iterator.next()).getPreferredSize();
                    this.prefSize.width = Math.max(this.prefSize.width, size.width);
                    this.prefSize.height = Math.max(this.prefSize.height, size.height);
                }
                super.setContent(new JComponent(){

                    @Override
                    public Dimension getPreferredSize() {
                        return WizardPanel.this.prefSize;
                    }
                });
                this.setPreferredSize(this.getPreferredSize());
            }
            super.setContent((Component)((List)this.pages).get(0));
        }
    }

    public int removePage(Component page) {
        int ndx = ((List)this.pages).indexOf(page);
        this.removePage(page, ndx);
        return ndx;
    }

    public Component removePage(int index) {
        Component pg = (Component)((List)this.pages).get(index);
        this.removePage(pg, index);
        return pg;
    }

    protected void removePage(Component page, int index) {
        ((List)this.pages).remove(page);
        int pgCount = this.pages.size();
        if (pgCount == 0) {
            this.pages = null;
        } else if (pgCount == 1) {
            this.removeNavigationButton(this.backButton);
            this.addAcceptButton(this.finishButton, this.removeNavigationButton(this.nextButton));
        }
        if (index == this.pgNdx) {
            if (index == pgCount) {
                --this.pgNdx;
            }
            this.showPage(this.pgNdx);
        }
    }

    public void showNextPage() {
        if (this.pgNdx < this.getPageCount() - 1) {
            this.showPage(this.pgNdx + 1);
        }
    }

    public void showPage(int index) {
        this.showPage((Component)((List)this.pages).get(index), index);
    }

    public void showPage(Component page) {
        Iterator iterator = this.pages.iterator();
        int ndx = 0;
        while (iterator.hasNext()) {
            if (iterator.next().equals(page)) {
                this.showPage(page, ndx);
                return;
            }
            ++ndx;
        }
    }

    protected void showPage(Component page, int index) {
        super.setContent(page);
        this.pgNdx = index;
        if (this.getWindowAncestor() != null) {
            this.updateNavigationButtons();
            this.revalidate();
            this.repaint();
        }
    }

    public void showPreviousPage() {
        if (this.pgNdx > 0) {
            this.showPage(this.pgNdx - 1);
        }
    }

    protected void updateNavigationButtons() {
        this.backButton.setEnabled(this.pgNdx > 0);
        int pgCount = this.getPageCount();
        if (pgCount > 1) {
            if (this.pgNdx < pgCount - 1) {
                if (this.finishButton.getParent() != null) {
                    this.addNavigationButton(this.nextButton, this.removeNavigationButton(this.finishButton));
                }
            } else if (this.nextButton.getParent() != null) {
                this.addAcceptButton(this.finishButton, this.removeNavigationButton(this.nextButton));
            }
        }
    }

    @Override
    public void windowAdded() {
        this.updateNavigationButtons();
    }
}

