/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.button;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ButtonBorderPainter
extends MouseAdapter
implements ChangeListener {
    private static final ButtonBorderPainter instance = new ButtonBorderPainter();
    private AbstractButton currentMouseOverButton = null;

    public static void registerButton(AbstractButton b) {
        b.addChangeListener(instance);
        b.addMouseListener(instance);
        b.setBorderPainted(b.isSelected());
    }

    private ButtonBorderPainter() {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        if (!b.isSelected()) {
            if (b != this.currentMouseOverButton) {
                b.setBorderPainted(false);
            }
        } else {
            b.setBorderPainted(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        if (b.isEnabled()) {
            b.setBorderPainted(true);
        } else if (b.isSelected()) {
            b.setBorderPainted(true);
        }
        this.currentMouseOverButton = b;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        if (!b.isSelected()) {
            b.setBorderPainted(false);
        }
        this.currentMouseOverButton = null;
    }
}

