/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class ToggleButtonBorder
extends BasicBorders.ButtonBorder {
    private static final UIDefaults table = UIManager.getLookAndFeelDefaults();

    public ToggleButtonBorder() {
        this(table.getColor("controlShadow"), table.getColor("controlDkShadow"), table.getColor("controlHighlight"), table.getColor("controlLtHighlight"));
    }

    public ToggleButtonBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
        super(shadow, darkShadow, highlight, lightHighlight);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel m = b.getModel();
        if (m.isPressed() || m.isSelected()) {
            BasicGraphicsUtils.drawLoweredBezel(g, x, y, width, height, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        } else {
            BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, false, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(2, 3, 2, 3);
    }
}

