/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.laf;

import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.laf.LookAndFeelUtilities;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class ButtonLookAndFeel
extends MetalButtonUI {
    private static final ButtonLookAndFeel INSTANCE = new ButtonLookAndFeel();
    private static boolean areDfltsInstalled = false;
    private static Border border = null;
    private static Border pressedBorder = null;

    public static boolean areDefaultsInstalled() {
        return areDfltsInstalled;
    }

    public static ComponentUI createUI(JComponent component) {
        return INSTANCE;
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        ButtonWidget button = (ButtonWidget)component;
        LookAndFeelUtilities.clearViewBounds();
        LookAndFeelUtilities.layoutText(button.getTextFormat(), button.getIcon(), this.defaultTextIconGap, button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), button.getFontMetrics(button.getFont()));
        Dimension size = LookAndFeelUtilities.getPreferredSize(component);
        size.width += 2;
        size.height += 2;
        if (size.width % 2 == 0) {
            ++size.width;
        }
        if (size.height % 2 == 0) {
            ++size.height;
        }
        return size;
    }

    @Override
    public void installDefaults(AbstractButton button) {
        if (!areDfltsInstalled) {
            UIDefaults dflts = UIDefaults.getInstance();
            Insets margin = dflts.getInsets("Button.margin");
            Border marginBorder = BorderFactory.createEmptyBorder(margin.top, margin.left, margin.bottom, margin.right);
            border = BorderFactory.createCompoundBorder(dflts.getBorder("Button.border"), marginBorder);
            UIManager.getDefaults().put("Button.border", border);
            pressedBorder = BorderFactory.createCompoundBorder(dflts.getBorder("Button.pressedBorder"), marginBorder);
            areDfltsInstalled = true;
        }
        super.installDefaults(button);
        ButtonWidget buttonWidget = (ButtonWidget)button;
        buttonWidget.setIconTextGap(this.defaultTextIconGap);
        buttonWidget.setPressedShift(this.defaultTextShiftOffset);
    }

    @Override
    public void paint(Graphics graphic, JComponent component) {
        ButtonWidget button = (ButtonWidget)component;
        LookAndFeelUtilities.setViewBounds(component);
        String text = LookAndFeelUtilities.layoutText(button.getTextFormat(), button.getIcon(), this.defaultTextIconGap, button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), graphic.getFontMetrics());
        graphic.setFont(component.getFont());
        ButtonModel model = button.getModel();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(graphic, button);
        } else {
            this.clearTextShiftOffset();
            button.setBorder(border);
        }
        if (button.getIcon() != null) {
            this.paintIcon(graphic, component, LookAndFeelUtilities.ICON_BOUNDS);
        }
        int shift = this.getTextShiftOffset();
        LookAndFeelUtilities.TEXT_BOUNDS.x += shift;
        LookAndFeelUtilities.TEXT_BOUNDS.y += shift;
        LookAndFeelUtilities.ICON_BOUNDS.x += shift;
        LookAndFeelUtilities.ICON_BOUNDS.y += shift;
        if (text.length() > 0) {
            this.paintText(graphic, component, LookAndFeelUtilities.TEXT_BOUNDS, text);
        }
        if (button.isFocusPainted() && button.hasFocus()) {
            this.paintFocus(graphic, button, LookAndFeelUtilities.VIEW_BOUNDS, LookAndFeelUtilities.TEXT_BOUNDS, LookAndFeelUtilities.ICON_BOUNDS);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics graphic, AbstractButton button) {
        this.setTextShiftOffset();
        button.setBorder(pressedBorder);
    }

    @Override
    protected void paintText(Graphics graphic, JComponent component, Rectangle TEXT_BOUNDS, String text) {
        LookAndFeelUtilities.paintText(graphic, component, text, ((AbstractButton)component).getMnemonic());
    }

    public void setIconTextGap(int iconTextGap) {
        this.defaultTextIconGap = iconTextGap;
    }

    public void setPressedShift(int pressedShift) {
        this.defaultTextShiftOffset = pressedShift;
    }
}

