/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.laf;

import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.button.CheckBoxModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class CheckBoxLookAndFeel
extends BasicCheckBoxUI {
    private static final CheckBoxLookAndFeel INSTANCE = new CheckBoxLookAndFeel();
    private static final Dimension size = new Dimension();
    private static final Rectangle viewRect = new Rectangle();
    private static final Rectangle iconRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();
    public static final String BOX_BACKGROUND_COLOR_PROPERTY = "CheckBox.boxBackgroundColor";
    public static final String BOX_DISABLED_BACKGROUND_COLOR_PROPERTY = "CheckBox.boxDisabledBackgroundColor";
    public static final String PARTIALLY_SELECTED_COLOR_PROPERTY = "CheckBox.partiallySelectedColor";
    private static final Color DEFAULT_BOX_BACKGROUND_COLOR = UIDefaults.getInstance().getColor("CheckBox.boxBackgroundColor");
    private static final Color DEFAULT_BOX_DISABLED_BACKGROUND_COLOR = UIDefaults.getInstance().getColor("CheckBox.boxDisabledBackgroundColor");
    private static boolean areDfltsInstalled = false;
    private static Color focusColor = null;
    private static Color selectedColor = null;
    private static Color partiallySelectedColor = null;

    public static ComponentUI createUI(JComponent component) {
        return INSTANCE;
    }

    @Override
    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        if (!areDfltsInstalled) {
            partiallySelectedColor = UIDefaults.getInstance().getColor(PARTIALLY_SELECTED_COLOR_PROPERTY);
            focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
            selectedColor = UIManager.getColor(this.getPropertyPrefix() + "select");
            areDfltsInstalled = true;
        }
        CheckBox checkBox = (CheckBox)button;
        checkBox.setBoxBackgroundColor(DEFAULT_BOX_BACKGROUND_COLOR);
        checkBox.setBoxDisabledBackgroundColor(DEFAULT_BOX_DISABLED_BACKGROUND_COLOR);
    }

    @Override
    public void paint(Graphics canvas, JComponent component) {
        canvas.setFont(component.getFont());
        CheckBox checkBox = (CheckBox)component;
        checkBox.getSize(size);
        CheckBoxLookAndFeel.viewRect.y = 0;
        CheckBoxLookAndFeel.viewRect.x = 0;
        CheckBoxLookAndFeel.viewRect.width = CheckBoxLookAndFeel.size.width;
        CheckBoxLookAndFeel.viewRect.height = CheckBoxLookAndFeel.size.height;
        CheckBoxLookAndFeel.iconRect.height = 0;
        CheckBoxLookAndFeel.iconRect.width = 0;
        CheckBoxLookAndFeel.iconRect.y = 0;
        CheckBoxLookAndFeel.iconRect.x = 0;
        CheckBoxLookAndFeel.textRect.height = 0;
        CheckBoxLookAndFeel.textRect.width = 0;
        CheckBoxLookAndFeel.textRect.y = 0;
        CheckBoxLookAndFeel.textRect.x = 0;
        Icon altIcon = checkBox.getIcon();
        FontMetrics metrics = canvas.getFontMetrics();
        String text = SwingUtilities.layoutCompoundLabel(component, metrics, checkBox.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), checkBox.getVerticalAlignment(), checkBox.getHorizontalAlignment(), checkBox.getVerticalTextPosition(), checkBox.getHorizontalTextPosition(), viewRect, iconRect, textRect, this.getDefaultTextIconGap(checkBox));
        canvas.setColor(checkBox.getBackground());
        canvas.fillRect(0, 0, CheckBoxLookAndFeel.size.width, CheckBoxLookAndFeel.size.height);
        ButtonModel model = checkBox.getModel();
        if (altIcon != null) {
            if (!model.isEnabled()) {
                altIcon = checkBox.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = checkBox.getPressedIcon();
                if (altIcon == null) {
                    altIcon = checkBox.getSelectedIcon();
                }
            } else if (model.isSelected() || model instanceof CheckBoxModel && ((CheckBoxModel)model).isPartiallySelected()) {
                if (checkBox.isRolloverEnabled() && model.isRollover()) {
                    altIcon = checkBox.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = checkBox.getSelectedIcon();
                    }
                } else {
                    altIcon = checkBox.getSelectedIcon();
                }
            } else if (checkBox.isRolloverEnabled() && model.isRollover()) {
                altIcon = checkBox.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = checkBox.getIcon();
            }
            altIcon.paintIcon(component, canvas, CheckBoxLookAndFeel.iconRect.x, CheckBoxLookAndFeel.iconRect.y);
        } else {
            if (model.isEnabled()) {
                canvas.setColor(checkBox.getBoxBackgroundColor());
            } else {
                canvas.setColor(checkBox.getBoxDisabledBackgroundColor());
            }
            canvas.fillRect(CheckBoxLookAndFeel.iconRect.x, CheckBoxLookAndFeel.iconRect.y, CheckBoxLookAndFeel.iconRect.width, CheckBoxLookAndFeel.iconRect.height);
            Border border = checkBox.getBorder();
            if (border == null) {
                border = BorderFactory.createLoweredBevelBorder();
            }
            border.paintBorder(component, canvas, CheckBoxLookAndFeel.iconRect.x, CheckBoxLookAndFeel.iconRect.y, CheckBoxLookAndFeel.iconRect.width, CheckBoxLookAndFeel.iconRect.height);
            if (checkBox.isPartiallySelected()) {
                int x1;
                canvas.translate(CheckBoxLookAndFeel.iconRect.x, CheckBoxLookAndFeel.iconRect.y);
                Insets insets = border.getBorderInsets(component);
                int x2 = x1 = CheckBoxLookAndFeel.iconRect.width / 3;
                int y1 = CheckBoxLookAndFeel.iconRect.height / 2;
                int y2 = CheckBoxLookAndFeel.iconRect.height - insets.bottom - 1;
                if (checkBox.isSelected()) {
                    canvas.setColor(selectedColor);
                } else {
                    canvas.setColor(partiallySelectedColor);
                }
                canvas.drawLine(x1, y1, x2, y2);
                canvas.drawLine(x1 + 1, y1, x2 + 1, y2);
                x2 = CheckBoxLookAndFeel.iconRect.width - insets.right - 1;
                y1 = y2 - 1;
                y2 = y1 - (x2 - (x1 += 2));
                canvas.drawLine(x1, y1, x2, y2);
                canvas.drawLine(x1, y1 - 1, x2, y2 - 1);
                canvas.translate(-CheckBoxLookAndFeel.iconRect.x, -CheckBoxLookAndFeel.iconRect.y);
            }
        }
        if (text != null) {
            if (model.isEnabled()) {
                canvas.setColor(checkBox.getForeground());
                BasicGraphicsUtils.drawString(canvas, text, model.getMnemonic(), CheckBoxLookAndFeel.textRect.x, CheckBoxLookAndFeel.textRect.y + metrics.getAscent());
            } else {
                canvas.setColor(checkBox.getBackground().brighter());
                BasicGraphicsUtils.drawString(canvas, text, model.getMnemonic(), CheckBoxLookAndFeel.textRect.x + 1, CheckBoxLookAndFeel.textRect.y + metrics.getAscent() + 1);
                canvas.setColor(checkBox.getBackground().darker());
                BasicGraphicsUtils.drawString(canvas, text, model.getMnemonic(), CheckBoxLookAndFeel.textRect.x, CheckBoxLookAndFeel.textRect.y + metrics.getAscent());
            }
            if (checkBox.hasFocus() && checkBox.isFocusPainted() && CheckBoxLookAndFeel.textRect.width > 0 && CheckBoxLookAndFeel.textRect.height > 0) {
                this.paintFocus(canvas, textRect, size);
            }
        }
    }

    @Override
    protected void paintFocus(Graphics canvas, Rectangle textRect, Dimension size) {
        canvas.setColor(focusColor);
        canvas.drawRect(textRect.x, textRect.y, textRect.width - 1, textRect.height - 1);
    }
}

