/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.laf;

import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.laf.LookAndFeelUtilities;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLabelUI;

public class LabelLookAndFeel
extends MetalLabelUI {
    private static final LabelLookAndFeel INSTANCE = new LabelLookAndFeel();
    private static boolean areDfltsInstalled = false;

    public static ComponentUI createUI(JComponent component) {
        return INSTANCE;
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        LabelWidget label = (LabelWidget)component;
        String text = label.getTextFormat();
        Icon icon = label.getIcon();
        if ((text == null || text.length() == 0) && icon == null) {
            text = " ";
        }
        LookAndFeelUtilities.clearViewBounds();
        LookAndFeelUtilities.layoutText(text, icon, label.getIconTextGap(), label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), label.getFontMetrics(label.getFont()));
        Dimension size = LookAndFeelUtilities.getPreferredSize(component);
        if (label.getFont().getStyle() == 2) {
            size.width += 5;
        }
        return size;
    }

    @Override
    protected void installDefaults(JLabel label) {
        if (!areDfltsInstalled) {
            areDfltsInstalled = true;
        }
        super.installDefaults(label);
    }

    @Override
    public void paint(Graphics graphic, JComponent component) {
        Icon icon;
        LabelWidget label = (LabelWidget)component;
        String text = label.getTextFormat();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if ((text == null || text.length() == 0) && icon == null) {
            return;
        }
        LookAndFeelUtilities.setViewBounds(component);
        text = LookAndFeelUtilities.layoutText(text, icon, label.getIconTextGap(), label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), graphic.getFontMetrics());
        graphic.setFont(component.getFont());
        if (icon != null) {
            icon.paintIcon(component, graphic, LookAndFeelUtilities.ICON_BOUNDS.x, LookAndFeelUtilities.ICON_BOUNDS.y);
        }
        if (text.length() > 0) {
            LookAndFeelUtilities.paintText(graphic, component, text, ((JLabel)component).getDisplayedMnemonic());
        }
    }
}

