/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.laf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.basic.BasicGraphicsUtils;

class LookAndFeelUtilities
implements SwingConstants {
    static final Rectangle VIEW_BOUNDS = new Rectangle();
    static final Rectangle TEXT_BOUNDS = new Rectangle();
    static final Rectangle ICON_BOUNDS = new Rectangle();
    static final Rectangle TMP_BOUNDS = new Rectangle();
    static final Insets INSETS = new Insets(0, 0, 0, 0);

    LookAndFeelUtilities() {
    }

    static void clearViewBounds() {
        LookAndFeelUtilities.VIEW_BOUNDS.y = 0;
        LookAndFeelUtilities.VIEW_BOUNDS.x = 0;
        LookAndFeelUtilities.VIEW_BOUNDS.height = Short.MAX_VALUE;
        LookAndFeelUtilities.VIEW_BOUNDS.width = Short.MAX_VALUE;
    }

    static Dimension getPreferredSize(JComponent component) {
        LookAndFeelUtilities.union(ICON_BOUNDS, TEXT_BOUNDS, VIEW_BOUNDS);
        component.getInsets(INSETS);
        LookAndFeelUtilities.VIEW_BOUNDS.width += LookAndFeelUtilities.INSETS.left + LookAndFeelUtilities.INSETS.right;
        LookAndFeelUtilities.VIEW_BOUNDS.height += LookAndFeelUtilities.INSETS.top + LookAndFeelUtilities.INSETS.bottom;
        return VIEW_BOUNDS.getSize();
    }

    static String layoutText(String text, Icon icon, int gap, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, FontMetrics metrics) {
        boolean isTextEmpty;
        StringBuffer textBuf = new StringBuffer();
        boolean bl = isTextEmpty = text == null || text.length() == 0;
        if (isTextEmpty || icon == null) {
            gap = 0;
        }
        LookAndFeelUtilities.ICON_BOUNDS.y = 0;
        LookAndFeelUtilities.ICON_BOUNDS.x = 0;
        if (icon == null) {
            LookAndFeelUtilities.ICON_BOUNDS.height = 0;
            LookAndFeelUtilities.ICON_BOUNDS.width = 0;
        } else {
            LookAndFeelUtilities.ICON_BOUNDS.width = icon.getIconWidth();
            LookAndFeelUtilities.ICON_BOUNDS.height = icon.getIconHeight();
        }
        if (isTextEmpty) {
            LookAndFeelUtilities.TEXT_BOUNDS.height = 0;
            LookAndFeelUtilities.TEXT_BOUNDS.width = 0;
            text = "";
        } else {
            int maxTextWth = horizontalTextPosition == 0 ? LookAndFeelUtilities.VIEW_BOUNDS.width : LookAndFeelUtilities.VIEW_BOUNDS.width - (LookAndFeelUtilities.ICON_BOUNDS.width + gap);
            StringTokenizer lines = new StringTokenizer(text, "\n");
            LookAndFeelUtilities.TEXT_BOUNDS.height = metrics.getHeight() * lines.countTokens();
            LookAndFeelUtilities.TEXT_BOUNDS.width = 0;
            int lineWth = 0;
            int ellipsisWth = 0;
            boolean isClipped = false;
            while (lines.hasMoreTokens()) {
                String line = lines.nextToken();
                lineWth = metrics.stringWidth(line);
                if (lineWth > maxTextWth) {
                    if (!isClipped) {
                        ellipsisWth = metrics.stringWidth("...");
                        isClipped = true;
                    }
                    if (line.length() > 0) {
                        while ((lineWth = metrics.stringWidth(line = line.substring(0, line.length() - 1))) + ellipsisWth > maxTextWth && line.length() > 0) {
                        }
                    }
                    lineWth += ellipsisWth;
                    line = line + "...";
                }
                if (textBuf.length() > 0) {
                    textBuf.append('\n');
                }
                textBuf.append(line);
                LookAndFeelUtilities.TEXT_BOUNDS.width = Math.max(LookAndFeelUtilities.TEXT_BOUNDS.width, lineWth);
            }
        }
        horizontalAlignment = LookAndFeelUtilities.translateOrientationValue(horizontalAlignment);
        horizontalTextPosition = LookAndFeelUtilities.translateOrientationValue(horizontalTextPosition);
        LookAndFeelUtilities.TEXT_BOUNDS.y = verticalTextPosition == 1 ? (horizontalTextPosition == 0 ? -(LookAndFeelUtilities.TEXT_BOUNDS.height + gap) : 0) : (verticalTextPosition == 0 ? LookAndFeelUtilities.ICON_BOUNDS.height / 2 - LookAndFeelUtilities.TEXT_BOUNDS.height / 2 : (horizontalTextPosition != 0 ? LookAndFeelUtilities.ICON_BOUNDS.height - LookAndFeelUtilities.TEXT_BOUNDS.height : LookAndFeelUtilities.ICON_BOUNDS.height + gap));
        LookAndFeelUtilities.TEXT_BOUNDS.x = horizontalTextPosition == 2 ? -(LookAndFeelUtilities.TEXT_BOUNDS.width + gap) : (horizontalTextPosition == 0 ? LookAndFeelUtilities.ICON_BOUNDS.width / 2 - LookAndFeelUtilities.TEXT_BOUNDS.width / 2 : LookAndFeelUtilities.ICON_BOUNDS.width + gap);
        LookAndFeelUtilities.union(ICON_BOUNDS, TEXT_BOUNDS, TMP_BOUNDS);
        int dy = verticalAlignment == 1 ? LookAndFeelUtilities.VIEW_BOUNDS.y - LookAndFeelUtilities.TMP_BOUNDS.y : (verticalAlignment == 0 ? LookAndFeelUtilities.VIEW_BOUNDS.y + LookAndFeelUtilities.VIEW_BOUNDS.height / 2 - (LookAndFeelUtilities.TMP_BOUNDS.y + LookAndFeelUtilities.TMP_BOUNDS.height / 2) : LookAndFeelUtilities.VIEW_BOUNDS.y + LookAndFeelUtilities.VIEW_BOUNDS.height - (LookAndFeelUtilities.TMP_BOUNDS.y + LookAndFeelUtilities.TMP_BOUNDS.height));
        int dx = horizontalAlignment == 2 ? LookAndFeelUtilities.VIEW_BOUNDS.x - LookAndFeelUtilities.TMP_BOUNDS.x : (horizontalAlignment == 4 ? LookAndFeelUtilities.VIEW_BOUNDS.x + LookAndFeelUtilities.VIEW_BOUNDS.width - (LookAndFeelUtilities.TMP_BOUNDS.x + LookAndFeelUtilities.TMP_BOUNDS.width) : LookAndFeelUtilities.VIEW_BOUNDS.x + LookAndFeelUtilities.VIEW_BOUNDS.width / 2 - (LookAndFeelUtilities.TMP_BOUNDS.x + LookAndFeelUtilities.TMP_BOUNDS.width / 2));
        LookAndFeelUtilities.TEXT_BOUNDS.x += dx;
        LookAndFeelUtilities.TEXT_BOUNDS.y += dy;
        LookAndFeelUtilities.ICON_BOUNDS.x += dx;
        LookAndFeelUtilities.ICON_BOUNDS.y += dy;
        return textBuf.toString();
    }

    static void paintText(Graphics graphic, JComponent component, String text, int mnemonic) {
        FontMetrics metrics = graphic.getFontMetrics();
        int ascent = metrics.getAscent();
        int hgt = metrics.getHeight();
        StringTokenizer lines = new StringTokenizer(text, "\n");
        int x = LookAndFeelUtilities.TEXT_BOUNDS.x;
        int y = LookAndFeelUtilities.TEXT_BOUNDS.y + ascent;
        if (component.isEnabled()) {
            graphic.setColor(component.getForeground());
            while (lines.hasMoreTokens()) {
                BasicGraphicsUtils.drawString(graphic, lines.nextToken(), mnemonic, x, y);
                y += hgt;
            }
        } else {
            Color bkgd = component.getBackground();
            while (lines.hasMoreTokens()) {
                String line = lines.nextToken();
                graphic.setColor(bkgd.brighter());
                BasicGraphicsUtils.drawString(graphic, line, mnemonic, x, y);
                graphic.setColor(bkgd.darker());
                BasicGraphicsUtils.drawString(graphic, line, mnemonic, x - 1, y - 1);
                y += hgt;
            }
        }
    }

    static void setViewBounds(JComponent component) {
        component.getInsets(INSETS);
        LookAndFeelUtilities.VIEW_BOUNDS.x = LookAndFeelUtilities.INSETS.left;
        LookAndFeelUtilities.VIEW_BOUNDS.y = LookAndFeelUtilities.INSETS.top;
        LookAndFeelUtilities.VIEW_BOUNDS.width = component.getWidth() - (LookAndFeelUtilities.INSETS.right + LookAndFeelUtilities.VIEW_BOUNDS.x);
        LookAndFeelUtilities.VIEW_BOUNDS.height = component.getHeight() - (LookAndFeelUtilities.INSETS.bottom + LookAndFeelUtilities.VIEW_BOUNDS.y);
    }

    private static int translateOrientationValue(int orientation) {
        if (orientation == 11) {
            return 4;
        }
        if (orientation == 10) {
            return 2;
        }
        return orientation;
    }

    static void union(Rectangle firstRectangle, Rectangle secondRectangle, Rectangle targetRectangle) {
        targetRectangle.x = Math.min(firstRectangle.x, secondRectangle.x);
        targetRectangle.y = Math.min(firstRectangle.y, secondRectangle.y);
        targetRectangle.width = Math.max(firstRectangle.x + firstRectangle.width, secondRectangle.x + secondRectangle.width) - targetRectangle.x;
        targetRectangle.height = Math.max(firstRectangle.y + firstRectangle.height, secondRectangle.y + secondRectangle.height) - targetRectangle.y;
    }
}

