/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.laf;

import com.metamatrix.toolbox.ui.widget.MultiLineToolTip;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class MultiLineToolTipUI
extends BasicToolTipUI {
    private CellRendererPane rendererPane;
    private JTextArea txa = new JTextArea();

    private MultiLineToolTipUI() {
        this.txa.setWrapStyleWord(true);
        this.rendererPane = new CellRendererPane();
        this.rendererPane.add(this.txa);
    }

    public static ComponentUI createUI(JComponent theComponent) {
        return new MultiLineToolTipUI();
    }

    @Override
    public Dimension getMaximumSize(JComponent theComponent) {
        return this.getPreferredSize(theComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent theComponent) {
        return this.getPreferredSize(theComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent theComponent) {
        Dimension result = new Dimension(0, 0);
        MultiLineToolTip toolTip = (MultiLineToolTip)theComponent;
        String tipText = toolTip.getTipText();
        if (tipText != null) {
            this.txa.setText(tipText);
            this.txa.setLineWrap(false);
            int textWidth = toolTip.getFontMetrics().stringWidth(tipText);
            int maxWidth = toolTip.getMaxWidth();
            if (textWidth > maxWidth) {
                this.txa.setLineWrap(true);
                Dimension d = this.txa.getPreferredSize();
                d.width = maxWidth;
                ++d.height;
                this.txa.setSize(d);
            }
            result = this.txa.getPreferredSize();
            ++result.height;
            ++result.width;
        }
        return result;
    }

    @Override
    public void installUI(JComponent theComponent) {
        super.installUI(theComponent);
        theComponent.add(this.rendererPane);
    }

    @Override
    public void paint(Graphics theGraphics, JComponent theComponent) {
        Dimension size = theComponent.getSize();
        this.txa.setBackground(theComponent.getBackground());
        this.rendererPane.paintComponent(theGraphics, this.txa, theComponent, 1, 1, size.width, size.height, true);
    }

    @Override
    public void uninstallUI(JComponent theComponent) {
        super.uninstallUI(theComponent);
        theComponent.remove(this.rendererPane);
    }
}

